/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.Info;
import VASSAL.build.GameModule;
import VASSAL.configure.DirectoryConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.preferences.Prefs;
import VASSAL.tools.DataArchive;
import VASSAL.tools.ProblemDialog;
import VASSAL.tools.ReadErrorDialog;
import VASSAL.tools.WriteErrorDialog;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.image.svg.SVGImageUtils;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.io.FileArchive;
import VASSAL.tools.io.ZipArchive;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.StringUtils;

public class ArchiveWriter
extends DataArchive {
    private String archiveName;
    private String defaultExtension;
    private boolean isTempArchive = false;

    public ArchiveWriter(String zipName, String defaultExtension) {
        this.archiveName = zipName;
        this.defaultExtension = defaultExtension;
        if (this.archiveName == null) {
            this.isTempArchive = true;
            if (this.defaultExtension == null) {
                this.defaultExtension = ".zip";
            }
            try {
                this.archiveName = Files.createTempFile(Info.getTempDir().toPath(), "tmp_", this.defaultExtension, new FileAttribute[0]).toAbsolutePath().toString();
            }
            catch (IOException e) {
                WriteErrorDialog.error(e, this.archiveName);
            }
        }
        File f = new File(this.archiveName);
        try {
            if (f.exists()) {
                try {
                    this.archive = new ZipArchive(this.archiveName);
                }
                catch (IOException e1) {
                    this.archive = new ZipArchive(this.archiveName, true);
                }
            } else {
                this.archive = new ZipArchive(this.archiveName);
            }
        }
        catch (IOException e) {
            this.archive = null;
            WriteErrorDialog.error(e, this.archiveName);
        }
    }

    public ArchiveWriter(FileArchive archive, String defaultExtension) {
        this.archiveName = archive.getName();
        this.defaultExtension = defaultExtension;
        this.archive = archive;
    }

    public ArchiveWriter(String zipName) {
        this(zipName, (String)null);
    }

    public ArchiveWriter(FileArchive archive) {
        this(archive, null);
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public ArchiveWriter(ZipFile archive) {
        ProblemDialog.showDeprecated("2020-08-06");
        this.archiveName = archive.getName();
        try {
            this.archive = new ZipArchive(this.archiveName);
        }
        catch (IOException e) {
            archive = null;
            WriteErrorDialog.error(e, this.archiveName);
        }
    }

    public void addImage(String path, String name) {
        if (name.toLowerCase().endsWith(".svg")) {
            List<String> exrefs;
            try {
                exrefs = SVGImageUtils.getExternalReferences(path);
            }
            catch (IOException e) {
                ReadErrorDialog.error(e, name);
                return;
            }
            for (String s : exrefs) {
                byte[] buf;
                File f = new File(s);
                try {
                    buf = SVGImageUtils.relativizeExternalReferences(s);
                }
                catch (IOException e) {
                    ReadErrorDialog.error(e, f);
                    continue;
                }
                this.addFile(this.imageDir + f.getName(), buf);
            }
        } else {
            this.addFile(path, this.imageDir + name);
        }
        Op.load(name).update();
        this.localImages = null;
    }

    public void addImage(String name, byte[] contents) {
        this.addFile(this.imageDir + name, contents);
        this.localImages = null;
    }

    public void addSound(String path, String fileName) {
        this.addFile(path, this.soundDir + fileName);
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public boolean isImageAdded(String name) {
        ProblemDialog.showDeprecated("2020-08-06");
        try {
            return this.archive.contains(this.imageDir + name);
        }
        catch (IOException e) {
            return false;
        }
    }

    public void removeImage(String name) {
        this.removeFile(this.imageDir + name);
        this.localImages = null;
    }

    public void removeFile(String name) {
        try {
            this.archive.remove(name);
        }
        catch (IOException e) {
            WriteErrorDialog.error(e, this.archive.getName());
        }
    }

    public void addFile(String path, String fileName) {
        try {
            this.archive.add(fileName, path);
        }
        catch (IOException e) {
            WriteErrorDialog.error(e, this.archive.getName());
        }
    }

    public void addFile(String fileName, InputStream in) {
        try (OutputStream out = this.archive.getOutputStream(fileName);){
            in.transferTo(out);
        }
        catch (IOException e) {
            WriteErrorDialog.error(e, this.archive.getName());
        }
    }

    public void addFile(String fileName, byte[] content) {
        try {
            this.archive.add(fileName, content);
        }
        catch (IOException e) {
            WriteErrorDialog.error(e, this.archive.getName());
        }
    }

    public boolean save() throws IOException {
        return this.save(false);
    }

    public boolean save(boolean notifyModuleManager) throws IOException {
        if (this.isTempArchive) {
            return this.saveAs(notifyModuleManager);
        }
        this.write(this.archive, notifyModuleManager);
        return true;
    }

    public boolean saveAs() throws IOException {
        return this.saveAs(false);
    }

    protected void write(FileArchive fa, boolean notifyModuleManager) throws IOException {
        fa.flush();
    }

    public boolean saveAs(boolean notifyModuleManager) throws IOException {
        FileChooser fc = FileChooser.createFileChooser(GameModule.getGameModule().getPlayerWindow(), (DirectoryConfigurer)Prefs.getGlobalPrefs().getOption("modulesDir"));
        if (fc.showSaveDialog() != 0) {
            return false;
        }
        Object filename = fc.getSelectedFile().getPath();
        if (!StringUtils.isEmpty((CharSequence)this.defaultExtension) && ((String)filename).lastIndexOf(46) < 0 && new File((String)(filename = (String)filename + this.defaultExtension)).exists() && 1 == JOptionPane.showConfirmDialog(GameModule.getGameModule().getPlayerWindow(), Resources.getString("Editor.ArchiveWriter.overwrite", filename), Resources.getString("Editor.ArchiveWriter.file_exists"), 0)) {
            return false;
        }
        if (!((String)filename).equals(this.archive.getName())) {
            FileArchive tmp = this.archive;
            this.archiveName = filename;
            this.archive = new ZipArchive(tmp, (String)filename);
            this.archive.flush();
            tmp.revert();
            tmp.close();
            this.write(this.archive, notifyModuleManager);
            if (this.isTempArchive) {
                tmp.getFile().delete();
                this.isTempArchive = false;
            }
        } else {
            this.write(this.archive, notifyModuleManager);
        }
        return true;
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public void write() throws IOException {
        ProblemDialog.showDeprecated("2020-08-06");
        this.write(false);
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public void write(boolean notifyModuleManager) throws IOException {
        ProblemDialog.showDeprecated("2020-08-06");
        this.save(notifyModuleManager);
    }
}

