/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractToolbarItem;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.MutablePropertiesContainer;
import VASSAL.build.module.properties.MutableProperty;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.AutoConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.ConfigurerWindow;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.PlayerIdFormattedStringConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.search.HTMLImageFinder;
import VASSAL.tools.FormattedString;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.ProblemDialog;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;

public class DiceButton
extends AbstractToolbarItem {
    protected Random ran;
    protected int nSides = 6;
    protected int nDice = 2;
    protected int plus = 0;
    protected int addToTotal = 0;
    protected boolean reportTotal = false;
    protected boolean promptAlways = false;
    protected boolean sortDice = false;
    protected final FormattedString reportFormat = new FormattedString("** $name$ = $result$ *** &lt;$PlayerName$&gt;");
    @Deprecated(since="2021-04-03", forRemoval=true)
    protected LaunchButton launch;
    protected String tooltip = "";
    protected final MutableProperty.Impl property = new MutableProperty.Impl("", this);
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String BUTTON_TEXT = "text";
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String TOOLTIP = "tooltip";
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String NAME = "name";
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String ICON = "icon";
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String HOTKEY = "hotkey";
    public static final String DEPRECATED_NAME = "label";
    public static final String N_DICE = "nDice";
    public static final String N_SIDES = "nSides";
    public static final String PLUS = "plus";
    public static final String ADD_TO_TOTAL = "addToTotal";
    public static final String REPORT_TOTAL = "reportTotal";
    public static final String PROMPT_ALWAYS = "prompt";
    public static final String REPORT_FORMAT = "reportFormat";
    public static final String SORT_DICE_RESULTS = "sortDice";
    public static final String RESULT = "result";
    public static final String REPORT_NAME = "name";
    private final VisibilityCondition cond = () -> !this.promptAlways;
    private final VisibilityCondition canSort = () -> !this.reportTotal;

    public DiceButton() {
        this.initLaunchButton();
    }

    protected void initLaunchButton() {
        ActionListener rollAction = e -> {
            if (this.promptAlways) {
                DiceButton delegate = new DiceButton(){

                    @Override
                    protected void initLaunchButton() {
                        this.setLaunchButton(this.makeLaunchButton("", DiceButton.BUTTON_TEXT, "", null));
                    }
                };
                List<String> keepAttributes = Arrays.asList(N_DICE, N_SIDES, PLUS, ADD_TO_TOTAL);
                for (String key : keepAttributes) {
                    delegate.setAttribute(key, this.getAttributeValueString(key));
                }
                AutoConfigurer ac = new AutoConfigurer(delegate);
                ConfigurerWindow w = new ConfigurerWindow(ac, true);
                for (String key : this.getAttributeNames()) {
                    if (keepAttributes.contains(key)) continue;
                    Component controls = ac.getConfigurer(key).getControls();
                    Container parent = controls.getParent();
                    parent.remove(controls);
                    parent.remove(ac.getLabel(key));
                }
                w.setLocationRelativeTo(this.getLaunchButton().getTopLevelAncestor());
                SwingUtils.repack(w, true);
                w.setVisible(true);
                for (String key : keepAttributes) {
                    this.setAttribute(key, delegate.getAttributeValueString(key));
                }
                if (!w.isCancelled()) {
                    this.DR();
                }
            } else {
                this.DR();
            }
        };
        this.setLaunchButton(this.makeLaunchButton(Resources.getString("Editor.DiceButton.dice_button_text"), Resources.getString("Editor.DiceButton.dice_button_tooltip"), "/images/die.gif", rollAction));
        this.launch = this.getLaunchButton();
        this.setAttribute("name", Resources.getString("Editor.DiceButton.dice_name"));
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.DiceButton.component_type");
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    protected String getReportPrefix() {
        ProblemDialog.showDeprecated("2020-08-06");
        return " *** " + this.getConfigureName() + " = ";
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    protected String getReportSuffix() {
        ProblemDialog.showDeprecated("2020-08-06");
        return " ***  <" + GlobalOptions.getInstance().getPlayerId() + ">";
    }

    protected void DR() {
        int i;
        StringBuilder val = new StringBuilder();
        int total = this.addToTotal;
        int[] dice = null;
        if (!this.reportTotal && this.nDice > 1 && this.sortDice) {
            dice = new int[this.nDice];
        }
        for (i = 0; i < this.nDice; ++i) {
            int roll = this.ran.nextInt(this.nSides) + 1 + this.plus;
            if (dice != null) {
                dice[i] = roll;
                continue;
            }
            if (this.reportTotal) {
                total += roll;
                continue;
            }
            val.append(roll);
            if (i >= this.nDice - 1) continue;
            val.append(',');
        }
        if (this.reportTotal) {
            val.append(total);
        } else if (dice != null) {
            Arrays.sort(dice);
            for (i = 0; i < this.nDice; ++i) {
                val.append(dice[i]);
                if (i >= this.nDice - 1) continue;
                val.append(',');
            }
        }
        String report = this.formatResult(val.toString());
        Command c = report.length() == 0 ? new NullCommand() : new Chatter.DisplayText(GameModule.getGameModule().getChatter(), report);
        c.execute();
        c.append(this.property.setPropertyValue(val.toString()));
        GameModule.getGameModule().sendAndLog(c);
    }

    protected String formatResult(String result) {
        this.reportFormat.setProperty("name", this.getLocalizedConfigureName());
        this.reportFormat.setProperty(RESULT, result);
        this.reportFormat.setProperty(N_DICE, Integer.toString(this.nDice));
        this.reportFormat.setProperty(N_SIDES, Integer.toString(this.nSides));
        this.reportFormat.setProperty(PLUS, Integer.toString(this.plus));
        this.reportFormat.setProperty(ADD_TO_TOTAL, Integer.toString(this.addToTotal));
        String text = this.reportFormat.getLocalizedText();
        Object report = text;
        if (text.length() > 0) {
            report = text.startsWith("*") ? "*" + text : "* " + text;
        }
        return report;
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{"name", BUTTON_TEXT, TOOLTIP, ICON, N_DICE, N_SIDES, PLUS, ADD_TO_TOTAL, REPORT_TOTAL, HOTKEY, PROMPT_ALWAYS, REPORT_FORMAT, SORT_DICE_RESULTS};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.name_label"), Resources.getString("Editor.button_text_label"), Resources.getString("Editor.tooltip_text_label"), Resources.getString("Editor.button_icon_label"), Resources.getString("Dice.number_of_dice"), Resources.getString("Dice.number_of_sides"), Resources.getString("Dice.add_to_each_side"), Resources.getString("Dice.add_to_total"), Resources.getString("Editor.DiceButton.report_total"), Resources.getString("Editor.hotkey_label"), Resources.getString("Editor.DiceButton.prompt_value"), Resources.getString("Editor.report_format"), Resources.getString("Editor.DiceButton.sort_results")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, String.class, IconConfig.class, Integer.class, Integer.class, Integer.class, Integer.class, Boolean.class, NamedKeyStroke.class, Boolean.class, ReportFormatConfig.class, Boolean.class};
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (List.of(N_DICE, N_SIDES, PLUS, ADD_TO_TOTAL).contains(name)) {
            return this.cond;
        }
        if (SORT_DICE_RESULTS.equals(name)) {
            return this.canSort;
        }
        return null;
    }

    @Override
    public void addTo(Buildable parent) {
        super.addTo(parent);
        this.ran = GameModule.getGameModule().getRNG();
        this.property.setPropertyValue("1");
        this.property.addTo((MutablePropertiesContainer)((Object)parent));
    }

    @Override
    public void setAttribute(String key, Object o) {
        if (DEPRECATED_NAME.equals(key)) {
            this.setAttribute("name", o);
            this.setAttribute(BUTTON_TEXT, o);
        } else if ("name".equals(key)) {
            this.setConfigureName((String)o);
            this.property.setPropertyName(this.getConfigureName() + "_result");
            this.getLaunchButton().setToolTipText((String)o);
        } else if (N_DICE.equals(key)) {
            if (o instanceof Integer) {
                this.nDice = (Integer)o;
            } else if (o instanceof String) {
                this.nDice = Integer.parseInt((String)o);
            }
        } else if (N_SIDES.equals(key)) {
            if (o instanceof Integer) {
                this.nSides = (Integer)o;
            } else if (o instanceof String) {
                this.nSides = Integer.parseInt((String)o);
            }
        } else if (PLUS.equals(key)) {
            if (o instanceof Integer) {
                this.plus = (Integer)o;
            } else if (o instanceof String) {
                this.plus = Integer.parseInt((String)o);
            }
        } else if (ADD_TO_TOTAL.equals(key)) {
            if (o instanceof Integer) {
                this.addToTotal = (Integer)o;
            } else if (o instanceof String) {
                this.addToTotal = Integer.parseInt((String)o);
            }
        } else if (REPORT_TOTAL.equals(key)) {
            if (o instanceof Boolean) {
                this.reportTotal = (Boolean)o;
            } else if (o instanceof String) {
                this.reportTotal = "true".equals(o);
            }
        } else if (PROMPT_ALWAYS.equals(key)) {
            if (o instanceof Boolean) {
                this.promptAlways = (Boolean)o;
            } else if (o instanceof String) {
                this.promptAlways = "true".equals(o);
            }
        } else if (REPORT_FORMAT.equals(key)) {
            this.reportFormat.setFormat((String)o);
        } else if (TOOLTIP.equals(key)) {
            this.tooltip = (String)o;
            super.setAttribute(key, o);
        } else if (SORT_DICE_RESULTS.equals(key)) {
            if (o instanceof Boolean) {
                this.sortDice = (Boolean)o;
            } else if (o instanceof String) {
                this.sortDice = "true".equals(o);
            }
        } else {
            super.setAttribute(key, o);
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if ("name".equals(key)) {
            return this.getConfigureName();
        }
        if (N_DICE.equals(key)) {
            return String.valueOf(this.nDice);
        }
        if (N_SIDES.equals(key)) {
            return String.valueOf(this.nSides);
        }
        if (PLUS.equals(key)) {
            return String.valueOf(this.plus);
        }
        if (ADD_TO_TOTAL.equals(key)) {
            return String.valueOf(this.addToTotal);
        }
        if (REPORT_TOTAL.equals(key)) {
            return String.valueOf(this.reportTotal);
        }
        if (PROMPT_ALWAYS.equals(key)) {
            return String.valueOf(this.promptAlways);
        }
        if (REPORT_FORMAT.equals(key)) {
            return this.reportFormat.getFormat();
        }
        if (TOOLTIP.equals(key)) {
            return this.tooltip.length() == 0 ? super.getAttributeValueString(BUTTON_TEXT) : this.tooltip;
        }
        if (SORT_DICE_RESULTS.equals(key)) {
            return String.valueOf(this.sortDice);
        }
        return super.getAttributeValueString(key);
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GameModule.html", "DiceButton");
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.getConfigureName() + "_result");
        return l;
    }

    @Override
    public void addLocalImageNames(Collection<String> s) {
        HTMLImageFinder h = new HTMLImageFinder(this.reportFormat.getFormat());
        h.addImageNames(s);
        super.addLocalImageNames(s);
    }

    @Deprecated(since="2020-10-01", forRemoval=true)
    public static class IconConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new IconConfigurer(key, name, "/images/die.gif");
        }
    }

    public static class ReportFormatConfig
    implements TranslatableConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new PlayerIdFormattedStringConfigurer(key, name, new String[]{"name", DiceButton.RESULT, DiceButton.N_DICE, DiceButton.N_SIDES, DiceButton.PLUS, DiceButton.ADD_TO_TOTAL});
        }
    }
}

