/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.BadDataReport;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.BeanShellExpressionConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.Resources;
import VASSAL.script.expression.BeanShellExpression;
import VASSAL.script.expression.Expression;
import VASSAL.script.expression.ExpressionException;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.RecursionLimitException;
import VASSAL.tools.RecursionLimiter;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.KeyStroke;

public class CalculatedProperty
extends Decorator
implements EditablePiece,
RecursionLimiter.Loopable {
    public static final String ID = "calcProp;";
    protected static int counter = 0;
    protected String name = "";
    protected Expression expression;
    protected String description = "";

    public CalculatedProperty() {
        this(ID, null);
    }

    public CalculatedProperty(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        return KeyCommand.NONE;
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.name).append(this.getExpression()).append(this.description);
        return ID + se.getValue();
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        return null;
    }

    @Override
    public void mySetState(String newState) {
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public String getDescription() {
        return this.buildDescription("Editor.CalculatedProperty.trait_description", this.name, this.description);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("CalculatedProperty.html");
    }

    @Override
    public void mySetType(String type) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        st.nextToken();
        this.name = st.nextToken("");
        this.expression = BeanShellExpression.createExpression(st.nextToken(""), true);
        this.description = st.nextToken("");
    }

    protected String getExpression() {
        return this.expression.getExpression();
    }

    @Override
    public List<String> getExpressionList() {
        return List.of(this.getExpression());
    }

    @Override
    public List<String> getPropertyList() {
        return List.of(this.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getProperty(Object key) {
        String result = "";
        if (this.name.length() > 0 && this.name.equals(key)) {
            if (this.getMap() == null) {
                return "";
            }
            if (RecursionLimiter.isReportingInfiniteLoop()) {
                return this.getExpression();
            }
            try {
                RecursionLimiter.startExecution(this);
                String string = result = this.evaluate();
                return string;
            }
            catch (RecursionLimitException e) {
                RecursionLimiter.infiniteLoop(e);
            }
            finally {
                RecursionLimiter.endExecution();
            }
            return result;
        }
        return super.getProperty(key);
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        if (this.name.length() > 0 && this.name.equals(key)) {
            return this.getProperty(key);
        }
        return super.getLocalizedProperty(key);
    }

    protected String evaluate() {
        try {
            return this.expression.evaluate(Decorator.getOutermost(this));
        }
        catch (ExpressionException e) {
            ErrorDialog.dataWarning(new BadDataReport(Resources.getString("Error.expression_error"), this.piece.getProperty("BasicName") + "-Calculated Property[" + this.name + "]=" + this.getExpression() + ", Error=" + e.getError(), e));
            return "";
        }
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof CalculatedProperty)) {
            return false;
        }
        CalculatedProperty c = (CalculatedProperty)o;
        if (!Objects.equals(this.name, c.name)) {
            return false;
        }
        return Objects.equals(this.expression, c.expression);
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public String getComponentName() {
        return this.piece.getName();
    }

    @Override
    public String getComponentTypeName() {
        return this.getDescription();
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.name);
        return l;
    }

    public static class Ed
    implements PieceEditor {
        protected StringConfigurer nameConfig;
        protected BeanShellExpressionConfigurer expressionConfig;
        protected StringConfigurer defaultValueConfig;
        protected TraitConfigPanel box = new TraitConfigPanel();
        private final StringConfigurer descConfig;

        public Ed(CalculatedProperty piece) {
            this.descConfig = new StringConfigurer(piece.description);
            this.descConfig.setHintKey("Editor.description_hint");
            this.box.add("Editor.description_label", (Configurer)this.descConfig);
            this.nameConfig = new StringConfigurer(piece.name);
            this.box.add("Editor.CalculatedProperty.property_name", (Configurer)this.nameConfig);
            this.expressionConfig = new BeanShellExpressionConfigurer(piece.getExpression(), Decorator.getOutermost(piece));
            this.box.add("Editor.CalculatedProperty.expression", (Configurer)this.expressionConfig);
        }

        @Override
        public Component getControls() {
            return this.box;
        }

        @Override
        public String getState() {
            return "";
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.nameConfig.getValueString()).append(this.expressionConfig.getValueString()).append(this.descConfig.getValueString());
            return CalculatedProperty.ID + se.getValue();
        }
    }
}

