/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.i18n;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Configurable;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PlaceMarker;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Translatable;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.i18n.TranslatableMarker;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.i18n.Translation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ComponentI18nData {
    protected String prefix;
    protected Translatable parent;
    protected Configurable myComponent;
    protected Map<String, Property> translatableProperties = new TreeMap<String, Property>();
    protected Map<String, Property> allProperties = new TreeMap<String, Property>();
    protected List<Translatable> children = new ArrayList<Translatable>();

    public ComponentI18nData(AbstractConfigurable c, String prefix) {
        this.init((Configurable)c, prefix, c.getAttributeNames(), c.getAttributeTypes(), c.getAttributeDescriptions());
    }

    @Deprecated(since="2020-10-26", forRemoval=true)
    public ComponentI18nData(AbstractConfigurable c, String prefix, ArrayList<String> names, ArrayList<Class<?>> types, ArrayList<String> descriptions) {
        this.init((Configurable)c, prefix, names.toArray(new String[0]), types.toArray(new Class[0]), descriptions.toArray(new String[0]));
    }

    public ComponentI18nData(AbstractConfigurable c, String prefix, List<String> names, List<Class<?>> types, List<String> descriptions) {
        this.init((Configurable)c, prefix, names.toArray(new String[0]), types.toArray(new Class[0]), descriptions.toArray(new String[0]));
    }

    public ComponentI18nData(AutoConfigurable c, String prefix) {
        this.parent = null;
        this.init((Configurable)c, prefix, c.getAttributeNames(), c.getAttributeTypes(), c.getAttributeDescriptions());
    }

    protected void init(Configurable c, String pfx, String[] names, Class<?>[] types, String[] descriptions) {
        boolean[] translatable = new boolean[types.length];
        for (int i = 0; i < types.length; ++i) {
            translatable[i] = types[i] != null && (types[i].equals(String.class) || TranslatableConfigurerFactory.class.isAssignableFrom(types[i]));
        }
        this.init(c, pfx, names, descriptions, translatable);
    }

    protected void init(Configurable c, String pfx, String[] names, String[] descriptions, boolean[] translatable) {
        this.setPrefix(pfx);
        this.myComponent = c;
        this.children.addAll(Arrays.asList(this.myComponent.getConfigureComponents()));
        for (int i = 0; i < translatable.length; ++i) {
            Property p = new Property(names[i], descriptions[i]);
            this.allProperties.put(names[i], p);
            if (!translatable[i]) continue;
            this.translatableProperties.put(names[i], p);
        }
    }

    public ComponentI18nData(Configurable c, String prefix, Translatable parent, String[] names, boolean[] translatable, String[] descriptions) {
        this.myComponent = c;
        this.parent = parent;
        this.init(c, prefix, names, descriptions, translatable);
    }

    public ComponentI18nData(Configurable c, String prefix, Translatable parent) {
        this(c, prefix, parent, new String[0], new boolean[0], new String[0]);
    }

    public ComponentI18nData(Configurable c, String prefix) {
        this(c, prefix, null);
    }

    public ComponentI18nData(Configurable c, GamePiece piece) {
        this.myComponent = c;
        this.setPrefix("Piece.");
        this.parent = null;
        GamePiece p = piece;
        while (p != null) {
            if (p instanceof TranslatablePiece) {
                PieceI18nData pieceData = ((TranslatablePiece)p).getI18nData();
                for (PieceI18nData.Property prop : pieceData.getProperties()) {
                    Property property = new Property(prop.getName(), prop.getDescription());
                    this.translatableProperties.put(prop.getName(), property);
                    this.allProperties.put(prop.getName(), property);
                }
            }
            if (p instanceof PlaceMarker && ((PlaceMarker)p).isMarkerStandalone()) {
                this.children.add(new TranslatableMarker((PlaceMarker)p));
            }
            if (p instanceof BasicPiece) {
                p = null;
                continue;
            }
            p = ((Decorator)p).getInner();
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String p) {
        this.prefix = p.intern();
    }

    public String getFullPrefix() {
        Object fullPrefix;
        if ("Piece.".equals(this.prefix)) {
            return this.prefix;
        }
        Object object = fullPrefix = this.getOwningComponent() == null ? "" : this.getOwningComponent().getI18nData().getFullPrefix();
        if (((String)fullPrefix).length() > 0 && this.prefix.length() > 0) {
            fullPrefix = (String)fullPrefix + ".";
        }
        return (String)fullPrefix + this.prefix;
    }

    public Collection<String> getAttributeKeys() {
        return this.translatableProperties.keySet();
    }

    public void setOwningComponent(Translatable t) {
        this.parent = t;
    }

    public Translatable getOwningComponent() {
        return this.parent;
    }

    public boolean isAttributeTranslatable(String attr) {
        return this.translatableProperties.containsKey(attr);
    }

    public boolean isTranslatable() {
        if (!this.translatableProperties.isEmpty()) {
            return true;
        }
        for (Translatable child : this.children) {
            if (!child.getI18nData().isTranslatable()) continue;
            return true;
        }
        return false;
    }

    public void setAttributeTranslatable(String attribute, boolean set) {
        if (set) {
            this.translatableProperties.put(attribute, this.allProperties.get(attribute));
        } else {
            this.translatableProperties.remove(attribute);
        }
    }

    public void setAllAttributesUntranslatable() {
        this.translatableProperties.clear();
    }

    public void applyTranslation(String attr, String value) {
        Property p = this.translatableProperties.get(attr);
        if (attr != null) {
            p.setUntranslatedValue(this.myComponent.getAttributeValueString(attr));
            this.myComponent.setAttribute(attr, value);
        }
    }

    public String getAttributeDescription(String attr) {
        return this.allProperties.get(attr).getDescription();
    }

    public String getLocalUntranslatedValue(String attr) {
        Property p = this.allProperties.get(attr);
        String val = p == null || p.getUntranslatedValue() == null ? this.myComponent.getAttributeValueString(attr) : p.getUntranslatedValue();
        return val;
    }

    public void setUntranslatedValue(String attr, String value) {
        this.allProperties.get(attr).setUntranslatedValue(value);
    }

    public String getTranslatedValue(String attr, Translation translation) {
        String fullKey = this.getFullPrefix() + attr;
        return translation.translate(fullKey);
    }

    public List<Translatable> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public boolean hasUntranslatedAttributes(Translation t) {
        if (t == null) {
            return false;
        }
        for (Property p : this.translatableProperties.values()) {
            String translation;
            String currentValue = this.myComponent.getAttributeValueString(p.getName());
            if (currentValue == null || currentValue.length() <= 0 || (translation = this.getTranslatedValue(p.getName(), t)) != null && translation.length() != 0) continue;
            return true;
        }
        for (Translatable child : this.children) {
            if (!child.getI18nData().hasUntranslatedAttributes(t)) continue;
            return true;
        }
        return false;
    }

    public static class Property {
        private final String name;
        private final String description;
        private String untranslatedValue;

        public Property(String name, String description) {
            this.name = name;
            this.description = description;
            this.untranslatedValue = name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getName() {
            return this.name;
        }

        public String getUntranslatedValue() {
            return this.untranslatedValue;
        }

        public void setUntranslatedValue(String untranslatedValue) {
            this.untranslatedValue = untranslatedValue;
        }
    }
}

