/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.tools.AudioClip;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioSystemClip
implements AudioClip {
    private static final Logger log = LoggerFactory.getLogger(AudioSystemClip.class);
    protected Clip the_clip;

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    protected Clip getClip(InputStream in) throws IOException {
        if (!in.markSupported()) {
            in = new BufferedInputStream(in);
        }
        Clip clip = null;
        try {
            try {
                clip = AudioSystem.getClip();
            }
            catch (IllegalArgumentException | SecurityException | LineUnavailableException e) {
                throw new IOException(e);
            }
            AudioInputStream ais = null;
            try {
                ais = AudioSystem.getAudioInputStream(in);
            }
            catch (UnsupportedAudioFileException e) {
                throw new IOException(e);
            }
            try (AudioInputStream a = ais;){
                AudioInputStream cais = null;
                try {
                    cais = AudioSystem.getAudioInputStream(clip.getFormat(), a);
                }
                catch (IllegalArgumentException e) {
                    throw new IOException(e);
                }
                try (AudioInputStream ca = cais;){
                    clip.open(ca);
                    Clip clip2 = clip;
                    return clip2;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        catch (Exception e) {
            if (clip != null) {
                try {
                    clip.close();
                }
                catch (Exception e2) {
                    log.error("Error while closing clip {}", (Object)clip, (Object)e2);
                }
            }
            throw e;
        }
    }

    public AudioSystemClip(URL url) throws IOException {
        try (InputStream in = url.openStream();){
            this.the_clip = this.getClip(in);
        }
    }

    public AudioSystemClip(InputStream in) throws IOException {
        this.the_clip = this.getClip(in);
    }

    @Override
    public void play() {
        this.the_clip.setFramePosition(0);
        this.the_clip.start();
    }
}

