/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.io;

import VASSAL.tools.concurrent.listener.DefaultEventListenerSupport;
import VASSAL.tools.concurrent.listener.EventListener;
import VASSAL.tools.concurrent.listener.EventListenerSupport;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tailer {
    private static final Logger logger = LoggerFactory.getLogger(Tailer.class);
    protected static final long DEFAULT_POLL_INTERVAL = 1000L;
    protected final File file;
    protected final long poll_interval;
    protected long position = 0L;
    protected volatile boolean tailing = false;
    protected final EventListenerSupport<String> lsup;

    public Tailer(File file) {
        this(file, 1000L);
    }

    public Tailer(File file, long poll_interval) {
        if (file == null) {
            throw new IllegalArgumentException("file == null");
        }
        this.file = file;
        this.poll_interval = poll_interval;
        this.lsup = new DefaultEventListenerSupport<String>(this);
    }

    public Tailer(File file, long poll_interval, EventListenerSupport<String> lsup) {
        if (file == null) {
            throw new IllegalArgumentException("file == null");
        }
        if (lsup == null) {
            throw new IllegalArgumentException("lsup == null");
        }
        this.file = file;
        this.poll_interval = poll_interval;
        this.lsup = lsup;
    }

    public synchronized void start() throws IOException {
        if (!this.tailing) {
            if (!this.file.exists()) {
                throw new IOException(this.file.getAbsolutePath() + " does not exist");
            }
            if (this.file.isDirectory()) {
                throw new IOException(this.file.getAbsolutePath() + " is a directory");
            }
            this.tailing = true;
            new Thread((Runnable)new Monitor(), "tailing " + this.file.getAbsolutePath()).start();
        }
    }

    public void stop() {
        this.tailing = false;
    }

    public boolean isTailing() {
        return this.tailing;
    }

    public File getFile() {
        return this.file;
    }

    public void addEventListener(EventListener<? super String> l) {
        this.lsup.addEventListener(l);
    }

    public void removeEventListener(EventListener<? super String> l) {
        this.lsup.removeEventListener(l);
    }

    public boolean hasEventListeners() {
        return this.lsup.hasEventListeners();
    }

    public List<EventListener<? super String>> getEventListeners() {
        return this.lsup.getEventListeners();
    }

    public static void main(String[] args) throws IOException {
        Tailer t = new Tailer(new File(args[0]));
        t.addEventListener((src, s) -> System.out.print((String)s));
        t.start();
    }

    private class Monitor
    implements Runnable {
        private Monitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] buf = new byte[4096];
            RandomAccessFile raf = null;
            try {
                raf = new RandomAccessFile(Tailer.this.file, "r");
                while (Tailer.this.tailing) {
                    long length = raf.length();
                    if (length < Tailer.this.position) {
                        raf = new RandomAccessFile(Tailer.this.file, "r");
                        Tailer.this.position = 0L;
                    } else if (length > Tailer.this.position) {
                        raf.seek(Tailer.this.position);
                        int rlen = raf.read(buf);
                        Tailer.this.lsup.notify(new String(buf, 0, rlen, StandardCharsets.UTF_8));
                        Tailer.this.position = raf.getFilePointer();
                    }
                    Thread.sleep(Tailer.this.poll_interval);
                }
            }
            catch (IOException | InterruptedException e) {
                logger.error("", (Throwable)e);
            }
            finally {
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (IOException e) {
                        logger.error("Error while closing the logfile", (Throwable)e);
                    }
                }
            }
        }
    }
}

