/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.script.expression;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.BeanShellExpressionConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.i18n.Resources;
import VASSAL.script.expression.Expression;
import VASSAL.script.expression.IntExpression;
import VASSAL.script.expression.StringExpression;
import VASSAL.tools.BrowserSupport;
import VASSAL.tools.ButtonFactory;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class FunctionBuilder
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected String save;
    protected StringConfigurer target;
    protected String function;
    protected List<BeanShellExpressionConfigurer> configs = new ArrayList<BeanShellExpressionConfigurer>();
    protected EditablePiece targetPiece;
    protected BeanShellExpressionConfigurer result;

    public FunctionBuilder(StringConfigurer c, JDialog parent, String function, String desc, String[] parmDesc, EditablePiece piece, String[] hints, BeanShellExpressionConfigurer.Option[] options, String selectedText) {
        super(parent, Resources.getString("Editor.FunctionBuilder.component_type") + " - " + function, true);
        this.target = c;
        this.targetPiece = piece;
        this.save = this.target.getValueString();
        this.function = function;
        this.setLayout((LayoutManager)new MigLayout("fillx,ins 0"));
        JPanel p = new JPanel((LayoutManager)new MigLayout("fillx", "[]rel[grow]"));
        p.add((Component)new JLabel(desc), "span 2,align center,wrap,growx");
        for (int i = 0; i < parmDesc.length; ++i) {
            String[] config = new BeanShellExpressionConfigurer(null, "", "", (GamePiece)this.targetPiece, options[i], this);
            if (i == 0 && this.isStringFunction() && selectedText != null) {
                config.setValue(selectedText);
            }
            this.configs.add((BeanShellExpressionConfigurer)config);
            p.add((Component)new JLabel(parmDesc[i] + ":"), "align right");
            p.add(config.getControls(), "align right,growx, wrap");
        }
        this.result = new BeanShellExpressionConfigurer(null, "", "", null, BeanShellExpressionConfigurer.Option.NONE, true);
        p.add((Component)new JLabel(Resources.getString("Editor.FunctionBuilder.result")), "align right");
        p.add(this.result.getControls(), "align right,growx, wrap");
        if (hints != null && hints.length > 0) {
            JPanel hintPanel = new JPanel((LayoutManager)new MigLayout("ins 5"));
            hintPanel.setBorder(BorderFactory.createEtchedBorder(1));
            for (String hint : hints) {
                hintPanel.add((Component)new JLabel(hint), "wrap");
            }
            p.add((Component)hintPanel, "span 2,growx,wrap");
        }
        JPanel buttonBox = new JPanel((LayoutManager)new MigLayout("", "push[]rel[]rel[]push"));
        JButton okButton = ButtonFactory.getOkButton();
        okButton.addActionListener(e -> this.save());
        buttonBox.add(okButton);
        JButton cancelButton = ButtonFactory.getCancelButton();
        cancelButton.addActionListener(e -> this.cancel());
        buttonBox.add(cancelButton);
        JButton helpButton = ButtonFactory.getHelpButton();
        helpButton.addActionListener(e -> BrowserSupport.openURL(HelpFile.getReferenceManualPage("ExpressionBuilder.html").getContents().toString()));
        buttonBox.add(helpButton);
        p.add((Component)buttonBox, "span 2,align center,growx,wrap");
        this.add((Component)p, "growx");
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                FunctionBuilder.this.cancel();
            }
        });
    }

    public void update() {
        this.result.setValue(this.buildResult());
        this.result.validate();
    }

    public void save() {
        this.target.setValue(this.buildResult());
        this.dispose();
    }

    protected String buildResult() {
        if (this.function.equals("?")) {
            return "((" + this.configs.get(0).getValueString() + ") ? " + this.getExpr(this.configs.get(1)) + " : " + this.getExpr(this.configs.get(2)) + ")";
        }
        if (this.isStringFunction()) {
            return this.configs.get(0).getValueString() + this.getFunctionBody(true);
        }
        return this.getFunctionBody(false);
    }

    private String getFunctionBody(boolean skipFirstArgument) {
        int i;
        StringBuilder result = new StringBuilder(this.function).append('(');
        boolean first = true;
        int n = i = skipFirstArgument ? 1 : 0;
        while (i < this.configs.size()) {
            BeanShellExpressionConfigurer fec = this.configs.get(i);
            if (!first) {
                result.append(',');
            }
            result.append(fec.getOption() == BeanShellExpressionConfigurer.Option.PME ? this.escape(fec.getValueString()) : fec.getValueString());
            first = false;
            ++i;
        }
        result.append(')');
        return result.toString();
    }

    private String escape(String expr) {
        return "\"{" + expr.replace("\"", "\\\"") + "}\"";
    }

    private String getExpr(Configurer c) {
        Expression e = Expression.createExpression("{" + c.getValueString() + "}");
        boolean isAtomic = e instanceof IntExpression || e instanceof StringExpression;
        return (isAtomic ? "" : "(") + c.getValueString() + (isAtomic ? "" : ")");
    }

    private boolean isStringFunction() {
        return this.function.startsWith(".");
    }

    public void cancel() {
        this.dispose();
    }
}

