/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.script.expression;

import VASSAL.build.module.properties.PropertySource;
import VASSAL.script.expression.BeanShellExpression;
import VASSAL.script.expression.Expression;
import VASSAL.script.expression.ExpressionException;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class SinglePropertyExpression
extends Expression {
    public SinglePropertyExpression(String ex) {
        super(ex.startsWith("$") && ex.endsWith("$") ? ex.substring(1, ex.length() - 1) : ex);
    }

    @Override
    public String evaluate(PropertySource ps, Map<String, String> properties, boolean localized) throws ExpressionException {
        String value = null;
        try {
            if (properties != null) {
                value = properties.get(this.getExpression());
            }
            if (value == null && ps != null) {
                value = localized ? (String)ps.getLocalizedProperty(this.getExpression()) : (String)ps.getProperty(this.getExpression());
            }
        }
        catch (Exception ex) {
            throw new ExpressionException(this.getExpression(), ex.getMessage());
        }
        return value == null ? "" : value;
    }

    @Override
    public String toBeanShellString() {
        return BeanShellExpression.convertProperty(this.getExpression());
    }

    public static Expression instance(String s) {
        return CACHE.computeIfAbsent(Pair.of((Object)s, SinglePropertyExpression.class), k -> new SinglePropertyExpression(s));
    }
}

