/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.Configurable;
import VASSAL.build.module.documentation.HelpWindow;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.PropertiesWindow;
import VASSAL.i18n.Resources;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;

public class EditPropertiesAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    protected Configurable target;
    protected HelpWindow helpWindow;
    protected static final Map<Configurable, PropertiesWindow> openWindows = new HashMap<Configurable, PropertiesWindow>();
    protected Frame dialogOwner;
    protected ConfigureTree tree;

    public EditPropertiesAction(Configurable target, HelpWindow helpWindow, Frame dialogOwner) {
        super(Resources.getString("Editor.properties"));
        this.helpWindow = helpWindow;
        this.target = target;
        this.dialogOwner = dialogOwner;
        this.setEnabled(target.getConfigurer() != null);
    }

    public EditPropertiesAction(Configurable target, HelpWindow helpWindow, Frame dialogOwner, ConfigureTree tree) {
        this(target, helpWindow, dialogOwner);
        this.tree = tree;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        PropertiesWindow w = openWindows.get(this.target);
        if (w == null) {
            boolean ctrl;
            w = new PropertiesWindow(this.dialogOwner, false, this.target, this.helpWindow);
            w.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    openWindows.remove(EditPropertiesAction.this.target);
                    if (EditPropertiesAction.this.tree != null) {
                        if (EditPropertiesAction.this.target instanceof ConfigureTree.Mutable) {
                            EditPropertiesAction.this.tree.nodeUpdated(EditPropertiesAction.this.target);
                        }
                        EditPropertiesAction.this.tree.nodeEdited(EditPropertiesAction.this.target);
                    }
                }
            });
            openWindows.put(this.target, w);
            w.setVisible(true);
            boolean alt = (evt.getModifiers() & 0x200) != 0;
            boolean shift = (evt.getModifiers() & 0x40) != 0;
            boolean bl = ctrl = (evt.getModifiers() & 0x180) != 0;
            if (alt || shift || ctrl) {
                int y;
                int x;
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice defaultScreen = ge.getDefaultScreenDevice();
                Rectangle rect = defaultScreen.getDefaultConfiguration().getBounds();
                if (alt) {
                    if (ctrl && shift) {
                        x = 30;
                        y = (int)rect.getMaxY() - w.getHeight() - 30;
                    } else if (ctrl) {
                        x = 30;
                        y = 30;
                    } else if (shift) {
                        x = (int)rect.getMaxX() - w.getWidth() - 30;
                        y = (int)rect.getMaxY() - w.getHeight() - 30;
                    } else {
                        x = 30;
                        y = ((int)rect.getMaxY() - w.getHeight()) / 2;
                    }
                } else if (shift) {
                    if (ctrl) {
                        x = (int)rect.getMaxX() - w.getWidth() - 30;
                        y = 30;
                    } else {
                        x = (int)rect.getMaxX() - w.getWidth() - 30;
                        y = (int)(rect.getMaxY() - (double)w.getHeight()) / 2;
                    }
                } else {
                    x = ((int)rect.getMaxX() - w.getWidth()) / 2;
                    y = ((int)rect.getMaxY() - w.getHeight()) / 2;
                }
                w.setLocation(x, y);
            }
            SwingUtils.ensureOnScreen(w);
            if (this.tree != null) {
                this.tree.notifyStateChanged(true);
                this.tree.nodeEdited(this.target);
            }
        }
        w.toFront();
    }
}

