/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.script.expression;

import VASSAL.build.BadDataReport;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.counters.PieceFilter;
import VASSAL.i18n.Resources;
import VASSAL.script.expression.AuditTrail;
import VASSAL.script.expression.Auditable;
import VASSAL.script.expression.BeanShellExpression;
import VASSAL.script.expression.ExpressionException;
import VASSAL.script.expression.FormattedStringExpression;
import VASSAL.script.expression.IntExpression;
import VASSAL.script.expression.NullExpression;
import VASSAL.script.expression.PropertyMatchExpression;
import VASSAL.script.expression.SinglePropertyExpression;
import VASSAL.script.expression.StringExpression;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.concurrent.ConcurrentSoftHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;

public class Expression {
    protected static final Map<Pair<Object, Class<? extends Expression>>, Expression> CACHE = new ConcurrentSoftHashMap<Pair<Object, Class<? extends Expression>>, Expression>();
    private final String expr;

    protected Expression(String s) {
        this.expr = s;
    }

    public String getExpression() {
        return this.expr;
    }

    public void setExpression(String s) {
        throw new UnsupportedOperationException();
    }

    protected void reset() {
    }

    public String evaluate(PropertySource ps, Map<String, String> properties, boolean localized, Auditable owner, AuditTrail audit) throws ExpressionException {
        return this.expr;
    }

    public String evaluate(PropertySource ps, boolean localized, Auditable owner, AuditTrail audit) throws ExpressionException {
        return this.evaluate(ps, null, localized, owner, audit);
    }

    public String evaluate(PropertySource ps, Auditable owner, AuditTrail audit) throws ExpressionException {
        return this.evaluate(ps, null, false, owner, audit);
    }

    public String evaluate(Auditable owner, AuditTrail audit) throws ExpressionException {
        return this.evaluate(null, null, false, owner, audit);
    }

    @Deprecated(since="2021-06-11")
    public String evaluate(PropertySource ps, Map<String, String> properties, boolean localized) throws ExpressionException {
        return this.evaluate(ps, properties, localized, null, null);
    }

    @Deprecated(since="2021-06-11")
    public String evaluate(PropertySource ps, boolean localized) throws ExpressionException {
        return this.evaluate(ps, null, localized, null, null);
    }

    @Deprecated(since="2021-06-11")
    public String evaluate(PropertySource ps) throws ExpressionException {
        return this.evaluate(ps, null, false, null, null);
    }

    @Deprecated(since="2021-06-11")
    public String evaluate(boolean localized) throws ExpressionException {
        return this.evaluate(null, null, localized, null, null);
    }

    @Deprecated(since="2021-06-11")
    public String evaluate() throws ExpressionException {
        return this.evaluate(null, null, false, null, null);
    }

    protected void handleError(ExpressionException e) {
        ErrorDialog.dataWarning(new BadDataReport(Resources.getString("Error.expression_error"), this.getExpression(), e));
    }

    public String tryEvaluate(PropertySource ps, Auditable owner, AuditTrail audit) {
        return this.tryEvaluate(ps, null, false, owner, audit);
    }

    public String tryEvaluate(PropertySource ps, Auditable owner, String fieldKey) {
        return this.tryEvaluate(ps, null, false, owner, AuditTrail.create(owner, this.getExpression(), Resources.getString(fieldKey)));
    }

    public String quietEvaluate(PropertySource ps, Auditable owner, String fieldKey) {
        return this.quietEvaluate(ps, null, false, owner, null);
    }

    @Deprecated(since="2021-06-11")
    public String tryEvaluate(PropertySource ps) {
        return this.tryEvaluate(ps, null, false, null, null);
    }

    public String tryEvaluate(Auditable owner, AuditTrail audit) {
        return this.tryEvaluate(null, null, false, owner, audit);
    }

    @Deprecated(since="2021-06-11")
    public String tryEvaluate() {
        return this.tryEvaluate(null, null, false, null, null);
    }

    public String tryEvaluate(PropertySource ps, boolean localized, Auditable owner, AuditTrail audit) {
        return this.tryEvaluate(ps, null, localized, owner, audit);
    }

    @Deprecated(since="2021-06-11")
    public String tryEvaluate(PropertySource ps, boolean localized) {
        return this.tryEvaluate(ps, null, localized, null, null);
    }

    public String tryEvaluate(boolean localized, Auditable owner, AuditTrail audit) {
        return this.tryEvaluate(null, null, localized, owner, audit);
    }

    @Deprecated(since="2021-06-11")
    public String tryEvaluate(boolean localized) {
        return this.tryEvaluate(null, null, localized, null, null);
    }

    public String tryEvaluate(PropertySource ps, Map<String, String> properties, boolean localized, Auditable owner, AuditTrail audit) {
        try {
            return this.evaluate(ps, properties, localized, owner, audit);
        }
        catch (ExpressionException e) {
            this.handleError(e);
            return "";
        }
    }

    public String quietEvaluate(PropertySource ps, Map<String, String> properties, boolean localized, Auditable owner, AuditTrail audit) {
        try {
            return this.evaluate(ps, properties, localized, owner, audit);
        }
        catch (ExpressionException e) {
            return "";
        }
    }

    @Deprecated(since="2021-06-11")
    public String tryEvaluate(PropertySource ps, Map<String, String> properties, boolean localized) {
        return this.tryEvaluate(ps, properties, localized, null, null);
    }

    public PieceFilter getFilter(PropertySource ps, Auditable owner, AuditTrail audit) {
        return piece -> true;
    }

    public PieceFilter getFilter(Auditable owner, AuditTrail audit) {
        return this.getFilter(null, owner, audit);
    }

    @Deprecated(since="2021-06-11")
    public PieceFilter getFilter(PropertySource ps) {
        return this.getFilter(ps, null, null);
    }

    @Deprecated(since="2021-06-11")
    public PieceFilter getFilter() {
        return this.getFilter(null, null);
    }

    public String toBeanShellString() {
        return this.expr;
    }

    public static Expression createExpression(String s) {
        if (s == null || s.isBlank()) {
            return NullExpression.instance();
        }
        String t = s.trim();
        if (t.startsWith("{") && t.endsWith("}")) {
            return BeanShellExpression.createExpression(s);
        }
        try {
            return IntExpression.instance(Integer.parseInt(t));
        }
        catch (NumberFormatException numberFormatException) {
            if (t.indexOf(36) >= 0) {
                return FormattedStringExpression.instance(t);
            }
            return StringExpression.instance(s);
        }
    }

    public int hashCode() {
        return this.expr == null ? 0 : this.expr.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Expression other = (Expression)obj;
        return Objects.equals(this.expr, other.expr);
    }

    public static Expression createPropertyExpression(String s) {
        if (s == null || s.isBlank()) {
            return NullExpression.instance();
        }
        String t = s.trim();
        if (t.startsWith("{") && t.endsWith("}")) {
            return BeanShellExpression.instance(t.substring(1, t.length() - 1));
        }
        return PropertyMatchExpression.instance(t);
    }

    public static Expression createSimplePropertyExpression(String s) {
        if (s == null || s.isBlank()) {
            return NullExpression.instance();
        }
        String t = s.trim();
        if (t.startsWith("{") && t.endsWith("}")) {
            return BeanShellExpression.instance(t.substring(1, t.length() - 1));
        }
        return SinglePropertyExpression.instance(t);
    }

    public static void resetCachedExpressions() {
        CACHE.values().forEach(e -> {
            if (e != null) {
                e.reset();
            }
        });
    }
}

