/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imageop;

import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.AbstractTileOpImpl;
import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.opcache.Op;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class SourceTileOpBitmapImpl
extends AbstractTileOpImpl {
    private final ImageOp sop;
    private final int x0;
    private final int y0;
    private final int x1;
    private final int y1;
    private final int hash;

    public SourceTileOpBitmapImpl(ImageOp sop, int tileX, int tileY) {
        if (sop == null) {
            throw new IllegalArgumentException();
        }
        if (tileX < 0 || tileX >= sop.getNumXTiles() || tileY < 0 || tileY >= sop.getNumYTiles()) {
            throw new IndexOutOfBoundsException();
        }
        this.sop = sop;
        int tw = sop.getTileWidth();
        int th = sop.getTileHeight();
        int sw = sop.getWidth();
        int sh = sop.getHeight();
        this.x0 = tileX * tw;
        this.y0 = tileY * th;
        this.x1 = Math.min((tileX + 1) * tw, sw);
        this.y1 = Math.min((tileY + 1) * th, sh);
        this.size = new Dimension(this.x1 - this.x0, this.y1 - this.y0);
        this.hash = new HashCodeBuilder().append((Object)sop).append(this.x0).append(this.y0).append(this.x1).append(this.y1).toHashCode();
    }

    @Override
    public List<Op<?>> getSources() {
        return Collections.singletonList(this.sop);
    }

    @Override
    public BufferedImage eval() throws Exception {
        BufferedImage src = this.sop.getImage(null);
        BufferedImage dst = ImageUtils.createCompatibleImage(this.size.width, this.size.height, src.getTransparency() != 1);
        Graphics2D g = dst.createGraphics();
        g.drawImage(src, 0, 0, this.size.width, this.size.height, this.x0, this.y0, this.x1, this.y1, null);
        g.dispose();
        return dst;
    }

    @Override
    protected void fixSize() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        SourceTileOpBitmapImpl op = (SourceTileOpBitmapImpl)o;
        return this.x0 == op.x0 && this.y0 == op.y0 && this.x1 == op.x1 && this.y1 == op.y1 && this.sop.equals(op.sop);
    }

    public int hashCode() {
        return this.hash;
    }
}

