/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.NamedKeyStroke;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public abstract class AbstractToolbarItem
extends AbstractConfigurable {
    public static final String NAME = "name";
    public static final String TOOLTIP = "tooltip";
    public static final String BUTTON_TEXT = "text";
    public static final String HOTKEY = "hotkey";
    public static final String ICON = "icon";
    protected LaunchButton launch;
    private String nameKey = "name";
    private String tooltipKey = "tooltip";
    private String buttonTextKey = "text";
    private String hotKeyKey = "hotkey";
    private String iconKey = "icon";
    private String namePrompt = "";

    protected void setNamePrompt(String namePrompt) {
        this.namePrompt = namePrompt;
    }

    protected void setNameKey(String nameKey) {
        this.nameKey = nameKey;
    }

    protected void setTooltipKey(String tooltipKey) {
        this.tooltipKey = tooltipKey;
    }

    protected void setButtonTextKey(String buttonTextKey) {
        this.buttonTextKey = buttonTextKey;
    }

    protected void setHotKeyKey(String hotKeyKey) {
        this.hotKeyKey = hotKeyKey;
    }

    protected void setIconKey(String iconKey) {
        this.iconKey = iconKey;
    }

    protected LaunchButton makeLaunchButton(String tooltip, String button_text, String iconFile, ActionListener action) {
        this.launch = new LaunchButton(button_text, this.tooltipKey, this.buttonTextKey, this.hotKeyKey, this.iconKey, action);
        if (!tooltip.isEmpty()) {
            this.setAttribute(this.tooltipKey, tooltip);
        }
        if (!button_text.isEmpty()) {
            if (!this.nameKey.isEmpty()) {
                this.setAttribute(this.nameKey, button_text);
            }
            this.launch.setAttribute(this.buttonTextKey, button_text);
        }
        if (!iconFile.isEmpty()) {
            this.setAttribute(this.iconKey, iconFile);
        }
        return this.launch;
    }

    public LaunchButton getLaunchButton() {
        return this.launch;
    }

    protected void setLaunchButton(LaunchButton launch) {
        this.launch = launch;
    }

    @Override
    public String[] getAttributeNames() {
        if (!this.nameKey.isEmpty()) {
            return new String[]{this.nameKey, this.buttonTextKey, this.tooltipKey, this.iconKey, this.hotKeyKey};
        }
        return new String[]{this.buttonTextKey, this.tooltipKey, this.iconKey, this.hotKeyKey};
    }

    @Override
    public String[] getAttributeDescriptions() {
        if (!this.nameKey.isEmpty()) {
            return new String[]{this.namePrompt.isEmpty() ? Resources.getString("Editor.description_label") : this.namePrompt, Resources.getString("Editor.button_text_label"), Resources.getString("Editor.tooltip_text_label"), Resources.getString("Editor.button_icon_label"), Resources.getString("Editor.hotkey_label")};
        }
        return new String[]{Resources.getString("Editor.button_text_label"), Resources.getString("Editor.tooltip_text_label"), Resources.getString("Editor.button_icon_label"), Resources.getString("Editor.hotkey_label")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        if (!this.nameKey.isEmpty()) {
            return new Class[]{String.class, String.class, String.class, IconConfig.class, NamedKeyStroke.class};
        }
        return new Class[]{String.class, String.class, IconConfig.class, NamedKeyStroke.class};
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (!this.nameKey.isEmpty() && this.nameKey.equals(key)) {
            this.setConfigureName((String)value);
        } else {
            this.launch.setAttribute(key, value);
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (!this.nameKey.isEmpty() && this.nameKey.equals(key)) {
            return this.getConfigureName();
        }
        return this.launch.getAttributeValueString(key);
    }

    protected Component getComponent() {
        return this.launch;
    }

    @Override
    public void addTo(Buildable parent) {
        GameModule.getGameModule().getToolBar().add(this.getComponent());
    }

    @Override
    public void removeFrom(Buildable b) {
        GameModule.getGameModule().getToolBar().remove(this.getComponent());
        GameModule.getGameModule().getToolBar().revalidate();
    }

    @Override
    public List<String> getMenuTextList() {
        return List.of(this.getAttributeValueString(this.buttonTextKey), this.getAttributeValueString(this.tooltipKey));
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return Arrays.asList(NamedHotKeyConfigurer.decode(this.getAttributeValueString(this.hotKeyKey)));
    }

    @Override
    public void addLocalImageNames(Collection<String> s) {
        String string = this.launch.getAttributeValueString(this.launch.getIconAttribute());
        if (string != null) {
            s.add(string);
        }
    }

    public static class IconConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new IconConfigurer(key, name, ((AbstractToolbarItem)c).getLaunchButton().getAttributeValueString(AbstractToolbarItem.ICON));
        }
    }
}

