/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.GlobalKeyCommand;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.MassKeyCommand;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.configure.TranslatableStringEnum;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.Resources;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.UniqueIdManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class StartupGlobalKeyCommand
extends GlobalKeyCommand
implements GameComponent,
CommandEncoder,
UniqueIdManager.Identifyable {
    public static final String WHEN_TO_APPLY = "whenToApply";
    public static final String APPLY_FIRST_LAUNCH_OF_SESSION = "firstLaunchOfSession";
    public static final String APPLY_EVERY_LAUNCH_OF_SESSION = "everyLaunchOfSession";
    public static final String APPLY_START_OF_GAME_ONLY = "startOfGameOnly";
    private static final char DELIMITER = '\t';
    public static final String COMMAND_PREFIX = "SGKC\t";
    protected static final UniqueIdManager idMgr = new UniqueIdManager("SGKC");
    protected String id = "";
    public String whenToApply = "everyLaunchOfSession";
    private boolean hasEverApplied = false;
    private boolean hasAppliedThisGame = false;

    public StartupGlobalKeyCommand() {
        this.condition = null;
        this.launch.setAttribute("buttonText", "");
        this.launch.setAttribute("tooltip", "");
        this.launch.setAttribute("icon", "");
        this.launch.setAttribute("buttonHotkey", "");
    }

    public StartupGlobalKeyCommand(MassKeyCommand gkc) {
        super(gkc);
        this.condition = null;
        this.launch.setAttribute("buttonText", "");
        this.launch.setAttribute("tooltip", "");
        this.launch.setAttribute("icon", "");
        this.launch.setAttribute("buttonHotkey", "");
    }

    @Override
    public void addTo(Buildable parent) {
        idMgr.add(this);
        super.addTo(parent);
        GameModule.getGameModule().getGameState().addGameComponent(this);
        GameModule.getGameModule().addCommandEncoder(this);
    }

    @Override
    public void removeFrom(Buildable parent) {
        GameModule.getGameModule().getGameState().removeGameComponent(this);
        GameModule.getGameModule().removeCommandEncoder(this);
        idMgr.remove(this);
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.StartupGlobalKeyCommand.component_type");
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.html", "StartupGlobalKeyCommand");
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String key) {
        if (List.of("buttonText", "tooltip", "icon", "buttonHotkey").contains(key)) {
            return () -> false;
        }
        return super.getAttributeVisibility(key);
    }

    @Override
    public String[] getAttributeDescriptions() {
        ArrayList<String> descs = new ArrayList<String>();
        descs.add(Resources.getString("Editor.StartupGlobalKeyCommand.when_to_apply"));
        Collections.addAll(descs, super.getAttributeDescriptions());
        return descs.toArray(new String[0]);
    }

    @Override
    public String[] getAttributeNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(WHEN_TO_APPLY);
        for (String n : super.getAttributeNames()) {
            if (List.of("propValue", "property", "names").contains(n)) continue;
            names.add(n);
        }
        return names.toArray(new String[0]);
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        ArrayList<Class<Prompt>> types = new ArrayList<Class<Prompt>>();
        types.add(Prompt.class);
        Collections.addAll(types, super.getAttributeTypes());
        return types.toArray(new Class[0]);
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (WHEN_TO_APPLY.equals(key)) {
            if (value instanceof String) {
                this.whenToApply = (String)value;
            }
        } else {
            super.setAttribute(key, value);
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (WHEN_TO_APPLY.equals(key)) {
            return this.whenToApply;
        }
        return super.getAttributeValueString(key);
    }

    public boolean applyIfNotApplied() {
        if (APPLY_FIRST_LAUNCH_OF_SESSION.equals(this.whenToApply) ? this.hasEverApplied : APPLY_START_OF_GAME_ONLY.equals(this.whenToApply) && this.hasAppliedThisGame) {
            return false;
        }
        this.hasEverApplied = true;
        this.hasAppliedThisGame = true;
        this.apply();
        return true;
    }

    @Override
    public void setup(boolean gameStarting) {
    }

    public void freshGame() {
        this.hasAppliedThisGame = false;
    }

    @Override
    public Command getRestoreCommand() {
        return new UpdateStartupGlobalKeyCommand(this, this.hasAppliedThisGame);
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Command decode(String command) {
        if (!command.startsWith(COMMAND_PREFIX + this.getId() + "\t")) {
            return null;
        }
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(command, '\t');
        decoder.nextToken();
        decoder.nextToken();
        boolean applied = decoder.nextBoolean(true);
        return new UpdateStartupGlobalKeyCommand(this, applied);
    }

    @Override
    public String encode(Command c) {
        if (!(c instanceof UpdateStartupGlobalKeyCommand)) {
            return null;
        }
        UpdateStartupGlobalKeyCommand comm = (UpdateStartupGlobalKeyCommand)c;
        SequenceEncoder encoder = new SequenceEncoder('\t');
        encoder.append(comm.getId());
        encoder.append(comm.appliedThisGame);
        if (!this.id.equals(comm.getId())) {
            return null;
        }
        return COMMAND_PREFIX + encoder.getValue();
    }

    public static class Prompt
    extends TranslatableStringEnum {
        @Override
        public String[] getValidValues(AutoConfigurable target) {
            return new String[]{StartupGlobalKeyCommand.APPLY_FIRST_LAUNCH_OF_SESSION, StartupGlobalKeyCommand.APPLY_EVERY_LAUNCH_OF_SESSION, StartupGlobalKeyCommand.APPLY_START_OF_GAME_ONLY};
        }

        @Override
        public String[] getI18nKeys(AutoConfigurable target) {
            return new String[]{"Editor.StartupGlobalKeyCommand.first_launch_of_session", "Editor.StartupGlobalKeyCommand.every_launch_of_session", "Editor.StartupGlobalKeyCommand.start_of_game_only"};
        }
    }

    private static class UpdateStartupGlobalKeyCommand
    extends Command {
        private final boolean appliedThisGame;
        StartupGlobalKeyCommand sgkc;

        public UpdateStartupGlobalKeyCommand(StartupGlobalKeyCommand sgkc, boolean appliedThisGame) {
            this.sgkc = sgkc;
            this.appliedThisGame = appliedThisGame;
        }

        @Override
        protected void executeCommand() {
            this.sgkc.hasAppliedThisGame = this.appliedThisGame;
        }

        @Override
        protected Command myUndoCommand() {
            return null;
        }

        public String getId() {
            return this.sgkc.getId();
        }
    }
}

