/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.boardPicker.board.mapgrid;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.HexGrid;
import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.build.module.map.boardPicker.board.RegionGrid;
import VASSAL.build.module.map.boardPicker.board.SquareGrid;
import VASSAL.build.module.map.boardPicker.board.ZonedGrid;
import VASSAL.build.module.map.boardPicker.board.mapgrid.GridContainer;
import VASSAL.build.module.map.boardPicker.board.mapgrid.PolygonEditor;
import VASSAL.build.module.map.boardPicker.board.mapgrid.ZoneHighlight;
import VASSAL.build.module.properties.ChangePropertyCommandEncoder;
import VASSAL.build.module.properties.MutablePropertiesContainer;
import VASSAL.build.module.properties.MutableProperty;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.build.module.properties.ZoneProperty;
import VASSAL.command.Command;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.FormattedStringConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.script.expression.Auditable;
import VASSAL.tools.AdjustableSpeedScrollPane;
import VASSAL.tools.FormattedString;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.swing.FlowLabel;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class Zone
extends AbstractConfigurable
implements GridContainer,
MutablePropertiesContainer,
PropertySource,
GameComponent {
    public static final String NAME = "name";
    public static final String PATH = "path";
    public static final String USE_PARENT_GRID = "useParentGrid";
    public static final String LOCATION_FORMAT = "locationFormat";
    public static final String GRID_LOCATION = "gridLocation";
    public static final String USE_HIGHLIGHT = "useHighlight";
    public static final String HIGHLIGHT_PROPERTY = "highlightProperty";
    protected static final Dimension DEFAULT_SIZE = new Dimension(600, 600);
    protected String locationFormat = "$name$";
    protected FormattedString format = new FormattedString();
    protected Polygon myPolygon;
    protected MapGrid grid = null;
    protected ZonedGrid parentGrid;
    protected boolean useParentGrid;
    protected PropertyChangeListener globalPropertyListener;
    protected MutablePropertiesContainer propsContainer = new MutablePropertiesContainer.Impl();
    protected PropertyChangeListener repaintOnPropertyChange = evt -> this.repaint();
    protected int lastBoundsX = -1;
    protected int lastBoundsY = -1;
    protected double lastScale = -1.0;
    protected Shape lastScaledShape = null;
    protected Shape lastTransformedShape = null;
    protected Polygon lastPolygon = null;
    protected ZoneHighlight highlighter = null;
    protected boolean useHighlight = false;
    protected String highlightPropertyName = "";
    protected MutableProperty highlightProperty = null;
    protected PropertyChangeListener highlightPropertyChangeListener = null;

    public Zone() {
        this.myPolygon = new Polygon();
        this.setConfigureName("");
    }

    public String getName() {
        return this.getConfigureName();
    }

    public String getLocalizedName() {
        return this.getLocalizedConfigureName();
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, LOCATION_FORMAT, PATH, USE_PARENT_GRID, USE_HIGHLIGHT, HIGHLIGHT_PROPERTY};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.name_label"), Resources.getString("Editor.Zone.location_format"), Resources.getString("Editor.Zone.shape"), Resources.getString("Editor.Zone.use_boards_grid"), Resources.getString("Editor.Zone.use_highlighting"), Resources.getString("Editor.Zone.highlight_property")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, LocationFormatConfig.class, ShapeEditor.class, Boolean.class, Boolean.class, String.class};
    }

    @Override
    public void addTo(Buildable b) {
        this.parentGrid = (ZonedGrid)b;
        this.parentGrid.addZone(this);
        GameModule.getGameModule().getGameState().addGameComponent(this);
        GameModule.getGameModule().addCommandEncoder(new ChangePropertyCommandEncoder(this));
        this.setAttributeTranslatable(HIGHLIGHT_PROPERTY, false);
    }

    public void repaint() {
        if (this.getMap() != null) {
            this.getMap().repaint();
        }
    }

    @Override
    public void removeFrom(Buildable b) {
        ((ZonedGrid)b).removeZone(this);
        GameModule.getGameModule().getGameState().removeGameComponent(this);
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.Zone.component_type");
    }

    @Override
    public HelpFile getHelpFile() {
        return null;
    }

    @Override
    public String getAttributeValueString(String key) {
        if (NAME.equals(key)) {
            return this.getConfigureName();
        }
        if (PATH.equals(key)) {
            return PolygonEditor.polygonToString(this.myPolygon);
        }
        if (LOCATION_FORMAT.equals(key)) {
            return this.locationFormat;
        }
        if (USE_PARENT_GRID.equals(key)) {
            return String.valueOf(this.useParentGrid);
        }
        if (USE_HIGHLIGHT.equals(key)) {
            return String.valueOf(this.useHighlight);
        }
        if (HIGHLIGHT_PROPERTY.equals(key)) {
            return this.highlightPropertyName;
        }
        return null;
    }

    @Override
    public void setAttribute(String key, Object val) {
        if (val == null) {
            return;
        }
        if (NAME.equals(key)) {
            this.setConfigureName((String)val);
        } else if (PATH.equals(key)) {
            PolygonEditor.reset(this.myPolygon, (String)val);
        } else if (LOCATION_FORMAT.equals(key)) {
            this.locationFormat = (String)val;
        } else if (USE_PARENT_GRID.equals(key)) {
            this.useParentGrid = "true".equals(val) || Boolean.TRUE.equals(val);
        } else if (USE_HIGHLIGHT.equals(key)) {
            this.useHighlight = "true".equals(val) || Boolean.TRUE.equals(val);
        } else if (HIGHLIGHT_PROPERTY.equals(key)) {
            this.highlightPropertyName = (String)val;
        }
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (HIGHLIGHT_PROPERTY.equals(name)) {
            return () -> this.useHighlight;
        }
        return super.getAttributeVisibility(name);
    }

    public Class<?>[] getAllowableConfigureComponents() {
        Class[] classArray;
        if (this.useParentGrid) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = ZoneProperty.class;
        } else {
            Class[] classArray3 = new Class[4];
            classArray3[0] = HexGrid.class;
            classArray3[1] = SquareGrid.class;
            classArray3[2] = RegionGrid.class;
            classArray = classArray3;
            classArray3[3] = ZoneProperty.class;
        }
        return classArray;
    }

    @Override
    public void addMutableProperty(String key, MutableProperty p) {
        p.addMutablePropertyChangeListener(this.repaintOnPropertyChange);
        this.propsContainer.addMutableProperty(key, p);
    }

    @Override
    public MutableProperty removeMutableProperty(String key) {
        MutableProperty existing = this.propsContainer.removeMutableProperty(key);
        if (existing != null) {
            existing.removeMutablePropertyChangeListener(this.repaintOnPropertyChange);
        }
        return existing;
    }

    public Point getLocation(String location) throws MapGrid.BadCoords {
        SequenceEncoder.Decoder se = new SequenceEncoder.Decoder(this.locationFormat, '$');
        boolean isProperty = true;
        StringBuilder regex = new StringBuilder();
        int groupCount = 0;
        while (se.hasMoreTokens()) {
            String token = se.nextToken();
            boolean bl = isProperty = !isProperty;
            if (token.length() <= 0) continue;
            if (!isProperty || !se.hasMoreTokens()) {
                regex.append(Pattern.quote(token));
                continue;
            }
            if (token.equals(NAME)) {
                regex.append(Pattern.quote(this.getConfigureName()));
                continue;
            }
            if (!token.equals(GRID_LOCATION) || this.getGrid() == null) continue;
            regex.append("(.*)");
            ++groupCount;
        }
        if (regex.length() == 0) {
            throw new MapGrid.BadCoords();
        }
        Pattern pattern = Pattern.compile(regex.toString());
        Matcher matcher = pattern.matcher(location);
        if (!matcher.matches()) {
            throw new MapGrid.BadCoords();
        }
        assert (matcher.groupCount() == groupCount);
        if (groupCount > 0) {
            String locationName = location.substring(matcher.start(groupCount), matcher.end(groupCount));
            Point p = this.getGrid().getLocation(locationName);
            if (p == null || !this.contains(p)) {
                throw new MapGrid.BadCoords();
            }
            return p;
        }
        Point p = new Point(0, 0);
        for (int i = 0; i < this.myPolygon.npoints; ++i) {
            p.translate(this.myPolygon.xpoints[i], this.myPolygon.ypoints[i]);
        }
        p.x /= this.myPolygon.npoints;
        p.y /= this.myPolygon.npoints;
        if (!this.contains(p)) {
            p.x = this.myPolygon.xpoints[0];
            p.y = this.myPolygon.ypoints[0];
        }
        return p;
    }

    public String locationName(Point p) {
        this.format.setFormat(this.locationFormat);
        this.format.setProperty(NAME, this.getConfigureName());
        String gridLocation = null;
        if (this.getGrid() != null) {
            gridLocation = this.getGrid().locationName(p);
        }
        this.format.setProperty(GRID_LOCATION, gridLocation);
        return this.format.getText((Auditable)this, "Editor.Zone.location_format");
    }

    public String localizedLocationName(Point p) {
        this.format.setFormat(this.locationFormat);
        this.format.setProperty(NAME, this.getLocalizedConfigureName());
        String gridLocation = null;
        if (this.getGrid() != null) {
            gridLocation = this.getGrid().localizedLocationName(p);
        }
        this.format.setProperty(GRID_LOCATION, gridLocation);
        return this.format.getLocalizedText(this, "Editor.Zone.location_format");
    }

    @Override
    public boolean contains(Point p) {
        return this.myPolygon.contains(p);
    }

    public Point snapTo(Point p) {
        Point snap = p;
        if (this.getGrid() != null) {
            snap = this.getGrid().snapTo(p);
        }
        return snap;
    }

    @Override
    public Dimension getSize() {
        return this.myPolygon.getBounds().getSize();
    }

    @Override
    public void removeGrid(MapGrid grid) {
        if (this.grid == grid) {
            this.grid = null;
        }
    }

    @Override
    public Board getBoard() {
        return this.parentGrid == null ? null : this.parentGrid.getBoard();
    }

    public Map getMap() {
        return this.parentGrid == null ? null : this.parentGrid.getBoard().getMap();
    }

    public ZonedGrid getParentGrid() {
        return this.parentGrid;
    }

    @Override
    public void setGrid(MapGrid m) {
        this.grid = m;
    }

    public MapGrid getGrid() {
        if (this.useParentGrid) {
            return this.parentGrid != null ? this.parentGrid.getBackgroundGrid() : null;
        }
        return this.grid;
    }

    public boolean isUseParentGrid() {
        return this.useParentGrid;
    }

    public Shape getShape() {
        return this.myPolygon;
    }

    public Rectangle getBounds() {
        return this.myPolygon.getBounds();
    }

    public void setHighlight(ZoneHighlight h) {
        this.highlighter = h;
    }

    public void draw(Graphics g, Rectangle bounds, Rectangle visibleRect, double scale, boolean reversed) {
        if (this.getGrid() != null && this.getGrid().isVisible() || this.highlighter != null) {
            Graphics2D g2d = (Graphics2D)g;
            Shape oldClip = g2d.getClip();
            Area newClip = new Area(visibleRect);
            Shape s = this.getCachedShape(this.myPolygon, bounds.x, bounds.y, scale);
            newClip.intersect(new Area(s));
            g2d.setClip(newClip);
            if (this.getGrid() != null && this.getGrid().isVisible()) {
                this.getGrid().draw(g, bounds, visibleRect, scale, reversed);
            }
            if (this.highlighter != null) {
                this.highlighter.draw(g2d, s, scale);
            }
            g2d.setClip(oldClip);
        }
    }

    protected Shape getScaledShape(Polygon myPolygon, double scale) {
        if (scale == this.lastScale && this.lastPolygon == myPolygon && this.lastScaledShape != null) {
            return this.lastScaledShape;
        }
        AffineTransform transform = AffineTransform.getScaleInstance(scale, scale);
        this.lastScaledShape = transform.createTransformedShape(myPolygon);
        this.lastScale = scale;
        this.lastPolygon = myPolygon;
        return this.lastScaledShape;
    }

    protected Shape getCachedShape(Polygon poly, int x, int y, double scale) {
        if (poly.equals(this.lastPolygon) && x == this.lastBoundsX && y == this.lastBoundsY && scale == this.lastScale) {
            return this.lastTransformedShape;
        }
        Shape scaled = this.getScaledShape(this.myPolygon, scale);
        AffineTransform transform = AffineTransform.getTranslateInstance(x, y);
        this.lastTransformedShape = transform.createTransformedShape(scaled);
        this.lastPolygon = this.myPolygon;
        this.lastBoundsX = x;
        this.lastBoundsY = y;
        this.lastScale = scale;
        return this.lastTransformedShape;
    }

    @Override
    public Object getProperty(Object key) {
        MutableProperty p = this.propsContainer.getMutableProperty(String.valueOf(key));
        Object value = p != null ? p.getPropertyValue() : this.getMap().getProperty(key);
        return value;
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        Object value = null;
        MutableProperty p = this.propsContainer.getMutableProperty(String.valueOf(key));
        if (p != null) {
            value = p.getPropertyValue();
        }
        if (value == null) {
            value = this.getMap().getLocalizedProperty(key);
        }
        return value;
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> l = new ArrayList<String>();
        for (ZoneProperty zp : this.getComponentsOf(ZoneProperty.class)) {
            l.add(zp.getConfigureName());
        }
        return l;
    }

    @Override
    public MutableProperty getMutableProperty(String name) {
        return this.propsContainer.getMutableProperty(name);
    }

    @Override
    public String getMutablePropertiesContainerId() {
        return (this.getMap() == null ? "" : this.getMap().getMapName()) + ":" + this.getConfigureName();
    }

    @Override
    public void setup(boolean gameStarting) {
        if (gameStarting) {
            if (this.useHighlight && this.highlightPropertyName.length() > 0) {
                this.highlightProperty = MutableProperty.Util.findMutableProperty(this.highlightPropertyName, Arrays.asList(this, this.getMap(), GameModule.getGameModule()));
                if (this.highlightProperty != null) {
                    if (this.highlightPropertyChangeListener == null) {
                        this.highlightPropertyChangeListener = e -> this.setHighlighter((String)e.getNewValue());
                    }
                    this.highlightProperty.addMutablePropertyChangeListener(this.highlightPropertyChangeListener);
                    this.setHighlighter(this.highlightProperty.getPropertyValue());
                }
            }
        } else if (this.highlightProperty != null && this.highlightPropertyChangeListener != null) {
            this.highlightProperty.removeMutablePropertyChangeListener(this.highlightPropertyChangeListener);
            this.highlightProperty = null;
        }
    }

    public void setHighlighter(String highlightName) {
        this.highlighter = this.parentGrid.getZoneHighlight(highlightName);
        this.repaint();
    }

    @Override
    public Command getRestoreCommand() {
        return null;
    }

    @Override
    public List<String> getFormattedStringList() {
        return List.of(this.locationFormat);
    }

    public static class LocationFormatConfig
    implements TranslatableConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new FormattedStringConfigurer(key, name, new String[]{Zone.NAME, Zone.GRID_LOCATION});
        }
    }

    public static class ShapeEditor
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new Editor((Zone)c);
        }
    }

    public static class Editor
    extends Configurer {
        private final JPanel buttonPanel;
        private final JButton button;
        private PolygonEditor editor;
        private Board board;
        private JDialog frame;
        protected AdjustableSpeedScrollPane scroll;
        protected Polygon savePoly;
        protected FlowLabel coordsLabel;
        protected JLabel coordLabel;
        protected Zone zone;
        protected final JLabel warning = new JLabel(Resources.getString("Editor.Zone.zone_has_not_been_defined"));

        public Editor(Zone zone) {
            super(Zone.PATH, null);
            this.buttonPanel = new JPanel((LayoutManager)new MigLayout("ins 0"));
            this.button = new JButton(Resources.getString("Editor.Zone.define_shape"));
            this.buttonPanel.add(this.button);
            this.button.addActionListener(e -> this.init(zone));
            this.zone = zone;
        }

        public void updateCoords(Polygon polygon) {
            StringBuilder s = new StringBuilder("");
            if (polygon != null) {
                for (int p = 0; p < polygon.npoints; ++p) {
                    s.append('(');
                    s.append(polygon.xpoints[p]);
                    s.append(',');
                    s.append(polygon.ypoints[p]);
                    s.append(") ");
                }
            }
            this.coordsLabel.setText(s.toString());
            this.coordsLabel.repaint();
        }

        public void updateCoords() {
            this.updateCoords(this.zone.myPolygon);
        }

        public void updateCoord(String s) {
            this.coordLabel.setText(s);
            this.coordLabel.repaint();
        }

        public void updateCoord(int x, int y) {
            this.updateCoord(x + "," + y);
        }

        private void init(Zone zone) {
            this.editor = new PolygonEditor(new Polygon(zone.myPolygon.xpoints, zone.myPolygon.ypoints, zone.myPolygon.npoints)){
                private static final long serialVersionUID = 1L;

                @Override
                protected void paintBackground(Graphics g) {
                    if (board != null) {
                        Graphics2D g2d = (Graphics2D)g;
                        double os_scale = g2d.getDeviceConfiguration().getDefaultTransform().getScaleX();
                        AffineTransform orig_t = g2d.getTransform();
                        g2d.setTransform(SwingUtils.descaleTransform(orig_t));
                        Rectangle b = this.getVisibleRect();
                        b.x = (int)((double)b.x * os_scale);
                        b.y = (int)((double)b.y * os_scale);
                        b.width = (int)((double)b.width * os_scale);
                        b.height = (int)((double)b.height * os_scale);
                        g.clearRect(b.x, b.y, b.width, b.height);
                        board.draw(g, 0, 0, os_scale, editor);
                        g2d.setTransform(orig_t);
                    } else {
                        super.paintBackground(g);
                    }
                    warning.setVisible(editor != null && (editor.getPolygon() == null || editor.getPolygon().npoints == 0));
                }
            };
            this.editor.setMyConfigurer(this);
            this.frame = new JDialog(GameModule.getGameModule().getPlayerWindow(), zone.getConfigureName(), true);
            this.frame.setFocusTraversalKeysEnabled(false);
            this.frame.setLayout(new BoxLayout(this.frame.getContentPane(), 1));
            JPanel labels = new JPanel();
            labels.setLayout(new GridLayout(3, 2));
            labels.add(new JLabel(Resources.getString("Editor.Zone.drag_to_create_initial_shape")));
            labels.add(new JLabel(Resources.getString("Editor.Zone.right_click_to_add_point")));
            labels.add(new JLabel(Resources.getString("Editor.Zone.left_drag_to_move_points")));
            labels.add(new JLabel(Resources.getString("Editor.Zone.del_to_remove_points")));
            this.warning.setForeground(Color.red);
            this.warning.setVisible(false);
            labels.add(this.warning);
            labels.setAlignmentX(0.0f);
            this.frame.add(labels);
            JButton direct = new JButton(Resources.getString("Editor.Zone.set_coordinates_directly"));
            direct.setFocusable(false);
            direct.addActionListener(e -> {
                String newShape = JOptionPane.showInputDialog(this.frame, Resources.getString("Editor.Zone.enter_points_instructions"), PolygonEditor.polygonToString(this.editor.getPolygon()).replace(';', ' '));
                if (newShape != null) {
                    StringBuilder buffer = new StringBuilder();
                    StringTokenizer st = new StringTokenizer(newShape);
                    while (st.hasMoreTokens()) {
                        buffer.append(st.nextToken());
                        if (!st.hasMoreTokens()) continue;
                        buffer.append(';');
                    }
                    newShape = buffer.toString();
                    PolygonEditor.reset(this.editor.getPolygon(), newShape);
                    this.editor.repaint();
                }
            });
            direct.setAlignmentX(0.0f);
            this.frame.add(direct);
            this.scroll = new AdjustableSpeedScrollPane(this.editor, 22, 32);
            this.editor.setScroll(this.scroll);
            this.frame.add(this.scroll);
            Box coordPanel = Box.createVerticalBox();
            this.coordsLabel = new FlowLabel("");
            this.coordLabel = new JLabel("");
            coordPanel.add((Component)this.coordLabel, "Center");
            coordPanel.add((Component)this.coordsLabel, "Center");
            this.updateCoords();
            this.updateCoord("");
            this.frame.add(coordPanel);
            JPanel buttonPanel = new JPanel();
            JButton closeButton = new JButton(Resources.getString("General.ok"));
            closeButton.setFocusable(false);
            closeButton.addActionListener(e -> {
                this.setValue((Object)this.getValueString());
                this.frame.setVisible(false);
            });
            JButton canButton = new JButton(Resources.getString("General.cancel"));
            canButton.setFocusable(false);
            canButton.addActionListener(e -> {
                this.editor.setPolygon(this.savePoly);
                this.setValue((Object)this.getValueString());
                this.frame.setVisible(false);
            });
            buttonPanel.add(closeButton);
            buttonPanel.add(canButton);
            this.frame.add(buttonPanel);
            this.board = zone.getBoard();
            this.editor.setPreferredSize(this.board != null ? this.board.getSize() : DEFAULT_SIZE);
            this.editor.reset();
            this.savePoly = new Polygon(zone.myPolygon.xpoints, zone.myPolygon.ypoints, zone.myPolygon.npoints);
            this.editor.setPolygon(zone.myPolygon.npoints == 0 ? null : new Polygon(zone.myPolygon.xpoints, zone.myPolygon.ypoints, zone.myPolygon.npoints));
            if (this.editor.getPolygon() != null) {
                Rectangle polyBounds = this.editor.getPolygon().getBounds();
                Point polyCenter = new Point(polyBounds.x + polyBounds.width / 2, polyBounds.y + polyBounds.height / 2);
                if (!this.editor.getVisibleRect().contains(polyCenter)) {
                    this.editor.center(polyCenter);
                }
            }
            this.frame.pack();
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            this.frame.setSize(Math.min(this.frame.getWidth(), d.width * 2 / 3), Math.min(this.frame.getHeight(), d.height * 2 / 3));
            this.frame.setTitle(zone.getConfigureName());
            this.frame.setVisible(true);
        }

        @Override
        public Component getControls() {
            return this.buttonPanel;
        }

        @Override
        public String getValueString() {
            if (this.editor != null) {
                return PolygonEditor.polygonToString(this.editor.getPolygon());
            }
            return "";
        }

        @Override
        public void setValue(String s) {
            if (this.editor != null) {
                PolygonEditor.reset(this.editor.getPolygon(), s);
            }
        }
    }
}

