/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.module.properties.PropertyChangerConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.FormattedStringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.i18n.Resources;
import VASSAL.script.expression.ExpressionBuilder;
import VASSAL.tools.FormattedString;
import VASSAL.tools.icon.IconFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class FormattedExpressionConfigurer
extends FormattedStringConfigurer {
    protected ExpressionButton button;
    protected EditablePiece pieceTarget;

    public FormattedExpressionConfigurer(String key, String name) {
        super(key, name);
    }

    public FormattedExpressionConfigurer(String key, String name, String s) {
        super(key, name);
        this.setValue(s);
    }

    public FormattedExpressionConfigurer(String s) {
        this(null, "", s);
    }

    public FormattedExpressionConfigurer(String key, String name, FormattedString s) {
        this(key, name, s.getFormat());
    }

    public FormattedExpressionConfigurer(String key, String name, String s, EditablePiece p) {
        this(key, name, s, (GamePiece)p);
    }

    public FormattedExpressionConfigurer(String s, PropertyChangerConfigurer.Constraints p) {
        this(null, "", s, p);
    }

    public FormattedExpressionConfigurer(String key, String name, String s, PropertyChangerConfigurer.Constraints p) {
        this(key, name, s);
        if (p instanceof GamePiece) {
            this.storePiece((GamePiece)((Object)p));
        }
    }

    public FormattedExpressionConfigurer(String s, GamePiece p) {
        this(null, "", s, p);
    }

    public FormattedExpressionConfigurer(String key, String name, String s, GamePiece p) {
        this(key, name, s);
        this.storePiece(p);
    }

    protected void storePiece(GamePiece p) {
        GamePiece gp;
        if (p instanceof Decorator && (gp = Decorator.getOutermost(p)) instanceof EditablePiece) {
            this.pieceTarget = (EditablePiece)gp;
        }
    }

    public FormattedExpressionConfigurer(String key, String name, String[] options) {
        super(key, name, options);
    }

    @Override
    public Component getControls() {
        JPanel p = (JPanel)super.getControls();
        if (this.button == null) {
            this.button = this.buildButton();
            p.add(this.button);
        }
        this.button.setSize(this.nameField.getPreferredSize().height);
        return p;
    }

    protected ExpressionButton buildButton() {
        return new ExpressionButton(this, this.nameField.getPreferredSize().height, this.pieceTarget);
    }

    public static class ExpressionButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        protected Configurer config;
        protected EditablePiece piece;

        public ExpressionButton(Configurer config, int size) {
            this(config, size, null);
        }

        public ExpressionButton(Configurer config, int size, EditablePiece piece) {
            this.config = config;
            this.piece = piece;
            this.setIcon(IconFactory.getIcon("calculator", 0));
            this.setSize(size);
            this.setToolTipText(Resources.getString("Editor.FormattedExpressionConfigurer.expression_builder"));
            this.addActionListener(this);
        }

        public void setSize(int size) {
            this.setPreferredSize(new Dimension(size, size));
            this.setMaximumSize(new Dimension(size, size));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new ExpressionBuilder(this.config, (JDialog)this.getTopLevelAncestor(), this.piece).setVisible(true);
        }
    }
}

