/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.FreeRotator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.Mat;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.PieceFinder;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.imageop.GamePieceOp;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.imageop.RotateScaleOp;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.swing.KeyStroke;

public class MatCargo
extends Decorator
implements TranslatablePiece {
    public static final String ID = "matPiece;";
    public static final String NO_MAT = "noMat";
    public static final String CURRENT_MAT = "CurrentMat";
    public static final String CURRENT_MAT_ID = "CurrentMatID";
    public static final String CURRENT_MAT_X = "CurrentMatX";
    public static final String CURRENT_MAT_Y = "CurrentMatY";
    public static final String CURRENT_MAT_OFFSET_X = "CurrentMatOffsetX";
    public static final String CURRENT_MAT_OFFSET_Y = "CurrentMatOffsetY";
    public static final String CURRENT_MAT_PIECE_NAME = "CurrentMatPieceName";
    public static final String CURRENT_MAT_BASIC_NAME = "CurrentMatBasicName";
    public static final String CURRENT_MAT_LOCATION_NAME = "CurrentMatLocationName";
    public static final String CURRENT_MAT_ZONE = "CurrentMatZone";
    public static final String CURRENT_MAT_BOARD = "CurrentMatBoard";
    public static final String CURRENT_MAT_MAP = "CurrentMatMap";
    public static final String CURRENT_MAT_PROP0 = "CurrentMatProp0";
    public static final String CURRENT_MAT_PROP1 = "CurrentMatProp1";
    public static final String CURRENT_MAT_PROP2 = "CurrentMatProp2";
    public static final String CURRENT_MAT_PROP3 = "CurrentMatProp3";
    public static final String CURRENT_MAT_PROP4 = "CurrentMatProp4";
    public static final String CURRENT_MAT_PROP5 = "CurrentMatProp5";
    public static final String CURRENT_MAT_PROP6 = "CurrentMatProp6";
    public static final String CURRENT_MAT_PROP7 = "CurrentMatProp7";
    public static final String CURRENT_MAT_PROP8 = "CurrentMatProp8";
    public static final String CURRENT_MAT_PROP9 = "CurrentMatProp9";
    public static final String IS_CARGO = "IsCargo";
    protected String desc;
    protected boolean maintainRelativeFacing;
    protected int detectionDistanceX;
    protected int detectionDistanceY;
    protected NamedKeyStroke matFindKey;
    protected NamedKeyStroke matDetachKey;
    protected boolean keyCommandsSet;
    protected KeyCommand matFindKeyCommand;
    protected KeyCommand matDetachKeyCommand;
    protected GamePieceOp gpOp;
    protected java.util.Map<Double, Rectangle> bounds = new HashMap<Double, Rectangle>();
    protected java.util.Map<Double, RotateScaleOp> rotOp = new HashMap<Double, RotateScaleOp>();
    protected static final double PI_180 = Math.PI / 180;
    protected GamePiece mat;

    public MatCargo() {
        this("matPiece;;true", null);
    }

    public MatCargo(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    public void mySetType(String type) {
        type = type.substring(ID.length());
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        this.desc = st.nextToken();
        this.maintainRelativeFacing = st.nextBoolean(true);
        this.detectionDistanceX = st.nextInt(0);
        this.detectionDistanceY = st.nextInt(0);
        this.matFindKey = st.nextNamedKeyStroke(null);
        this.matDetachKey = st.nextNamedKeyStroke(null);
        this.keyCommandsSet = false;
        this.matFindKeyCommand = null;
        this.matDetachKeyCommand = null;
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.desc).append(this.maintainRelativeFacing).append(this.detectionDistanceX).append(this.detectionDistanceY).append(this.matFindKey).append(this.matDetachKey);
        return ID + se.getValue();
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return Arrays.asList(this.matFindKey, this.matDetachKey);
    }

    public void clearMat() {
        this.mat = null;
    }

    public Command makeClearMatCommand() {
        if (this.mat == null) {
            return new NullCommand();
        }
        ChangeTracker ctMat = null;
        Mat actualMat = (Mat)Decorator.getDecorator(Decorator.getOutermost(this.mat), Mat.class);
        if (actualMat != null) {
            ctMat = new ChangeTracker(actualMat);
            actualMat.removeCargo(Decorator.getOutermost(this));
        }
        ChangeTracker ct = new ChangeTracker(this);
        this.clearMat();
        Command c = ct.getChangeCommand();
        if (ctMat != null) {
            c = c.append(ctMat.getChangeCommand());
        }
        return c;
    }

    public void setMat(GamePiece mat) {
        GamePiece actualMat;
        this.mat = mat;
        if (mat != null && (actualMat = Decorator.getDecorator(Decorator.getOutermost(mat), Mat.class)) != null && !((Mat)actualMat).hasCargo(Decorator.getOutermost(this))) {
            ((Mat)actualMat).addCargo(Decorator.getOutermost(this));
        }
    }

    public Command makeSetMatCommand(GamePiece newMat) {
        if (this.mat == newMat) {
            return new NullCommand();
        }
        if (newMat == null) {
            return this.makeClearMatCommand();
        }
        Mat actualMat = (Mat)Decorator.getDecorator(Decorator.getOutermost(newMat), Mat.class);
        if (actualMat == null) {
            return this.makeClearMatCommand();
        }
        return actualMat.makeAddCargoCommand(this);
    }

    public Command findNewMat(Map map, Point pt) {
        Command comm = new NullCommand();
        if (map != null) {
            GamePiece newMat = this.locateNewMat(map, pt);
            if (newMat != null) {
                Mat mat = (Mat)Decorator.getDecorator(newMat, Mat.class);
                if (mat != null) {
                    comm = comm.append(mat.makeAddCargoCommand(MatCargo.getOutermost(this)));
                }
            } else {
                comm = comm.append(this.makeClearMatCommand());
            }
        }
        return comm;
    }

    public GamePiece locateNewMat(Map map, Point pt) {
        if (map == null) {
            return null;
        }
        GamePiece newMat = map.findAnyPiece(pt, PieceFinder.MAT_ONLY);
        if (newMat == null && this.detectionDistanceX != 0 || this.detectionDistanceY != 0) {
            Point pt2 = new Point();
            pt2.x = pt.x + this.detectionDistanceX;
            pt2.y = pt.y + this.detectionDistanceY;
            newMat = map.findAnyPiece(pt2, PieceFinder.MAT_ONLY);
            if (newMat == null) {
                pt2.x = pt.x - this.detectionDistanceX;
                pt2.y = pt.y + this.detectionDistanceY;
                newMat = map.findAnyPiece(pt2, PieceFinder.MAT_ONLY);
                if (newMat == null) {
                    pt2.x = pt.x + this.detectionDistanceX;
                    pt2.y = pt.y - this.detectionDistanceY;
                    newMat = map.findAnyPiece(pt2, PieceFinder.MAT_ONLY);
                    if (newMat == null) {
                        pt2.x = pt.x - this.detectionDistanceX;
                        pt2.y = pt.y - this.detectionDistanceY;
                        newMat = map.findAnyPiece(pt2, PieceFinder.MAT_ONLY);
                    }
                }
            }
        }
        return newMat;
    }

    public Command findNewMat() {
        return this.findNewMat(this.getMap(), this.getPosition());
    }

    public static Command findNewMat(Command c, GamePiece gp) {
        MatCargo cargo;
        if (GameModule.getGameModule().isMatSupport() && Boolean.TRUE.equals(gp.getProperty(IS_CARGO)) && (cargo = (MatCargo)Decorator.getDecorator(gp, MatCargo.class)) != null) {
            c = c.append(cargo.findNewMat());
        }
        return c;
    }

    public GamePiece getMat() {
        return this.mat;
    }

    @Override
    public KeyCommand[] myGetKeyCommands() {
        return KeyCommand.NONE;
    }

    @Override
    public String myGetState() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.mat == null ? NO_MAT : this.mat.getId());
        return se.getValue();
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        if (!this.keyCommandsSet) {
            if (this.matFindKey != null && !this.matFindKey.isNull()) {
                this.matFindKeyCommand = new KeyCommand("", this.matFindKey, Decorator.getOutermost(this), (TranslatablePiece)this);
            }
            if (this.matDetachKey != null && !this.matDetachKey.isNull()) {
                this.matDetachKeyCommand = new KeyCommand("", this.matDetachKey, Decorator.getOutermost(this), (TranslatablePiece)this);
            }
            this.keyCommandsSet = true;
        }
        if (this.matFindKeyCommand != null && this.matFindKeyCommand.matches(stroke)) {
            return this.findNewMat();
        }
        if (this.matDetachKeyCommand != null && this.matDetachKeyCommand.matches(stroke)) {
            return this.makeClearMatCommand();
        }
        return null;
    }

    @Override
    public void mySetState(String newState) {
        GameModule gm = GameModule.getGameModule();
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(newState, ';');
        String token = st.nextToken();
        this.mat = NO_MAT.equals(token) ? null : gm.getGameState().getPieceForId(token);
        this.setMat(this.mat);
        gm.setMatSupport(true);
    }

    @Override
    public Rectangle boundingBox() {
        Rectangle r;
        Rectangle b = this.piece.boundingBox();
        double angle = this.getMatAngle();
        if (angle == 0.0) {
            return b;
        }
        if (this.getGpOp() != null && this.getGpOp().isChanged() || (r = this.bounds.get(angle)) == null) {
            r = AffineTransform.getRotateInstance(-Math.PI / 180 * angle, this.centerX(), this.centerY()).createTransformedShape(b).getBounds();
            this.bounds.put(angle, r);
        }
        return new Rectangle(r);
    }

    protected GamePieceOp getGpOp() {
        if (this.gpOp == null && this.getInner() != null) {
            this.gpOp = Op.piece(this.getInner());
        }
        return this.gpOp;
    }

    protected double getMatAngle() {
        if (this.mat == null || !this.maintainRelativeFacing) {
            return 0.0;
        }
        FreeRotator mrot = (FreeRotator)Decorator.getDecorator(MatCargo.getOutermost(this.mat), FreeRotator.class);
        return mrot == null ? 0.0 : mrot.getAngle();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        RotateScaleOp op;
        double angle = this.getMatAngle();
        if (angle == 0.0) {
            this.piece.draw(g, x, y, obs, zoom);
            return;
        }
        if (this.getGpOp() != null && this.getGpOp().isChanged()) {
            this.gpOp = Op.piece(this.piece);
            this.bounds.clear();
            this.rotOp.clear();
            op = Op.rotateScale(this.gpOp, angle, zoom);
            this.rotOp.put(angle, op);
        } else {
            op = this.rotOp.get(angle);
            if (op == null || op.getScale() != zoom) {
                op = Op.rotateScale(this.gpOp, angle, zoom);
                this.rotOp.put(angle, op);
            }
        }
        Rectangle r = this.boundingBox();
        BufferedImage img = op.getImage();
        if (img != null) {
            g.drawImage(img, x + (int)(zoom * (double)r.x), y + (int)(zoom * (double)r.y), obs);
        }
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    private double centerX() {
        return (double)(this.piece.boundingBox().width % 2) / 2.0;
    }

    private double centerY() {
        return (double)(this.piece.boundingBox().height % 2) / 2.0;
    }

    @Override
    public Shape getShape() {
        double angle = this.getMatAngle();
        Shape s = this.piece.getShape();
        if (angle == 0.0) {
            return s;
        }
        return AffineTransform.getRotateInstance(-Math.PI / 180 * angle, this.centerX(), this.centerY()).createTransformedShape(s);
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public Object getProperty(Object key) {
        if (this.mat != null) {
            if (CURRENT_MAT.equals(key)) {
                return this.mat.getProperty("MatName");
            }
            if ("IgnoreGrid".equals(key) && this.mat != null) {
                return true;
            }
            if (CURRENT_MAT_ID.equals(key)) {
                return this.mat.getProperty("MatID");
            }
            if (CURRENT_MAT_X.equals(key)) {
                return Decorator.getOutermost((GamePiece)this.mat).getPosition().x;
            }
            if (CURRENT_MAT_Y.equals(key)) {
                return Decorator.getOutermost((GamePiece)this.mat).getPosition().y;
            }
            if (CURRENT_MAT_OFFSET_X.equals(key)) {
                return Decorator.getOutermost((GamePiece)this.mat).getPosition().x - Decorator.getOutermost((GamePiece)this).getPosition().x;
            }
            if (CURRENT_MAT_OFFSET_Y.equals(key)) {
                return Decorator.getOutermost((GamePiece)this.mat).getPosition().y - Decorator.getOutermost((GamePiece)this).getPosition().y;
            }
            if (CURRENT_MAT_BASIC_NAME.equals(key)) {
                return Decorator.getOutermost(this.mat).getProperty("BasicName");
            }
            if (CURRENT_MAT_PIECE_NAME.equals(key)) {
                return Decorator.getOutermost(this.mat).getProperty("PieceName");
            }
            if (CURRENT_MAT_LOCATION_NAME.equals(key)) {
                return Decorator.getOutermost(this.mat).getProperty("LocationName");
            }
            if (CURRENT_MAT_ZONE.equals(key)) {
                return Decorator.getOutermost(this.mat).getProperty("CurrentZone");
            }
            if (CURRENT_MAT_BOARD.equals(key)) {
                return Decorator.getOutermost(this.mat).getProperty("CurrentBoard");
            }
            if (CURRENT_MAT_MAP.equals(key)) {
                return Decorator.getOutermost(this.mat).getProperty("CurrentMap");
            }
            if (List.of(CURRENT_MAT_PROP0, CURRENT_MAT_PROP1, CURRENT_MAT_PROP2, CURRENT_MAT_PROP3, CURRENT_MAT_PROP4, CURRENT_MAT_PROP5, CURRENT_MAT_PROP6, CURRENT_MAT_PROP7, CURRENT_MAT_PROP8, CURRENT_MAT_PROP9).contains(key)) {
                return Decorator.getOutermost(this.mat).getProperty(key);
            }
        }
        if (IS_CARGO.equals(key)) {
            return Boolean.TRUE;
        }
        return super.getProperty(key);
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        if (this.mat != null) {
            if (CURRENT_MAT.equals(key)) {
                return this.mat.getLocalizedProperty("MatName");
            }
            if ("IgnoreGrid".equals(key) && this.mat != null) {
                return true;
            }
            if (CURRENT_MAT_BASIC_NAME.equals(key)) {
                return Decorator.getOutermost(this.mat).getLocalizedProperty("BasicName");
            }
            if (CURRENT_MAT_PIECE_NAME.equals(key)) {
                return Decorator.getOutermost(this.mat).getLocalizedProperty("PieceName");
            }
            if (CURRENT_MAT_LOCATION_NAME.equals(key)) {
                return Decorator.getOutermost(this.mat).getLocalizedProperty("LocationName");
            }
            if (CURRENT_MAT_ZONE.equals(key)) {
                return Decorator.getOutermost(this.mat).getLocalizedProperty("CurrentZone");
            }
            if (CURRENT_MAT_BOARD.equals(key)) {
                return Decorator.getOutermost(this.mat).getLocalizedProperty("CurrentBoard");
            }
            if (CURRENT_MAT_MAP.equals(key)) {
                return Decorator.getOutermost(this.mat).getLocalizedProperty("CurrentMap");
            }
            if (List.of(CURRENT_MAT_PROP0, CURRENT_MAT_PROP1, CURRENT_MAT_PROP2, CURRENT_MAT_PROP3, CURRENT_MAT_PROP4, CURRENT_MAT_PROP5, CURRENT_MAT_PROP6, CURRENT_MAT_PROP7, CURRENT_MAT_PROP8, CURRENT_MAT_PROP9).contains(key)) {
                return Decorator.getOutermost(this.mat).getLocalizedProperty(key);
            }
        }
        if (List.of(CURRENT_MAT_ID, CURRENT_MAT_X, CURRENT_MAT_Y, CURRENT_MAT_OFFSET_X, CURRENT_MAT_OFFSET_Y, IS_CARGO).contains(key)) {
            return this.getProperty(key);
        }
        return super.getLocalizedProperty(key);
    }

    @Override
    public String getDescription() {
        return this.buildDescription("Editor.MatCargo.trait_description", this.desc);
    }

    @Override
    public String getBaseDescription() {
        return Resources.getString("Editor.MatCargo.trait_description");
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof MatCargo)) {
            return false;
        }
        MatCargo c = (MatCargo)o;
        if (this.detectionDistanceX != c.detectionDistanceX) {
            return false;
        }
        if (this.detectionDistanceY != c.detectionDistanceY) {
            return false;
        }
        if (!Objects.equals(this.matFindKey, c.matFindKey)) {
            return false;
        }
        if (!Objects.equals(this.matDetachKey, c.matDetachKey)) {
            return false;
        }
        return Objects.equals(this.desc, c.desc) && this.maintainRelativeFacing == c.maintainRelativeFacing;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("MatCargo.html");
    }

    @Override
    public List<String> getPropertyNames() {
        return Arrays.asList(CURRENT_MAT, CURRENT_MAT_ID, IS_CARGO, CURRENT_MAT_X, CURRENT_MAT_Y, CURRENT_MAT_OFFSET_X, CURRENT_MAT_OFFSET_Y, CURRENT_MAT_BASIC_NAME, CURRENT_MAT_PIECE_NAME, CURRENT_MAT_LOCATION_NAME, CURRENT_MAT_ZONE, CURRENT_MAT_BOARD, CURRENT_MAT_MAP, CURRENT_MAT_PROP0, CURRENT_MAT_PROP1, CURRENT_MAT_PROP2, CURRENT_MAT_PROP3, CURRENT_MAT_PROP4, CURRENT_MAT_PROP5, CURRENT_MAT_PROP6, CURRENT_MAT_PROP7, CURRENT_MAT_PROP8, CURRENT_MAT_PROP9);
    }

    public static class Ed
    implements PieceEditor {
        private final StringConfigurer descInput;
        private final BooleanConfigurer rotInput;
        private final TraitConfigPanel controls = new TraitConfigPanel();
        private final IntConfigurer xInput;
        private final IntConfigurer yInput;
        private final NamedHotKeyConfigurer findInput;
        private final NamedHotKeyConfigurer detachInput;

        public Ed(MatCargo p) {
            this.descInput = new StringConfigurer(p.desc);
            this.descInput.setHintKey("Editor.description_hint");
            this.controls.add("Editor.description_label", (Configurer)this.descInput);
            this.rotInput = new BooleanConfigurer(p.maintainRelativeFacing);
            this.controls.add("Editor.MatCargo.maintain_relative_facing", (Configurer)this.rotInput);
            this.xInput = new IntConfigurer(p.detectionDistanceX);
            this.controls.add("Editor.MatCargo.detection_distance_x", (Configurer)this.xInput);
            this.yInput = new IntConfigurer(p.detectionDistanceY);
            this.controls.add("Editor.MatCargo.detection_distance_y", (Configurer)this.yInput);
            this.findInput = new NamedHotKeyConfigurer(p.matFindKey);
            this.controls.add("Editor.MatCargo.mat_find_key", (Configurer)this.findInput);
            this.detachInput = new NamedHotKeyConfigurer(p.matDetachKey);
            this.controls.add("Editor.MatCargo.mat_detach_key", (Configurer)this.detachInput);
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.descInput.getValueString()).append(this.rotInput.getValueBoolean()).append(this.xInput.getIntValue(0)).append(this.yInput.getIntValue(0)).append(this.findInput.getValueString()).append(this.detachInput.getValueString());
            return MatCargo.ID + se.getValue();
        }

        @Override
        public String getState() {
            return "";
        }
    }
}

