/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.command.RemovePiece;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyBuffer;
import VASSAL.counters.Mat;
import VASSAL.counters.MatCargo;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.PlaceMarker;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import javax.swing.KeyStroke;

public class Replace
extends PlaceMarker {
    public static final String ID = "replace;";

    public Replace() {
        this(ID + Resources.getString("Editor.Replace.default_command") + ";R;null", null);
    }

    public Replace(String type, GamePiece inner) {
        super(type, inner);
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        Command c = null;
        if (this.command.matches(stroke)) {
            c = this.replacePiece();
        }
        return c;
    }

    protected Command replacePiece() {
        Command c = this.placeMarker();
        if (c == null) {
            Replace.reportDataError(this, Resources.getString("Error.bad_replace"));
        } else {
            if (GameModule.getGameModule().isMatSupport()) {
                Mat mat;
                String matName;
                MatCargo cargo;
                GamePiece outer = Decorator.getOutermost(this);
                if (Boolean.TRUE.equals(outer.getProperty("IsCargo")) && (cargo = (MatCargo)Decorator.getDecorator(outer, MatCargo.class)) != null) {
                    c = c.append(cargo.makeClearMatCommand());
                }
                if ((matName = (String)outer.getProperty("MatName")) != null && !"".equals(matName) && (mat = (Mat)Decorator.getDecorator(outer, Mat.class)) != null) {
                    c = c.append(mat.makeRemoveAllCargoCommand());
                }
            }
            RemovePiece remove = new RemovePiece(Decorator.getOutermost(this));
            remove.execute();
            c.append(remove);
        }
        return c;
    }

    @Override
    protected void selectMarker(GamePiece marker) {
        KeyBuffer.getBuffer().add(marker);
    }

    @Override
    public String getDescription() {
        Object s = this.buildDescription("Editor.Replace.trait_description", this.description);
        s = (String)s + this.getCommandDesc(this.command.getName(), this.key);
        return s;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Replace.html");
    }

    @Override
    public String myGetType() {
        return ID + super.myGetType().substring("placemark;".length());
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public GamePiece createMarker() {
        GamePiece marker = super.createMarker();
        if (marker != null && this.matchRotation) {
            if (this.above) {
                this.matchTraits(this, marker);
            } else {
                this.matchTraits(Decorator.getOutermost(this), marker);
            }
        }
        return marker;
    }

    protected void matchTraits(GamePiece base, GamePiece marker) {
        if (!(base instanceof Decorator) || !(marker instanceof Decorator)) {
            return;
        }
        Decorator currentTrait = (Decorator)base;
        Decorator lastMatch = (Decorator)marker;
        while (currentTrait != null) {
            Decorator candidate = lastMatch;
            while (candidate != null) {
                if ((candidate = (Decorator)Decorator.getDecorator(candidate, currentTrait.getClass())) == null) continue;
                if (candidate.myGetType().equals(currentTrait.myGetType())) {
                    candidate.mySetState(currentTrait.myGetState());
                    lastMatch = candidate;
                    candidate = null;
                    continue;
                }
                GamePiece inner = candidate.getInner();
                if (inner instanceof Decorator) {
                    candidate = (Decorator)inner;
                    continue;
                }
                candidate = null;
            }
            if (currentTrait.getInner() instanceof Decorator) {
                currentTrait = (Decorator)currentTrait.getInner();
                continue;
            }
            currentTrait = null;
        }
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(this.command.getName(), this.getCommandDescription(this.description, Resources.getString("Editor.Replace.replace_command")));
    }

    protected static class Ed
    extends PlaceMarker.Ed {
        public Ed(Replace piece) {
            super(piece);
            this.defineButton.setText(Resources.getString("Editor.Replace.define_replacement"));
        }

        @Override
        protected BooleanConfigurer createMatchRotationConfig() {
            return new BooleanConfigurer(null, Resources.getString("Editor.Replace.match_current_state"));
        }

        @Override
        protected BooleanConfigurer createAboveConfig() {
            return new BooleanConfigurer(null, Resources.getString("Editor.Replace.only_match_above"));
        }

        @Override
        public String getType() {
            return Replace.ID + super.getType().substring("placemark;".length());
        }
    }
}

