/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.MovementReporter;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.FormattedExpressionConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Deck;
import VASSAL.counters.DeckVisitor;
import VASSAL.counters.DeckVisitorDispatcher;
import VASSAL.counters.Decorator;
import VASSAL.counters.FreeRotator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.Mat;
import VASSAL.counters.MatCargo;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.Stack;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.FormattedString;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;

public class Translate
extends Decorator
implements TranslatablePiece {
    private static final String _0 = "0";
    public static final String ID = "translate;";
    protected KeyCommand[] commands;
    protected String commandName;
    protected NamedKeyStroke keyCommand;
    protected FormattedString xDist = new FormattedString("");
    protected FormattedString xIndex = new FormattedString("");
    protected FormattedString xOffset = new FormattedString("");
    protected FormattedString yDist = new FormattedString("");
    protected FormattedString yIndex = new FormattedString("");
    protected FormattedString yOffset = new FormattedString("");
    protected String description;
    protected boolean moveStack;
    protected KeyCommand moveCommand;
    protected static MoveExecuter mover;

    public Translate() {
        this(ID + Resources.getString("Editor.MoveFixedDistance.default_command"), null);
    }

    public Translate(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    public String getDescription() {
        Object s = this.buildDescription("Editor.MoveFixedDistance.trait_description", this.description);
        s = (String)s + this.getCommandDesc(this.commandName, this.keyCommand);
        return s;
    }

    @Override
    public String getBaseDescription() {
        return Resources.getString("Editor.MoveFixedDistance.trait_description");
    }

    @Override
    public void mySetType(String type) {
        type = type.substring(ID.length());
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        this.commandName = st.nextToken(Resources.getString("Editor.MoveFixedDistance.default_command"));
        this.keyCommand = st.nextNamedKeyStroke('M');
        this.xDist.setFormat(st.nextToken(_0));
        this.yDist.setFormat(st.nextToken("60"));
        this.moveStack = st.nextBoolean(false);
        this.xIndex.setFormat(st.nextToken(_0));
        this.yIndex.setFormat(st.nextToken(_0));
        this.xOffset.setFormat(st.nextToken(_0));
        this.yOffset.setFormat(st.nextToken(_0));
        this.description = st.nextToken("");
        this.commands = null;
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        if (this.commands == null) {
            this.moveCommand = new KeyCommand(this.commandName, this.keyCommand, Decorator.getOutermost(this), (TranslatablePiece)this);
            this.commands = this.commandName.length() > 0 && this.keyCommand != null && !this.keyCommand.isNull() ? new KeyCommand[]{this.moveCommand} : KeyCommand.NONE;
        }
        this.moveCommand.setEnabled(this.getMap() != null);
        return this.commands;
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.commandName).append(this.keyCommand).append(this.xDist.getFormat()).append(this.yDist.getFormat()).append(this.moveStack).append(this.xIndex.getFormat()).append(this.yIndex.getFormat()).append(this.xOffset.getFormat()).append(this.yOffset.getFormat()).append(this.description);
        return ID + se.getValue();
    }

    @Override
    public Command keyEvent(KeyStroke stroke) {
        if (GlobalOptions.getInstance().isUseClassicMoveFixedDistance()) {
            this.myGetKeyCommands();
            if (this.moveCommand.matches(stroke)) {
                return this.myKeyEvent(stroke);
            }
        }
        return super.keyEvent(stroke);
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        this.myGetKeyCommands();
        if (this.moveCommand.matches(stroke)) {
            return GlobalOptions.getInstance().isUseClassicMoveFixedDistance() ? this.classicTranslate(stroke) : this.newTranslate(stroke);
        }
        return null;
    }

    protected Command newTranslate(KeyStroke stroke) {
        Map map;
        String matName;
        GamePiece target = this.findTarget(stroke);
        if (target == null) {
            return null;
        }
        Point p = this.getPosition();
        Mat mat = null;
        List<GamePiece> contents = null;
        List<Point> offsets = null;
        GamePiece outer = Translate.getOutermost(target);
        if (GameModule.getGameModule().isMatSupport() && !(target instanceof Stack) && (matName = (String)outer.getProperty("MatName")) != null && !"".equals(matName) && (mat = (Mat)Decorator.getDecorator(outer, Mat.class)) != null) {
            contents = mat.getContents();
            offsets = mat.getOffsets(p.x, p.y);
        }
        this.translate(p);
        FreeRotator myRotation = (FreeRotator)Decorator.getDecorator(this, FreeRotator.class);
        if (myRotation != null) {
            Point myPosition = this.getPosition().getLocation();
            Object p2d = p.getLocation();
            p2d = AffineTransform.getRotateInstance(myRotation.getCumulativeAngleInRadians(), ((Point2D)myPosition).getX(), ((Point2D)myPosition).getY()).transform((Point2D)p2d, null);
            p = new Point((int)Math.round(((Point2D)p2d).getX()), (int)Math.round(((Point2D)p2d).getY()));
        }
        if (!Boolean.TRUE.equals(Decorator.getOutermost(this).getProperty("IgnoreGrid"))) {
            p = this.getMap().snapTo(p);
        }
        Command c = new NullCommand();
        if (target instanceof Stack) {
            for (GamePiece gp : ((Stack)target).asList()) {
                boolean pieceSelected = Boolean.TRUE.equals(gp.getProperty("Selected"));
                if (!pieceSelected && !this.moveStack) continue;
                c = c.append(this.movePiece(gp, p));
            }
        } else {
            Map ourMap;
            c = c.append(this.movePiece(target, p));
            if (GameModule.getGameModule().isMatSupport() && offsets != null && (ourMap = outer.getMap()) != null) {
                for (int i = 0; i < contents.size(); ++i) {
                    GamePiece piece = contents.get(i);
                    MatCargo cargo = (MatCargo)Decorator.getDecorator(piece, MatCargo.class);
                    if (cargo == null) continue;
                    Point pt = new Point(p);
                    pt.x += offsets.get((int)i).x;
                    pt.y += offsets.get((int)i).y;
                    c = c.append(this.movePiece(piece, pt));
                }
            }
        }
        if ((map = target.getMap()) != null) {
            map.repaint();
        }
        return c;
    }

    protected Command movePiece(GamePiece gp, Point dest) {
        Stack parent;
        Map map = gp.getMap();
        if (map == null) {
            return null;
        }
        Command c = Translate.putOldProperties(this);
        GamePiece outer = Decorator.getOutermost(gp);
        ChangeTracker comm = new ChangeTracker(outer);
        outer.setProperty("Moved", Boolean.TRUE);
        c = c.append(comm.getChangeCommand());
        c = c.append(map.placeOrMerge(outer, dest));
        c = MatCargo.findNewMat(c, outer);
        if (map.getMoveKey() != null) {
            c = c.append(outer.keyEvent(map.getMoveKey()));
        }
        if ((parent = outer.getParent()) != null) {
            c = c.append(parent.pieceRemoved(outer));
        }
        return c;
    }

    protected Command classicTranslate(KeyStroke stroke) {
        GamePiece target;
        Command c = new NullCommand();
        if (mover == null) {
            mover = new MoveExecuter();
            mover.setKeyEvent(stroke);
            mover.setAdditionalCommand(Translate.putOldProperties(this));
            SwingUtilities.invokeLater(mover);
        }
        if ((target = this.findTarget(stroke)) != null) {
            c = c.append(this.moveTarget(target));
        }
        mover.addKeyEventTarget(this.piece);
        c = new NullCommand(){

            @Override
            public boolean isNull() {
                return false;
            }
        };
        return c;
    }

    protected Command moveTarget(GamePiece target) {
        Point p = mover.getUpdatedPosition(target);
        if (p == null) {
            p = new Point(this.getPosition());
        }
        this.translate(p);
        FreeRotator myRotation = (FreeRotator)Decorator.getDecorator(this, FreeRotator.class);
        if (myRotation != null) {
            Point myPosition = this.getPosition().getLocation();
            Point2D p2d = p.getLocation();
            p2d = AffineTransform.getRotateInstance(myRotation.getCumulativeAngleInRadians(), ((Point2D)myPosition).getX(), ((Point2D)myPosition).getY()).transform(p2d, null);
            p = new Point((int)p2d.getX(), (int)p2d.getY());
        }
        if (!Boolean.TRUE.equals(Decorator.getOutermost(this).getProperty("IgnoreGrid"))) {
            p = this.getMap().snapTo(p);
        }
        mover.add(target.getMap(), target, p);
        return null;
    }

    protected void translate(Point p) {
        GamePiece outer = Decorator.getOutermost(this);
        Board b = outer.getMap().findBoard(p);
        int Xdist = this.xDist.getTextAsInt((PropertySource)outer, Resources.getString("Editor.MoveFixedDistance.distance_to_the_right"), this);
        int Xindex = this.xIndex.getTextAsInt((PropertySource)outer, Resources.getString("Editor.MoveFixedDistance.additional_offset_to_the_right"), this);
        int Xoffset = this.xOffset.getTextAsInt((PropertySource)outer, Resources.getString("Editor.MoveFixedDistance.times") + " X", this);
        int x = Xdist + Xindex * Xoffset;
        if (b != null) {
            x = (int)Math.round(b.getMagnification() * (double)x);
        }
        int Ydist = this.yDist.getTextAsInt((PropertySource)outer, Resources.getString("Editor.MoveFixedDistance.distance_upwards"), this);
        int Yindex = this.yIndex.getTextAsInt((PropertySource)outer, Resources.getString("Editor.MoveFixedDistance.additional_offset_upwards"), this);
        int Yoffset = this.yOffset.getTextAsInt((PropertySource)outer, Resources.getString("Editor.MoveFixedDistance.times") + " Y", this);
        int y = Ydist + Yindex * Yoffset;
        if (b != null) {
            y = (int)Math.round(b.getMagnification() * (double)y);
        }
        p.translate(x, -y);
    }

    protected GamePiece findTarget(KeyStroke stroke) {
        GamePiece outer;
        GamePiece target = outer = Decorator.getOutermost(this);
        if (this.moveStack && outer.getParent() != null && !outer.getParent().isExpanded()) {
            target = outer != outer.getParent().topPiece(GameModule.getActiveUserId()) ? null : outer.getParent();
        }
        return target;
    }

    @Override
    public void mySetState(String newState) {
    }

    @Override
    public Rectangle boundingBox() {
        return this.getInner().boundingBox();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.getInner().draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.getInner().getName();
    }

    @Override
    public Shape getShape() {
        return this.getInner().getShape();
    }

    @Override
    public PieceEditor getEditor() {
        return new Editor(this);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Translate.html");
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(this.commandName, this.getCommandDescription(this.description, Resources.getString("Editor.MoveFixedDistance.move_fixed_distance_command")));
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof Translate)) {
            return false;
        }
        Translate c = (Translate)o;
        if (!Objects.equals(this.commandName, c.commandName)) {
            return false;
        }
        if (!Objects.equals(this.keyCommand, c.keyCommand)) {
            return false;
        }
        if (!Objects.equals(this.xDist, c.xDist)) {
            return false;
        }
        if (!Objects.equals(this.yDist, c.yDist)) {
            return false;
        }
        if (!Objects.equals(this.moveStack, c.moveStack)) {
            return false;
        }
        if (!Objects.equals(this.xIndex, c.xIndex)) {
            return false;
        }
        if (!Objects.equals(this.yIndex, c.yIndex)) {
            return false;
        }
        if (!Objects.equals(this.xOffset, c.xOffset)) {
            return false;
        }
        if (!Objects.equals(this.yOffset, c.yOffset)) {
            return false;
        }
        return Objects.equals(this.description, c.description);
    }

    public static class MoveExecuter
    implements Runnable {
        private final List<Move> moves = new ArrayList<Move>();
        private final Set<GamePiece> pieces = new HashSet<GamePiece>();
        private KeyStroke stroke;
        private final List<GamePiece> innerPieces = new ArrayList<GamePiece>();
        private Command additionalCommand;

        @Override
        public void run() {
            mover = null;
            Command comm = new NullCommand();
            comm = comm.append(this.additionalCommand);
            Iterator<Move> iterator = this.moves.iterator();
            while (iterator.hasNext()) {
                Move move;
                final Map.Merger merger = new Map.Merger(move.map, move.pos, move.piece);
                move = iterator.next();
                DeckVisitor v = new DeckVisitor(){

                    @Override
                    public Object visitDeck(Deck d) {
                        return merger.visitDeck(d);
                    }

                    @Override
                    public Object visitStack(Stack s) {
                        if (!pieces.contains(s) && move.map.getPieceCollection().canMerge(s, move.piece)) {
                            return merger.visitStack(s);
                        }
                        return null;
                    }

                    @Override
                    public Object visitDefault(GamePiece p) {
                        if (!pieces.contains(p) && move.map.getPieceCollection().canMerge(p, move.piece)) {
                            return merger.visitDefault(p);
                        }
                        return null;
                    }
                };
                DeckVisitorDispatcher dispatch = new DeckVisitorDispatcher(v);
                Command c = move.map.apply(dispatch);
                if (c == null) {
                    c = move.map.placeAt(move.piece, move.pos);
                    if (move.map.getMoveKey() != null) {
                        c.append(Decorator.getOutermost(move.piece).keyEvent(move.map.getMoveKey()));
                    }
                }
                comm.append(c);
                if (move.piece.getMap() == move.map) {
                    move.map.ensureVisible(move.map.selectionBoundsOf(move.piece));
                }
                this.pieces.remove(move.piece);
                move.map.repaint();
            }
            MovementReporter r = new MovementReporter(comm);
            if (GlobalOptions.getInstance().autoReportEnabled()) {
                Command reportCommand = r.getReportCommand();
                if (reportCommand != null) {
                    reportCommand.execute();
                }
                comm.append(reportCommand);
            }
            comm.append(r.markMovedPieces());
            if (this.stroke != null) {
                for (GamePiece gamePiece : this.innerPieces) {
                    comm.append(gamePiece.keyEvent(this.stroke));
                }
            }
            GameModule.getGameModule().sendAndLog(comm);
        }

        public void add(Map map, GamePiece piece, Point pos) {
            this.moves.add(new Move(map, piece, pos));
            this.pieces.add(piece);
        }

        public void addKeyEventTarget(GamePiece piece) {
            this.innerPieces.add(piece);
        }

        public void setKeyEvent(KeyStroke stroke) {
            this.stroke = stroke;
        }

        public void setAdditionalCommand(Command c) {
            this.additionalCommand = c;
        }

        public Command getAdditionalCommand() {
            return this.additionalCommand;
        }

        public Point getUpdatedPosition(GamePiece target) {
            Point p = null;
            for (Move move : this.moves) {
                if (move.piece != target) continue;
                p = move.pos;
            }
            return p;
        }

        private static class Move {
            private final Map map;
            private final GamePiece piece;
            private final Point pos;

            public Move(Map map, GamePiece piece, Point pos) {
                this.map = map;
                this.piece = piece;
                this.pos = pos;
            }
        }
    }

    public static class Editor
    implements PieceEditor {
        private final FormattedExpressionConfigurer xDist;
        private final FormattedExpressionConfigurer yDist;
        private final StringConfigurer name;
        private final NamedHotKeyConfigurer key;
        private final TraitConfigPanel controls = new TraitConfigPanel();
        private final BooleanConfigurer moveStack;
        @Deprecated(since="2020-12-11", forRemoval=true)
        protected BooleanConfigurer advancedInput;
        protected FormattedExpressionConfigurer xIndexInput;
        protected FormattedExpressionConfigurer xOffsetInput;
        protected FormattedExpressionConfigurer yIndexInput;
        protected FormattedExpressionConfigurer yOffsetInput;
        protected StringConfigurer descInput;

        public Editor(Translate t) {
            this.descInput = new StringConfigurer(t.description);
            this.descInput.setHintKey("Editor.description_hint");
            this.controls.add("Editor.description_label", (Configurer)this.descInput);
            this.name = new StringConfigurer(t.commandName);
            this.name.setHintKey("Editor.menu_command_hint");
            this.controls.add("Editor.menu_command", (Configurer)this.name);
            this.key = new NamedHotKeyConfigurer(t.keyCommand);
            this.controls.add("Editor.keyboard_command", (Configurer)this.key);
            this.xDist = new FormattedExpressionConfigurer(t.xDist.getFormat(), t);
            this.controls.add("Editor.MoveFixedDistance.distance_to_the_right", (Configurer)this.xDist);
            this.yDist = new FormattedExpressionConfigurer(t.yDist.getFormat(), t);
            this.controls.add("Editor.MoveFixedDistance.distance_upwards", (Configurer)this.yDist);
            this.moveStack = new BooleanConfigurer((Boolean)t.moveStack);
            this.controls.add("Editor.MoveFixedDistance.move_entire_stack", (Configurer)this.moveStack);
            JLabel xLabel = new JLabel(Resources.getString("Editor.MoveFixedDistance.additional_offset_to_the_right"));
            JPanel xControls = new JPanel((LayoutManager)new MigLayout("ins 0", "[fill,grow]rel[]rel[fill,grow]"));
            xLabel.setLabelFor(xControls);
            this.xIndexInput = new FormattedExpressionConfigurer(t.xIndex.getFormat(), t);
            xControls.add(this.xIndexInput.getControls(), "grow");
            JLabel times = new JLabel(Resources.getString("Editor.MoveFixedDistance.times"));
            this.xOffsetInput = new FormattedExpressionConfigurer(t.xOffset.getFormat(), t);
            times.setLabelFor(this.xOffsetInput.getControls());
            xControls.add(times);
            xControls.add(this.xOffsetInput.getControls(), "grow");
            this.controls.add(xLabel);
            this.controls.add((Component)xControls, "grow,wrap");
            JLabel yLabel = new JLabel(Resources.getString("Editor.MoveFixedDistance.additional_offset_upwards"));
            JPanel yControls = new JPanel((LayoutManager)new MigLayout("ins 0", "[fill,grow]rel[]rel[fill,grow]"));
            yLabel.setLabelFor(yControls);
            this.yIndexInput = new FormattedExpressionConfigurer(t.yIndex.getFormat(), t);
            yControls.add(this.yIndexInput.getControls());
            times = new JLabel(Resources.getString("Editor.MoveFixedDistance.times"));
            this.yOffsetInput = new FormattedExpressionConfigurer(t.yOffset.getFormat(), t);
            times.setLabelFor(this.yOffsetInput.getControls());
            yControls.add(times);
            yControls.add(this.yOffsetInput.getControls(), "grow");
            this.controls.add(yLabel);
            this.controls.add((Component)yControls, "grow,wrap");
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        @Override
        public String getState() {
            return "";
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.name.getValueString()).append(this.key.getValueString()).append(this.xDist.getValueString()).append(this.yDist.getValueString()).append(this.moveStack.getValueString()).append(this.xIndexInput.getValueString()).append(this.yIndexInput.getValueString()).append(this.xOffsetInput.getValueString()).append(this.yOffsetInput.getValueString()).append(this.descInput.getValueString());
            return Translate.ID + se.getValue();
        }
    }
}

