/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.script.expression;

import VASSAL.build.module.properties.PropertySource;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceFilter;
import VASSAL.i18n.Resources;
import VASSAL.script.ExpressionInterpreter;
import VASSAL.script.expression.AuditTrail;
import VASSAL.script.expression.Auditable;
import VASSAL.script.expression.Expression;
import VASSAL.script.expression.ExpressionException;
import VASSAL.script.expression.IntExpression;
import VASSAL.script.expression.NullExpression;
import VASSAL.script.expression.StringExpression;
import VASSAL.tools.FormattedString;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class BeanShellExpression
extends Expression {
    protected ExpressionInterpreter interpreter;

    public BeanShellExpression(String s) {
        super("{" + s + "}");
    }

    @Override
    protected void reset() {
        this.interpreter = null;
    }

    @Override
    public String evaluate(PropertySource ps, Map<String, String> properties, boolean localized, Auditable owner, AuditTrail audit) throws ExpressionException {
        if (this.interpreter == null) {
            this.interpreter = new ExpressionInterpreter(BeanShellExpression.strip(this.getExpression()));
        }
        return this.interpreter.evaluate(ps, properties, localized, owner, audit);
    }

    @Override
    @Deprecated(since="2021-06-11")
    public String evaluate(PropertySource ps, Map<String, String> properties, boolean localized) throws ExpressionException {
        return this.evaluate(ps, properties, localized, null, null);
    }

    @Override
    public String toBeanShellString() {
        return BeanShellExpression.strip(this.getExpression());
    }

    protected static String strip(String expr) {
        String s = expr.trim();
        if (s.startsWith("{") && s.endsWith("}")) {
            return s.substring(1, s.length() - 1);
        }
        return expr;
    }

    protected boolean isDynamic() {
        return this.getExpression() != null && this.getExpression().indexOf(36) >= 0;
    }

    @Override
    @Deprecated(since="2021-06-11")
    public PieceFilter getFilter(PropertySource ps) {
        return this.getFilter(ps, null, null);
    }

    @Override
    public PieceFilter getFilter(PropertySource ps, Auditable owner, AuditTrail audit) {
        if (this.isDynamic()) {
            String s = new FormattedString(BeanShellExpression.strip(this.getExpression())).getText(ps, owner, audit);
            return Expression.createExpression("{" + s + "}").getFilter(owner, audit);
        }
        return new BshFilter(owner, audit);
    }

    public static String convertProperty(String prop) {
        if (prop == null || prop.length() == 0) {
            return "";
        }
        if (BeanShellExpression.isBeanShellExpression(prop)) {
            return BeanShellExpression.strip(prop);
        }
        boolean ok = Character.isJavaIdentifierStart(prop.charAt(0));
        if (ok) {
            for (int i = 1; i < prop.length() && ok; ++i) {
                ok = Character.isJavaIdentifierPart(prop.charAt(i));
            }
        }
        return ok ? prop : "GetProperty(\"" + prop + "\")";
    }

    public static boolean isBeanShellExpression(String expr) {
        return expr.startsWith("{") && expr.endsWith("}");
    }

    public static boolean isJavaIdentifier(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static Expression createExpression(String s) {
        return BeanShellExpression.createExpression(s, false);
    }

    public static Expression createExpression(String s, boolean dontCreateStringExpressions) {
        String expr = BeanShellExpression.strip(s);
        if (expr.isBlank()) {
            return NullExpression.instance();
        }
        try {
            return IntExpression.instance(Integer.parseInt(expr));
        }
        catch (NumberFormatException numberFormatException) {
            if (!dontCreateStringExpressions && expr.length() > 1 && expr.startsWith("\"") && expr.endsWith("\"") && expr.indexOf(34, 1) == expr.length() - 1) {
                return StringExpression.instance(expr.substring(1, expr.length() - 1));
            }
            return BeanShellExpression.instance(expr);
        }
    }

    public static Expression instance(String s) {
        return CACHE.computeIfAbsent(Pair.of((Object)s, BeanShellExpression.class), k -> new BeanShellExpression(s));
    }

    public class BshFilter
    implements PieceFilter {
        private final Auditable owningAuditable;
        private final AuditTrail auditTrail;

        public BshFilter(Auditable owner, AuditTrail auditTrail) {
            this.owningAuditable = owner;
            this.auditTrail = auditTrail;
        }

        @Override
        @Deprecated(since="2021-06-11")
        public boolean accept(GamePiece piece) {
            return this.accept(piece, this.owningAuditable, this.auditTrail);
        }

        @Override
        public boolean accept(GamePiece piece, Auditable owner, String fieldKey) {
            return this.accept(piece, owner, AuditTrail.create(owner, BeanShellExpression.this.getExpression(), Resources.getString(fieldKey)));
        }

        @Override
        public boolean accept(GamePiece piece, Auditable owner, AuditTrail audit) {
            return "true".equals(BeanShellExpression.this.tryEvaluate((PropertySource)piece, owner, audit));
        }
    }
}

