/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.deprecation;

import VASSAL.tools.deprecation.Walker;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class DeprecationWalker
implements Walker {
    private Callback callback = (n, s, r) -> {};
    private final List<String> path = new ArrayList<String>();
    private ClassReader reader;
    private static final String DEPRECATED = Deprecated.class.getName();

    public void setCallback(Callback cb) {
        this.callback = cb;
    }

    @Override
    public void setInput(byte[] classFile) {
        this.reader = new ClassReader(classFile);
    }

    @Override
    public void setInput(InputStream in) throws IOException {
        this.reader = new ClassReader(in);
    }

    @Override
    public void setInput(String className) throws IOException {
        this.reader = new ClassReader(className);
    }

    @Override
    public void walk() {
        this.reader.accept((ClassVisitor)new ClassDependencyVisitor(), 0);
    }

    private String typeString(Type t) {
        switch (t.getSort()) {
            case 1: {
                return "boolean";
            }
            case 2: {
                return "char";
            }
            case 3: {
                return "byte";
            }
            case 4: {
                return "short";
            }
            case 5: {
                return "int";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "long";
            }
            case 8: {
                return "double";
            }
            case 9: {
                return this.typeString(t.getElementType()) + "[]".repeat(t.getDimensions());
            }
            case 10: {
                return t.getInternalName();
            }
        }
        throw new IllegalArgumentException();
    }

    private String classString(String name) {
        return Type.getObjectType((String)name).getInternalName().replace('/', '.');
    }

    private String descString(String desc) {
        return Type.getType((String)desc).getInternalName().replace('/', '.');
    }

    private String methodString(String name, String desc) {
        ArrayList<String> args = new ArrayList<String>();
        for (Type t : Type.getArgumentTypes((String)desc)) {
            args.add(this.typeString(t));
        }
        return (name + "(" + String.join((CharSequence)", ", args) + ")").replace('/', '.');
    }

    @FunctionalInterface
    public static interface Callback {
        public void accept(String var1, String var2, boolean var3);
    }

    private class ClassDependencyVisitor
    extends ClassVisitor {
        public ClassDependencyVisitor() {
            super(589824);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            DeprecationWalker.this.path.clear();
            DeprecationWalker.this.path.add(DeprecationWalker.this.classString(name));
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return DEPRECATED.equals(DeprecationWalker.this.descString(desc)) ? new AnnotationDependencyVisitor() : null;
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            DeprecationWalker.this.path.add(name);
            return new FieldDependencyVisitor();
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            DeprecationWalker.this.path.add(DeprecationWalker.this.methodString(name, desc));
            return new MethodDependencyVisitor();
        }
    }

    private class MethodDependencyVisitor
    extends MethodVisitor {
        public MethodDependencyVisitor() {
            super(589824);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return DEPRECATED.equals(DeprecationWalker.this.descString(desc)) ? new AnnotationDependencyVisitor() : null;
        }

        public void visitEnd() {
            DeprecationWalker.this.path.remove(DeprecationWalker.this.path.size() - 1);
        }
    }

    private class FieldDependencyVisitor
    extends FieldVisitor {
        public FieldDependencyVisitor() {
            super(589824);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return DEPRECATED.equals(DeprecationWalker.this.descString(desc)) ? new AnnotationDependencyVisitor() : null;
        }

        public void visitEnd() {
            DeprecationWalker.this.path.remove(DeprecationWalker.this.path.size() - 1);
        }
    }

    private class AnnotationDependencyVisitor
    extends AnnotationVisitor {
        private String since;
        private boolean forRemoval;

        public AnnotationDependencyVisitor() {
            super(589824);
            this.since = null;
            this.forRemoval = false;
        }

        public void visit(String name, Object value) {
            if ("since".equals(name)) {
                this.since = (String)value;
            } else if ("forRemoval".equals(name)) {
                this.forRemoval = (Boolean)value;
            }
        }

        public void visitEnd() {
            DeprecationWalker.this.callback.accept(String.join((CharSequence)".", DeprecationWalker.this.path), this.since, this.forRemoval);
        }
    }
}

