/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image;

import java.awt.Image;
import java.awt.image.AbstractMultiResolutionImage;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Objects;

public class MultiResolutionRenderedImage
extends AbstractMultiResolutionImage {
    private final int baseWidth;
    private final int baseHeight;
    private final Renderer renderer;

    public MultiResolutionRenderedImage(int w, int h, Renderer r) {
        this.baseWidth = w;
        this.baseHeight = h;
        this.renderer = Objects.requireNonNull(r);
    }

    @Override
    public Image getResolutionVariant(double w, double h) {
        return this.renderer.render((int)Math.round(w), (int)Math.round(h), w / (double)this.baseWidth);
    }

    @Override
    public List<Image> getResolutionVariants() {
        return List.of(this.getBaseImage());
    }

    @Override
    protected Image getBaseImage() {
        return this.renderer.render(this.baseWidth, this.baseHeight, 1.0);
    }

    @FunctionalInterface
    public static interface Renderer {
        public BufferedImage render(int var1, int var2, double var3);
    }
}

