/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.version;

import VASSAL.tools.version.LiveVersionInfo;
import VASSAL.tools.version.VersionInfo;
import java.io.IOException;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class VersionUtils {
    private static VersionInfo vinfo = new LiveVersionInfo();

    protected VersionUtils() {
    }

    public static void setVersionInfo(VersionInfo vi) {
        vinfo = vi;
    }

    public static int compareReportable(String version) throws IOException {
        switch (Integer.signum(VersionUtils.compareVersions(version, vinfo.getRelease()))) {
            case -1: {
                return -1;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return Integer.signum(VersionUtils.compareVersions(version, vinfo.getBeta()));
            }
        }
        throw new IllegalStateException();
    }

    public static boolean isCurrent(String version) throws IOException {
        return VersionUtils.compareReportable(version) >= 0;
    }

    @Deprecated(since="2021-04-15", forRemoval=true)
    public static Boolean isUpdateable(String runningVersion) throws IOException {
        return !VersionUtils.isCurrent(runningVersion);
    }

    public static int compareVersions(String v0, String v1) {
        ComparableVersion comparableVersion0 = new ComparableVersion(v0);
        ComparableVersion comparableVersion1 = new ComparableVersion(v1);
        return comparableVersion0.compareTo(comparableVersion1);
    }

    public static String nextMinorVersion(String v) {
        DefaultArtifactVersion av = new DefaultArtifactVersion(v);
        return String.valueOf(av.getMajorVersion()) + "." + (av.getMinorVersion() + 1);
    }

    public static String truncateToMinorVersion(String v) {
        DefaultArtifactVersion av = new DefaultArtifactVersion(v);
        return String.valueOf(av.getMajorVersion()) + "." + av.getMinorVersion();
    }
}

