/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHAmbiguousName;
import bsh.BSHAssignment;
import bsh.BSHMethodInvocation;
import bsh.ParseException;
import bsh.Parser;
import bsh.SimpleNode;
import bsh.TokenMgrError;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class BeanShellExpressionValidator {
    protected String expression;
    protected List<String> variables = new ArrayList<String>();
    protected List<String> stringVariables = new ArrayList<String>();
    protected List<String> methods = new ArrayList<String>();
    protected String error;
    protected boolean valid;
    private static final Set<String> supportedStringFunctions = Set.of(".compareTo", ".compareToIgnoreCase", ".contains", ".endsWith", ".equals", ".equalsIgnoreCase", ".format", ".hashCode", ".indexOf", ".isBlank", ".isEmpty", ".lastIndexOf", ".length", ".matches", ".regionMatches", ".repeat", ".replace", ".replaceAll", ".replaceFirst", ".startsWith", ".strip", ".stripLeading", ".stripTrailing", ".substring", ".toLowerCase", ".toUpperCase", ".trim");

    public BeanShellExpressionValidator(String expression) {
        this.expression = expression;
        this.valid = this.validate();
    }

    public boolean isValid() {
        return this.valid;
    }

    protected void setValid(boolean b) {
        this.valid = b;
    }

    public List<String> getStringVariables() {
        return this.stringVariables;
    }

    public List<String> getVariables() {
        return this.variables;
    }

    public List<String> getMethods() {
        return this.methods;
    }

    public String getError() {
        return this.error;
    }

    protected void setError(String s) {
        this.error = s;
    }

    protected boolean validate() {
        String expr = BeanShellExpressionValidator.stripBraces(this.expression);
        this.setError("");
        try {
            SimpleNode node;
            Parser p = new Parser(new StringReader(expr + ";"));
            do {
                if (!p.Line()) continue;
                return true;
            } while (this.processNode(node = p.popNode()));
            return false;
        }
        catch (ParseException e) {
            this.setError(e.getMessage());
            return false;
        }
        catch (TokenMgrError e) {
            this.setError(e.getMessage());
            return false;
        }
    }

    public static String stripBraces(String s) {
        String expr = s;
        if (s.trim().startsWith("{") && s.trim().endsWith("}")) {
            int start = s.indexOf("{");
            int end = s.lastIndexOf("}");
            StringBuilder buffer = new StringBuilder(s.length());
            for (int i = 0; i < s.length(); ++i) {
                if (i == start || i == end) {
                    buffer.append(' ');
                    continue;
                }
                buffer.append(s.charAt(i));
            }
            expr = buffer.toString();
        }
        return expr;
    }

    protected boolean processNode(SimpleNode node) {
        if (node == null) {
            return true;
        }
        if (node instanceof BSHAmbiguousName) {
            String name = node.getText().trim();
            if (node.parent instanceof BSHMethodInvocation) {
                if (!this.methods.contains(name)) {
                    String[] tokens = name.split(" ");
                    if (tokens.length == 1) {
                        if (!this.methods.contains(name)) {
                            this.methods.add(name);
                        }
                    } else if (supportedStringFunctions.contains(tokens[1]) && !this.stringVariables.contains(tokens[0])) {
                        this.stringVariables.add(tokens[0]);
                    }
                }
            } else if (!this.variables.contains(name)) {
                this.variables.add(name);
            }
        } else {
            if (node instanceof BSHAssignment) {
                this.setError("Assignments (=) not allowed in Expressions. See Help");
                return false;
            }
            if (node.children != null) {
                for (int i = 0; i < node.children.length; ++i) {
                    if (this.processNode(node.getChild(i))) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

