/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractFolder;
import VASSAL.build.AbstractToolbarItem;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.MutablePropertiesContainer;
import VASSAL.build.module.properties.MutableProperty;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.AutoConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.ConfigurerWindow;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.PlayerIdFormattedExpressionConfigurer;
import VASSAL.configure.TranslatingStringEnumConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.search.HTMLImageFinder;
import VASSAL.tools.FormattedString;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.ArrayUtils;

public class DiceButton
extends AbstractToolbarItem {
    protected Random ran;
    protected int nSides = 6;
    protected int nDice = 2;
    protected int plus = 0;
    protected int addToTotal = 0;
    protected boolean reportTotal = false;
    protected boolean promptAlways = false;
    protected boolean sortDice = false;
    protected final FormattedString reportFormat = new FormattedString("** $name$ = $result$ *** &lt;$PlayerName$&gt;");
    protected boolean lockSides = false;
    protected boolean lockDice = false;
    protected boolean lockPlus = false;
    protected boolean lockAdd = false;
    protected int[] keepDice;
    protected int numericTotal;
    protected boolean keepingDice = false;
    protected String keepOption = ">";
    protected int keepValue = 1;
    protected int keepCount;
    protected static final String KEEP_SMALLEST = "s";
    protected static final String KEEP_LARGEST = "l";
    protected static final String KEEP_EQUAL = "=";
    protected static final String KEEP_GREATER = ">";
    protected static final String KEEP_LESS = "<";
    @Deprecated(since="2021-04-03", forRemoval=true)
    protected LaunchButton launch;
    protected String tooltip = "";
    protected final MutableProperty.Impl property = new MutableProperty.Impl("", this);
    protected final MutableProperty.Impl totalProp = new MutableProperty.Impl("", this);
    protected final MutableProperty.Impl keepProp = new MutableProperty.Impl("", this);
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String BUTTON_TEXT = "text";
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String TOOLTIP = "tooltip";
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String NAME = "name";
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String ICON = "icon";
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String HOTKEY = "hotkey";
    public static final String DEPRECATED_NAME = "label";
    public static final String N_DICE = "nDice";
    public static final String N_SIDES = "nSides";
    public static final String PLUS = "plus";
    public static final String ADD_TO_TOTAL = "addToTotal";
    public static final String REPORT_TOTAL = "reportTotal";
    public static final String PROMPT_ALWAYS = "prompt";
    public static final String REPORT_FORMAT = "reportFormat";
    public static final String SORT_DICE_RESULTS = "sortDice";
    public static final String KEEP_DICE = "keepDice";
    public static final String KEEP_OPTION = "keepOption";
    public static final String KEEP_COUNT = "keepCount";
    public static final String LOCK_DICE = "lockDice";
    public static final String LOCK_SIDES = "lockSides";
    public static final String LOCK_PLUS = "lockPlus";
    public static final String LOCK_ADD = "lockAdd";
    public static final String RESULT = "result";
    public static final String REPORT_NAME = "name";
    public static final String RESULT_N = "result#";
    public static final String NUMERIC_TOTAL = "numericalTotal";
    private final VisibilityCondition cond = () -> this.promptAlways;
    private final VisibilityCondition keep = () -> this.keepingDice;

    public DiceButton() {
        this.initLaunchButton();
    }

    protected void initLaunchButton() {
        ActionListener rollAction = e -> {
            ArrayList<String> keepAttributes = new ArrayList<String>();
            if (this.promptAlways) {
                if (!this.lockDice) {
                    keepAttributes.add(N_DICE);
                }
                if (!this.lockSides) {
                    keepAttributes.add(N_SIDES);
                }
                if (!this.lockPlus) {
                    keepAttributes.add(PLUS);
                }
                if (!this.lockAdd) {
                    keepAttributes.add(ADD_TO_TOTAL);
                }
            }
            if (this.promptAlways && !keepAttributes.isEmpty()) {
                DiceButton delegate = new DiceButton(){

                    @Override
                    protected void initLaunchButton() {
                        this.setLaunchButton(this.makeLaunchButton("", DiceButton.BUTTON_TEXT, "", null));
                    }
                };
                for (String key : keepAttributes) {
                    delegate.setAttribute(key, this.getAttributeValueString(key));
                }
                AutoConfigurer ac = new AutoConfigurer(delegate);
                ConfigurerWindow w = new ConfigurerWindow(ac, true);
                w.setTitle(this.getConfigureName());
                for (String key : this.getAttributeNames()) {
                    if (keepAttributes.contains(key)) continue;
                    Component controls = ac.getConfigurer(key).getControls();
                    Container parent = controls.getParent();
                    parent.remove(controls);
                    parent.remove(ac.getLabel(key));
                }
                w.setLocationRelativeTo(this.getLaunchButton().getTopLevelAncestor());
                SwingUtils.repack(w, true);
                w.setVisible(true);
                for (String key : keepAttributes) {
                    this.setAttribute(key, delegate.getAttributeValueString(key));
                }
                if (!w.isCancelled()) {
                    this.DR();
                }
            } else {
                this.DR();
            }
        };
        this.setLaunchButton(this.makeLaunchButton(Resources.getString("Editor.DiceButton.dice_button_text"), Resources.getString("Editor.DiceButton.dice_button_tooltip"), "/images/die.gif", rollAction));
        this.launch = this.getLaunchButton();
        this.setAttribute("name", Resources.getString("Editor.DiceButton.dice_name"));
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.DiceButton.component_type");
    }

    protected void DR() {
        int i;
        this.keepDice = new int[this.nDice];
        this.numericTotal = this.addToTotal;
        this.keepCount = 0;
        for (int i2 = 0; i2 < this.nDice; ++i2) {
            int roll = this.ran.nextInt(this.nSides) + 1 + this.plus;
            if (this.keepingDice && (KEEP_GREATER.equals(this.keepOption) && roll < this.keepValue || KEEP_LESS.equals(this.keepOption) && roll > this.keepValue || KEEP_EQUAL.equals(this.keepOption) && roll != this.keepValue)) continue;
            ++this.keepCount;
            this.keepDice[this.keepCount - 1] = roll;
            this.numericTotal += roll;
        }
        if (List.of(KEEP_SMALLEST, KEEP_LARGEST).contains(this.keepOption)) {
            int[] tempDice = Arrays.copyOf(this.keepDice, this.keepDice.length);
            Arrays.sort(tempDice);
            this.keepCount = Math.max(0, Math.min(this.keepValue, tempDice.length));
            this.keepDice = new int[this.keepCount];
            if (KEEP_SMALLEST.equals(this.keepOption)) {
                System.arraycopy(tempDice, 0, this.keepDice, 0, this.keepCount);
            } else {
                for (i = 0; i < this.keepCount; ++i) {
                    this.keepDice[i] = tempDice[tempDice.length - this.keepCount + i];
                }
            }
            this.numericTotal = this.addToTotal;
            for (i = 0; i < this.keepCount; ++i) {
                this.numericTotal += this.keepDice[i];
            }
        }
        if (this.sortDice) {
            Arrays.sort(this.keepDice);
        }
        StringBuilder val = new StringBuilder();
        if (this.reportTotal) {
            val.append(this.numericTotal);
        } else {
            for (i = 0; i < this.keepCount; ++i) {
                val.append(this.keepDice[i]);
                if (i >= this.keepCount - 1) continue;
                val.append(',');
            }
        }
        String report = this.formatResult(val.toString());
        Command c = report.length() == 0 ? new NullCommand() : new Chatter.DisplayText(GameModule.getGameModule().getChatter(), report);
        c.execute();
        c = c.append(this.property.setPropertyValue(val.toString())).append(this.totalProp.setPropertyValue(Integer.toString(this.numericTotal))).append(this.keepProp.setPropertyValue(Integer.toString(this.keepCount)));
        GameModule.getGameModule().sendAndLog(c);
    }

    protected String formatResult(String result) {
        this.reportFormat.setProperty("name", this.getLocalizedConfigureName());
        this.reportFormat.setProperty(RESULT, result);
        this.reportFormat.setProperty(N_DICE, Integer.toString(this.nDice));
        this.reportFormat.setProperty(N_SIDES, Integer.toString(this.nSides));
        this.reportFormat.setProperty(PLUS, Integer.toString(this.plus));
        this.reportFormat.setProperty(ADD_TO_TOTAL, Integer.toString(this.addToTotal));
        for (int i = 0; i < this.keepCount; ++i) {
            this.reportFormat.setProperty(RESULT + (i + 1), Integer.toString(this.keepDice[i]));
        }
        this.reportFormat.setProperty(NUMERIC_TOTAL, Integer.toString(this.numericTotal));
        this.reportFormat.setProperty(KEEP_DICE, Integer.toString(this.keepValue));
        this.reportFormat.setProperty(KEEP_COUNT, Integer.toString(this.keepCount));
        String text = this.reportFormat.getLocalizedText(this, "Editor.report_format");
        Object report = text;
        if (text.length() > 0) {
            report = text.startsWith("*") ? "*" + text : "* " + text;
        }
        return report;
    }

    @Override
    public String[] getAttributeNames() {
        return (String[])ArrayUtils.addAll((Object[])super.getAttributeNames(), (Object[])new String[]{REPORT_FORMAT, PROMPT_ALWAYS, N_DICE, LOCK_DICE, N_SIDES, LOCK_SIDES, PLUS, LOCK_PLUS, ADD_TO_TOTAL, LOCK_ADD, REPORT_TOTAL, SORT_DICE_RESULTS, KEEP_DICE, KEEP_OPTION, KEEP_COUNT});
    }

    @Override
    public String[] getAttributeDescriptions() {
        return (String[])ArrayUtils.addAll((Object[])super.getAttributeDescriptions(), (Object[])new String[]{Resources.getString("Editor.report_format"), Resources.getString("Editor.DiceButton.prompt_value"), Resources.getString("Dice.number_of_dice"), Resources.getString("Editor.DiceButton.lock_number_of_dice"), Resources.getString("Dice.number_of_sides"), Resources.getString("Editor.DiceButton.lock_number_of_sides"), Resources.getString("Dice.add_to_each_side"), Resources.getString("Editor.DiceButton.lock_add_to_each_side"), Resources.getString("Dice.add_to_total"), Resources.getString("Editor.DiceButton.lock_add_to_total"), Resources.getString("Editor.DiceButton.report_total"), Resources.getString("Editor.DiceButton.sort_results"), Resources.getString("Editor.DiceButton.keep_dice"), Resources.getString("Editor.DiceButton.keep_option"), Resources.getString("Editor.DiceButton.keep_count")});
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return (Class[])ArrayUtils.addAll((Object[])super.getAttributeTypes(), (Object[])new Class[]{ReportFormatConfig.class, Boolean.class, Integer.class, Boolean.class, Integer.class, Boolean.class, Integer.class, Boolean.class, Integer.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, KeepConfig.class, Integer.class});
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (List.of(LOCK_DICE, LOCK_SIDES, LOCK_PLUS, LOCK_ADD).contains(name)) {
            return this.cond;
        }
        if (List.of(KEEP_OPTION, KEEP_COUNT).contains(name)) {
            return this.keep;
        }
        return super.getAttributeVisibility(name);
    }

    @Override
    public void addTo(Buildable parent) {
        super.addTo(parent);
        if (parent instanceof AbstractFolder) {
            parent = ((AbstractFolder)parent).getNonFolderAncestor();
        }
        this.ran = GameModule.getGameModule().getRNG();
        this.property.setPropertyValue("1");
        this.property.addTo((MutablePropertiesContainer)((Object)parent));
        this.totalProp.setPropertyValue("0");
        this.totalProp.addTo((MutablePropertiesContainer)((Object)parent));
        this.keepProp.setPropertyValue("0");
        this.keepProp.addTo((MutablePropertiesContainer)((Object)parent));
    }

    @Override
    public void setAttribute(String key, Object o) {
        if (DEPRECATED_NAME.equals(key)) {
            this.setAttribute("name", o);
            this.setAttribute(BUTTON_TEXT, o);
        } else if ("name".equals(key)) {
            this.setConfigureName((String)o);
            this.property.setPropertyName(this.getConfigureName() + "_result");
            this.totalProp.setPropertyName(this.getConfigureName() + "_total");
            this.keepProp.setPropertyName(this.getConfigureName() + "_keep");
            this.getLaunchButton().setToolTipText((String)o);
        } else if (N_DICE.equals(key)) {
            if (o instanceof Integer) {
                this.nDice = (Integer)o;
            } else if (o instanceof String) {
                this.nDice = Integer.parseInt((String)o);
            }
        } else if (LOCK_DICE.equals(key)) {
            if (o instanceof Boolean) {
                this.lockDice = (Boolean)o;
            } else if (o instanceof String) {
                this.lockDice = "true".equals(o);
            }
        } else if (N_SIDES.equals(key)) {
            if (o instanceof Integer) {
                this.nSides = (Integer)o;
            } else if (o instanceof String) {
                this.nSides = Integer.parseInt((String)o);
            }
        } else if (LOCK_SIDES.equals(key)) {
            if (o instanceof Boolean) {
                this.lockSides = (Boolean)o;
            } else if (o instanceof String) {
                this.lockSides = "true".equals(o);
            }
        } else if (PLUS.equals(key)) {
            if (o instanceof Integer) {
                this.plus = (Integer)o;
            } else if (o instanceof String) {
                this.plus = Integer.parseInt((String)o);
            }
        } else if (LOCK_PLUS.equals(key)) {
            if (o instanceof Boolean) {
                this.lockPlus = (Boolean)o;
            } else if (o instanceof String) {
                this.lockPlus = "true".equals(o);
            }
        } else if (ADD_TO_TOTAL.equals(key)) {
            if (o instanceof Integer) {
                this.addToTotal = (Integer)o;
            } else if (o instanceof String) {
                this.addToTotal = Integer.parseInt((String)o);
            }
        } else if (LOCK_ADD.equals(key)) {
            if (o instanceof Boolean) {
                this.lockAdd = (Boolean)o;
            } else if (o instanceof String) {
                this.lockAdd = "true".equals(o);
            }
        } else if (REPORT_TOTAL.equals(key)) {
            if (o instanceof Boolean) {
                this.reportTotal = (Boolean)o;
            } else if (o instanceof String) {
                this.reportTotal = "true".equals(o);
            }
        } else if (PROMPT_ALWAYS.equals(key)) {
            if (o instanceof Boolean) {
                this.promptAlways = (Boolean)o;
            } else if (o instanceof String) {
                this.promptAlways = "true".equals(o);
            }
        } else if (REPORT_FORMAT.equals(key)) {
            this.reportFormat.setFormat((String)o);
        } else if (TOOLTIP.equals(key)) {
            this.tooltip = (String)o;
            super.setAttribute(key, o);
        } else if (SORT_DICE_RESULTS.equals(key)) {
            if (o instanceof Boolean) {
                this.sortDice = (Boolean)o;
            } else if (o instanceof String) {
                this.sortDice = "true".equals(o);
            }
        } else if (KEEP_DICE.equals(key)) {
            if (o instanceof Boolean) {
                this.keepingDice = (Boolean)o;
            } else if (o instanceof String) {
                this.keepingDice = "true".equals(o);
            }
        } else if (KEEP_OPTION.equals(key)) {
            this.keepOption = (String)o;
        } else if (KEEP_COUNT.equals(key)) {
            if (o instanceof Integer) {
                this.keepValue = (Integer)o;
            } else if (o instanceof String) {
                this.keepValue = Integer.parseInt((String)o);
            }
        } else {
            super.setAttribute(key, o);
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if ("name".equals(key)) {
            return this.getConfigureName();
        }
        if (N_DICE.equals(key)) {
            return String.valueOf(this.nDice);
        }
        if (LOCK_DICE.equals(key)) {
            return String.valueOf(this.lockDice);
        }
        if (N_SIDES.equals(key)) {
            return String.valueOf(this.nSides);
        }
        if (LOCK_SIDES.equals(key)) {
            return String.valueOf(this.lockSides);
        }
        if (PLUS.equals(key)) {
            return String.valueOf(this.plus);
        }
        if (LOCK_PLUS.equals(key)) {
            return String.valueOf(this.lockPlus);
        }
        if (ADD_TO_TOTAL.equals(key)) {
            return String.valueOf(this.addToTotal);
        }
        if (LOCK_ADD.equals(key)) {
            return String.valueOf(this.lockAdd);
        }
        if (REPORT_TOTAL.equals(key)) {
            return String.valueOf(this.reportTotal);
        }
        if (PROMPT_ALWAYS.equals(key)) {
            return String.valueOf(this.promptAlways);
        }
        if (REPORT_FORMAT.equals(key)) {
            return this.reportFormat.getFormat();
        }
        if (TOOLTIP.equals(key)) {
            return this.tooltip.length() == 0 ? super.getAttributeValueString(BUTTON_TEXT) : this.tooltip;
        }
        if (SORT_DICE_RESULTS.equals(key)) {
            return String.valueOf(this.sortDice);
        }
        if (KEEP_DICE.equals(key)) {
            return String.valueOf(this.keepingDice);
        }
        if (KEEP_OPTION.equals(key)) {
            return this.keepOption;
        }
        if (KEEP_COUNT.equals(key)) {
            return String.valueOf(this.keepValue);
        }
        return super.getAttributeValueString(key);
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("DiceButton.html");
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.getConfigureName() + "_result");
        return l;
    }

    @Override
    public void addLocalImageNames(Collection<String> s) {
        HTMLImageFinder h = new HTMLImageFinder(this.reportFormat.getFormat());
        h.addImageNames(s);
        super.addLocalImageNames(s);
    }

    public static class ReportFormatConfig
    implements TranslatableConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new PlayerIdFormattedExpressionConfigurer(key, name, new String[]{"name", DiceButton.RESULT, DiceButton.NUMERIC_TOTAL, DiceButton.RESULT_N, DiceButton.N_DICE, DiceButton.N_SIDES, DiceButton.PLUS, DiceButton.ADD_TO_TOTAL, DiceButton.KEEP_DICE, DiceButton.KEEP_COUNT});
        }
    }

    public static class KeepConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new TranslatingStringEnumConfigurer(key, name, new String[]{DiceButton.KEEP_GREATER, DiceButton.KEEP_EQUAL, DiceButton.KEEP_LESS, DiceButton.KEEP_LARGEST, DiceButton.KEEP_SMALLEST}, new String[]{"Editor.DiceButton.keep_greater_than", "Editor.DiceButton.keep_equal", "Editor.DiceButton.keep_less_than", "Editor.DiceButton.keep_largest", "Editor.DiceButton.keep_smallest"});
        }
    }

    @Deprecated(since="2020-10-01", forRemoval=true)
    public static class IconConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new IconConfigurer(key, name, "/images/die.gif");
        }
    }
}

