/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.metadata;

import VASSAL.build.module.metadata.AbstractMetaData;
import VASSAL.build.module.metadata.ExtensionMetaData;
import VASSAL.build.module.metadata.ModuleMetaData;
import VASSAL.build.module.metadata.SaveMetaData;
import VASSAL.tools.imports.ImportAction;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataFactory {
    private static final Logger logger = LoggerFactory.getLogger(MetaDataFactory.class);
    protected static final String BUILDFILE_MODULE_ELEMENT1 = "VASSAL.launch.BasicModule";
    protected static final String BUILDFILE_MODULE_ELEMENT2 = "VASSAL.build.GameModule";
    protected static final String BUILDFILE_EXTENSION_ELEMENT = "VASSAL.build.module.ModuleExtension";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AbstractMetaData buildMetaData(File file) {
        if (file == null) return null;
        if (!file.exists()) return null;
        if (!file.isFile()) {
            return null;
        }
        try (ZipFile zip = new ZipFile(file);){
            ZipEntry entry = zip.getEntry("savedGame");
            if (entry != null) {
                SaveMetaData saveMetaData = new SaveMetaData(zip);
                return saveMetaData;
            }
            ZipEntry buildFileEntry = zip.getEntry("buildFile.xml");
            if (buildFileEntry == null && (buildFileEntry = zip.getEntry("buildFile")) == null) {
                AbstractMetaData abstractMetaData = null;
                return abstractMetaData;
            }
            entry = zip.getEntry("extensiondata");
            if (entry != null) {
                ExtensionMetaData extensionMetaData = new ExtensionMetaData(zip);
                return extensionMetaData;
            }
            entry = zip.getEntry("moduledata");
            if (entry != null) {
                ModuleMetaData moduleMetaData = new ModuleMetaData(zip);
                return moduleMetaData;
            }
            try (InputStream zin = zip.getInputStream(buildFileEntry);
                 InputStreamReader isr = new InputStreamReader(zin, StandardCharsets.UTF_8);
                 BufferedReader br = new BufferedReader(isr);){
                int i = 0;
                while (i < 10) {
                    String s = br.readLine();
                    if (s.indexOf(BUILDFILE_MODULE_ELEMENT1) > 0 || s.indexOf(BUILDFILE_MODULE_ELEMENT2) > 0) {
                        ModuleMetaData moduleMetaData = new ModuleMetaData(zip);
                        return moduleMetaData;
                    }
                    if (s.indexOf(BUILDFILE_EXTENSION_ELEMENT) > 0) {
                        ExtensionMetaData extensionMetaData = new ExtensionMetaData(zip);
                        return extensionMetaData;
                    }
                    ++i;
                }
                return null;
            }
        }
        catch (ZipException e) {
            return ImportAction.buildMetaData(file);
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
        return null;
    }
}

