/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.build.GameModule;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.node.NodeClient;
import VASSAL.command.Command;
import VASSAL.i18n.Resources;
import VASSAL.tools.swing.Dialogs;

public class InviteCommand
extends Command {
    private final String room;
    private final String player;
    private final String playerId;
    private final ChatServerConnection client;

    public InviteCommand(String player, String playerId, String room, ChatServerConnection client) {
        this.player = player;
        this.playerId = playerId;
        this.room = room;
        this.client = client;
    }

    public InviteCommand(String player, String playerId, String room) {
        this(player, playerId, room, null);
    }

    public String getRoom() {
        return this.room;
    }

    public String getPlayer() {
        return this.player;
    }

    public String getPlayerId() {
        return this.playerId;
    }

    @Override
    protected void executeCommand() {
        int i;
        if (this.client instanceof NodeClient && (i = Dialogs.showConfirmDialog(GameModule.getGameModule().getPlayerWindow(), Resources.getString("Chat.invite_heading"), Resources.getString("Chat.invite_heading"), Resources.getString("Chat.invitation", this.player, this.room), 3, null, 0, "Invite" + this.playerId, Resources.getString("Chat.ignore_invitation"))) == 0) {
            ((NodeClient)this.client).doInvite(this.playerId, this.room);
        }
    }

    @Override
    protected Command myUndoCommand() {
        return null;
    }

    @Override
    public boolean isLoggable() {
        return false;
    }
}

