/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.boardPicker.board.mapgrid.PolygonConfigurer;
import VASSAL.build.module.map.boardPicker.board.mapgrid.PolygonEditor;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.FreeRotator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Hideable;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.MatCargo;
import VASSAL.counters.Obscurable;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.PieceFinder;
import VASSAL.counters.PropertyExporter;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.Resources;
import VASSAL.tools.AdjustableSpeedScrollPane;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.RecursionLimitException;
import VASSAL.tools.RecursionLimiter;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.swing.FlowLabel;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class ActionButton
extends Decorator
implements EditablePiece,
RecursionLimiter.Loopable {
    public static final String ID = "button;";
    public static final String LAUNCH_POPUP_MENU = "LaunchPopupMenu";
    public static final int ACTION_BUTTON_VERSION = 1;
    protected NamedKeyStroke stroke;
    protected Rectangle bounds = new Rectangle();
    protected Polygon polygon = new Polygon();
    protected ButtonPusher pusher;
    protected String description = "";
    protected int version;
    protected static final ButtonPusher globalPusher = new ButtonPusher();
    protected boolean launchPopupMenu = false;
    protected boolean useWholeShape = false;

    public ActionButton() {
        this(ID, null);
    }

    public ActionButton(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
        this.pusher = globalPusher;
    }

    @Override
    public void mySetState(String newState) {
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.stroke).append(this.bounds.x).append(this.bounds.y).append(this.bounds.width).append(this.bounds.height).append(this.description).append(this.launchPopupMenu).append(this.useWholeShape).append(1).append(this.polygon.npoints);
        for (int point = 0; point < this.polygon.npoints; ++point) {
            se.append(this.polygon.xpoints[point]).append(this.polygon.ypoints[point]);
        }
        return ID + se.getValue();
    }

    @Override
    public Object getProperty(Object key) {
        if (LAUNCH_POPUP_MENU.equals(key)) {
            return String.valueOf(this.launchPopupMenu);
        }
        return super.getProperty(key);
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        if (LAUNCH_POPUP_MENU.equals(key)) {
            return String.valueOf(this.launchPopupMenu);
        }
        return super.getLocalizedProperty(key);
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        return KeyCommand.NONE;
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        return null;
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public void setMap(Map m) {
        this.pusher.register(m);
        this.piece.setMap(m);
    }

    @Override
    public String getDescription() {
        Object s = this.buildDescription("Editor.ActionButton.trait_description", this.description);
        s = (String)s + this.getCommandDesc("", this.stroke);
        return s;
    }

    @Override
    public String getBaseDescription() {
        return Resources.getString("Editor.ActionButton.trait_description");
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return Arrays.asList(this.stroke);
    }

    @Override
    public void mySetType(String type) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        st.nextToken();
        this.stroke = st.nextNamedKeyStroke('A');
        this.bounds.x = st.nextInt(0);
        this.bounds.y = st.nextInt(0);
        this.bounds.width = st.nextInt(0);
        this.bounds.height = st.nextInt(0);
        this.description = st.nextToken("");
        this.launchPopupMenu = st.nextBoolean(false);
        this.useWholeShape = st.nextBoolean(false);
        this.version = st.nextInt(0);
        this.polygon.reset();
        if (this.version < 1) {
            if (this.bounds.width > 0 && this.bounds.height > 0) {
                this.polygon.addPoint(this.bounds.x, this.bounds.y);
                this.polygon.addPoint(this.bounds.x + this.bounds.width, this.bounds.y);
                this.polygon.addPoint(this.bounds.x + this.bounds.width, this.bounds.y + this.bounds.height);
                this.polygon.addPoint(this.bounds.x, this.bounds.y + this.bounds.height);
            } else {
                this.useWholeShape = true;
            }
        } else {
            int nPoints = st.nextInt(0);
            for (int point = 0; point < nPoints; ++point) {
                int x = st.nextInt(0);
                int y = st.nextInt(0);
                this.polygon.addPoint(x, y);
            }
        }
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("ActionButton.html");
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof ActionButton)) {
            return false;
        }
        ActionButton c = (ActionButton)o;
        if (!Objects.equals(this.bounds, c.bounds)) {
            return false;
        }
        if (!Objects.equals(this.launchPopupMenu, c.launchPopupMenu)) {
            return false;
        }
        if (!Objects.equals(this.useWholeShape, c.useWholeShape)) {
            return false;
        }
        if (this.version == c.version && !Objects.equals(this.polygon, c.polygon)) {
            return false;
        }
        return Objects.equals(this.description, c.description);
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    protected static class ButtonPusher {
        private final Set<Map> maps = new HashSet<Map>();
        private final java.util.Map<Component, ComponentMouseListener> componentMouseListeners = new HashMap<Component, ComponentMouseListener>();

        protected ButtonPusher() {
        }

        public void register(Map map) {
            if (map != null && !this.maps.contains(map)) {
                map.addLocalMouseListener(new MapMouseListener(map));
                this.maps.add(map);
            }
        }

        @Deprecated(since="2020-10-26", forRemoval=true)
        public void register(Component obs, GamePiece piece, int x, int y) {
            if (obs != null) {
                ComponentMouseListener l = this.componentMouseListeners.get(obs);
                if (l == null) {
                    l = new ComponentMouseListener(piece, x, y);
                    obs.addMouseListener(l);
                    this.componentMouseListeners.put(obs, l);
                } else {
                    l.xOffset = x;
                    l.yOffset = y;
                    l.target = piece;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doClick(GamePiece p, Point point) {
            GamePiece piece = p;
            while (piece instanceof Decorator) {
                block14: {
                    ActionButton action;
                    block17: {
                        block16: {
                            block15: {
                                if (!(piece instanceof Obscurable)) break block15;
                                if (((Obscurable)piece).obscuredToMe()) {
                                    return;
                                }
                                break block14;
                            }
                            if (!(piece instanceof Hideable)) break block16;
                            if (((Hideable)piece).invisibleToMe()) {
                                return;
                            }
                            break block14;
                        }
                        if (!(piece instanceof ActionButton)) break block14;
                        action = (ActionButton)piece;
                        if (action.stroke == null || action.stroke.getKeyStroke() == null) break block14;
                        if (action.useWholeShape) break block17;
                        double cumulative = 0.0;
                        for (Decorator rotateTrait = action.getOuter(); rotateTrait != null; rotateTrait = rotateTrait.getOuter()) {
                            if (rotateTrait instanceof FreeRotator) {
                                cumulative += ((FreeRotator)rotateTrait).getAngleInRadians();
                                continue;
                            }
                            if (!(rotateTrait instanceof MatCargo)) continue;
                            cumulative += ((MatCargo)rotateTrait).getMatAngleInRadians();
                        }
                        Shape shape = cumulative != 0.0 ? AffineTransform.getRotateInstance(cumulative, 0.0, 0.0).createTransformedShape(action.polygon) : action.polygon;
                        if (!shape.contains(point)) break block14;
                    }
                    p.setProperty("snapshot", ((PropertyExporter)((Object)p)).getProperties());
                    try {
                        RecursionLimiter.startExecution(action);
                        Command command = p.keyEvent(action.stroke.getKeyStroke());
                        GameModule.getGameModule().sendAndLog(command);
                    }
                    catch (RecursionLimitException e) {
                        RecursionLimiter.infiniteLoop(e);
                    }
                    finally {
                        RecursionLimiter.endExecution();
                    }
                }
                piece = ((Decorator)piece).getInner();
            }
        }

        protected class MapMouseListener
        extends MouseAdapter {
            private final Map map;
            private GamePiece armedForClick = null;

            public MapMouseListener(Map map) {
                this.map = map;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point point;
                GamePiece p;
                if (!(!SwingUtils.isMainMouseButtonDown(e) || e.isAltDown() || e.isShiftDown() || e.isPopupTrigger() || SwingUtils.isSelectionToggle(e) || (p = this.map.findPiece(point = e.getPoint(), PieceFinder.PIECE_IN_STACK)) == null)) {
                    this.armedForClick = p;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.armedForClick != null) {
                    if (!(!SwingUtils.isMainMouseButtonDown(e) || e.isAltDown() || e.isShiftDown() || e.isPopupTrigger() || SwingUtils.isSelectionToggle(e) || this.armedForClick.getMap() != this.map)) {
                        Point epos = e.getPoint();
                        Point rel = this.map.positionOf(this.armedForClick);
                        epos.translate(-rel.x, -rel.y);
                        Shape s = this.armedForClick.getShape();
                        if (s.contains(epos)) {
                            ButtonPusher.this.doClick(this.armedForClick, epos);
                        }
                    }
                    this.armedForClick = null;
                }
            }
        }

        @Deprecated(since="2020-10-26", forRemoval=true)
        protected class ComponentMouseListener
        extends MouseAdapter {
            private GamePiece target;
            private int xOffset;
            private int yOffset;

            public ComponentMouseListener(GamePiece piece, int x, int y) {
                this.target = piece;
                this.xOffset = x;
                this.yOffset = y;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtils.isMainMouseButtonDown(e)) {
                    Point point = e.getPoint();
                    point.translate(-this.xOffset, -this.yOffset);
                    ButtonPusher.this.doClick(this.target, point);
                    e.getComponent().repaint();
                }
            }
        }
    }

    public static class Ed
    implements PieceEditor {
        private final TraitConfigPanel box = new TraitConfigPanel();
        private final JButton defineButton;
        private final NamedHotKeyConfigurer strokeConfig;
        private final BooleanConfigurer launchConfig;
        private final BooleanConfigurer useShapeConfig;
        private final IntConfigurer xConfig;
        private final IntConfigurer yConfig;
        private final IntConfigurer widthConfig;
        private final IntConfigurer heightConfig;
        protected StringConfigurer descConfig;
        private Polygon polygon;

        public Ed(ActionButton p) {
            this.polygon = p.polygon;
            this.descConfig = new StringConfigurer(p.description);
            this.descConfig.setHintKey("Editor.description_hint");
            this.box.add("Editor.description_label", (Configurer)this.descConfig);
            this.strokeConfig = new NamedHotKeyConfigurer(p.stroke);
            this.box.add("Editor.ActionButton.invoke_key_command", (Configurer)this.strokeConfig);
            this.launchConfig = new BooleanConfigurer(p.launchPopupMenu);
            this.box.add("Editor.ActionButton.launch_popup_menu", (Configurer)this.launchConfig);
            this.useShapeConfig = new BooleanConfigurer(p.useWholeShape);
            this.useShapeConfig.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    defineButton.setVisible((Boolean)evt.getNewValue() == false);
                    Decorator.repack(box);
                    box.repaint();
                }
            });
            this.box.add("Editor.ActionButton.use_whole_shape", (Configurer)this.useShapeConfig);
            this.xConfig = new IntConfigurer(p.bounds.x);
            this.yConfig = new IntConfigurer(p.bounds.y);
            this.widthConfig = new IntConfigurer(p.bounds.width);
            this.heightConfig = new IntConfigurer(p.bounds.height);
            this.defineButton = new JButton(Resources.getString("Editor.ActionButton.define_shape"));
            this.defineButton.addActionListener(e -> {
                VisualEditor ve = new VisualEditor();
                ve.show(p, this.polygon, this);
            });
            this.box.add(this.defineButton);
            this.defineButton.setVisible(!this.useShapeConfig.getValueBoolean());
        }

        public void setPolygon(Polygon polygon) {
            this.polygon = polygon;
        }

        @Override
        public Component getControls() {
            return this.box;
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.strokeConfig.getValueString()).append(this.xConfig.getValueString()).append(this.yConfig.getValueString()).append(this.widthConfig.getValueString()).append(this.heightConfig.getValueString()).append(this.descConfig.getValueString()).append(this.launchConfig.getValueString()).append(this.useShapeConfig.getValueString()).append(1).append(this.polygon.npoints);
            for (int point = 0; point < this.polygon.npoints; ++point) {
                se.append(this.polygon.xpoints[point]).append(this.polygon.ypoints[point]);
            }
            return ActionButton.ID + se.getValue();
        }

        @Override
        public String getState() {
            return "";
        }
    }

    public static class VisualEditor
    implements PolygonConfigurer {
        private PolygonEditor editor;
        Polygon polygon;
        private Decorator outer;
        private JDialog frame;
        private Point offsetView;
        protected AdjustableSpeedScrollPane scroll;
        protected FlowLabel coordsLabel;
        protected JLabel coordLabel;
        protected final JLabel warning = new JLabel(Resources.getString("Editor.ActionButton.empty_polygon"));

        public void show(ActionButton piece, Polygon poly, Ed pieceEditor) {
            this.polygon = poly;
            this.outer = (Decorator)Decorator.getOutermost(piece);
            Rectangle bounds = this.outer.boundingBox();
            if (this.polygon.npoints < 3) {
                this.polygon.reset();
                if (bounds.width > 0 && bounds.height > 0) {
                    this.polygon.addPoint(bounds.x, bounds.y);
                    this.polygon.addPoint(bounds.x + bounds.width, bounds.y);
                    this.polygon.addPoint(bounds.x + bounds.width, bounds.y + bounds.height);
                    this.polygon.addPoint(bounds.x, bounds.y + bounds.height);
                }
            }
            int spaceWidth = (int)Math.max(bounds.getWidth() * 2.0, 500.0);
            int spaceHeight = (int)Math.max(bounds.getHeight() * 2.0, 500.0);
            for (int point = 0; point < this.polygon.npoints; ++point) {
                spaceWidth = Math.max(spaceWidth, Math.abs(this.polygon.xpoints[point] * 2 * 11 / 10));
                spaceHeight = Math.max(spaceHeight, Math.abs(this.polygon.ypoints[point] * 2 * 11 / 10));
            }
            final int width = spaceWidth;
            final int height = spaceHeight;
            Dimension viewSize = new Dimension(width, height);
            this.offsetView = new Point(width / 2, height / 2);
            this.editor = new PolygonEditor(new Polygon(this.polygon.xpoints, this.polygon.ypoints, this.polygon.npoints), this.offsetView){
                private static final long serialVersionUID = 1L;

                @Override
                protected void paintBackground(Graphics g) {
                    super.paintBackground(g);
                    g.setColor(Color.BLACK);
                    g.drawLine(-5 + offsetView.x, offsetView.y, 5 + offsetView.x, offsetView.y);
                    g.drawLine(offsetView.x, -5 + offsetView.y, offsetView.x, 5 + offsetView.y);
                    outer.draw(g, width / 2, height / 2, null, 1.0);
                    warning.setVisible(editor != null && (editor.getPolygon() == null || editor.getPolygon().npoints == 0));
                }
            };
            this.editor.setMyConfigurer(this);
            this.frame = new JDialog(GameModule.getGameModule().getPlayerWindow(), Resources.getString("Editor.ActionButton.define_hotspot"), true);
            this.frame.setFocusTraversalKeysEnabled(false);
            this.frame.setLayout(new BoxLayout(this.frame.getContentPane(), 1));
            JPanel labels = new JPanel();
            labels.setLayout(new GridLayout(3, 2));
            labels.add(new JLabel(Resources.getString("Editor.Zone.drag_to_create_initial_shape")));
            labels.add(new JLabel(Resources.getString("Editor.Zone.right_click_to_add_point")));
            labels.add(new JLabel(Resources.getString("Editor.Zone.left_drag_to_move_points")));
            labels.add(new JLabel(Resources.getString("Editor.Zone.del_to_remove_points")));
            labels.setAlignmentX(0.0f);
            this.frame.add(labels);
            this.warning.setForeground(Color.red);
            this.warning.setVisible(false);
            this.frame.add(this.warning);
            JButton direct = new JButton(Resources.getString("Editor.ActionButton.set_coordinates_directly"));
            direct.setFocusable(false);
            direct.addActionListener(e -> {
                String newShape = JOptionPane.showInputDialog(this.frame, Resources.getString("Editor.ActionButton.enter_points_instructions"), PolygonEditor.polygonToString(this.editor.getPolygon()).replace(';', ' '));
                if (newShape != null) {
                    StringBuilder buffer = new StringBuilder();
                    StringTokenizer st = new StringTokenizer(newShape);
                    while (st.hasMoreTokens()) {
                        buffer.append(st.nextToken());
                        if (!st.hasMoreTokens()) continue;
                        buffer.append(';');
                    }
                    newShape = buffer.toString();
                    Polygon newPoly = new Polygon();
                    PolygonEditor.reset(newPoly, newShape);
                    this.editor.setPolygon(newPoly);
                    this.editor.repaint();
                }
            });
            direct.setAlignmentX(0.0f);
            this.frame.add(direct);
            this.scroll = new AdjustableSpeedScrollPane(this.editor, 22, 32);
            this.editor.setScroll(this.scroll);
            this.frame.add(this.scroll);
            Box coordPanel = Box.createVerticalBox();
            this.coordsLabel = new FlowLabel("");
            this.coordLabel = new JLabel("");
            coordPanel.add((Component)this.coordLabel, "Center");
            coordPanel.add((Component)this.coordsLabel, "Center");
            this.frame.add(coordPanel);
            JPanel buttonPanel = new JPanel();
            JButton closeButton = new JButton(Resources.getString("General.ok"));
            closeButton.setFocusable(false);
            closeButton.addActionListener(e -> {
                this.polygon = this.editor.getPolygon();
                pieceEditor.setPolygon(this.polygon == null ? new Polygon() : this.polygon);
                this.frame.setVisible(false);
            });
            JButton canButton = new JButton(Resources.getString("General.cancel"));
            canButton.setFocusable(false);
            canButton.addActionListener(e -> this.frame.setVisible(false));
            buttonPanel.add(closeButton);
            buttonPanel.add(canButton);
            this.frame.add(buttonPanel);
            this.editor.setPreferredSize(viewSize);
            this.editor.reset();
            this.editor.setPolygon(this.polygon.npoints == 0 ? null : new Polygon(this.polygon.xpoints, this.polygon.ypoints, this.polygon.npoints));
            if (this.editor.getPolygon() != null) {
                Rectangle currentBounds = this.editor.getPolygon().getBounds();
                Point polyCenter = new Point(currentBounds.x + currentBounds.width / 2 - this.offsetView.x, currentBounds.y + currentBounds.height / 2 - this.offsetView.y);
                this.editor.center(polyCenter);
            }
            this.updateCoords();
            this.updateCoord("");
            this.frame.pack();
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            this.frame.setSize(Math.min(this.frame.getWidth(), d.width * 2 / 3), Math.min(this.frame.getHeight(), d.height * 2 / 3));
            this.frame.setTitle(Resources.getString("Editor.ActionButton.define_hotspot"));
            this.frame.setVisible(true);
        }

        @Override
        public void updateCoords(Polygon polygon) {
            StringBuilder s = new StringBuilder("");
            if (polygon != null) {
                for (int p = 0; p < polygon.npoints; ++p) {
                    s.append('(');
                    s.append(polygon.xpoints[p] - this.offsetView.x);
                    s.append(',');
                    s.append(polygon.ypoints[p] - this.offsetView.y);
                    s.append(") ");
                }
                this.coordsLabel.setText(s.toString());
            } else {
                this.coordsLabel.setText("");
            }
            this.coordsLabel.repaint();
        }

        @Override
        public void updateCoords() {
            this.updateCoords(this.editor.getRawPolygon());
        }

        @Override
        public void updateCoord(String s) {
            this.coordLabel.setText(s);
            this.coordLabel.repaint();
        }

        @Override
        public void updateCoord(int x, int y) {
            this.updateCoord(x - this.offsetView.x + "," + (y - this.offsetView.y));
        }
    }
}

