/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.EnumeratedPropertyPrompt;
import VASSAL.build.module.properties.IncrementProperty;
import VASSAL.build.module.properties.PropertyChanger;
import VASSAL.build.module.properties.PropertyChangerConfigurer;
import VASSAL.build.module.properties.PropertyPrompt;
import VASSAL.build.module.properties.PropertySetter;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.DynamicKeyCommandListConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Deck;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.Stack;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.script.expression.Auditable;
import VASSAL.script.expression.Expression;
import VASSAL.tools.FormattedString;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;

public class DynamicProperty
extends Decorator
implements TranslatablePiece,
PropertyPrompt.DialogParent,
PropertyChangerConfigurer.Constraints {
    public static final String ID = "PROP;";
    protected String value = "";
    protected String key;
    protected boolean numeric;
    protected int minValue;
    protected int maxValue;
    protected boolean wrap;
    protected FormattedString format = new FormattedString();
    protected DynamicKeyCommand[] keyCommands;
    protected KeyCommand[] menuCommands;
    protected DynamicKeyCommandListConfigurer keyCommandListConfig;
    protected String description = "";

    public DynamicProperty() {
        this(ID, null);
    }

    public DynamicProperty(String type, GamePiece p) {
        this.setInner(p);
        this.keyCommandListConfig = new DynamicKeyCommandListConfigurer(null, Resources.getString("Editor.DynamicProperty.commands"), this);
        this.mySetType(type);
    }

    @Override
    public void mySetType(String s) {
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s, ';');
        sd.nextToken();
        this.key = sd.nextToken("name");
        this.decodeConstraints(sd.nextToken(""));
        this.keyCommandListConfig.setValue(sd.nextToken(""));
        this.keyCommands = this.keyCommandListConfig.getListValue().toArray(new DynamicKeyCommand[0]);
        this.description = sd.nextToken("");
        this.menuCommands = (KeyCommand[])Arrays.stream(this.keyCommands).filter(kc -> !StringUtils.isEmpty((CharSequence)kc.getName())).toArray(KeyCommand[]::new);
    }

    protected void decodeConstraints(String s) {
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s, ',');
        this.numeric = sd.nextBoolean(false);
        this.minValue = sd.nextInt(0);
        this.maxValue = sd.nextInt(100);
        this.wrap = sd.nextBoolean(false);
    }

    protected String encodeConstraints() {
        return new SequenceEncoder(',').append(this.numeric).append(this.minValue).append(this.maxValue).append(this.wrap).getValue();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public Object getProperty(Object key) {
        if (key.equals(this.getKey())) {
            return this.getValue();
        }
        return super.getProperty(key);
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        if (key.equals(this.getKey())) {
            return this.getValue();
        }
        return super.getLocalizedProperty(key);
    }

    @Override
    public void setProperty(Object key, Object value) {
        if (key.equals(this.getKey())) {
            this.setValue(null == value ? null : value.toString());
        } else {
            super.setProperty(key, value);
        }
    }

    @Override
    public String myGetState() {
        return this.getValue();
    }

    @Override
    public Component getComponent() {
        return this.getMap() != null ? this.getMap().getView().getTopLevelAncestor() : GameModule.getGameModule().getPlayerWindow();
    }

    @Override
    public void mySetState(String state) {
        this.setValue(state);
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        Stack parent = this.getParent();
        Map map = this.getMap();
        value = this.formatValue(value);
        if (map != null && !(this.getParent() instanceof Deck)) {
            GamePiece outer = Decorator.getOutermost(this);
            if (parent == null) {
                Point pos = this.getPosition();
                map.removePiece(outer);
                this.value = value;
                map.placeOrMerge(outer, pos);
            } else {
                GamePiece other = parent.getPieceBeneath(outer);
                if (other == null) {
                    other = parent.getPieceAbove(outer);
                }
                if (other == null) {
                    Point pos = parent.getPosition();
                    map.removePiece(parent);
                    this.value = value;
                    map.placeOrMerge(parent, pos);
                } else {
                    this.value = value;
                    if (!map.getPieceCollection().canMerge(other, outer)) {
                        map.placeOrMerge(outer, parent.getPosition());
                    }
                }
            }
        } else {
            this.value = value;
        }
    }

    private String formatValue(String value) {
        this.format.setFormat(value);
        return this.format.getText((PropertySource)Decorator.getOutermost(this), (Auditable)this, "Editor.value");
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.key);
        se.append(this.encodeConstraints());
        se.append(this.keyCommandListConfig.getValueString());
        se.append(this.description);
        return ID + se.getValue();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        return this.menuCommands;
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        ChangeTracker tracker = new ChangeTracker(this);
        for (DynamicKeyCommand dkc : this.keyCommands) {
            if (!dkc.matches(stroke)) continue;
            this.setValue(dkc.propChanger.getNewValue(this.value));
        }
        return tracker.getChangeCommand();
    }

    @Override
    public String getDescription() {
        return this.buildDescription("Editor.DynamicProperty.trait_description", this.getKey(), this.description);
    }

    @Override
    public String getBaseDescription() {
        return Resources.getString("Editor.DynamicProperty.trait_description");
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return Arrays.stream(this.keyCommands).map(KeyCommand::getNamedKeyStroke).collect(Collectors.toList());
    }

    @Override
    public List<String> getExpressionList() {
        ArrayList<String> l = new ArrayList<String>();
        if (!this.value.isEmpty()) {
            l.add(Resources.getString("Editor.DynamicProperty.init_value", this.value));
        }
        if (this.numeric) {
            l.add(Resources.getString("Editor.DynamicProperty.min_value", this.minValue));
            l.add(Resources.getString("Editor.DynamicProperty.max_value", this.maxValue));
        }
        for (DynamicKeyCommand dkc : this.keyCommands) {
            Expression[] ve;
            PropertyChanger propChanger = dkc.getPropChanger();
            if (propChanger == null) continue;
            if (propChanger instanceof IncrementProperty) {
                l.add(((IncrementProperty)propChanger).getIncrement());
                continue;
            }
            if (propChanger instanceof PropertySetter) {
                l.add(((PropertySetter)propChanger).getRawValue());
                continue;
            }
            if (!(propChanger instanceof PropertyPrompt)) continue;
            PropertyPrompt pp = (PropertyPrompt)propChanger;
            l.add(pp.getPrompt());
            if (!(pp instanceof EnumeratedPropertyPrompt)) continue;
            for (Expression e : ve = ((EnumeratedPropertyPrompt)pp).getValueExpressions()) {
                if (e == null) continue;
                l.add(e.getExpression());
            }
        }
        return l;
    }

    @Override
    public List<String> getMenuTextList() {
        ArrayList<String> l = new ArrayList<String>();
        for (DynamicKeyCommand dkc : this.keyCommands) {
            if (StringUtils.isEmpty((CharSequence)dkc.getName())) continue;
            l.add(dkc.getName());
        }
        return l;
    }

    @Override
    public List<String> getPropertyList() {
        return Collections.singletonList(this.key);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("DynamicProperty.html");
    }

    @Override
    public int getMaximumValue() {
        return this.maxValue;
    }

    @Override
    public int getMinimumValue() {
        return this.minValue;
    }

    @Override
    public boolean isNumeric() {
        return this.numeric;
    }

    @Override
    public boolean isWrap() {
        return this.wrap;
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.key);
        return l;
    }

    @Override
    public PropertySource getPropertySource() {
        return Decorator.getOutermost(this);
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public PieceI18nData getI18nData() {
        String[] commandNames = new String[this.menuCommands.length];
        String[] commandDescs = new String[this.menuCommands.length];
        for (int i = 0; i < this.menuCommands.length; ++i) {
            commandNames[i] = this.menuCommands[i].getName();
            commandDescs[i] = Resources.getString("Editor.DynamicProperty.command_description", this.key, i);
        }
        return this.getI18nData(commandNames, commandDescs);
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof DynamicProperty)) {
            return false;
        }
        DynamicProperty c = (DynamicProperty)o;
        if (!Objects.equals(this.encodeConstraints(), c.encodeConstraints())) {
            return false;
        }
        if (!Objects.equals(this.keyCommandListConfig.getValueString(), this.keyCommandListConfig.getValueString())) {
            return false;
        }
        if (!Objects.equals(this.key, c.key)) {
            return false;
        }
        return Objects.equals(this.value, c.value);
    }

    public static class DynamicKeyCommand
    extends KeyCommand {
        private static final long serialVersionUID = 1L;
        protected PropertyChanger propChanger;

        public DynamicKeyCommand(String name, NamedKeyStroke key, GamePiece target, TranslatablePiece i18nPiece, PropertyChanger propChanger) {
            super(name, key, target, i18nPiece);
            this.propChanger = propChanger;
        }

        public PropertyChanger getPropChanger() {
            return this.propChanger;
        }

        public void setPropChanger(PropertyChanger propChanger) {
            this.propChanger = propChanger;
        }
    }

    protected static class Ed
    implements PieceEditor {
        protected StringConfigurer nameConfig;
        protected StringConfigurer initialValueConfig;
        protected BooleanConfigurer numericConfig;
        protected IntConfigurer minConfig;
        protected IntConfigurer maxConfig;
        protected BooleanConfigurer wrapConfig;
        protected JLabel minLabel;
        protected JLabel maxLabel;
        protected JLabel wrapLabel;
        protected DynamicKeyCommandListConfigurer keyCommandListConfig;
        protected TraitConfigPanel controls;
        private final StringConfigurer descConfig;

        public Ed(DynamicProperty m) {
            this.keyCommandListConfig = new DynamicKeyCommandListConfigurer(null, Resources.getString("Editor.DynamicProperty.key_commands"), m);
            this.keyCommandListConfig.setValue(new ArrayList<DynamicKeyCommand>(Arrays.asList(m.keyCommands)));
            PropertyChangeListener l = evt -> {
                boolean isNumeric = this.numericConfig.booleanValue();
                this.minConfig.getControls().setVisible(isNumeric);
                this.minLabel.setVisible(isNumeric);
                this.maxConfig.getControls().setVisible(isNumeric);
                this.maxLabel.setVisible(isNumeric);
                this.wrapConfig.getControls().setVisible(isNumeric);
                this.wrapLabel.setVisible(isNumeric);
                Decorator.repack(this.keyCommandListConfig);
            };
            this.controls = new TraitConfigPanel();
            this.descConfig = new StringConfigurer(m.description);
            this.descConfig.setHintKey("Editor.description_hint");
            this.controls.add("Editor.description_label", (Configurer)this.descConfig);
            this.nameConfig = new StringConfigurer(m.getKey());
            this.nameConfig.setHint(Resources.getString("Editor.DynamicProperty.property_name_hint"));
            this.controls.add("Editor.DynamicProperty.property_name", (Configurer)this.nameConfig);
            this.initialValueConfig = new StringConfigurer(m.getValue());
            this.initialValueConfig.setHint(Resources.getString("Editor.DynamicProperty.initial_value_hint"));
            this.controls.add("Editor.DynamicProperty.initial_value", (Configurer)this.initialValueConfig);
            this.numericConfig = new BooleanConfigurer(m.isNumeric());
            this.controls.add("Editor.DynamicProperty.is_numeric", (Configurer)this.numericConfig);
            this.minLabel = new JLabel(Resources.getString("Editor.DynamicProperty.minimum_value"));
            this.minConfig = new IntConfigurer(m.getMinimumValue());
            this.controls.add(this.minLabel, (Configurer)this.minConfig);
            this.maxLabel = new JLabel(Resources.getString("Editor.DynamicProperty.maximum_value"));
            this.maxConfig = new IntConfigurer(m.getMaximumValue());
            this.controls.add(this.maxLabel, (Configurer)this.maxConfig);
            this.wrapLabel = new JLabel(Resources.getString("Editor.DynamicProperty.wrap"));
            this.wrapConfig = new BooleanConfigurer(m.isWrap());
            this.controls.add(this.wrapLabel, (Configurer)this.wrapConfig, "wrap");
            this.controls.add("Editor.DynamicProperty.key_commands", (Configurer)this.keyCommandListConfig);
            this.numericConfig.addPropertyChangeListener(l);
            this.numericConfig.fireUpdate();
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        protected String encodeConstraints() {
            return new SequenceEncoder(',').append(this.numericConfig.getValueString()).append(this.minConfig.getValueString()).append(this.maxConfig.getValueString()).append(this.wrapConfig.getValueString()).getValue();
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.nameConfig.getValueString());
            se.append(this.encodeConstraints());
            se.append(this.keyCommandListConfig.getValueString());
            se.append(this.descConfig.getValueString());
            return DynamicProperty.ID + se.getValue();
        }

        @Override
        public String getState() {
            return this.initialValueConfig.getValueString();
        }
    }

    @Deprecated(since="2020-12-06", forRemoval=true)
    protected static class DynamicKeyCommandConfigurer
    extends Configurer {
        protected final NamedHotKeyConfigurer keyConfig;
        protected PropertyChangerConfigurer propChangeConfig;
        protected StringConfigurer commandConfig = new StringConfigurer(Resources.getString("Editor.DynamicProperty.change_value"));
        protected JPanel controls;
        protected DynamicProperty target;

        public DynamicKeyCommandConfigurer(DynamicProperty target) {
            super(target.getKey(), target.getKey(), new DynamicKeyCommand(Resources.getString("Editor.DynamicProperty.change_value"), NamedKeyStroke.of('V', 128), Decorator.getOutermost(target), (TranslatablePiece)target, new PropertyPrompt(target, Resources.getString("Editor.DynamicProperty.change_value_of", target.getKey()))));
            this.keyConfig = new NamedHotKeyConfigurer(NamedKeyStroke.of('V', 128));
            this.propChangeConfig = new PropertyChangerConfigurer(null, target.getKey(), target);
            this.propChangeConfig.setValue(new PropertyPrompt(target, Resources.getString("Editor.DynamicProperty.change_value_of", target.getKey())));
            this.commandConfig.addPropertyChangeListener(e -> this.updateValue());
            this.keyConfig.addPropertyChangeListener(e -> this.updateValue());
            this.propChangeConfig.addPropertyChangeListener(e -> {
                this.updateValue();
                this.repack(this.commandConfig.getControls());
            });
            this.target = target;
        }

        @Override
        public String getValueString() {
            SequenceEncoder se = new SequenceEncoder(':');
            se.append(this.commandConfig.getValueString()).append(this.keyConfig.getValueString()).append(this.propChangeConfig.getValueString());
            return se.getValue();
        }

        @Override
        public void setFrozen(boolean val) {
            super.setFrozen(val);
            this.commandConfig.setFrozen(val);
            this.keyConfig.setFrozen(val);
            this.propChangeConfig.setFrozen(val);
        }

        @Override
        public void setValue(Object value) {
            if (!this.noUpdate && value instanceof DynamicKeyCommand && this.commandConfig != null) {
                DynamicKeyCommand dkc = (DynamicKeyCommand)value;
                this.commandConfig.setValue(dkc.getName());
                this.keyConfig.setValue(dkc.getNamedKeyStroke());
                this.propChangeConfig.setValue(dkc.propChanger);
            }
            super.setValue(value);
        }

        public DynamicKeyCommand getKeyCommand() {
            return (DynamicKeyCommand)this.getValue();
        }

        @Override
        public void setValue(String s) {
            SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s == null ? "" : s, ':');
            this.commandConfig.setValue(sd.nextToken(""));
            this.keyConfig.setValue(sd.nextNamedKeyStroke(null));
            this.propChangeConfig.setValue(sd.nextToken(""));
            this.updateValue();
        }

        @Override
        public Component getControls() {
            if (this.controls == null) {
                this.buildControls();
            }
            return this.controls;
        }

        protected void updateValue() {
            this.noUpdate = true;
            this.setValue(new DynamicKeyCommand(this.commandConfig.getValueString(), this.keyConfig.getValueNamedKeyStroke(), (GamePiece)this.target, (TranslatablePiece)this.target, this.propChangeConfig.getPropertyChanger()));
            this.noUpdate = false;
        }

        protected void buildControls() {
            this.controls = new JPanel((LayoutManager)new MigLayout("ins panel,gapy 4,hidemode 3", "[]rel[][]rel[]"));
            this.controls.setBorder(BorderFactory.createEtchedBorder());
            JLabel label = new JLabel(Resources.getString("Editor.menu_command"));
            label.setLabelFor(this.commandConfig.getControls());
            this.controls.add(label);
            this.controls.add(this.commandConfig.getControls(), "grow");
            label = new JLabel(Resources.getString("Editor.keyboard_command"));
            label.setLabelFor(this.keyConfig.getControls());
            this.controls.add(label);
            this.controls.add(this.keyConfig.getControls(), "grow,wrap");
            this.controls.add(this.propChangeConfig.getTypeLabel());
            this.controls.add(this.propChangeConfig.getTypeControls(), "grow");
            this.controls.add(this.propChangeConfig.getChangerLabel());
            this.controls.add(this.propChangeConfig.getChangerControls(), "growx,aligny center,wrap");
            this.controls.add(this.propChangeConfig.getValuesControls(), "grow,span 4");
        }
    }
}

