/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.widget.PieceSlot;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.counters.BoundsTracker;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceSorter;
import VASSAL.counters.PropertyExporter;
import VASSAL.counters.Stack;
import VASSAL.property.PersistentPropertyContainer;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.KeyStroke;

public class KeyBuffer {
    private static KeyBuffer theBuffer;
    private final List<GamePiece> pieces;
    private final BoundsTracker bounds;
    private final Comparator<GamePiece> pieceSorter = new PieceSorter();
    private final Point clickPoint;
    private final List<PieceSlot> slots;
    private boolean fromPalette = false;

    private KeyBuffer() {
        this.pieces = new ArrayList<GamePiece>();
        this.bounds = new BoundsTracker();
        this.clickPoint = new Point();
        this.slots = new ArrayList<PieceSlot>();
    }

    public static void init(KeyBuffer kb) {
        if (theBuffer == null) {
            theBuffer = kb;
        }
    }

    public static KeyBuffer getBuffer() {
        if (theBuffer == null) {
            theBuffer = new KeyBuffer();
        }
        return theBuffer;
    }

    public PieceSlot getSlotForPiece(GamePiece piece) {
        if (!this.fromPalette) {
            return null;
        }
        int index = this.pieces.indexOf(piece);
        return index >= 0 ? this.slots.get(index) : null;
    }

    public void setClickPoint(Point p) {
        this.clickPoint.setLocation(p);
    }

    public Point getClickPoint() {
        return this.clickPoint;
    }

    public void add(GamePiece p) {
        if (this.fromPalette) {
            this.clear();
        }
        if (p != null && !this.pieces.contains(p)) {
            this.pieces.add(p);
            p.setProperty("Selected", Boolean.TRUE);
        }
    }

    public void addFromPalette(GamePiece p, PieceSlot slot) {
        if (!this.fromPalette) {
            this.clear();
        }
        if (p != null && !this.pieces.contains(p)) {
            this.pieces.add(p);
            p.setProperty("Selected", Boolean.TRUE);
            this.fromPalette = true;
            if (slot != null && !this.slots.contains(slot)) {
                this.slots.add(slot);
            }
        }
    }

    public void cleansePalette() {
        this.fromPalette = false;
        for (PieceSlot slot : this.slots) {
            slot.getComponent().repaint();
        }
        this.slots.clear();
    }

    public void clear() {
        for (GamePiece p : this.pieces) {
            p.setProperty("Selected", null);
        }
        this.pieces.clear();
        this.cleansePalette();
    }

    public void remove(GamePiece p) {
        if (p != null) {
            p.setProperty("Selected", null);
            this.pieces.remove(p);
        }
    }

    public void removeFromPalette(GamePiece p, PieceSlot slot) {
        this.remove(p);
        if (slot != null && this.slots.contains(slot)) {
            slot.getComponent().repaint();
            this.slots.remove(slot);
            if (this.slots.isEmpty()) {
                this.fromPalette = false;
            }
        }
    }

    public boolean contains(GamePiece p) {
        if (p instanceof Stack) {
            return this.pieces.containsAll(((Stack)p).asList());
        }
        return this.pieces.contains(p);
    }

    public boolean isEmpty() {
        return this.pieces.isEmpty();
    }

    public Command keyCommand(KeyStroke stroke) {
        GamePiece top;
        this.sort(this.pieceSorter);
        Command comm = new NullCommand();
        this.bounds.clear();
        ArrayList<GamePiece> targets = new ArrayList<GamePiece>(this.pieces);
        if (!targets.isEmpty() && (top = targets.get(0)).getMap() != null && (stroke.equals(top.getMap().getStackMetrics().getMoveBottomKey()) || stroke.equals(top.getMap().getStackMetrics().getMoveUpKey()))) {
            Collections.reverse(targets);
        }
        for (GamePiece p : targets) {
            this.bounds.addPiece(p);
            p.setProperty("snapshot", ((PropertyExporter)((Object)p)).getProperties());
            if (p instanceof PersistentPropertyContainer) {
                comm = comm.append(((PersistentPropertyContainer)((Object)p)).setPersistentProperty("ClickedX", String.valueOf(this.clickPoint.x))).append(((PersistentPropertyContainer)((Object)p)).setPersistentProperty("ClickedY", String.valueOf(this.clickPoint.y)));
            }
            comm = comm.append(p.keyEvent(stroke));
        }
        this.bounds.repaint();
        return comm;
    }

    public List<GamePiece> asList() {
        return Collections.unmodifiableList(this.pieces);
    }

    public Iterator<GamePiece> getPiecesIterator() {
        return this.pieces.iterator();
    }

    @Deprecated(since="2021-08-06", forRemoval=true)
    public Enumeration<GamePiece> getPieces() {
        return Collections.enumeration(this.pieces);
    }

    public void sort(Comparator<GamePiece> comp) {
        this.pieces.sort(comp);
    }

    public boolean containsChild(Stack stack) {
        return stack.asList().stream().anyMatch(this::contains);
    }
}

