/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.GpIdSupport;
import VASSAL.build.module.KeyNamer;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.widget.PieceSlot;
import VASSAL.configure.IntConfigurer;
import VASSAL.counters.ActionButton;
import VASSAL.counters.AreaOfEffect;
import VASSAL.counters.BasicName;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.CalculatedProperty;
import VASSAL.counters.Clone;
import VASSAL.counters.CounterGlobalKeyCommand;
import VASSAL.counters.Decorator;
import VASSAL.counters.Delete;
import VASSAL.counters.Deselect;
import VASSAL.counters.DynamicProperty;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.Embellishment;
import VASSAL.counters.Footprint;
import VASSAL.counters.FreeRotator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.GlobalHotKey;
import VASSAL.counters.Hideable;
import VASSAL.counters.Immobilized;
import VASSAL.counters.Labeler;
import VASSAL.counters.Marker;
import VASSAL.counters.Mat;
import VASSAL.counters.MatCargo;
import VASSAL.counters.MenuSeparator;
import VASSAL.counters.MovementMarkable;
import VASSAL.counters.NonRectangular;
import VASSAL.counters.Obscurable;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.Pivot;
import VASSAL.counters.PlaceMarker;
import VASSAL.counters.PlaySound;
import VASSAL.counters.PropertySheet;
import VASSAL.counters.Replace;
import VASSAL.counters.ReportState;
import VASSAL.counters.RestrictCommands;
import VASSAL.counters.Restricted;
import VASSAL.counters.ReturnToDeck;
import VASSAL.counters.SendToLocation;
import VASSAL.counters.SetGlobalProperty;
import VASSAL.counters.SubMenu;
import VASSAL.counters.TableInfo;
import VASSAL.counters.TranslatableMessage;
import VASSAL.counters.Translate;
import VASSAL.counters.TriggerAction;
import VASSAL.counters.UsePrototype;
import VASSAL.i18n.Resources;
import VASSAL.preferences.Prefs;
import VASSAL.tools.BrowserSupport;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ReflectionUtils;
import VASSAL.tools.icon.IconFactory;
import VASSAL.tools.image.LabelUtils;
import VASSAL.tools.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSource;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import net.miginfocom.swing.MigLayout;

public class PieceDefiner
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String MAX_SPLIT_PREF = "PieceDefinerMaxSplit";
    private static final String AVAILABLE = "Available";
    private static final String INUSE = "InUse";
    private static final Insets buttonInsets = new Insets(1, 2, 1, 2);
    private static final int PIECE_IMAGE_INSET = 10;
    protected static DefaultListModel<GamePiece> availableModel;
    private static final SortedMap<String, GamePiece> alphaMap;
    private static Boolean sorted;
    protected DefaultListModel<GamePiece> inUseModel;
    protected ListCellRenderer<? super GamePiece> r;
    protected ListCellRenderer<? super GamePiece> availableRenderer;
    protected ScaleablePieceSlot slot;
    private GamePiece piece;
    protected static TraitClipboard clipBoard;
    protected String pieceId = "";
    protected JLabel pieceIdLabel = new JLabel("");
    protected GpIdSupport gpidSupport;
    protected boolean changed;
    protected JList<GamePiece> availableList;
    private JButton helpButton;
    private JButton addButton;
    private JButton removeButton;
    private JList<GamePiece> inUseList;
    private JButton propsButton;
    private JButton moveUpButton;
    private JButton moveDownButton;
    private JButton moveTopButton;
    private JButton moveBottomButton;
    protected JButton copyButton;
    protected JButton pasteButton;
    private JPanel controls;
    private JSplitPane splitPane;
    private JPanel slotPanel;
    private int maxPanelHeight;
    private JLabel scaleLabel;
    private final Prefs prefs = GameModule.getGameModule().getPrefs();
    private static final int MINIMUM_SPLIT_SIZE;
    private static final int DEFAULT_MAX_SPLIT = 256;
    private boolean splitDragInProgress = false;

    public PieceDefiner() {
        IntConfigurer maxSplitConfig = new IntConfigurer(MAX_SPLIT_PREF, null, (Integer)256);
        this.prefs.addOption(MAX_SPLIT_PREF, maxSplitConfig);
        PieceDefiner.initDefinitions();
        this.inUseModel = new DefaultListModel();
        this.r = new Renderer();
        this.availableRenderer = new AvailableRenderer();
        this.slot = new ScaleablePieceSlot();
        this.initComponents();
        this.availableList.setSelectedIndex(0);
        this.setChanged(false);
        this.gpidSupport = GameModule.getGameModule().getGpIdSupport();
    }

    public PieceDefiner(String id, GpIdSupport s) {
        this();
        this.pieceId = id;
        this.pieceIdLabel.setText(Resources.getString("Editor.id") + ": " + id);
        this.gpidSupport = s;
    }

    public PieceDefiner(GpIdSupport s) {
        this();
        this.gpidSupport = s;
    }

    protected int getInUseSelectedIndex() {
        return this.inUseList.getSelectedIndex();
    }

    protected static void addElement(GamePiece piece) {
        availableModel.addElement(piece);
        alphaMap.put(((EditablePiece)piece).getDescription(), piece);
    }

    protected static void initDefinitions() {
        if (availableModel == null) {
            availableModel = new DefaultListModel();
            PieceDefiner.addElement(new BasicName());
            PieceDefiner.addElement(new Delete());
            PieceDefiner.addElement(new Clone());
            PieceDefiner.addElement(new Embellishment());
            PieceDefiner.addElement(new UsePrototype());
            PieceDefiner.addElement(new Labeler());
            PieceDefiner.addElement(new ReportState());
            PieceDefiner.addElement(new TriggerAction());
            PieceDefiner.addElement(new GlobalHotKey());
            PieceDefiner.addElement(new ActionButton());
            PieceDefiner.addElement(new FreeRotator());
            PieceDefiner.addElement(new Pivot());
            PieceDefiner.addElement(new Hideable());
            PieceDefiner.addElement(new Obscurable());
            PieceDefiner.addElement(new SendToLocation());
            PieceDefiner.addElement(new CounterGlobalKeyCommand());
            PieceDefiner.addElement(new Translate());
            PieceDefiner.addElement(new ReturnToDeck());
            PieceDefiner.addElement(new Immobilized());
            PieceDefiner.addElement(new PropertySheet());
            PieceDefiner.addElement(new TableInfo());
            PieceDefiner.addElement(new PlaceMarker());
            PieceDefiner.addElement(new Replace());
            PieceDefiner.addElement(new NonRectangular());
            PieceDefiner.addElement(new PlaySound());
            PieceDefiner.addElement(new MovementMarkable());
            PieceDefiner.addElement(new Footprint());
            PieceDefiner.addElement(new AreaOfEffect());
            PieceDefiner.addElement(new SubMenu());
            PieceDefiner.addElement(new MenuSeparator());
            PieceDefiner.addElement(new RestrictCommands());
            PieceDefiner.addElement(new Restricted());
            PieceDefiner.addElement(new Marker());
            PieceDefiner.addElement(new DynamicProperty());
            PieceDefiner.addElement(new CalculatedProperty());
            PieceDefiner.addElement(new SetGlobalProperty());
            PieceDefiner.addElement(new Deselect());
            PieceDefiner.addElement(new TranslatableMessage());
            PieceDefiner.addElement(new Mat(""));
            PieceDefiner.addElement(new MatCargo());
            PieceDefiner.buildAlphaModel();
        }
    }

    private static void buildAlphaModel() {
        DefaultListModel alphaModel = new DefaultListModel();
        alphaMap.values().forEach(alphaModel::addElement);
        availableModel = alphaModel;
    }

    private static void addAdditionalElement(GamePiece piece) {
        PieceDefiner.initDefinitions();
        PieceDefiner.addElement(piece);
        PieceDefiner.buildAlphaModel();
    }

    public static void addDefinition(GamePiece definition) {
        PieceDefiner.addAdditionalElement(definition);
    }

    public static Boolean getSorted() {
        return sorted;
    }

    public static void setSorted(Boolean sorted) {
        PieceDefiner.sorted = sorted;
    }

    public void setPiece(GamePiece piece) {
        this.inUseModel.clear();
        while (piece instanceof Decorator) {
            Class<?> pieceClass = piece.getClass();
            this.inUseModel.insertElementAt(piece, 0);
            boolean contains = false;
            int j = availableModel.size();
            for (int i = 0; i < j; ++i) {
                if (!pieceClass.isInstance(availableModel.elementAt(i))) continue;
                contains = true;
                break;
            }
            if (!contains) {
                try {
                    PieceDefiner.addAdditionalElement((GamePiece)pieceClass.getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Throwable t) {
                    ReflectionUtils.handleNewInstanceFailure(t, pieceClass);
                }
            }
            piece = ((Decorator)piece).piece;
        }
        this.inUseModel.insertElementAt(piece == null ? new BasicPiece() : piece, 0);
        this.inUseList.setSelectedIndex(0);
        this.refresh();
    }

    protected void refresh() {
        this.piece = this.inUseModel.getSize() > 0 ? this.inUseModel.lastElement() : null;
        this.slot.setPiece(this.piece);
        this.resizeSlotPanel();
        this.controls.revalidate();
        this.slotPanel.revalidate();
        this.slot.getComponent().repaint();
    }

    private void resizeSlotPanel() {
        Dimension newSlotSize;
        if (this.slot.isValid()) {
            double oldScale = this.slot.getScale();
            this.slot.setScale(1.0);
            newSlotSize = this.slot.getPreferredSize();
            this.slot.setScale(oldScale);
        } else {
            this.slot.getComponent().revalidate();
            this.slot.getComponent().repaint();
            Rectangle r = this.slot.getPiece().boundingBox();
            newSlotSize = new Dimension(r.width, r.height);
        }
        int maxSlotWidth = this.getMaxSplit() - 20;
        int maxSlotHeight = this.maxPanelHeight - 20;
        if (newSlotSize.width <= maxSlotWidth && newSlotSize.height <= maxSlotHeight) {
            this.slotPanel.setMaximumSize(new Dimension(newSlotSize.width + 20, this.maxPanelHeight));
            Dimension updatedSlotSize = new Dimension(newSlotSize.width + 20, newSlotSize.height);
            this.slotPanel.setPreferredSize(updatedSlotSize);
            this.slot.setScale(1.0);
            this.scaleLabel.setText("");
        } else {
            double xRatio = (double)maxSlotWidth / newSlotSize.getWidth();
            double yRatio = (double)maxSlotHeight / newSlotSize.getHeight();
            double newScale = Math.min(xRatio, yRatio);
            this.slot.setScale(newScale);
            this.scaleLabel.setText("(" + (int)(newScale * 100.0) + "%)");
            this.slot.getComponent().revalidate();
            this.slot.getComponent().repaint();
            Dimension scaledSlotSize = new Dimension((int)((double)newSlotSize.width * newScale), (int)((double)newSlotSize.height * newScale));
            this.slotPanel.setMaximumSize(new Dimension(Math.min(scaledSlotSize.width + 20, maxSlotWidth), this.maxPanelHeight));
            Dimension updatedSlotSize = new Dimension(scaledSlotSize.width + 20, scaledSlotSize.height);
            this.slotPanel.setPreferredSize(updatedSlotSize);
        }
        this.slotPanel.revalidate();
        this.splitPane.resetToPreferredSizes();
        this.slot.getComponent().repaint();
    }

    public GamePiece getPiece() {
        return this.piece;
    }

    public void setChanged(boolean b) {
        this.changed = b;
    }

    public boolean isChanged() {
        return this.changed;
    }

    private void initComponents() {
        this.maxPanelHeight = SwingUtils.getScreenSize().height - 150;
        this.setLayout((LayoutManager)new MigLayout("ins 0, fill"));
        this.controls = new JPanel((LayoutManager)new MigLayout("ins 0, fill", "[grow 1,:200:]rel[]rel[grow 4,:400:]rel[]", "[grow][][]"));
        this.slotPanel = new JPanel((LayoutManager)new MigLayout("ins 0", "push[]push", "push[]2[]push"));
        this.slotPanel.setMinimumSize(new Dimension(MINIMUM_SPLIT_SIZE, MINIMUM_SPLIT_SIZE));
        this.slotPanel.add(this.slot.getComponent(), "grow,wrap");
        this.scaleLabel = new JLabel();
        this.slotPanel.add((Component)this.scaleLabel, "center,aligny top");
        this.splitPane = new JSplitPane(1, true, this.slotPanel, this.controls);
        this.splitPane.addPropertyChangeListener("dividerLocation", e -> this.splitChanged());
        SplitPaneUI spui = this.splitPane.getUI();
        if (spui instanceof BasicSplitPaneUI) {
            ((BasicSplitPaneUI)spui).getDivider().addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    super.mousePressed(e);
                    PieceDefiner.this.setSplitDragInProgress(true);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    super.mouseReleased(e);
                    PieceDefiner.this.setSplitDragInProgress(false);
                }
            });
        }
        this.add((Component)this.splitPane, "grow,pushy");
        ListTransferHandler transferHandler = new ListTransferHandler(this);
        JPanel availablePanel = new JPanel((LayoutManager)new MigLayout("ins 0, fill"));
        this.availableList = new JList();
        this.availableList.setName(AVAILABLE);
        this.availableList.setDragEnabled(true);
        this.availableList.setTransferHandler(transferHandler);
        this.availableList.setModel(availableModel);
        this.availableList.setSelectionMode(0);
        this.availableList.setCellRenderer(this.availableRenderer);
        this.availableList.addKeyListener(new AvailableListKeyAdapter(this));
        this.availableList.setVisibleRowCount(99);
        this.availableList.addListSelectionListener(evt -> {
            GamePiece o = this.availableList.getSelectedValue();
            this.helpButton.setEnabled(o instanceof EditablePiece && ((EditablePiece)o).getHelpFile() != null);
            this.addButton.setEnabled(o instanceof Decorator);
        });
        this.availableList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    PieceDefiner.this.doAdd();
                }
            }
        });
        JPanel availableListPanel = new JPanel((LayoutManager)new MigLayout("ins 0, fill"));
        availableListPanel.add(this.availableList, "grow,push");
        JScrollPane availableScroll = new JScrollPane(availableListPanel);
        availableScroll.setBorder(BorderFactory.createTitledBorder(Resources.getString("Editor.PieceDefiner.available_traits")));
        availablePanel.add((Component)availableScroll, "grow,push");
        JPanel availableButtonPanel = new JPanel((LayoutManager)new MigLayout("ins 0", "push[]rel[]rel[]push"));
        this.helpButton = new JButton(Resources.getString("General.help"));
        this.helpButton.setToolTipText(Resources.getString("Editor.PieceDefiner.help_tip"));
        this.helpButton.addActionListener(evt -> this.showHelpForPiece());
        JButton importButton = new JButton(Resources.getString("General.import"));
        importButton.setToolTipText(Resources.getString("Editor.PieceDefiner.import_tip"));
        importButton.addActionListener(evt -> {
            String className = JOptionPane.showInputDialog(this, (Object)Resources.getString("Editor.PieceDefiner.enter_class"));
            this.importPiece(className);
        });
        availableButtonPanel.add((Component)importButton, "sg 2");
        availableButtonPanel.add((Component)this.helpButton, "sg 2");
        this.controls.add((Component)availablePanel, "grow,pushy");
        JPanel addRemovePanel = new JPanel();
        addRemovePanel.setLayout((LayoutManager)new MigLayout("ins 0,wrap 1"));
        this.addButton = new JButton(Resources.getString("Editor.PieceDefiner.add"), IconFactory.getIcon("go-next", 1));
        this.addButton.setHorizontalTextPosition(2);
        this.addButton.setMargin(buttonInsets);
        this.addButton.setToolTipText(Resources.getString("Editor.PieceDefiner.add_tip"));
        this.addButton.addActionListener(evt -> this.doAdd());
        addRemovePanel.add((Component)this.addButton, "sg");
        this.removeButton = new JButton(Resources.getString("Editor.PieceDefiner.remove"), IconFactory.getIcon("go-previous", 1));
        this.removeButton.setMargin(buttonInsets);
        this.removeButton.setToolTipText(Resources.getString("Editor.PieceDefiner.remove_tip"));
        this.removeButton.addActionListener(evt -> this.doRemove());
        addRemovePanel.add((Component)this.removeButton, "sg");
        addRemovePanel.add((Component)this.pieceIdLabel, "center");
        this.controls.add((Component)addRemovePanel, "aligny center");
        JPanel inUsePanel = new JPanel((LayoutManager)new MigLayout("ins 0,wrap 1,fill"));
        this.inUseList = new JList();
        this.inUseList.setName(INUSE);
        this.inUseList.addKeyListener(new InUseListKeyAdapter(this));
        this.inUseList.setDragEnabled(true);
        this.inUseList.setDropMode(DropMode.INSERT);
        this.inUseList.setTransferHandler(transferHandler);
        this.inUseList.setVisibleRowCount(99);
        this.inUseList.setModel(this.inUseModel);
        this.inUseList.setSelectionMode(0);
        this.inUseList.setCellRenderer(this.r);
        this.inUseList.addListSelectionListener(evt -> {
            GamePiece o = this.inUseList.getSelectedValue();
            this.propsButton.setEnabled(o instanceof EditablePiece);
            int index = this.inUseList.getSelectedIndex();
            boolean copyAndRemove = this.inUseModel.size() > 0 && (index > 0 || !(this.inUseModel.getElementAt(0) instanceof BasicPiece));
            this.copyButton.setEnabled(copyAndRemove);
            this.removeButton.setEnabled(copyAndRemove);
            this.moveUpButton.setEnabled(index > 1);
            this.moveTopButton.setEnabled(index > 1);
            this.moveDownButton.setEnabled(index > 0 && index < this.inUseModel.size() - 1);
            this.moveBottomButton.setEnabled(index > 0 && index < this.inUseModel.size() - 1);
        });
        this.inUseList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int index;
                if (e.getClickCount() == 2 && SwingUtils.isMainMouseButtonDown(e) && (index = PieceDefiner.this.inUseList.locationToIndex(e.getPoint())) >= 0) {
                    PieceDefiner.this.edit(index);
                }
            }
        });
        JPanel inUseListPanel = new JPanel(new BorderLayout());
        inUseListPanel.add(this.inUseList, "Center");
        JScrollPane inUseScroll = new JScrollPane(inUseListPanel);
        inUseScroll.setBorder(BorderFactory.createTitledBorder(Resources.getString("Editor.PieceDefiner.current_traits")));
        inUsePanel.add((Component)inUseScroll, "grow");
        JPanel inUseButtonPanel = new JPanel((LayoutManager)new MigLayout("ins 0", "push[]rel[]rel[]push"));
        this.copyButton = new JButton(Resources.getString("Editor.copy") + " (" + this.getCtrlKeyName('C') + ")");
        this.copyButton.addActionListener(evt -> this.doCopy());
        inUseButtonPanel.add((Component)this.copyButton, "sg 1");
        this.pasteButton = new JButton(Resources.getString("Editor.paste") + " (" + this.getCtrlKeyName('V') + ")");
        this.pasteButton.addActionListener(evt -> this.doPaste());
        inUseButtonPanel.add((Component)this.pasteButton, "sg 1");
        this.propsButton = new JButton(Resources.getString("Editor.properties"));
        this.propsButton.addActionListener(evt -> {
            int index = this.inUseList.getSelectedIndex();
            if (index >= 0) {
                this.edit(index);
            }
        });
        inUseButtonPanel.add((Component)this.propsButton, "sg 1");
        this.controls.add((Component)inUsePanel, "grow");
        JPanel moveUpDownPanel = new JPanel((LayoutManager)new MigLayout("ins 0,wrap 1"));
        this.moveTopButton = new JButton(Resources.getString("Editor.PieceDefiner.move_top"), IconFactory.getIcon("go-top", 1));
        this.moveTopButton.setToolTipText(Resources.getString("Editor.PieceDefiner.top_tip"));
        this.moveTopButton.setHorizontalAlignment(2);
        this.moveTopButton.setMargin(buttonInsets);
        this.moveTopButton.addActionListener(evt -> {
            int index = this.inUseList.getSelectedIndex();
            if (index > 1 && index < this.inUseModel.size()) {
                this.moveDecoratorTop(index);
            }
        });
        moveUpDownPanel.add((Component)this.moveTopButton, "sg");
        this.moveUpButton = new JButton(Resources.getString("Editor.PieceDefiner.move_up"), IconFactory.getIcon("go-up", 1));
        this.moveUpButton.setToolTipText(Resources.getString("Editor.PieceDefiner.up_tip"));
        this.moveUpButton.setHorizontalAlignment(2);
        this.moveUpButton.setMargin(buttonInsets);
        this.moveUpButton.addActionListener(evt -> {
            int index = this.inUseList.getSelectedIndex();
            if (index > 1 && index < this.inUseModel.size()) {
                this.moveDecoratorUp(index);
            }
        });
        moveUpDownPanel.add((Component)this.moveUpButton, "sg");
        this.moveDownButton = new JButton(Resources.getString("Editor.PieceDefiner.move_down"), IconFactory.getIcon("go-down", 1));
        this.moveDownButton.setToolTipText(Resources.getString("Editor.PieceDefiner.down_tip"));
        this.moveDownButton.setHorizontalAlignment(2);
        this.moveDownButton.setMargin(buttonInsets);
        this.moveDownButton.addActionListener(evt -> {
            int index = this.inUseList.getSelectedIndex();
            if (index > 0 && index < this.inUseModel.size() - 1) {
                this.moveDecoratorDown(index);
            }
        });
        moveUpDownPanel.add((Component)this.moveDownButton, "sg");
        this.moveBottomButton = new JButton(Resources.getString("Editor.PieceDefiner.move_bottom"), IconFactory.getIcon("go-bottom", 1));
        this.moveBottomButton.setToolTipText(Resources.getString("Editor.PieceDefiner.bottom_trait"));
        this.moveBottomButton.setHorizontalAlignment(2);
        this.moveBottomButton.setMargin(buttonInsets);
        this.moveBottomButton.addActionListener(evt -> {
            int index = this.inUseList.getSelectedIndex();
            if (index > 0 && index < this.inUseModel.size() - 1) {
                this.moveDecoratorBottom(index);
            }
        });
        moveUpDownPanel.add((Component)this.moveBottomButton, "sg");
        this.controls.add((Component)moveUpDownPanel, "wrap");
        this.controls.add((Component)availableButtonPanel, "center");
        this.controls.add(new JLabel(""));
        this.controls.add((Component)inUseButtonPanel, "center,wrap");
        JLabel noteLabel = new JLabel(Resources.getString("Editor.PieceDefiner.note1"));
        Font standardFont = noteLabel.getFont();
        Font italicFont = new Font(standardFont.getFontName(), 2, standardFont.getSize());
        noteLabel.setFont(italicFont);
        this.controls.add((Component)noteLabel, "span 3,center");
    }

    private void splitChanged() {
        if (!this.isSplitDragInProgress()) {
            return;
        }
        int splitPosition = this.splitPane.getDividerLocation();
        this.setMaxSplit(splitPosition);
        this.resizeSlotPanel();
    }

    private int getMaxSplit() {
        return (Integer)this.prefs.getValue(MAX_SPLIT_PREF);
    }

    private void setMaxSplit(int split) {
        this.prefs.setValue(MAX_SPLIT_PREF, split);
    }

    public boolean isSplitDragInProgress() {
        return this.splitDragInProgress;
    }

    public void setSplitDragInProgress(boolean splitDragInProgress) {
        this.splitDragInProgress = splitDragInProgress;
    }

    private String getCtrlKeyName(char c) {
        return KeyNamer.getKeyString(SwingUtils.genericToSystem(KeyStroke.getKeyStroke((int)c, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx())));
    }

    private void doCopy() {
        int index = this.inUseList.getSelectedIndex();
        if (index >= 0) {
            this.copy(index);
        }
    }

    protected void copy(int index) {
        this.pasteButton.setEnabled(true);
        clipBoard = new TraitClipboard((Decorator)this.inUseModel.get(index));
    }

    private void doPaste() {
        if (clipBoard != null) {
            this.paste();
        }
    }

    private void doRemove() {
        int index = this.inUseList.getSelectedIndex();
        if (index >= 0) {
            this.removeTrait(index);
            if (this.inUseModel.getSize() > 0) {
                this.inUseList.setSelectedIndex(Math.min(this.inUseModel.getSize() - 1, index));
            }
        }
    }

    private void doAdd() {
        int index = this.availableList.getSelectedIndex();
        if (index > 0) {
            this.doAdd(index, this.inUseList.getSelectedIndex() < 0 ? this.inUseList.getModel().getSize() : this.inUseList.getSelectedIndex());
        }
    }

    private void doAdd(int sourceIndex, int insertIndex) {
        GamePiece selected = this.availableList.getModel().getElementAt(sourceIndex);
        if (selected instanceof Decorator) {
            if (this.inUseModel.getSize() > 0) {
                Decorator c = (Decorator)selected;
                this.addTrait(c, insertIndex);
                if (this.inUseModel.getElementAt(insertIndex + 1).getClass() == c.getClass()) {
                    int previousSelect = this.inUseList.getSelectedIndex();
                    if (!this.edit(insertIndex + 1) && !this.inUseModel.isEmpty()) {
                        this.removeTrait(insertIndex + 1);
                        this.inUseList.setSelectedIndex(Math.min(previousSelect, this.inUseModel.getSize()) - 1);
                    }
                }
            }
        } else if (selected != null && this.inUseModel.getSize() == 0) {
            GamePiece p = null;
            try {
                p = (GamePiece)selected.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t) {
                ReflectionUtils.handleNewInstanceFailure(t, selected.getClass());
            }
            if (p != null) {
                this.setPiece(p);
                if (this.inUseModel.getSize() > 0 && !this.edit(0)) {
                    this.removeTrait(0);
                }
            }
        }
    }

    protected void paste() {
        Decorator c = (Decorator)GameModule.getGameModule().createPiece(clipBoard.getType(), null);
        if (c instanceof PlaceMarker) {
            ((PlaceMarker)c).updateGpId(GameModule.getGameModule().getGpIdSupport());
        }
        int selectedIndex = this.inUseList.getSelectedIndex();
        c.setInner(this.inUseModel.lastElement());
        this.inUseModel.addElement(c);
        c.mySetState(clipBoard.getState());
        this.moveDecorator(this.inUseModel.size() - 1, selectedIndex + 1);
        this.refresh();
    }

    protected void moveDecoratorDown(int index) {
        this.moveDecorator(index, index + 2);
    }

    protected void moveDecoratorUp(int index) {
        this.moveDecorator(index, index - 1);
    }

    protected void moveDecoratorTop(int index) {
        this.moveDecorator(index, 1);
    }

    protected void moveDecoratorBottom(int index) {
        this.moveDecorator(index, this.inUseModel.size());
    }

    protected void moveDecorator(int fromIndex, int toIndex) {
        if (this.inUseModel.size() > 0 && this.inUseModel.getElementAt(0) instanceof BasicPiece && toIndex == 0) {
            return;
        }
        if (toIndex == fromIndex) {
            this.inUseList.setSelectedIndex(toIndex);
            return;
        }
        GamePiece piece = this.removeDecorator(fromIndex);
        int actualToIndex = toIndex > fromIndex ? toIndex - 1 : toIndex;
        this.insertDecorator(actualToIndex, piece);
        this.inUseModel.lastElement().setProperty("Outer", null);
        this.inUseList.setSelectedIndex(actualToIndex);
        this.refresh();
        this.setChanged(true);
    }

    protected GamePiece removeDecorator(int index) {
        GamePiece inner = this.inUseModel.elementAt(index - 1);
        Decorator outer = index < this.inUseModel.size() - 1 ? (Decorator)this.inUseModel.elementAt(index + 1) : null;
        GamePiece piece = this.inUseModel.remove(index);
        if (outer != null) {
            outer.setInner(inner);
        }
        return piece;
    }

    protected void insertDecorator(int index, GamePiece piece) {
        GamePiece inner = this.inUseModel.elementAt(index - 1);
        Decorator outer = index < this.inUseModel.size() ? (Decorator)this.inUseModel.elementAt(index) : null;
        this.inUseModel.insertElementAt(piece, index);
        ((Decorator)piece).setInner(inner);
        if (outer != null) {
            outer.setInner(piece);
        }
    }

    protected void importPiece(String className) {
        if (className == null) {
            return;
        }
        Object o = null;
        try {
            o = GameModule.getGameModule().getDataArchive().loadClass(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable t) {
            ReflectionUtils.handleImportClassFailure(t, className);
        }
        if (o == null) {
            return;
        }
        if (o instanceof GamePiece) {
            PieceDefiner.addAdditionalElement(o);
        } else {
            ErrorDialog.show("Error.not_a_gamepiece", className);
        }
    }

    private void showHelpForPiece() {
        GamePiece o = this.availableList.getSelectedValue();
        if (o instanceof EditablePiece) {
            HelpFile h = ((EditablePiece)o).getHelpFile();
            BrowserSupport.openURL(h.getContents().toString());
        }
    }

    protected boolean edit(int index) {
        GamePiece o = this.inUseModel.elementAt(index);
        if (!(o instanceof EditablePiece)) {
            return false;
        }
        EditablePiece p = (EditablePiece)o;
        if (p.getEditor() != null) {
            Window w = SwingUtilities.getWindowAncestor(this);
            Ed ed = w instanceof Frame ? new Ed((Frame)w, p) : (w instanceof Dialog ? new Ed((Dialog)w, p) : new Ed((Frame)null, p));
            String oldState = p.getState();
            String oldType = p.getType();
            ed.setVisible(true);
            PieceEditor c = ed.getEditor();
            if (c != null) {
                p.mySetType(c.getType());
                if (p instanceof Decorator) {
                    ((Decorator)p).mySetState(c.getState());
                } else {
                    p.setState(c.getState());
                }
                if (!p.getType().equals(oldType) || !p.getState().equals(oldState)) {
                    this.setChanged(true);
                }
                this.refresh();
                return true;
            }
        }
        return false;
    }

    protected void removeTrait(int index) {
        this.inUseModel.removeElementAt(index);
        if (index < this.inUseModel.size()) {
            ((Decorator)this.inUseModel.elementAt(index)).setInner(this.inUseModel.elementAt(index - 1));
        }
        this.refresh();
        this.setChanged(true);
    }

    protected void addTrait(Decorator c) {
        this.addTrait(c, this.inUseList.getSelectedIndex());
    }

    protected void addTrait(Decorator c, int insertIndex) {
        Class<?> cClass = c.getClass();
        Decorator d = null;
        try {
            d = (Decorator)cClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable t) {
            ReflectionUtils.handleNewInstanceFailure(t, cClass);
        }
        if (d != null) {
            if (d instanceof PlaceMarker) {
                ((PlaceMarker)d).updateGpId(this.gpidSupport);
            }
            d.setInner(this.inUseModel.lastElement());
            this.inUseModel.addElement(d);
            this.moveDecorator(this.inUseModel.size() - 1, insertIndex == -1 ? this.inUseModel.size() : insertIndex + 1);
            this.setChanged(true);
        }
        this.refresh();
    }

    static {
        alphaMap = new TreeMap<String, GamePiece>();
        sorted = false;
        MINIMUM_SPLIT_SIZE = LabelUtils.noImageBoxImage().getWidth();
    }

    private static class Renderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            super.getListCellRendererComponent((JList<?>)list, "", index, selected, hasFocus);
            if (value instanceof EditablePiece) {
                this.setText(((EditablePiece)value).getDescription());
            } else {
                String s = value.getClass().getName();
                this.setText(s.substring(s.lastIndexOf(46) + 1));
            }
            return this;
        }
    }

    private static class AvailableRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private AvailableRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            super.getListCellRendererComponent((JList<?>)list, "", index, selected, hasFocus);
            if (value instanceof EditablePiece) {
                this.setText(((EditablePiece)value).getBaseDescription());
            } else {
                String s = value.getClass().getName();
                this.setText(s.substring(s.lastIndexOf(46) + 1));
            }
            return this;
        }
    }

    static class ScaleablePieceSlot
    extends PieceSlot {
        private double scale = 1.0;

        public ScaleablePieceSlot() {
            this.setScale(1.0);
        }

        @Override
        public double getScale() {
            return this.scale;
        }

        public void setScale(double scale) {
            this.scale = scale;
        }
    }

    static class ListTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 1L;
        private final PieceDefiner definer;
        private int fromIndex;
        private String fromList;

        public ListTransferHandler(PieceDefiner definer) {
            this.definer = definer;
        }

        public PieceDefiner getDefiner() {
            return this.definer;
        }

        public int getFromIndex() {
            return this.fromIndex;
        }

        public void setFromIndex(int fromIndex) {
            this.fromIndex = fromIndex;
        }

        public String getFromList() {
            return this.fromList;
        }

        public void setFromList(String fromList) {
            this.fromList = fromList;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            if (PieceDefiner.AVAILABLE.equals(info.getComponent().getName())) {
                return false;
            }
            JList list = (JList)info.getComponent();
            if (list.getModel().getSize() > 0 && ((GamePiece)list.getModel().getElementAt(0)).getClass() == BasicPiece.class && info.getDropLocation().getDropPoint().y < 10) {
                return false;
            }
            return info.isDataFlavorSupported(DataFlavor.stringFlavor);
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            JList list = (JList)c;
            this.setFromIndex(list.getSelectedIndex());
            this.setFromList(list.getName());
            if (DragSource.isDragImageSupported()) {
                this.setDragImage(((EditablePiece)list.getModel().getElementAt(this.getFromIndex())).getDescription());
            }
            return new StringSelection("");
        }

        private void setDragImage(String description) {
            Font DRAG_FONT = new Font("Dialog", 1, 12);
            JLabel label = new JLabel();
            label.setFont(DRAG_FONT);
            label.setText(description);
            int w = label.getFontMetrics(DRAG_FONT).stringWidth(description) + 2;
            int h = label.getFontMetrics(DRAG_FONT).getHeight() + 2;
            BufferedImage img = new BufferedImage(w, h, 6);
            Graphics2D g2 = img.createGraphics();
            g2.setColor(Color.white);
            g2.fillRect(0, 0, w, h);
            g2.setColor(Color.black);
            g2.setFont(DRAG_FONT);
            g2.drawString(description, 2, h - 5);
            g2.dispose();
            this.setDragImage(img);
            this.setDragImageOffset(new Point(0, h));
        }

        @Override
        public int getSourceActions(JComponent c) {
            if (this.getFromIndex() < 0) {
                return 0;
            }
            return 2;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            if (!info.isDrop() || !(info.getComponent() instanceof JList)) {
                return false;
            }
            int toIndex = ((JList.DropLocation)info.getDropLocation()).getIndex();
            if (toIndex > 0 && toIndex != this.getFromIndex()) {
                if (PieceDefiner.AVAILABLE.equals(this.getFromList())) {
                    this.getDefiner().doAdd(this.getFromIndex(), toIndex - 1);
                } else {
                    this.getDefiner().moveDecorator(this.getFromIndex(), toIndex);
                }
            }
            return true;
        }
    }

    static class AvailableListKeyAdapter
    extends KeyAdapter {
        private final PieceDefiner definer;

        public AvailableListKeyAdapter(PieceDefiner definer) {
            this.definer = definer;
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                this.definer.addButton.doClick();
            }
        }
    }

    static class InUseListKeyAdapter
    extends KeyAdapter {
        private final PieceDefiner definer;

        public InUseListKeyAdapter(PieceDefiner definer) {
            this.definer = definer;
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (SwingUtils.isModifierKeyDown(e)) {
                switch (e.getKeyCode()) {
                    case 67: {
                        this.definer.copyButton.doClick();
                        break;
                    }
                    case 86: {
                        this.definer.pasteButton.doClick();
                        break;
                    }
                    case 88: {
                        this.definer.doCopy();
                        this.definer.removeButton.doClick();
                        break;
                    }
                }
            } else if (e.getKeyCode() == 127) {
                this.definer.removeButton.doClick();
            } else if (e.getKeyCode() == 10) {
                this.definer.propsButton.doClick();
            }
        }
    }

    protected static class TraitClipboard {
        private final String type;
        private final String state;

        public TraitClipboard(Decorator copy) {
            this.type = copy.myGetType();
            this.state = copy.myGetState();
        }

        public String getType() {
            return this.type;
        }

        public String getState() {
            return this.state;
        }
    }

    protected static class Ed
    extends JDialog {
        private static final long serialVersionUID = 1L;
        PieceEditor ed;

        private Ed(Frame owner, EditablePiece p) {
            super(owner, Resources.getString("Editor.PieceDefiner.properties", p.getDescription()), true);
            this.initialize(p);
        }

        private Ed(Dialog owner, EditablePiece p) {
            super(owner, Resources.getString("Editor.PieceDefiner.properties", p.getDescription()), true);
            this.initialize(p);
        }

        private void initialize(EditablePiece p) {
            this.ed = p.getEditor();
            this.setLayout((LayoutManager)new MigLayout("fill", "[grow,fill]", "[align top]rel[align bottom]"));
            JPanel scrollPanel = new JPanel((LayoutManager)new MigLayout("wrap 1", "[grow,fill]", "[top]rel[bottom]"));
            JScrollPane scroll = new JScrollPane(scrollPanel, 20, 30);
            scrollPanel.add(this.ed.getControls(), "growx,aligny top,wrap");
            this.add((Component)scroll, "growx,wrap");
            JPanel buttonBox = new JPanel((LayoutManager)new MigLayout("ins 0", "push[]rel[]rel[]push"));
            JButton b = new JButton(Resources.getString("General.ok"));
            b.addActionListener(evt -> this.dispose());
            buttonBox.add((Component)b, "sg,tag ok");
            b = new JButton(Resources.getString("General.cancel"));
            b.addActionListener(evt -> {
                this.ed = null;
                this.dispose();
            });
            buttonBox.add((Component)b, "sg,tag cancel");
            if (p.getHelpFile() != null) {
                b = new JButton(Resources.getString("General.help"));
                b.addActionListener(evt -> BrowserSupport.openURL(p.getHelpFile().getContents().toString()));
                buttonBox.add((Component)b, "sg,tag help");
            }
            this.add((Component)buttonBox, "center");
            this.pack();
            this.setLocationRelativeTo(this.getOwner());
            SwingUtils.ensureOnScreen(this);
        }

        public PieceEditor getEditor() {
            return this.ed;
        }
    }
}

