/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.Info;
import VASSAL.i18n.Resources;
import VASSAL.launch.ModuleManagerWindow;
import VASSAL.tools.DataArchive;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.image.tilecache.ImageTileDiskCache;
import VASSAL.tools.image.tilecache.TileUtils;
import VASSAL.tools.io.ArgEncoding;
import VASSAL.tools.io.FileArchive;
import VASSAL.tools.io.FileStore;
import VASSAL.tools.io.InputOutputStreamPump;
import VASSAL.tools.io.ProcessLauncher;
import VASSAL.tools.io.ProcessWrapper;
import VASSAL.tools.lang.Pair;
import VASSAL.tools.swing.EDT;
import VASSAL.tools.swing.ProgressDialog;
import VASSAL.tools.swing.Progressor;
import java.awt.Dimension;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TilingHandler {
    private static final Logger logger = LoggerFactory.getLogger(TilingHandler.class);
    protected final String aname;
    protected final File cdir;
    protected final Dimension tdim;
    protected final int maxheap_limit;
    protected int retried = 0;
    @Deprecated(since="2021-08-06", forRemoval=true)
    protected final int pid = 42;

    public TilingHandler(String aname, File cdir, Dimension tdim, int mhlim) {
        this.aname = aname;
        this.cdir = cdir;
        this.tdim = tdim;
        this.maxheap_limit = mhlim;
    }

    @Deprecated(since="2021-08-06", forRemoval=true)
    public TilingHandler(String aname, File cdir, Dimension tdim, int mhlim, int pid) {
        this(aname, cdir, tdim, mhlim);
    }

    protected boolean isFresh(FileArchive archive, FileStore tcache, String ipath) throws IOException {
        String tpath = TileUtils.tileName(ipath, 0, 0, 1);
        long imtime = archive.getMTime(ipath);
        return imtime > 0L && imtime <= tcache.getMTime(tpath);
    }

    protected Dimension getImageSize(DataArchive archive, String ipath) throws IOException {
        try (InputStream in = archive.getInputStream(ipath);){
            Dimension dimension = ImageUtils.getImageSize(ipath, in);
            return dimension;
        }
    }

    protected Pair<Integer, Integer> findImages(DataArchive archive, FileStore tcache, List<String> multi, List<Pair<String, IOException>> failed) throws IOException {
        SortedSet<String> images = archive.getImageNameSet(true, true);
        int maxpix = 0;
        int tcount = 0;
        FileArchive fa = archive.getArchive();
        for (String ipath : images) {
            int t;
            Dimension idim;
            if (this.isFresh(fa, tcache, ipath)) continue;
            try {
                idim = this.getImageSize(archive, ipath);
            }
            catch (IOException e) {
                failed.add(Pair.of(ipath, e));
                continue;
            }
            int n = t = TileUtils.tileCountAtScale(idim, this.tdim, 1) > 1 ? TileUtils.tileCount(idim, this.tdim) : 0;
            if (t == 0) continue;
            tcount += t;
            multi.add(ipath);
            if (idim.width * idim.height <= maxpix) continue;
            maxpix = idim.width * idim.height;
        }
        return new Pair<Integer, Integer>(tcount, maxpix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runSlicer(List<String> multi, int tcount, int maxheap) throws CancellationException, IOException {
        block40: {
            InetAddress lo = InetAddress.getByName(null);
            ServerSocket ssock = new ServerSocket(0, 0, lo);
            int port = ssock.getLocalPort();
            ArrayList<String> args = new ArrayList<String>(List.of(Info.getJavaBinPath().getAbsolutePath(), "-classpath", System.getProperty("java.class.path"), "-Xmx" + maxheap + "M", "-Duser.home=" + System.getProperty("user.home"), "-DVASSAL.port=" + port, "VASSAL.tools.image.tilecache.ZipFileImageTiler"));
            String cdirpath = this.cdir.getAbsolutePath();
            if (ArgEncoding.requires(this.aname) || ArgEncoding.requires(cdirpath)) {
                args.add("--encoded-args");
                args.add(ArgEncoding.encode(this.aname));
                args.add(ArgEncoding.encode(cdirpath));
            } else {
                args.add(this.aname);
                args.add(cdirpath);
            }
            args.add(String.valueOf(this.tdim.width));
            args.add(String.valueOf(this.tdim.height));
            final ProgressDialog pd = ProgressDialog.createOnEDT(ModuleManagerWindow.getInstance(), Resources.getString("TilingHandler.processing_image_tiles"), " ");
            InputOutputStreamPump outP = new InputOutputStreamPump(null, System.out);
            InputOutputStreamPump errP = new InputOutputStreamPump(null, System.err);
            ProcessWrapper proc = new ProcessLauncher().launch(null, outP, errP, args.toArray(new String[0]));
            try (PrintWriter stdin = new PrintWriter(proc.stdin, true, StandardCharsets.UTF_8);){
                multi.forEach(stdin::println);
            }
            try (Socket csock = ssock.accept();){
                csock.shutdownOutput();
                try (DataInputStream in = new DataInputStream(csock.getInputStream());){
                    Progressor progressor = new Progressor(0, tcount){

                        @Override
                        protected void run(Pair<Integer, Integer> prog) {
                            pd.setProgress(100 * (Integer)prog.second / this.max);
                        }
                    };
                    EDT.execute(() -> pd.addActionListener(e -> {
                        pd.setVisible(false);
                        proc.future.cancel(true);
                    }));
                    boolean done = false;
                    block33: while (!done) {
                        byte type = in.readByte();
                        switch (type) {
                            case 1: {
                                String ipath = in.readUTF();
                                EDT.execute(() -> {
                                    pd.setLabel(Resources.getString("TilingHandler.tiling", ipath));
                                    if (!pd.isVisible()) {
                                        pd.setVisible(true);
                                    }
                                });
                                continue block33;
                            }
                            case 2: {
                                progressor.increment();
                                if (progressor.get() < tcount) continue block33;
                                pd.setVisible(false);
                                continue block33;
                            }
                            case 3: {
                                done = true;
                                continue block33;
                            }
                        }
                        throw new IllegalStateException("bad type: " + type);
                    }
                }
            }
            catch (IOException e) {
                logger.error("Error during tiling", (Throwable)e);
            }
            finally {
                try {
                    ssock.close();
                }
                catch (IOException e) {
                    logger.error("Error while closing the server socket", (Throwable)e);
                }
            }
            try {
                int retval = proc.future.get();
                if (retval == 0) break block40;
                pd.setVisible(false);
                proc.future.cancel(true);
                if (retval == 2 && this.retried < 2) {
                    logger.info("Tiling ran out of memory. Retrying tiling with twice as much.");
                    ++this.retried;
                    this.runSlicer(multi, tcount, 2 * maxheap);
                    break block40;
                }
                throw new IOException("return value == " + retval);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    protected void makeHashDirs() throws IOException {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                File d = new File(String.format("%s/%1x/%1x%1x", this.cdir, i, i, j));
                FileUtils.forceMkdir((File)d);
            }
        }
    }

    protected void cleanup() throws IOException {
        FileUtils.forceDelete((File)this.cdir);
    }

    public void sliceTiles() throws CancellationException, IOException {
        Pair<Integer, Integer> s;
        ArrayList<String> multi = new ArrayList<String>();
        ArrayList<Pair<String, IOException>> failed = new ArrayList<Pair<String, IOException>>();
        try (DataArchive archive = new DataArchive(this.aname);){
            ImageTileDiskCache tcache = new ImageTileDiskCache(this.cdir.getAbsolutePath());
            s = this.findImages(archive, tcache, multi, failed);
        }
        if (multi.isEmpty()) {
            logger.info("No images to tile.");
            return;
        }
        this.makeHashDirs();
        int max_data_mbytes = 4 * (Integer)s.second >> 20;
        int maxheap_estimated = (int)(1.66 * (double)max_data_mbytes + 150.0);
        int maxheap = Math.min(maxheap_estimated, this.maxheap_limit);
        try {
            this.runSlicer(multi, (Integer)s.first, maxheap);
        }
        catch (IOException | CancellationException e) {
            this.cleanup();
            throw e;
        }
    }
}

