/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.node;

import VASSAL.build.GameModule;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.HttpMessageServer;
import VASSAL.chat.node.NodeClientFactory;
import VASSAL.chat.node.OfficialNodeClient;
import VASSAL.chat.peer2peer.PeerPoolInfo;
import VASSAL.i18n.Resources;
import java.util.Properties;

public class OfficialNodeClientFactory
extends NodeClientFactory {
    public static final String OFFICIAL_TYPE = "official";
    public static final String OFFICIAL_HOST = "game.vassalengine.org";
    public static final String OFFICIAL_PORT = "5050";
    private static final String UNNAMED_MODULE = Resources.getString("Chat.unknown_module");
    private static final String UNKNOWN_USER = Resources.getString("Chat.unknown_user");

    @Override
    protected ChatServerConnection buildServerImpl(Properties param) {
        String host = param.getProperty("nodeHost", OFFICIAL_HOST);
        int port = Integer.parseInt(param.getProperty("nodePort", OFFICIAL_PORT));
        PeerPoolInfo publicInfo = new PeerPoolInfo(){

            @Override
            public String getModuleName() {
                GameModule g = GameModule.getGameModule();
                return g == null ? UNNAMED_MODULE : g.getGameName();
            }

            @Override
            public String getUserName() {
                GameModule g = GameModule.getGameModule();
                return g == null ? UNKNOWN_USER : (String)g.getPrefs().getValue("RealName");
            }
        };
        HttpMessageServer httpMessageServer = new HttpMessageServer(publicInfo);
        GameModule g = GameModule.getGameModule();
        return new OfficialNodeClient(g.getGameName(), GameModule.getUserId() + "." + System.currentTimeMillis(), g, host, port, httpMessageServer, httpMessageServer);
    }
}

