/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.peer2peer;

import VASSAL.build.module.Chatter;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.Room;
import VASSAL.chat.SimpleRoom;
import VASSAL.chat.peer2peer.P2PPlayer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Random;
import java.util.stream.Collectors;
import org.litesoft.p2pchat.PeerInfo;

public class EchoClient
implements Runnable,
PropertyChangeListener {
    public static final String NAME = "EchoBot";
    private static final Random rng = new Random();
    private final int changeRoom;
    private final int numRooms;
    private final FileWriter log;
    private final ChatServerConnection client;

    public EchoClient(ChatServerConnection client, int changeRoom, int numRooms, FileWriter log) {
        this.client = client;
        this.changeRoom = changeRoom;
        this.numRooms = numRooms;
        this.log = log;
        client.addPropertyChangeListener("AvailableRooms", this);
        client.addPropertyChangeListener("Status", evt -> System.err.println(evt.getNewValue()));
        client.setConnected(true);
        client.setRoom(new SimpleRoom("Room0"));
        new Thread(this).start();
    }

    public synchronized void showCHAT(PeerInfo pPeerInfo, String msg) {
        P2PPlayer sender = new P2PPlayer(pPeerInfo);
        if (!sender.getName().startsWith(NAME) && ((String)msg).startsWith("CHAT")) {
            msg = "<" + this.client.getUserInfo().getName() + ((String)msg).substring(((String)msg).indexOf("> -"));
            Chatter.DisplayText c = new Chatter.DisplayText(null, (String)msg);
            this.client.sendTo(sender, c);
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                int nextSleep = Math.round(rng.nextFloat() * 2.0f * (float)this.changeRoom * 1000.0f);
                Thread.sleep(nextSleep);
            }
            catch (InterruptedException nextSleep) {
                // empty catch block
            }
            String newRoom = "Room" + (int)((float)this.numRooms * rng.nextFloat());
            this.client.setRoom(new SimpleRoom(newRoom));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.log != null && evt.getPropertyName().equals("AvailableRooms")) {
            try {
                this.log.write("----------" + new Date() + "---------\n");
                this.log.write(EchoClient.report((Room[])evt.getNewValue()));
                this.log.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String report(Room[] r) {
        StringBuilder buffer = new StringBuilder();
        for (Room room : r) {
            buffer.append(room.getName()).append(": ").append(room.getPlayerList().stream().map(Object::toString).collect(Collectors.joining(", "))).append('\n');
        }
        return buffer.toString();
    }
}

