/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.peer2peer;

import java.io.IOException;
import java.net.ServerSocket;
import org.litesoft.p2pchat.PendingPeerManager;

public class AcceptPeerThread
extends Thread {
    private boolean running = true;
    private ServerSocket socket;
    private final PendingPeerManager ppm;
    private int port;
    private static final int MAX_ATTEMPTS = 10;

    public AcceptPeerThread(int initialPort, PendingPeerManager ppm) throws IOException {
        this.ppm = ppm;
        for (int i = 0; i < 10; ++i) {
            this.port = initialPort + i;
            try {
                this.socket = new ServerSocket(this.port);
                break;
            }
            catch (Exception ex) {
                if (i != 9) continue;
                throw new IOException(ex);
            }
        }
    }

    public int getPort() {
        return this.port;
    }

    public AcceptPeerThread(ServerSocket socket, PendingPeerManager ppm) {
        this.socket = socket;
        this.ppm = ppm;
    }

    @Override
    public synchronized void start() {
        this.running = true;
        super.start();
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                this.ppm.addNewPeer(this.socket.accept());
            }
            catch (Exception ex) {
                this.halt();
            }
        }
    }

    public void halt() {
        this.interrupt();
        this.running = false;
        try {
            this.socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

