/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.ui;

import VASSAL.build.GameModule;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.Room;
import VASSAL.chat.ui.RoomActionFactory;
import VASSAL.i18n.Resources;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class JoinRoomAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private final Room r;
    private final ChatServerConnection client;

    public JoinRoomAction(Room r, ChatServerConnection client) {
        super(Resources.getString("Chat.join_room"));
        this.r = r;
        this.client = client;
        this.setEnabled(r != null && !r.equals(client.getRoom()));
        if (r != null) {
            GameModule.getGameModule().warn(Resources.getString("Chat.joining_room", r.getName()));
            if (Resources.getString("Chat.main_room").equals(r.getName())) {
                JoinRoomAction.explainMainRoom();
            } else {
                GameModule.getGameModule().warn(Resources.getString("Chat.explain_joined_room"));
            }
        }
    }

    public static void explainMainRoom() {
        GameModule.getGameModule().warn(Resources.getString("Chat.explain_main_room"));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.client.setRoom(this.r);
    }

    public static RoomActionFactory factory(ChatServerConnection chatClient) {
        return (p, tree) -> new JoinRoomAction(p, chatClient);
    }
}

