/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.PieceAccessConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceAccess;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.PlayerAccess;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.KeyStroke;

public class Hideable
extends Decorator
implements TranslatablePiece {
    public static final String ID = "hide;";
    public static final String HIDDEN_BY = "hiddenBy";
    public static final String TRANSPARENCY = "transparency";
    protected String hiddenBy;
    protected NamedKeyStroke hideKey;
    protected String command = Resources.getString("Editor.Hideable.default_command");
    protected PieceAccess access = PlayerAccess.getInstance();
    protected float transparency = 0.3f;
    protected Color bgColor;
    protected boolean disableAutoReportMove;
    protected KeyCommand[] commands;
    protected KeyCommand hideCommand;
    protected String description = "";

    @Override
    public void setProperty(Object key, Object val) {
        if (HIDDEN_BY.equals(key)) {
            this.hiddenBy = (String)val;
        } else {
            super.setProperty(key, val);
        }
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        if (this.invisibleToMe()) {
            return ((BasicPiece)Decorator.getInnermost(this)).getLocalizedPublicProperty(key);
        }
        if (HIDDEN_BY.equals(key)) {
            return this.hiddenBy;
        }
        if ("Invisible".equals(key)) {
            return this.invisibleToMe() ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("InvisibleToOthers".equals(key)) {
            return this.invisibleToOthers() ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("visibleState".equals(key)) {
            return Boolean.toString(this.invisibleToOthers()) + this.invisibleToMe() + this.piece.getProperty(key);
        }
        return super.getLocalizedProperty(key);
    }

    @Override
    public Object getProperty(Object key) {
        if (HIDDEN_BY.equals(key)) {
            return this.hiddenBy;
        }
        if ("Invisible".equals(key)) {
            return this.invisibleToMe() ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("InvisibleToOthers".equals(key)) {
            return this.invisibleToOthers() ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("InvisibleDisableAutoReportMoves".equals(key)) {
            return this.disableAutoReportMove;
        }
        if ("visibleState".equals(key)) {
            return Boolean.toString(this.invisibleToOthers()) + this.invisibleToMe() + this.piece.getProperty(key);
        }
        return super.getProperty(key);
    }

    public Hideable() {
        this("hide;I", null);
    }

    public Hideable(String type, GamePiece p) {
        this.setInner(p);
        this.mySetType(type);
    }

    @Override
    public void mySetType(String type) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        st.nextToken();
        this.hideKey = st.nextNamedKeyStroke('I');
        this.command = st.nextToken(Resources.getString("Editor.Hideable.default_command"));
        this.bgColor = st.nextColor(null);
        this.access = PieceAccessConfigurer.decode(st.nextToken(null));
        this.transparency = Math.max(0.0f, Math.min(1.0f, st.hasMoreTokens() ? (float)st.nextDouble(0.3) : 0.3f));
        this.description = st.nextToken("");
        this.disableAutoReportMove = st.nextBoolean(false);
        this.commands = null;
    }

    @Override
    public void mySetState(String in) {
        this.hiddenBy = "null".equals(in) ? null : in;
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.hideKey).append(this.command).append(this.bgColor).append(PieceAccessConfigurer.encode(this.access)).append(this.transparency).append(this.description).append(this.disableAutoReportMove);
        return ID + se.getValue();
    }

    @Override
    public String myGetState() {
        return this.hiddenBy == null ? "null" : this.hiddenBy;
    }

    public boolean invisibleToMe() {
        return !this.access.currentPlayerHasAccess(this.hiddenBy);
    }

    public boolean invisibleToOthers() {
        return this.hiddenBy != null;
    }

    @Override
    public Shape getShape() {
        if (this.invisibleToMe()) {
            return new Rectangle();
        }
        return this.piece.getShape();
    }

    @Override
    public Rectangle boundingBox() {
        if (this.invisibleToMe()) {
            return new Rectangle();
        }
        return this.piece.boundingBox();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        if (this.invisibleToMe()) {
            return;
        }
        if (this.invisibleToOthers()) {
            Graphics2D g2d = (Graphics2D)g;
            if (this.bgColor != null) {
                g.setColor(this.bgColor);
                AffineTransform t = AffineTransform.getScaleInstance(zoom, zoom);
                t.translate((double)x / zoom, (double)y / zoom);
                g2d.fill(t.createTransformedShape(this.piece.getShape()));
            }
            Composite oldComposite = g2d.getComposite();
            g2d.setComposite(AlphaComposite.getInstance(3, this.transparency));
            this.piece.draw(g, x, y, obs, zoom);
            g2d.setComposite(oldComposite);
        } else {
            this.piece.draw(g, x, y, obs, zoom);
        }
    }

    @Override
    public String getName() {
        if (this.invisibleToMe()) {
            return "";
        }
        if (this.invisibleToOthers()) {
            return this.piece.getName() + "(" + this.command + ")";
        }
        return this.piece.getName();
    }

    @Override
    public KeyCommand[] myGetKeyCommands() {
        if (this.commands == null) {
            this.hideCommand = new KeyCommand(this.command, this.hideKey, Decorator.getOutermost(this), (TranslatablePiece)this);
            this.commands = this.command.length() > 0 && this.hideKey != null && !this.hideKey.isNull() ? new KeyCommand[]{this.hideCommand} : KeyCommand.NONE;
        }
        this.hideCommand.setEnabled(this.access.currentPlayerCanModify(this.hiddenBy));
        return this.commands;
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        this.myGetKeyCommands();
        if (this.hideCommand.matches(stroke)) {
            ChangeTracker tracker = new ChangeTracker(this);
            if (this.invisibleToOthers()) {
                this.hiddenBy = null;
            } else if (!this.invisibleToMe()) {
                this.hiddenBy = this.access.getCurrentPlayerId();
            }
            return tracker.getChangeCommand();
        }
        return null;
    }

    @Override
    public String getDescription() {
        return this.buildDescription("Editor.Hideable.trait_description", this.description);
    }

    @Override
    public String getBaseDescription() {
        return Resources.getString("Editor.Hideable.trait_description");
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Hideable.html");
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Deprecated(since="2021-12-01", forRemoval=true)
    public static void setAllHidden(boolean allHidden) {
        if (allHidden) {
            PieceAccess.GlobalAccess.hideAll();
        } else {
            PieceAccess.GlobalAccess.revertAll();
        }
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(this.command, Resources.getString("Editor.Hideable.hide_command"));
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("InvisibleToOthers");
        return l;
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof Hideable)) {
            return false;
        }
        Hideable c = (Hideable)o;
        if (!Objects.equals(this.hideKey, c.hideKey)) {
            return false;
        }
        if (!Objects.equals(this.command, c.command)) {
            return false;
        }
        if (!Objects.equals(this.bgColor, c.bgColor)) {
            return false;
        }
        if (!Objects.equals(PieceAccessConfigurer.encode(this.access), PieceAccessConfigurer.encode(c.access))) {
            return false;
        }
        if (!Objects.equals(Float.valueOf(this.transparency), Float.valueOf(c.transparency))) {
            return false;
        }
        if (!Objects.equals(this.bgColor, c.bgColor)) {
            return false;
        }
        if (!Objects.equals(this.disableAutoReportMove, c.disableAutoReportMove)) {
            return false;
        }
        return Objects.equals(this.hiddenBy, c.hiddenBy);
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return Arrays.asList(this.hideKey);
    }

    @Override
    public List<String> getMenuTextList() {
        return List.of(this.command);
    }

    protected static class Ed
    implements PieceEditor {
        protected NamedHotKeyConfigurer hideKeyInput;
        protected StringConfigurer hideCommandInput;
        protected ColorConfigurer colorConfig;
        protected IntConfigurer transpConfig;
        protected BooleanConfigurer disableAutoReportMoves;
        protected PieceAccessConfigurer accessConfig;
        protected TraitConfigPanel controls = new TraitConfigPanel();
        private final StringConfigurer descInput;

        public Ed(Hideable p) {
            this.descInput = new StringConfigurer(p.description);
            this.descInput.setHintKey("Editor.description_hint");
            this.controls.add("Editor.description_label", (Configurer)this.descInput);
            this.hideCommandInput = new StringConfigurer(p.command);
            this.hideCommandInput.setHintKey("Editor.menu_command_hint");
            this.controls.add("Editor.menu_command", (Configurer)this.hideCommandInput);
            this.hideKeyInput = new NamedHotKeyConfigurer(p.hideKey);
            this.controls.add("Editor.keyboard_command", (Configurer)this.hideKeyInput);
            this.colorConfig = new ColorConfigurer(p.bgColor);
            this.controls.add("Editor.Hideable.background_color", (Configurer)this.colorConfig);
            this.transpConfig = new IntConfigurer((int)(p.transparency * 100.0f));
            this.controls.add("Editor.Hideable.opacity", (Configurer)this.transpConfig);
            this.disableAutoReportMoves = new BooleanConfigurer(p.disableAutoReportMove);
            this.controls.add("Editor.Hideable.disable_auto_report_moves", (Configurer)this.disableAutoReportMoves);
            this.accessConfig = new PieceAccessConfigurer(p.access);
            this.controls.add("Editor.Hideable.can_be_hidden_by", (Configurer)this.accessConfig);
        }

        @Override
        public String getState() {
            return "null";
        }

        @Override
        public String getType() {
            float transp = Math.max(0.0f, Math.min(1.0f, (float)this.transpConfig.getIntValue(30) / 100.0f));
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.hideKeyInput.getValueString()).append(this.hideCommandInput.getValueString()).append(this.colorConfig.getValue() == null ? "" : this.colorConfig.getValueString()).append(this.accessConfig.getValueString()).append(transp).append(this.descInput.getValueString()).append(this.disableAutoReportMoves.getValueString());
            return Hideable.ID + se.getValue();
        }

        @Override
        public Component getControls() {
            return this.controls;
        }
    }
}

