/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imports.adc2;

import VASSAL.build.GameModule;
import VASSAL.build.Widget;
import VASSAL.build.module.ChartWindow;
import VASSAL.build.module.DiceButton;
import VASSAL.build.module.Map;
import VASSAL.build.module.MultiActionButton;
import VASSAL.build.module.PieceWindow;
import VASSAL.build.module.PlayerHand;
import VASSAL.build.module.PlayerRoster;
import VASSAL.build.module.PrototypeDefinition;
import VASSAL.build.module.PrototypesContainer;
import VASSAL.build.module.ToolbarMenu;
import VASSAL.build.module.map.BoardPicker;
import VASSAL.build.module.map.CounterDetailViewer;
import VASSAL.build.module.map.DrawPile;
import VASSAL.build.module.map.LOS_Thread;
import VASSAL.build.module.map.LayeredPieceCollection;
import VASSAL.build.module.map.MassKeyCommand;
import VASSAL.build.module.map.SetupStack;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.build.module.map.boardPicker.board.ZonedGrid;
import VASSAL.build.module.map.boardPicker.board.mapgrid.Zone;
import VASSAL.build.module.turn.ListTurnLevel;
import VASSAL.build.module.turn.TurnTracker;
import VASSAL.build.widget.CardSlot;
import VASSAL.build.widget.Chart;
import VASSAL.build.widget.HtmlChart;
import VASSAL.build.widget.ListWidget;
import VASSAL.build.widget.PieceSlot;
import VASSAL.build.widget.TabWidget;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.Decorator;
import VASSAL.counters.Delete;
import VASSAL.counters.DynamicProperty;
import VASSAL.counters.Embellishment;
import VASSAL.counters.Footprint;
import VASSAL.counters.FreeRotator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Hideable;
import VASSAL.counters.Marker;
import VASSAL.counters.MovementMarkable;
import VASSAL.counters.Obscurable;
import VASSAL.counters.PropertySheet;
import VASSAL.counters.Replace;
import VASSAL.counters.ReturnToDeck;
import VASSAL.counters.UsePrototype;
import VASSAL.search.AbstractImageFinder;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.filechooser.ExtensionFileFilter;
import VASSAL.tools.imports.FileFormatException;
import VASSAL.tools.imports.Importer;
import VASSAL.tools.imports.adc2.ADC2Utils;
import VASSAL.tools.imports.adc2.MapBoard;
import VASSAL.tools.imports.adc2.SymbolSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ADC2Module
extends Importer {
    private static final Logger log;
    private static final String FLIP_DEFINITIONS = "Flip Definitions";
    private static final String ADD_NEW_PIECES = "Add New Pieces";
    private static final String PC_NAME = "$pcName$";
    private static final String CHARTS = "Charts";
    private static final String TRAY = "Tray";
    private static final String FORCE_POOL_PNG = "forcePool.png";
    private static final String FORCE_POOL = "Force Pool";
    private static final String DECKS = "Decks";
    private static final int FORCE_POOL_BLOCK_END = 30000;
    public static final String DRAW_ON_TOP_OF_OTHERS = "Draw on top of others?";
    public static final String PIECE = "Pieces";
    private static final double[] FACING_ANGLES;
    private final Set<String> uniquePieceNames = new HashSet<String>();
    private static boolean usePieceNames;
    private final java.util.Map<Integer, SymbolSet> cardDecks = new HashMap<Integer, SymbolSet>();
    protected static final int ALL_PLAYERS = 200;
    protected static final int NO_PLAYERS = 201;
    public static final String COMMON_PROPERTIES = "Common Properties";
    private String name;
    private MapBoard map = null;
    private final List<PieceClass> pieceClasses = new ArrayList<PieceClass>();
    private final List<Piece> pieces = new ArrayList<Piece>();
    private final List<Player> players = new ArrayList<Player>();
    private final java.util.Map<Integer, List<Piece>> stacks = new HashMap<Integer, List<Piece>>();
    private final java.util.Map<Integer, List<Piece>> forcePoolHashMap = new HashMap<Integer, List<Piece>>();
    private final ForcePoolList forcePools = new ForcePoolList();
    private final String[] classValues = new String[8];
    private final String[] pieceValues = new String[8];
    private FacingDirection[] allowedFacings;
    private java.util.Map<StateFlag, java.util.Map<Dimension, String>> hiddenFlagImages;
    private int version;
    private int classCombatSummaryValues;
    private int pieceCombatSummaryValues;
    private final StatusDots[] statusDots = new StatusDots[6];
    private final List<String> turnNames = new ArrayList<String>();
    private boolean useLOS;
    private String deckName;
    private int nCardSets;
    private final String[] infoPages = new String[10];
    private String infoPageName;
    public static final Color FLAG_BACKGROUND;
    public static final Color FLAG_FOREGROUND;
    private int nFlipDefs = 0;
    private PieceWindow flipDefs;
    private PieceWindow pieceWin;

    protected PieceClass getClassFromIndex(int index) {
        if (index < 0 || index >= this.pieceClasses.size()) {
            return null;
        }
        return this.pieceClasses.get(index);
    }

    protected SymbolSet getCardDeck(int deck) throws IOException {
        SymbolSet set = this.cardDecks.get(deck);
        if (set == null) {
            File f = this.action.getCaseInsensitiveFile(new File(this.deckName + "-c" + (deck + 1) + ".set"), this.file, true, new ExtensionFileFilter("ADC2 Symbol Set", new String[]{".set"}));
            if (f == null) {
                throw new FileNotFoundException("Unable to locate deck symbol set.");
            }
            set = new SymbolSet();
            set.importCardSet(this.action, f);
            this.cardDecks.put(deck, set);
        }
        return set;
    }

    private String getFlagTab(int height, StateFlag flag) throws IOException {
        Dimension d;
        java.util.Map map;
        String imageName;
        if (this.hiddenFlagImages == null) {
            this.hiddenFlagImages = new HashMap<StateFlag, java.util.Map<Dimension, String>>();
        }
        if ((imageName = (String)(map = this.hiddenFlagImages.computeIfAbsent(flag, k -> new HashMap())).get(d = new Dimension(0, height))) == null) {
            int tabHeight = 15;
            int tabSpace = height < 43 ? (height - 15) / 2 : 14;
            int tabWidth = 10;
            BufferedImage icon = new BufferedImage(10, height, 2);
            Graphics2D g = icon.createGraphics();
            g.translate(0, tabSpace * flag.tab);
            flag.drawFlagImage(g);
            imageName = ADC2Module.getUniqueImageFileName(flag.name + "0x" + height);
            map.put(d, imageName);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)icon, "png", out);
            byte[] imageDataArray = out.toByteArray();
            GameModule.getGameModule().getArchiveWriter().addImage(imageName, imageDataArray);
        }
        return imageName;
    }

    private String getFlagLayer(Dimension d, StateFlag flag) throws IOException {
        java.util.Map map;
        String imageName;
        if (this.hiddenFlagImages == null) {
            this.hiddenFlagImages = new HashMap<StateFlag, java.util.Map<Dimension, String>>();
        }
        if ((imageName = (String)(map = this.hiddenFlagImages.computeIfAbsent(flag, k -> new HashMap())).get(d)) == null) {
            int tabHeight = 15;
            int tabSpace = d.height < 43 ? (d.height - 15) / 2 : 14;
            int tabWidth = 10;
            BufferedImage icon = new BufferedImage(d.width + 20, d.height, 2);
            Graphics2D g = icon.createGraphics();
            g.translate(d.width + 10, tabSpace * flag.tab);
            flag.drawFlagImage(g);
            imageName = ADC2Module.getUniqueImageFileName(flag.name + d.width + "x" + d.height);
            map.put(d, imageName);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)icon, "png", out);
            byte[] imageDataArray = out.toByteArray();
            GameModule.getGameModule().getArchiveWriter().addImage(imageName, imageDataArray);
        }
        return imageName;
    }

    public boolean usePieceValues() {
        for (String pieceValue : this.pieceValues) {
            if (pieceValue == null || pieceValue.equals("")) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void load(File f) throws IOException {
        super.load(f);
        try (InputStream fin = Files.newInputStream(f.toPath(), new OpenOption[0]);
             BufferedInputStream bin = new BufferedInputStream(fin);
             DataInputStream in = new DataInputStream(bin);){
            this.name = ADC2Module.stripExtension(f.getName());
            byte header = in.readByte();
            if (header != -3 && header != -2) {
                throw new FileFormatException("Invalid Game Module Header");
            }
            this.version = in.readUnsignedShort();
            String s = ADC2Module.readWindowsFileName(in);
            String mapFileName = ADC2Module.forceExtension(s, "map");
            this.map = new MapBoard();
            File mapFile = this.action.getCaseInsensitiveFile(new File(mapFileName), f, true, new ExtensionFileFilter("ADC2 Map Board", new String[]{".map"}));
            if (mapFile == null) {
                throw new FileNotFoundException("Unable to locate map file.");
            }
            this.map.importFile(this.action, mapFile);
            try {
                this.readGameTurnBlock(in);
                this.readClassBlock(in);
                this.readClassValueBlock(in);
                this.readPieceBlock(in);
                this.readPieceValueBlock(in);
                this.readPlayerBlock(in);
                this.readReplayBlock(in);
                this.readPoolBlock(in);
                this.readStackBlock(in);
                this.readCombatSummaryBlock(in);
                this.readFacingBlock(in);
                this.readSoundSettingBlock(in);
                this.readFlipDefinitionBlock(in);
                this.readPieceStatusDotsBlock(in);
                this.readDiceBlock(in);
                this.readTurnNameBlock(in);
                this.readLOSBlock(in);
                this.readLOSFlagBlock(in);
                this.readDeckNameBlock(in);
                this.readPoolOwnerBlock(in);
                this.readAutoRevealWhenMovingLOSFlagBlock(in);
                this.readCombatRevealFlagBlock(in);
                this.readInfoPageBlock(in);
                this.readInfoSizeBlock(in);
                this.readAllianceBlock(in);
                this.readDrawOptionsBlock(in);
                this.readPieceStatusDotsBlock(in);
            }
            catch (ADC2Utils.NoMoreBlocksException e) {
                log.error("Error during import", (Throwable)e);
            }
        }
    }

    private void readDrawOptionsBlock(DataInputStream in) throws IOException {
        ADC2Utils.readBlockHeader(in, "Draw Options");
        boolean showHexSides = in.readByte() != 0;
        boolean showHexLines = in.readByte() != 0;
        boolean showPlaceNames = in.readByte() != 0;
        int pieceOptionFlags = in.readUnsignedByte();
        boolean showPieces = (pieceOptionFlags & 1) > 0;
        boolean showMarkers = (pieceOptionFlags & 2) == 0;
        in.readFully(new byte[4]);
    }

    protected void readAllianceBlock(DataInputStream in) throws IOException {
        ADC2Utils.readBlockHeader(in, "Alliances");
        ADC2Utils.readBase250Word(in);
        for (Player p1 : this.players) {
            in.readUnsignedShort();
            for (Player p2 : this.players) {
                if (in.readUnsignedShort() <= 0) continue;
                p1.setAlly(p2);
            }
        }
    }

    protected void readInfoSizeBlock(DataInputStream in) throws IOException {
        ADC2Utils.readBlockHeader(in, "Info Size");
        in.readFully(new byte[4]);
    }

    protected void readInfoPageBlock(DataInputStream in) throws IOException {
        block21: {
            ADC2Utils.readBlockHeader(in, "Info Page");
            this.infoPageName = ADC2Module.readWindowsFileName(in);
            if (this.infoPageName.length() > 0) {
                File ipx = this.action.getCaseInsensitiveFile(new File(ADC2Module.forceExtension(this.infoPageName, "ipx")), this.file, true, new ExtensionFileFilter("Info page file (*.ipx;*.IPX)", new String[]{".ipx"}));
                if (ipx != null) {
                    try (InputStream fin = Files.newInputStream(ipx.toPath(), new OpenOption[0]);
                         BufferedInputStream bin = new BufferedInputStream(fin);){
                        DataInputStream input = new DataInputStream(bin);
                        try {
                            try {
                                while (true) {
                                    if (input.readUnsignedByte() != 59) {
                                        continue;
                                    }
                                    int idx = input.readUnsignedByte();
                                    int len = input.readUnsignedByte();
                                    byte[] dimensions = new byte[8];
                                    input.readFully(dimensions);
                                    byte[] buf = new byte[len];
                                    input.readFully(buf);
                                    String name = new String(buf, StandardCharsets.US_ASCII);
                                    if (idx >= 10 || this.infoPages[idx] != null) continue;
                                    this.infoPages[idx] = name;
                                }
                            }
                            catch (EOFException eOFException) {
                                input.close();
                                break block21;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                }
                this.infoPageName = null;
            }
        }
    }

    protected void readCombatRevealFlagBlock(DataInputStream in) throws IOException {
        ADC2Utils.readBlockHeader(in, "Combat Reveal Option Flag");
        in.readByte();
    }

    protected void readAutoRevealWhenMovingLOSFlagBlock(DataInputStream in) throws IOException {
        ADC2Utils.readBlockHeader(in, "Auto Reveal When Moving (LOS) Flag");
        in.readByte();
    }

    protected void readPoolOwnerBlock(DataInputStream in) throws IOException {
        ADC2Utils.readBlockHeader(in, "Pool Owner");
        Iterator iter = this.forcePools.iterator();
        for (int i = 0; i < this.forcePools.size(); ++i) {
            Pool p = (Pool)iter.next();
            int owner = in.readUnsignedByte();
            if (!(p instanceof Cards)) continue;
            ((Cards)p).setOwner(owner);
        }
    }

    protected void readDeckNameBlock(DataInputStream in) throws IOException {
        ADC2Utils.readBlockHeader(in, "Deck Name");
        this.deckName = ADC2Module.stripExtension(ADC2Module.readWindowsFileName(in));
    }

    protected void readLOSFlagBlock(DataInputStream in) throws IOException {
        ADC2Utils.readBlockHeader(in, "LOS Flags");
        in.readByte();
        byte rightMouseButton = in.readByte();
        if (rightMouseButton == 3 || rightMouseButton == 4) {
            this.useLOS = true;
        }
    }

    protected void readLOSBlock(DataInputStream in) throws IOException {
        ADC2Utils.readBlockHeader(in, "LOS");
        in.readFully(new byte[18]);
        in.readUnsignedShort();
        in.readByte();
        ADC2Utils.readBase250Word(in);
        ADC2Module.readNullTerminatedString(in, 20);
        in.readByte();
        ADC2Utils.readBase250Word(in);
        if (this.version > 518) {
            ADC2Utils.readBase250Word(in);
            byte[] units = new byte[10];
            in.readFully(units);
        }
        int nBlocks = ADC2Utils.readBase250Word(in);
        for (int i = 0; i < nBlocks; ++i) {
            ADC2Utils.readBase250Word(in);
            ADC2Utils.readBase250Word(in);
            ADC2Utils.readBase250Word(in);
            ADC2Utils.readBase250Word(in);
            ADC2Utils.readBase250Word(in);
            byte[] color = new byte[3];
            in.readFully(color);
        }
    }

    protected void readTurnNameBlock(DataInputStream in) throws IOException {
        ADC2Utils.readBlockHeader(in, "Turn Names");
        int nNames = ADC2Utils.readBase250Word(in);
        boolean terminate = false;
        for (int i = 0; i < nNames; ++i) {
            String name = ADC2Module.readNullTerminatedString(in, 50);
            if (name.equals("")) {
                terminate = true;
                continue;
            }
            if (terminate) continue;
            this.turnNames.add(name);
        }
    }

    protected void readDiceBlock(DataInputStream in) throws IOException {
        ADC2Utils.readBlockHeader(in, "Dice");
        in.readByte();
        in.readByte();
        in.readUnsignedByte();
        in.readUnsignedByte();
    }

    protected void readPieceStatusDotsBlock(DataInputStream in) throws IOException {
        ADC2Utils.readBlockHeader(in, "Piece Status Dots");
        byte[] size = new byte[3];
        for (int i = 0; i < 6; ++i) {
            byte type = in.readByte();
            int show = ADC2Utils.readBase250Word(in);
            int color = in.readUnsignedByte();
            byte position = in.readByte();
            in.readFully(size);
            this.statusDots[i] = new StatusDots(type, show, ADC2Utils.getColorFromIndex(color), position, size[2]);
        }
    }

    protected void readFlipDefinitionBlock(DataInputStream in) throws IOException {
        ADC2Utils.readBlockHeader(in, "Flip Definition");
        in.readUnsignedByte();
        this.nFlipDefs = ADC2Utils.readBase250Word(in);
        for (int i = 0; i < this.nFlipDefs; ++i) {
            int from = ADC2Utils.readBase250Word(in);
            int to = ADC2Utils.readBase250Word(in);
            if (from < 0 || from >= this.pieceClasses.size() || to < 0 || to >= this.pieceClasses.size()) continue;
            this.pieceClasses.get(from).setFlipClass(to);
            this.pieceClasses.get(to).setBackFlipClass(from);
        }
    }

    protected void readSoundSettingBlock(DataInputStream in) throws IOException {
        ADC2Utils.readBlockHeader(in, "Sound Settings");
        for (int i = 0; i < 3; ++i) {
            in.readUnsignedByte();
        }
        in.readFully(new byte[3]);
        in.readUnsignedByte();
    }

    protected void readFacingBlock(DataInputStream in) throws IOException {
        ADC2Utils.readBlockHeader(in, "Facing");
        int nFacing = in.readUnsignedByte();
        this.allowedFacings = new FacingDirection[nFacing + 1];
        this.allowedFacings[0] = FacingDirection.NONE;
        for (int i = 0; i < nFacing; ++i) {
            ADC2Module.readNullTerminatedString(in);
            int direction = in.readUnsignedByte();
            if (i == 0 || this.allowedFacings[i] != FacingDirection.NONE) {
                switch (direction) {
                    case 2: {
                        this.allowedFacings[i + 1] = FacingDirection.VERTEX;
                        break;
                    }
                    case 3: {
                        this.allowedFacings[i + 1] = FacingDirection.BOTH;
                        break;
                    }
                    default: {
                        this.allowedFacings[i + 1] = FacingDirection.FLAT_SIDES;
                        break;
                    }
                }
            } else {
                this.allowedFacings[i + 1] = FacingDirection.NONE;
            }
            in.readUnsignedByte();
            in.readUnsignedByte();
            in.readUnsignedByte();
            in.readFully(new byte[3]);
        }
    }

    protected void readCombatSummaryBlock(DataInputStream in) throws IOException {
        ADC2Utils.readBlockHeader(in, "Fast Zoom");
        in.readUnsignedByte();
        this.classCombatSummaryValues = in.readUnsignedByte();
        this.pieceCombatSummaryValues = in.readUnsignedByte();
        in.readUnsignedByte();
    }

    protected void readStackBlock(DataInputStream in) throws IOException {
        ADC2Utils.readBlockHeader(in, "Stack");
        int nStackDefs = ADC2Utils.readBase250Word(in);
        for (int i = 0; i < nStackDefs; ++i) {
            ADC2Utils.readBase250Word(in);
            ADC2Utils.readBase250Word(in);
            for (int j = 0; j < 3; ++j) {
                in.readUnsignedByte();
            }
            ADC2Utils.readBase250Word(in);
        }
    }

    protected void readReplayBlock(DataInputStream in) throws IOException {
        ADC2Utils.readBlockHeader(in, "Replay");
        int nBytes = this.version > 515 ? ADC2Utils.readBase250Integer(in) : ADC2Utils.readBase250Word(in);
        in.readFully(new byte[nBytes]);
    }

    protected void readPoolBlock(DataInputStream in) throws IOException {
        ADC2Utils.readBlockHeader(in, FORCE_POOL);
        int nForcePools = ADC2Utils.readBase250Word(in);
        block4: for (int i = 0; i < nForcePools; ++i) {
            String n = ADC2Module.readNullTerminatedString(in, 25);
            byte type = in.readByte();
            in.readFully(new byte[2]);
            int nunits = ADC2Utils.readBase250Word(in);
            if (nunits == 30000) break;
            switch (type) {
                case 2: {
                    this.forcePools.add(new HandPool(n, this.forcePoolHashMap.get(i)));
                    continue block4;
                }
                case 3: {
                    this.forcePools.add(new DeckPool(n, this.forcePoolHashMap.get(i)));
                    continue block4;
                }
                default: {
                    this.forcePools.add(new ForcePool(n, this.forcePoolHashMap.get(i)));
                }
            }
        }
    }

    protected void readPlayerBlock(DataInputStream in) throws IOException {
        String name;
        ADC2Utils.readBlockHeader(in, "Player");
        ADC2Utils.readBase250Word(in);
        do {
            name = ADC2Module.readNullTerminatedString(in, 25);
            in.readFully(new byte[20]);
            in.readByte();
            ADC2Utils.readBase250Word(in);
            SymbolSet.SymbolData hiddenSymbol = this.getSet().getGamePiece(ADC2Utils.readBase250Word(in));
            ADC2Module.readNullTerminatedString(in);
            in.readUnsignedByte();
            int hiddenPieceOptions = in.readUnsignedByte();
            in.readByte();
            if (name.length() <= 0) continue;
            Player player = new Player(name, hiddenSymbol, hiddenPieceOptions);
            this.players.add(player);
        } while (name.length() > 0);
    }

    protected void readPieceBlock(DataInputStream in) throws IOException {
        ADC2Utils.readBlockHeader(in, PIECE);
        int nPieces = ADC2Utils.readBase250Word(in);
        for (int i = 0; i < nPieces; ++i) {
            HideState hidden;
            String name = ADC2Module.readNullTerminatedString(in, 25);
            PieceClass cl = this.getClassFromIndex(ADC2Utils.readBase250Word(in));
            if (cl == null) {
                throw new FileFormatException("Invalid Class Index");
            }
            if (name.equals(cl.getName())) {
                name = "";
            }
            int[] values = new int[8];
            for (int j = 0; j < values.length; ++j) {
                values[j] = in.readInt();
            }
            ValueType[] types = new ValueType[8];
            block12: for (int j = 0; j < types.length; ++j) {
                switch (in.readUnsignedByte()) {
                    case 1: {
                        types[j] = ValueType.NUMERIC;
                        continue block12;
                    }
                    case 2: {
                        types[j] = ValueType.TEXT;
                        continue block12;
                    }
                    case 3: {
                        types[j] = ValueType.YESNO;
                        continue block12;
                    }
                    case 10: {
                        if (j == 0) {
                            types[j] = ValueType.CARD;
                            continue block12;
                        }
                    }
                    default: {
                        types[j] = ValueType.NOT_USED;
                    }
                }
            }
            switch (in.readUnsignedByte()) {
                case 0: {
                    hidden = HideState.NOT_HIDDEN;
                    break;
                }
                case 1: {
                    hidden = HideState.INFO_HIDDEN;
                    break;
                }
                default: {
                    hidden = HideState.HIDDEN;
                }
            }
            in.readFully(new byte[2]);
            int position = ADC2Utils.readBase250Word(in);
            int flags = in.readUnsignedByte();
            int facing = in.readUnsignedByte();
            if (facing > FACING_ANGLES.length) {
                facing = 0;
            }
            Piece p = new Piece(position, name, cl, hidden, flags, facing);
            for (int j = 0; j < values.length; ++j) {
                p.setValue(j, values[j]);
                p.types[j] = types[j];
            }
            this.pieces.add(p);
        }
    }

    protected void readClassValueBlock(DataInputStream in) throws IOException {
        ADC2Utils.readBlockHeader(in, "Class Value");
        for (int i = 0; i < this.classValues.length; ++i) {
            this.classValues[i] = ADC2Module.readNullTerminatedString(in, 15);
        }
    }

    protected void readPieceValueBlock(DataInputStream in) throws IOException {
        ADC2Utils.readBlockHeader(in, "Piece Value");
        for (int i = 0; i < this.pieceValues.length; ++i) {
            this.pieceValues[i] = ADC2Module.readNullTerminatedString(in, 15);
        }
    }

    protected void readClassBlock(DataInputStream in) throws IOException {
        ADC2Utils.readBlockHeader(in, "Class");
        int nClasses = ADC2Utils.readBase250Word(in);
        for (int i = 0; i < nClasses; ++i) {
            PieceClass cl;
            int symbolIndex = ADC2Utils.readBase250Word(in);
            String name = ADC2Module.readNullTerminatedString(in, 25);
            int[] values = new int[8];
            for (int j = 0; j < values.length; ++j) {
                values[j] = in.readInt();
            }
            boolean isCard = false;
            int setIndex = 0;
            ValueType[] types = new ValueType[8];
            block7: for (int j = 0; j < types.length; ++j) {
                int t = in.readUnsignedByte();
                if (j == 0 && t == 10) {
                    isCard = true;
                }
                if (isCard) {
                    if (j == 1) {
                        setIndex = t;
                    }
                    if (setIndex < this.nCardSets) continue;
                    this.nCardSets = setIndex + 1;
                    continue;
                }
                switch (t) {
                    case 1: {
                        types[j] = ValueType.NUMERIC;
                        continue block7;
                    }
                    case 2: {
                        types[j] = ValueType.TEXT;
                        continue block7;
                    }
                    case 3: {
                        types[j] = ValueType.YESNO;
                        continue block7;
                    }
                    default: {
                        types[j] = ValueType.NOT_USED;
                    }
                }
            }
            int owner = in.readUnsignedByte();
            int hiddenSymbol = ADC2Utils.readBase250Word(in);
            int facing = in.readUnsignedByte();
            if (isCard) {
                cl = new CardClass(name, symbolIndex, setIndex);
            } else {
                cl = new PieceClass(name, this.getSet().getGamePiece(symbolIndex), owner, hiddenSymbol, facing);
                for (int j = 0; j < values.length; ++j) {
                    cl.setValue(j, values[j]);
                    cl.types[j] = types[j];
                }
            }
            this.pieceClasses.add(cl);
        }
    }

    protected void readGameTurnBlock(DataInputStream in) throws IOException {
        ADC2Utils.readBlockHeader(in, "Game Turn");
        int gameTurn = ADC2Utils.readBase250Word(in);
    }

    protected void writePrototypesToArchive(GameModule gameModule) {
        PrototypesContainer container = gameModule.getAllDescendantComponentsOf(PrototypesContainer.class).iterator().next();
        PrototypeDefinition def = new PrototypeDefinition();
        ADC2Module.insertComponent(def, container);
        def.setConfigureName(COMMON_PROPERTIES);
        AbstractImageFinder gp = new BasicPiece();
        Delete del = new Delete();
        SequenceEncoder se = new SequenceEncoder(';');
        se.append("Delete").append(NamedKeyStroke.of(KeyStroke.getKeyStroke("DELETE")));
        del.mySetType("delete;" + se.getValue());
        del.setInner((GamePiece)((Object)gp));
        gp = del;
        if (this.forcePools.count(ForcePool.class) > 0) {
            gp = new ReturnToDeck("return;Return to Force Pool;R;;Select Force Pool", (GamePiece)((Object)gp));
        }
        se = new SequenceEncoder(';');
        se.append(NamedKeyStroke.of(KeyStroke.getKeyStroke(84, 128))).append("Movement Trail").append(false).append(false).append(10).append(Color.WHITE).append(Color.BLACK).append(100).append(0);
        gp = new Footprint("footprint;" + se.getValue(), (GamePiece)((Object)gp));
        se = new SequenceEncoder(',');
        se.append("Type");
        gp = new Marker("mark;" + se.getValue(), (GamePiece)((Object)gp));
        gp.setProperty("Type", PIECE);
        def.setPiece((GamePiece)((Object)gp));
    }

    @Override
    public void writeToArchive() throws IOException {
        GameModule gameModule = GameModule.getGameModule();
        gameModule.setAttribute("name", this.name);
        this.writePrototypesToArchive(gameModule);
        this.getMap().writeToArchive();
        this.configureStatusFlagButtons();
        this.configureMapLayers();
        this.pieceWin = gameModule.getAllDescendantComponentsOf(PieceWindow.class).iterator().next();
        this.configureFlipDefinitions(gameModule);
        this.writeClassesToArchive(gameModule);
        this.writeForcePoolsToArchive(gameModule);
        this.writeDecksToArchive(gameModule);
        this.writeHandsToArchive(gameModule);
        this.writeInfoPagesToArchive(gameModule);
        this.writeToolbarMenuToArchive(gameModule);
        this.writeSetupStacksToArchive(gameModule);
        this.writePlayersToArchive(gameModule);
        this.configureMouseOverStackViewer(gameModule);
        this.configureMainMap();
        this.configureDiceRoller(gameModule);
        if (this.turnNames.size() > 1) {
            this.configureTurnCounter(gameModule);
        }
        if (this.useLOS) {
            ADC2Module.insertComponent(new LOS_Thread(), gameModule);
        }
    }

    private void configureFlipDefinitions(GameModule gameModule) {
        if (this.nFlipDefs > 0) {
            this.flipDefs = new PieceWindow();
            ADC2Module.insertComponent(this.flipDefs, gameModule);
            this.flipDefs.setAttribute("name", FLIP_DEFINITIONS);
            this.flipDefs.setAttribute("hidden", Boolean.TRUE);
            this.flipDefs.setAttribute("text", "");
            this.flipDefs.setAttribute("tooltip", "");
            ListWidget list = new ListWidget();
            ADC2Module.insertComponent(list, this.flipDefs);
        }
    }

    private void configureMainMap() throws IOException {
        Map mainMap = this.getMainMap();
        mainMap.setAttribute("markUnmovedIcon", StateFlag.MOVE.getStatusIconName());
    }

    private void configureStatusFlagButtons() throws IOException {
        String imageName = StateFlag.ATTACK.getStatusIconName();
        MassKeyCommand command = new MassKeyCommand();
        ADC2Module.insertComponent(command, this.getMainMap());
        command.setAttribute("tooltip", "Clear attacked status");
        command.setAttribute("buttonText", "Attacked");
        command.setAttribute("buttonHotkey", null);
        command.setAttribute("icon", imageName);
        command.setAttribute("name", "Attacked");
        command.setAttribute("hotkey", NamedKeyStroke.of(KeyStroke.getKeyStroke(65, 128)));
        command.setAttribute("filter", "Mark Attacked_Active = true");
        command.setAttribute("deckCount", "-1");
        command.setAttribute("reportSingle", Boolean.TRUE);
        command.setAttribute("reportFormat", "");
        imageName = StateFlag.DEFEND.getStatusIconName();
        command = new MassKeyCommand();
        ADC2Module.insertComponent(command, this.getMainMap());
        command.setAttribute("tooltip", "Clear defended status");
        command.setAttribute("buttonText", "Defended");
        command.setAttribute("buttonHotkey", null);
        command.setAttribute("icon", imageName);
        command.setAttribute("name", "Defended");
        command.setAttribute("hotkey", NamedKeyStroke.of(KeyStroke.getKeyStroke(68, 128)));
        command.setAttribute("filter", "Mark Defended_Active = true");
        command.setAttribute("deckCount", "-1");
        command.setAttribute("reportSingle", Boolean.TRUE);
        command.setAttribute("reportFormat", "");
        MultiActionButton button = new MultiActionButton();
        ADC2Module.insertComponent(button, this.getMainMap());
        button.setAttribute("text", "");
        button.setAttribute("tooltip", "Clear combat status flags.");
        button.setAttribute("icon", StateFlag.COMBAT.getStatusIconName());
        button.setAttribute("hotkey", KeyStroke.getKeyStroke(67, 128));
        button.setAttribute("menuItems", StringArrayConfigurer.arrayToString(new String[]{"Attacked", "Defended"}));
    }

    protected void writeInfoPagesToArchive(GameModule gameModule) throws IOException {
        if (this.infoPageName != null && !this.infoPageName.equals("")) {
            ChartWindow charts = new ChartWindow();
            ADC2Module.insertComponent(charts, gameModule);
            charts.setAttribute("name", CHARTS);
            charts.setAttribute("text", CHARTS);
            charts.setAttribute("tooltip", CHARTS);
            charts.setAttribute("hotkey", NamedKeyStroke.of(KeyStroke.getKeyStroke(67, 128)));
            TabWidget tab = new TabWidget();
            ADC2Module.insertComponent(tab, charts);
            for (int i = 0; i < this.infoPages.length; ++i) {
                Widget w;
                boolean isChart;
                File f = this.action.getCaseInsensitiveFile(new File(ADC2Module.forceExtension(this.infoPageName, "b" + i)), this.file, false, null);
                if (f == null) {
                    f = this.action.getCaseInsensitiveFile(new File(ADC2Module.forceExtension(this.infoPageName, "t" + i)), this.file, false, null);
                }
                if (f == null) continue;
                boolean bl = isChart = Character.toLowerCase(ADC2Module.getExtension(f.getName()).charAt(0)) == 'b';
                if (isChart) {
                    w = new Chart();
                    ADC2Module.insertComponent(w, tab);
                    w.setAttribute("chartName", this.infoPages[i]);
                    gameModule.getArchiveWriter().addImage(f.getPath(), f.getName());
                    w.setAttribute("fileName", f);
                } else {
                    w = new HtmlChart();
                    ADC2Module.insertComponent(w, tab);
                    w.setAttribute("chartName", this.infoPages[i]);
                    StringBuilder sb = new StringBuilder();
                    sb.append("<html><body>");
                    try (BufferedReader input = Files.newBufferedReader(f.toPath(), StandardCharsets.US_ASCII);){
                        String line;
                        do {
                            if (!StringUtils.isNotEmpty((CharSequence)(line = input.readLine()))) continue;
                            line = line.replaceAll(" (?: )", "&nbsp;").replaceAll("(?<=&nbsp;) ", "&nbsp;").replaceFirst("^ ", "&nbsp;");
                            sb.append("<p>").append(line).append("</p>");
                        } while (line != null);
                        sb.append("</body></html>");
                        gameModule.getArchiveWriter().addFile(f.getName(), sb.toString().getBytes(StandardCharsets.UTF_8));
                        w.setAttribute("fileName", f.getName());
                    }
                }
                tab.propertyChange(new PropertyChangeEvent(w, "name", "", this.infoPages[i]));
            }
        }
    }

    protected void configureMapLayers() {
        LayeredPieceCollection layer = this.getLayeredPieceCollection();
        Object order = layer.getAttributeValueString("layerOrder");
        order = ((String)order).equals("") ? "0,1" : (String)order + ",0,1";
        layer.setAttribute("layerOrder", order);
    }

    protected void configureTurnCounter(GameModule gameModule) {
        TurnTracker tracker = new TurnTracker();
        ADC2Module.insertComponent(tracker, gameModule);
        tracker.setAttribute("turnFormat", "$level1$");
        ListTurnLevel list = new ListTurnLevel();
        ADC2Module.insertComponent(list, tracker);
        list.setAttribute("property", "currentTurn");
        String[] names = new String[this.turnNames.size()];
        list.setAttribute("list", StringArrayConfigurer.arrayToString(this.turnNames.toArray(names)));
    }

    protected void configureDiceRoller(GameModule gameModule) {
        DiceButton dice = new DiceButton();
        ADC2Module.insertComponent(dice, gameModule);
        dice.setAttribute("name", "Roll");
        dice.setAttribute("prompt", Boolean.TRUE);
        dice.setAttribute("tooltip", "Roll the dice");
        dice.setAttribute("text", "Roll");
        dice.setAttribute("reportFormat", "** $name$ $nDice$d$nSides$ (+$plus$ each) = $result$ *** &lt;$playerName$&gt;");
    }

    protected void configureMouseOverStackViewer(GameModule gameModule) {
        CounterDetailViewer viewer = gameModule.getAllDescendantComponentsOf(CounterDetailViewer.class).iterator().next();
        viewer.setAttribute("display", "by using a property filter");
        viewer.setAttribute("propertyFilter", "Type = Pieces");
        StringBuilder sb = new StringBuilder();
        int mask = 1;
        for (String classValue : this.classValues) {
            if (classValue != null && !classValue.equals("") && (this.classCombatSummaryValues & mask) > 0) {
                if (sb.length() > 0) {
                    sb.append('-');
                }
                sb.append("$sum(").append(classValue).append(")$");
            }
            mask <<= 1;
        }
        mask = 1;
        for (String pieceValue : this.pieceValues) {
            if (pieceValue != null && !pieceValue.equals("") && (this.pieceCombatSummaryValues & mask) > 0) {
                if (sb.length() > 0) {
                    sb.append('-');
                }
                sb.append("$sum(").append(pieceValue).append(")$");
            }
            mask <<= 1;
        }
        viewer.setAttribute("showtext", Boolean.TRUE);
        if (sb.length() > 0) {
            sb.append(' ');
        }
        viewer.setAttribute("minDisplayPieces", "1");
        viewer.setAttribute("summaryReportFormat", sb + "($LocationName$)");
        if (usePieceNames) {
            viewer.setAttribute("counterReportFormat", PC_NAME);
        }
        viewer.setAttribute("unrotatePieces", Boolean.TRUE);
        viewer.setAttribute("bgColor", Color.WHITE);
    }

    protected void writeClassesToArchive(GameModule gameModule) throws IOException {
        this.pieceWin.setAttribute("name", ADD_NEW_PIECES);
        ListWidget list = new ListWidget();
        ADC2Module.insertComponent(list, this.pieceWin);
        for (PieceClass c : this.pieceClasses) {
            c.writeToArchive(list);
        }
    }

    protected void writePlayersToArchive(GameModule gameModule) {
        PlayerRoster roster = gameModule.getAllDescendantComponentsOf(PlayerRoster.class).iterator().next();
        SequenceEncoder se = new SequenceEncoder(',');
        for (Player player : this.players) {
            if (player.allies.first() != player) continue;
            se.append(player.getName());
        }
        for (int i = 0; i < 2; ++i) {
            roster.setAttribute("sides", se.getValue());
        }
    }

    protected void writeHandsToArchive(GameModule module) throws IOException {
        int nHands = this.forcePools.count(HandPool.class);
        if (nHands == 0) {
            return;
        }
        Iterator<Pool> iter = this.forcePools.iterator(HandPool.class);
        while (iter.hasNext()) {
            HandPool pool = (HandPool)iter.next();
            PlayerHand hand = new PlayerHand();
            ADC2Module.insertComponent(hand, module);
            if (pool.getOwner() == Player.ALL_PLAYERS) {
                String[] sides = new String[this.players.size()];
                for (int i = 0; i < this.players.size(); ++i) {
                    sides[i] = this.players.get(i).getName();
                }
                hand.setAttribute("side", StringArrayConfigurer.arrayToString(sides));
            } else {
                hand.setAttribute("side", pool.getOwner().getName());
            }
            hand.setAttribute("visible", Boolean.TRUE);
            hand.setAttribute("mapName", pool.name);
            hand.setAttribute("markMoved", "Never");
            hand.setAttribute("launch", Boolean.TRUE);
            hand.setAttribute("buttonName", pool.getButtonName());
            BoardPicker picker = hand.getBoardPicker();
            Board board = new Board();
            ADC2Module.insertComponent(board, picker);
            board.setConfigureName(pool.name);
            List<Piece> s = pool.getPieces();
            if (this.pieces.isEmpty()) continue;
            SetupStack stack = new SetupStack();
            ADC2Module.insertComponent(stack, hand);
            Dimension d = this.getMaxDeckSize();
            Point p = new Point(d.width / 2 + 10, d.height / 2 + 10);
            stack.setAttribute("name", pool.name);
            stack.setAttribute("owningBoard", board.getConfigureName());
            stack.setAttribute("x", Integer.toString(p.x));
            stack.setAttribute("y", Integer.toString(p.y));
            for (Piece pc : s) {
                pc.writeToArchive(stack);
            }
        }
    }

    protected void writeDecksToArchive(GameModule gameModule) throws IOException {
        int nDecks = this.forcePools.count(DeckPool.class);
        if (nDecks == 0) {
            return;
        }
        Map deckMap = new Map();
        ADC2Module.insertComponent(deckMap, gameModule);
        deckMap.setMapName(DECKS);
        deckMap.setAttribute("markMoved", "Never");
        deckMap.setAttribute("launch", Boolean.TRUE);
        deckMap.setAttribute("buttonName", DECKS);
        deckMap.setAttribute("hotkey", NamedKeyStroke.of(KeyStroke.getKeyStroke(68, 128)));
        BoardPicker boardPicker = deckMap.getBoardPicker();
        Dimension maxSize = this.getMaxDeckSize();
        boolean vertical = maxSize.width > maxSize.height;
        JPanel panel = new JPanel();
        JPanel[] deckPanels = new JPanel[nDecks];
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        c.anchor = 10;
        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Iterator<Pool> iter = this.forcePools.iterator(DeckPool.class);
        for (int i = 0; i < nDecks; ++i) {
            Pool pool = iter.next();
            deckPanels[i] = new JPanel();
            deckPanels[i].setPreferredSize(maxSize);
            deckPanels[i].setMaximumSize(maxSize);
            deckPanels[i].setBorder(BorderFactory.createLoweredBevelBorder());
            if (vertical) {
                c.gridy = i * 2;
                c.gridx = 1;
            } else {
                c.gridy = 1;
                c.gridx = i;
            }
            c.insets.bottom = 2;
            c.insets.top = 5;
            panel.add((Component)deckPanels[i], c);
            Object name = ((Cards)pool).getOwner() == Player.ALL_PLAYERS ? pool.name : (((Cards)pool).getOwner() == Player.NO_PLAYERS ? pool.name : pool.name + " (" + ((Cards)pool).getOwner().getName() + ")");
            JLabel label = new JLabel((String)name);
            label.setHorizontalAlignment(0);
            ++c.gridy;
            c.insets.top = 2;
            c.insets.bottom = 5;
            panel.add((Component)label, c);
        }
        Dimension d = panel.getPreferredSize();
        panel.setSize(d);
        panel.doLayout();
        BufferedImage poolImage = new BufferedImage(d.width, d.height, 1);
        Graphics2D g = poolImage.createGraphics();
        panel.printAll(g);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)poolImage, "png", out);
        byte[] imageDataArray = out.toByteArray();
        String deckImageName = "decks.png";
        gameModule.getArchiveWriter().addImage("decks.png", imageDataArray);
        Board board = new Board();
        ADC2Module.insertComponent(board, boardPicker);
        board.setConfigureName(DECKS);
        board.setAttribute("image", "decks.png");
        Rectangle rv = new Rectangle();
        iter = this.forcePools.iterator(DeckPool.class);
        for (int i = 0; i < nDecks; ++i) {
            Pool pool = iter.next();
            DrawPile pile = new DrawPile();
            ADC2Module.insertComponent(pile, deckMap);
            JPanel p = deckPanels[i];
            p.getBounds(rv);
            pile.setAttribute("owningBoard", DECKS);
            pile.setAttribute("x", rv.x + rv.width / 2);
            pile.setAttribute("y", rv.y + rv.height / 2);
            pile.setAttribute("width", rv.width);
            pile.setAttribute("height", rv.height);
            pile.setAttribute("faceDown", "Always");
            pile.setAttribute("drawFaceUp", Boolean.FALSE);
            pile.setAttribute("shuffle", "Never");
            pile.setAttribute("reversible", Boolean.FALSE);
            pile.setAttribute("allowMultiple", Boolean.TRUE);
            pile.setAttribute("allowSelect", ((Cards)pool).getOwner() == Player.ALL_PLAYERS);
            pile.setAttribute("reshufflable", Boolean.FALSE);
            pile.setAttribute("name", pool.name);
            pile.setAttribute("shuffle", "Via right-click Menu");
            pile.setAttribute("shuffleFormat", "$playerName$ reshuffles $deckName$");
            pile.setAttribute("shuffleHotkey", NamedKeyStroke.of(KeyStroke.getKeyStroke(83, 128)));
            for (Piece pc : pool.getPieces()) {
                pc.writeToArchive(pile);
            }
        }
    }

    protected void writeToolbarMenuToArchive(GameModule gameModule) {
        int nHands = this.forcePools.count(HandPool.class);
        if (nHands == 0) {
            return;
        }
        ToolbarMenu menu = new ToolbarMenu();
        ADC2Module.insertComponent(menu, gameModule);
        menu.setAttribute("text", "Windows");
        menu.setAttribute("tooltip", "Open trays, decks, charts, and hands.");
        String[] items = new String[nHands + 3];
        items[0] = TRAY;
        items[1] = DECKS;
        int start = 2;
        if (this.infoPageName != null) {
            items[2] = CHARTS;
            start = 3;
        }
        Iterator<Pool> iter = this.forcePools.iterator(HandPool.class);
        for (int i = 0; i < nHands; ++i) {
            items[i + start] = iter.next().getButtonName();
        }
        menu.setAttribute("menuItems", StringArrayConfigurer.arrayToString(items));
    }

    private Dimension getMaxDeckSize() throws IOException {
        Dimension d = new Dimension(0, 0);
        for (int i = 0; i < this.nCardSets; ++i) {
            this.getCardDeck(i).getMaxSize(d);
        }
        return d;
    }

    protected void writeForcePoolsToArchive(GameModule gameModule) throws IOException {
        int nForcePools = this.forcePools.count(ForcePool.class);
        if (nForcePools == 0) {
            return;
        }
        GameModule module = GameModule.getGameModule();
        Map forcePoolMap = new Map();
        ADC2Module.insertComponent(forcePoolMap, module);
        forcePoolMap.setMapName(TRAY);
        forcePoolMap.setAttribute("markMoved", "Never");
        forcePoolMap.setAttribute("launch", Boolean.TRUE);
        forcePoolMap.setAttribute("buttonName", TRAY);
        forcePoolMap.setAttribute("hotkey", NamedKeyStroke.of(KeyStroke.getKeyStroke(84, 128)));
        BoardPicker boardPicker = forcePoolMap.getBoardPicker();
        Dimension modalSize = this.getSet().getModalSize();
        modalSize.height = modalSize.height * 3 / 2;
        modalSize.width = modalSize.width * 3 / 2;
        JPanel panel = new JPanel();
        JPanel[] deckPanels = new JPanel[nForcePools];
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        c.anchor = 10;
        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        int nColumns = (int)Math.sqrt(nForcePools);
        Iterator<Pool> iter = this.forcePools.iterator(ForcePool.class);
        for (int i = 0; i < nForcePools; ++i) {
            ForcePool fp = (ForcePool)iter.next();
            deckPanels[i] = new JPanel();
            deckPanels[i].setBorder(BorderFactory.createLoweredBevelBorder());
            c.gridy = i / nColumns * 2;
            c.gridx = i % nColumns;
            c.insets.bottom = 2;
            c.insets.top = 5;
            panel.add((Component)deckPanels[i], c);
            JLabel label = new JLabel(fp.name);
            label.setHorizontalAlignment(0);
            ++c.gridy;
            c.insets.top = 2;
            c.insets.bottom = 5;
            panel.add((Component)label, c);
            Dimension d = label.getPreferredSize();
            if (d.width <= modalSize.width) continue;
            modalSize.width = d.width;
        }
        for (JPanel p : deckPanels) {
            p.setPreferredSize(modalSize);
        }
        Dimension d = panel.getPreferredSize();
        panel.setSize(d);
        panel.doLayout();
        BufferedImage forcePool = new BufferedImage(d.width, d.height, 1);
        Graphics2D g = forcePool.createGraphics();
        panel.printAll(g);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)forcePool, "png", out);
        byte[] imageDataArray = out.toByteArray();
        module.getArchiveWriter().addImage(FORCE_POOL_PNG, imageDataArray);
        Board board = new Board();
        ADC2Module.insertComponent(board, boardPicker);
        board.setConfigureName(TRAY);
        board.setAttribute("image", FORCE_POOL_PNG);
        Rectangle rv = new Rectangle();
        iter = this.forcePools.iterator(ForcePool.class);
        for (int i = 0; i < nForcePools; ++i) {
            ForcePool fp = (ForcePool)iter.next();
            DrawPile pile = new DrawPile();
            ADC2Module.insertComponent(pile, forcePoolMap);
            JPanel p = deckPanels[i];
            p.getBounds(rv);
            pile.setAttribute("owningBoard", TRAY);
            pile.setAttribute("x", rv.x + rv.width / 2);
            pile.setAttribute("y", rv.y + rv.height / 2);
            pile.setAttribute("width", rv.width);
            pile.setAttribute("height", rv.height);
            pile.setAttribute("faceDown", "Never");
            pile.setAttribute("drawFaceUp", Boolean.TRUE);
            pile.setAttribute("shuffle", "Never");
            pile.setAttribute("reversible", Boolean.FALSE);
            pile.setAttribute("allowMultiple", Boolean.FALSE);
            pile.setAttribute("reshufflable", Boolean.FALSE);
            pile.setAttribute("name", fp.name);
            for (Piece pc : fp.getPieces()) {
                pc.writeToArchive(pile);
            }
        }
    }

    protected void writeSetupStacksToArchive(GameModule gameModule) throws IOException {
        Map mainMap = this.getMainMap();
        Point offset = this.getMap().getCenterOffset();
        for (Map.Entry<Integer, List<Piece>> en : this.stacks.entrySet()) {
            int hex = en.getKey();
            Point p = this.getMap().indexToPosition(hex);
            if (p == null) continue;
            SetupStack stack = new SetupStack();
            ADC2Module.insertComponent(stack, mainMap);
            p.translate(offset.x, offset.y);
            String location = mainMap.locationName(p);
            stack.setAttribute("name", location);
            Board board = this.getMap().getBoard();
            stack.setAttribute("owningBoard", board.getConfigureName());
            MapGrid mg = board.getGrid();
            Zone z = null;
            if (mg instanceof ZonedGrid) {
                z = ((ZonedGrid)mg).findZone(p);
            }
            stack.setAttribute("x", Integer.toString(p.x));
            stack.setAttribute("y", Integer.toString(p.y));
            if (z != null) {
                try {
                    if (mg.getLocation(location) != null) {
                        if (!mg.locationName(mg.getLocation(location)).equals(location)) {
                            throw new AssertionError((Object)"Bad location");
                        }
                        stack.setAttribute("useGridLocation", true);
                        stack.setAttribute("location", location);
                    }
                }
                catch (MapGrid.BadCoords e) {
                    log.error("Error while writing setup stacks", (Throwable)e);
                }
            }
            for (Piece pc : en.getValue()) {
                pc.writeToArchive(stack);
            }
        }
    }

    protected MapBoard getMap() {
        return this.map;
    }

    protected SymbolSet getSet() {
        return this.getMap().getSet();
    }

    @Override
    public boolean isValidImportFile(File f) throws IOException {
        try (InputStream fin = Files.newInputStream(f.toPath(), new OpenOption[0]);){
            boolean bl;
            try (DataInputStream in = new DataInputStream(fin);){
                byte header = in.readByte();
                bl = header == -3 || header == -2;
            }
            return bl;
        }
    }

    static {
        int i;
        log = LoggerFactory.getLogger(ADC2Module.class);
        FACING_ANGLES = new double[46];
        for (i = 0; i < 3; ++i) {
            ADC2Module.FACING_ANGLES[i + 1] = (double)(-i) * 90.0;
            ADC2Module.FACING_ANGLES[i + 5] = -((double)i * 90.0 + 45.0);
        }
        for (i = 0; i < 6; ++i) {
            ADC2Module.FACING_ANGLES[i + 10] = (double)(-i) * 60.0;
            ADC2Module.FACING_ANGLES[i + 20] = -(((double)i * 60.0 - 15.0) % 360.0);
            ADC2Module.FACING_ANGLES[i + 30] = -((double)i * 60.0 + 30.0);
            ADC2Module.FACING_ANGLES[i + 40] = -((double)i * 60.0 + 15.0);
        }
        usePieceNames = false;
        FLAG_BACKGROUND = new Color(1.0f, 1.0f, 0.8f, 0.8f);
        FLAG_FOREGROUND = new Color(0.5f, 0.0f, 0.5f, 1.0f);
    }

    protected static class ForcePoolList
    extends ArrayList<Pool> {
        private static final long serialVersionUID = 1L;

        protected ForcePoolList() {
        }

        public int count(Class<?> type) {
            int size = 0;
            Iterator<Pool> iter = this.iterator(type);
            while (iter.hasNext()) {
                Pool p = iter.next();
                if (p.getClass() != type || !p.isUseable()) continue;
                ++size;
            }
            return size;
        }

        public Iterator<Pool> iterator(Class<?> type) {
            return new ForcePoolIterator(type);
        }

        private class ForcePoolIterator
        implements Iterator<Pool> {
            private final Class<?> type;
            private int cursor = 0;

            private ForcePoolIterator(Class<?> type) {
                this.type = type;
                this.setNext();
            }

            private void setNext() {
                while (!(this.cursor >= ForcePoolList.this.size() || ((Pool)ForcePoolList.this.get(this.cursor)).getClass() == this.type && ((Pool)ForcePoolList.this.get(this.cursor)).isUseable())) {
                    ++this.cursor;
                }
            }

            @Override
            public boolean hasNext() {
                return this.cursor < ForcePoolList.this.size();
            }

            @Override
            public Pool next() {
                Pool p = (Pool)ForcePoolList.this.get(this.cursor);
                ++this.cursor;
                this.setNext();
                return p;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    public class StatusDots {
        public static final int NOT_USED = 0;
        public static final int MOVED = 1;
        public static final int IN_COMBAT = 2;
        public static final int ATTACKED = 3;
        public static final int DEFENDED = 4;
        public static final int CLASS_VALUE = 5;
        public static final int PIECE_VALUE = 6;
        public static final int DO_NOT_DRAW = 0;
        public static final int TOP_LEFT = 1;
        public static final int TOP_CENTER = 2;
        public static final int TOP_RIGHT = 3;
        public static final int CENTER_LEFT = 4;
        public static final int CENTER_CENTER = 5;
        public static final int CENTER_RIGHT = 6;
        public static final int BOTTOM_LEFT = 7;
        public static final int BOTTOM_CENTER = 8;
        public static final int BOTTOM_RIGHT = 9;
        private final int type;
        private final int show;
        private final Color color;
        private final int position;
        private final int size;

        protected StatusDots(int type, int show, Color color, int position, int size) {
            this.type = type;
            this.show = show;
            this.color = color;
            this.position = position;
            this.size = size;
        }

        public Color getColor() {
            return this.color;
        }

        public int getPosition() {
            return this.position;
        }

        public int getShow() {
            return this.show;
        }

        public int getSize() {
            return this.size;
        }

        public int getType() {
            return this.type & 0xF;
        }

        public String getStatusPropertyName() {
            if (this.getType() == 5) {
                return ADC2Module.this.classValues[this.type >>> 4];
            }
            if (this.getType() == 6) {
                return ADC2Module.this.pieceValues[this.type >>> 4];
            }
            return null;
        }
    }

    public class PieceClass {
        public PieceClass backReplace;
        public static final String CLASS_PROPERTIES = "Class Properties";
        protected static final int NO_HIDDEN_SYMBOL = 30001;
        protected static final int PLAYER_DEFAULT_HIDDEN_SYMBOL = 30000;
        private final int[] values = new int[8];
        private final ValueType[] types = new ValueType[8];
        private final String name;
        protected SymbolSet.SymbolData symbol;
        protected int owner;
        private final int hiddenSymbol;
        private final int facing;
        private PieceClass flipClass;
        private Piece defaultPiece;
        private String uniqueName;
        private boolean flipClassAdded = false;
        private Piece flipDefinition;

        public PieceClass(String name, SymbolSet.SymbolData symbol, int owner, int hiddenSymbol, int facing) {
            this.name = name;
            this.symbol = symbol;
            this.owner = owner;
            this.hiddenSymbol = hiddenSymbol;
            this.facing = facing;
        }

        public Decorator getReplaceWithPreviousDecorator() throws IOException {
            PieceClass flipClass = this.getBackFlipClass();
            if (flipClass == null) {
                return null;
            }
            if (this.getFlipClass() == flipClass) {
                return null;
            }
            String path = flipClass.getFlipClassTreeConfigurePath();
            SequenceEncoder se = new SequenceEncoder(path, ';');
            se.append("null").append(0).append(0).append(true).append((NamedKeyStroke)null).append("").append("").append(2).append(true);
            flipClass.writeFlipDefinition();
            return new Replace("replace;Flip Back;B;" + se.getValue(), null);
        }

        private String getFlipClassTreeConfigurePath() {
            SequenceEncoder se2 = new SequenceEncoder(PieceWindow.class.getName(), ':');
            se2.append(ADC2Module.FLIP_DEFINITIONS);
            SequenceEncoder se = new SequenceEncoder(se2.getValue(), '/');
            se2 = new SequenceEncoder(ListWidget.class.getName(), ':');
            se.append(se2.getValue());
            se2 = new SequenceEncoder(PieceSlot.class.getName(), ':');
            se2.append(this.getUniqueName());
            se.append(se2.getValue());
            return se.getValue();
        }

        public Decorator getReplaceWithOtherDecorator() throws IOException {
            PieceClass flipClass = this.getFlipClass();
            if (flipClass == null) {
                return null;
            }
            String path = flipClass.getFlipClassTreeConfigurePath();
            SequenceEncoder se = new SequenceEncoder(path, ';');
            se.append("null").append(0).append(0).append(true).append((NamedKeyStroke)null).append("").append("").append(2).append(true);
            flipClass.writeFlipDefinition();
            return new Replace("replace;Flip;F;" + se.getValue(), null);
        }

        private void writeFlipDefinition() throws IOException {
            if (!this.flipClassAdded) {
                this.flipClassAdded = true;
                ListWidget list = ADC2Module.this.flipDefs.getAllDescendantComponentsOf(ListWidget.class).iterator().next();
                this.getFlipDefinition().writeToArchive(list);
            }
        }

        public PieceClass getBackFlipClass() {
            if (this.backReplace == this) {
                return null;
            }
            return this.backReplace;
        }

        public DynamicProperty getDynamicPropertyDecorator() {
            SequenceEncoder type = new SequenceEncoder(';');
            type.append("Layer");
            SequenceEncoder constraints = new SequenceEncoder(',');
            constraints.append(true).append(0).append(1).append(true);
            type.append(constraints.getValue());
            SequenceEncoder command = new SequenceEncoder(':');
            KeyStroke stroke = KeyStroke.getKeyStroke(61, 64);
            SequenceEncoder change = new SequenceEncoder(',');
            change.append('I').append(1);
            command.append("Draw on top").append(stroke.getKeyCode() + "," + stroke.getModifiers()).append(change.getValue());
            type.append(new SequenceEncoder(command.getValue(), ',').getValue());
            DynamicProperty dp = new DynamicProperty();
            dp.mySetType("PROP;" + type.getValue());
            return dp;
        }

        public String getUniqueName() {
            if (this.uniqueName == null) {
                this.uniqueName = this.getName();
                int index = 1;
                while (ADC2Module.this.uniquePieceNames.contains(this.uniqueName)) {
                    this.uniqueName = this.getName() + " (" + index++ + ")";
                }
                ADC2Module.this.uniquePieceNames.add(this.uniqueName);
            }
            return this.uniqueName;
        }

        public boolean checkHidden(Piece piece) {
            return piece.hideState == HideState.HIDDEN || piece.inForcePool() && this.getOwner().hiddenInForcePools();
        }

        public PropertySheet getPropertySheetDecorator() {
            SequenceEncoder type = new SequenceEncoder('~');
            SequenceEncoder state = new SequenceEncoder('~');
            for (int i = 0; i < ADC2Module.this.classValues.length; ++i) {
                if (ADC2Module.this.classValues[i] == null || ADC2Module.this.classValues[i].equals("")) continue;
                type.append("0" + ADC2Module.this.classValues[i]);
                Object o = this.getValue(i);
                if (o instanceof String) {
                    state.append((String)o);
                    continue;
                }
                if (o instanceof Integer) {
                    state.append(o.toString());
                    continue;
                }
                if (o instanceof Boolean) {
                    state.append(o.equals(Boolean.TRUE) ? "yes" : "no");
                    continue;
                }
                state.append("");
            }
            PropertySheet p = null;
            if (type.getValue() != null && type.getValue().length() > 0) {
                p = new PropertySheet();
                SequenceEncoder se = new SequenceEncoder(';');
                se.append(type.getValue() == null ? "" : type.getValue());
                se.append(CLASS_PROPERTIES);
                se.append('C');
                se.append(0);
                se.append("").append("").append("");
                p.mySetType("propertysheet;" + se.getValue());
                p.mySetState(state.getValue());
            }
            return p;
        }

        public UsePrototype getUsePrototypeDecorator() {
            SequenceEncoder se = new SequenceEncoder("prototype;".replaceAll(";", ""), ';');
            se.append(ADC2Module.COMMON_PROPERTIES);
            UsePrototype p = new UsePrototype();
            p.mySetType(se.getValue());
            return p;
        }

        public Embellishment getAttackedEmbellishmentDecorator() throws IOException {
            return this.getCombatEmbellishmentDecorator("Mark Attacked", "A", StateFlag.ATTACK);
        }

        public Embellishment getDefendedEmbellishmentDecorator() throws IOException {
            return this.getCombatEmbellishmentDecorator("Mark Defended", "D", StateFlag.DEFEND);
        }

        private Embellishment getCombatEmbellishmentDecorator(String command, String key, StateFlag flag) throws IOException {
            BufferedImage image = this.getSymbol().getImage();
            int xOffset = (image.getWidth() + 1) / 2 + 5;
            boolean yOffset = false;
            String imageName = ADC2Module.this.getFlagTab(image.getHeight(), flag);
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(command).append(128).append(key).append("").append(0).append("").append("").append(0).append("").append("").append("").append("").append(false).append(xOffset).append(0).append(StringArrayConfigurer.arrayToString(new String[]{imageName})).append(StringArrayConfigurer.arrayToString(new String[]{""})).append(false).append(command).append((NamedKeyStroke)null).append("").append(false).append("").append(1);
            Embellishment layer = new Embellishment();
            layer.mySetType("emb2;" + se.getValue());
            return layer;
        }

        public Obscurable getPieceValueMask() throws IOException {
            if (this.getOwner().useHiddenPieces()) {
                SequenceEncoder se = new SequenceEncoder(';');
                se.append(NamedKeyStroke.of(KeyStroke.getKeyStroke(73, 128)));
                se.append(this.getImageName());
                se.append("Hide Info");
                BufferedImage image = this.getSymbol().getImage();
                se.append("G" + ADC2Module.this.getFlagLayer(new Dimension(image.getWidth(), image.getHeight()), StateFlag.INFO));
                if (this.name == null) {
                    se.append(this.getName());
                } else {
                    se.append("Unknown Piece");
                }
                se.append("sides:" + this.getOwner().getName());
                Obscurable p = new Obscurable();
                p.mySetType("obs;" + se.getValue());
                return p;
            }
            return null;
        }

        public MovementMarkable getMovementMarkableDecorator() throws IOException {
            SequenceEncoder se = new SequenceEncoder(';');
            BufferedImage img = this.getSymbol().getImage();
            int xOffset = (img.getWidth() + 1) / 2;
            int yOffset = -img.getHeight() / 2;
            String movedIcon = ADC2Module.this.getFlagTab(img.getHeight(), StateFlag.MOVE);
            se.append(movedIcon).append(xOffset).append(yOffset);
            MovementMarkable p = new MovementMarkable();
            p.mySetType("markmoved;" + se.getValue());
            return p;
        }

        public Decorator getHiddenDecorator() throws IOException {
            if (this.getOwner().useHiddenPieces()) {
                Decorator p;
                Object sides = this.getOwner() == Player.ALL_PLAYERS || this.getOwner() == Player.NO_PLAYERS ? "side:" : "sides:" + this.getOwner().getName();
                SequenceEncoder se = new SequenceEncoder(';');
                se.append(NamedKeyStroke.of(KeyStroke.getKeyStroke(72, 128)));
                if (this.getHiddenSymbol() == null) {
                    se.append("Hide Piece");
                    se.append(new Color(255, 255, 255));
                    se.append((String)sides);
                    p = new Hideable();
                    p.mySetType("hide;" + se.getValue());
                } else {
                    se.append(this.getHiddenSymbol().getFileName());
                    se.append("Hide Piece");
                    BufferedImage image = this.getSymbol().getImage();
                    se.append("G" + ADC2Module.this.getFlagLayer(new Dimension(image.getWidth(), image.getHeight()), StateFlag.MARKER));
                    se.append(this.getHiddenName());
                    se.append((String)sides);
                    p = new Obscurable();
                    ((Obscurable)p).mySetType("obs;" + se.getValue());
                }
                return p;
            }
            return null;
        }

        public FreeRotator getFreeRotatorDecorator() {
            int nfacings;
            int nsides = ADC2Module.this.getMap().getNFaces();
            switch (this.getAllowedFacings()) {
                case NONE: {
                    return null;
                }
                case FLAT_SIDES: {
                    nfacings = nsides == 4 ? 4 : 12;
                    break;
                }
                default: {
                    nfacings = nsides == 4 ? 8 : 24;
                }
            }
            String type = "rotate;" + nfacings + ";];[;Rotate CW;Rotate CCW;;;;";
            FreeRotator p = new FreeRotator();
            p.mySetType(type);
            return p;
        }

        public String getHiddenName() {
            return "Unknown Piece";
        }

        protected void setValue(int index, int value) {
            this.values[index] = value;
            this.types[index] = ValueType.NUMERIC;
        }

        public FacingDirection getAllowedFacings() {
            if (ADC2Module.this.allowedFacings == null) {
                return FacingDirection.NONE;
            }
            if (this.facing >= ADC2Module.this.allowedFacings.length) {
                return FacingDirection.NONE;
            }
            return ADC2Module.this.allowedFacings[this.facing];
        }

        public SymbolSet.SymbolData getHiddenSymbol() throws IOException {
            if (this.hiddenSymbol == 30000) {
                return this.getOwner().getHiddenSymbol();
            }
            if (this.hiddenSymbol == 30001) {
                return null;
            }
            return ADC2Module.this.getSet().getGamePiece(this.hiddenSymbol);
        }

        public String getImageName() throws IOException {
            if (this.getSymbol() == null) {
                return null;
            }
            return this.symbol.getFileName();
        }

        public Player getOwner() {
            if (this.owner == 201) {
                return Player.NO_PLAYERS;
            }
            if (this.owner >= ADC2Module.this.players.size()) {
                return Player.ALL_PLAYERS;
            }
            return ADC2Module.this.players.get(this.owner);
        }

        public Player getPlayer(Piece p) {
            return this.getOwner();
        }

        protected void setFlipClass(int to) {
            if (to >= 0 && to < ADC2Module.this.pieceClasses.size()) {
                this.flipClass = ADC2Module.this.pieceClasses.get(to);
            }
        }

        protected void setBackFlipClass(int from) {
            this.backReplace = ADC2Module.this.pieceClasses.get(from);
            assert (this.backReplace.getFlipClass() == this);
        }

        public PieceClass getFlipClass() {
            if (this.flipClass == this) {
                return null;
            }
            return this.flipClass;
        }

        public String getName() {
            return this.name;
        }

        protected void setValue(int index, String value) {
            byte[] b = value.getBytes(StandardCharsets.US_ASCII);
            int result = 0;
            for (int i = 0; i < 4; ++i) {
                result = (result << 8) + (b[i] & 0xFF);
            }
            this.values[index] = result;
            this.types[index] = ValueType.TEXT;
        }

        protected void setValue(int index, boolean value) {
            this.values[index] = value ? 1 : 0;
            this.types[index] = ValueType.YESNO;
        }

        public int getValueAsInt(int index) {
            return this.values[index];
        }

        public String getValueAsString(int index) {
            byte[] b = new byte[4];
            int length = 0;
            int mask = 0x7F000000;
            for (int i = 0; i < b.length; ++i) {
                b[i] = (byte)((this.values[index] & mask) >> (3 - i) * 8);
                if (b[i] < 32 || b[i] > 126) break;
                ++length;
                mask >>= 8;
            }
            return new String(b, 0, length, StandardCharsets.US_ASCII);
        }

        public int getNValues() {
            int total = 0;
            for (ValueType t : this.types) {
                if (t == ValueType.NOT_USED) continue;
                ++total;
            }
            return total;
        }

        public boolean getValueAsBoolean(int index) {
            return this.values[index] > 0;
        }

        public Object getValue(int index) {
            if (this.types[index] == null) {
                return null;
            }
            switch (this.types[index]) {
                case NUMERIC: {
                    return this.getValueAsInt(index);
                }
                case TEXT: {
                    return this.getValueAsString(index);
                }
                case YESNO: {
                    return this.getValueAsBoolean(index);
                }
            }
            return null;
        }

        protected void writeToArchive(ListWidget list) throws IOException {
            this.getDefaultPiece().writeToArchive(list);
        }

        protected Piece getDefaultPiece() {
            if (this.defaultPiece == null) {
                this.defaultPiece = new Piece(this);
            }
            return this.defaultPiece;
        }

        protected Piece getFlipDefinition() {
            if (this.flipDefinition == null) {
                this.flipDefinition = new Piece(this);
            }
            return this.flipDefinition;
        }

        protected SymbolSet.SymbolData getSymbol() throws IOException {
            return this.symbol;
        }
    }

    public static class StateFlag {
        public static final StateFlag MOVE = new StateFlag("M", FLAG_BACKGROUND, FLAG_FOREGROUND, 0);
        public static final StateFlag ATTACK = new StateFlag("A", FLAG_BACKGROUND, FLAG_FOREGROUND, 1);
        public static final StateFlag DEFEND = new StateFlag("D", FLAG_BACKGROUND, FLAG_FOREGROUND, 1);
        public static final StateFlag INFO = new StateFlag("h", FLAG_BACKGROUND, FLAG_FOREGROUND, 2);
        public static final StateFlag MARKER = new StateFlag("H", FLAG_BACKGROUND, FLAG_FOREGROUND, 2);
        public static final StateFlag COMBAT = new StateFlag("C", FLAG_BACKGROUND, FLAG_FOREGROUND, 1);
        private final String name;
        private final Color background;
        private final Color foreground;
        private final int tab;
        private String imageName;
        private final List<StatusDots> statusDots = new ArrayList<StatusDots>();

        public StateFlag(String flag, Color background, Color foreground, int tab) {
            this.name = flag;
            this.background = background;
            this.foreground = foreground;
            this.tab = tab;
        }

        public String getStatusIconName() throws IOException {
            if (this.imageName == null) {
                BufferedImage icon = new BufferedImage(10, 15, 2);
                Graphics2D g = icon.createGraphics();
                this.drawFlagImage(g);
                this.imageName = Importer.getUniqueImageFileName(this.name, ".png");
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)icon, "png", out);
                byte[] imageDataArray = out.toByteArray();
                GameModule.getGameModule().getArchiveWriter().addImage(this.imageName, imageDataArray);
            }
            return this.imageName;
        }

        public void addStatusDots(StatusDots dots) {
            this.statusDots.add(dots);
        }

        public void drawFlagImage(Graphics2D g) {
            int tabHeight = 15;
            int tabWidth = 10;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setColor(this.background);
            g.fillRoundRect(-10, 0, 20, 15, 6, 6);
            g.setColor(this.foreground);
            g.drawRoundRect(-10, 0, 19, 14, 6, 6);
            g.setFont(new Font("Dialog", 0, 9));
            Rectangle2D r = g.getFontMetrics().getStringBounds(this.name, g);
            g.drawString(this.name, 5 - (int)(r.getWidth() / 2.0) - 1, 11);
            g.setBackground(new Color(0, 0, 0, 0));
            g.clearRect(-10, 0, 10, 15);
        }
    }

    public static class Player {
        public static final Player ALL_PLAYERS = new Player("All Players", null, 0);
        public static final Player NO_PLAYERS = new Player("No Player", null, 0);
        public static final Player UNKNOWN = new Player("Unknown", null, 0);
        private static int nPlayers = 0;
        private final String name;
        private final SymbolSet.SymbolData hiddenSymbol;
        private final int hiddenPieceOptions;
        private final int order;
        private final SortedSet<Player> allies = new TreeSet<Player>(Comparator.comparingInt(p -> p.order));

        public Player(String name, SymbolSet.SymbolData hiddenSymbol, int hiddenPieceOptions) {
            this.name = name;
            this.hiddenSymbol = hiddenSymbol;
            this.hiddenPieceOptions = hiddenPieceOptions;
            this.order = nPlayers++;
            this.allies.add(this);
        }

        public boolean useHiddenPieces() {
            return (this.hiddenPieceOptions & 1) > 0;
        }

        public boolean hiddenWhenPlaced() {
            return (this.hiddenPieceOptions & 2) > 0;
        }

        public boolean hiddenInForcePools() {
            return (this.hiddenPieceOptions & 4) > 0 || this.hiddenWhenPlaced();
        }

        public boolean isGameMaster() {
            return (this.hiddenPieceOptions & 8) > 0;
        }

        public SymbolSet.SymbolData getHiddenSymbol() {
            return this.hiddenSymbol;
        }

        public String getName() {
            StringBuilder sb = new StringBuilder();
            for (Player p : this.allies) {
                if (sb.length() > 0) {
                    sb.append('/');
                }
                sb.append(p.name);
            }
            return sb.toString();
        }

        public void setAlly(Player player) {
            this.allies.add(player);
        }

        public boolean isAlly(Player player) {
            return this.allies.contains(player);
        }

        public String toString() {
            return this.getName();
        }
    }

    public class Pool {
        public final String name;
        public final List<Piece> pieces;

        Pool(String name, List<Piece> pieces) {
            this.name = name;
            this.pieces = pieces;
        }

        List<Piece> getPieces() {
            if (this.pieces == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(this.pieces);
        }

        String getButtonName() {
            return this.name;
        }

        boolean isUseable() {
            return true;
        }
    }

    public class Cards
    extends Pool {
        protected Player owner;

        Cards(String name, List<Piece> pieces) {
            super(name, pieces);
            if (pieces != null) {
                pieces.removeIf(piece -> !piece.isCard());
            }
        }

        public void setOwner(int owner) {
            this.owner = owner == 201 ? Player.NO_PLAYERS : (owner >= 200 ? Player.ALL_PLAYERS : (owner >= ADC2Module.this.players.size() ? Player.UNKNOWN : ADC2Module.this.players.get(owner)));
        }

        public Player getOwner() {
            return this.owner;
        }
    }

    public static enum FacingDirection {
        FLAT_SIDES,
        VERTEX,
        BOTH,
        NONE;

    }

    public class HandPool
    extends Cards {
        HandPool(String name, List<Piece> pieces) {
            super(name, pieces);
        }

        @Override
        String getButtonName() {
            return super.getButtonName() + " (" + this.getOwner().getName() + " Hand)";
        }
    }

    public class DeckPool
    extends Cards {
        DeckPool(String name, List<Piece> pieces) {
            super(name, pieces);
        }
    }

    public class ForcePool
    extends Pool {
        @Override
        boolean isUseable() {
            if (!this.getPieces().isEmpty()) {
                return true;
            }
            if (this.name == null) {
                return false;
            }
            for (int i = 0; i < this.name.length(); ++i) {
                if (!Character.isLetterOrDigit(this.name.charAt(i))) continue;
                return true;
            }
            return false;
        }

        ForcePool(String name, List<Piece> pieces) {
            super(name, pieces);
        }
    }

    public static enum ValueType {
        NOT_USED,
        NUMERIC,
        TEXT,
        YESNO,
        CARD;

    }

    public static enum HideState {
        NOT_HIDDEN,
        INFO_HIDDEN,
        HIDDEN;

    }

    public class Piece {
        private static final String PIECE_PROPERTIES = "Piece Properties";
        public final PieceClass pieceClass;
        public final HideState hideState;
        private final int[] values = new int[8];
        private final ValueType[] types = new ValueType[8];
        private final String name;
        private final int flags;
        private final int facing;
        private GamePiece gamePiece;
        private PieceSlot pieceSlot;
        private final int position;
        private PropertySheet classPS = null;
        private PropertySheet piecePS = null;
        private Marker pieceNameMarker = null;

        public Piece(PieceClass cl) {
            this.name = null;
            this.pieceClass = cl;
            this.flags = 0;
            this.hideState = null;
            this.position = -1;
            this.facing = 0;
        }

        public Piece(int position, String name, PieceClass cl, HideState hidden, int flags, int facing) {
            this.name = name == null || name.equals("") ? null : name;
            this.position = position;
            this.pieceClass = cl;
            this.flags = flags;
            assert (hidden != null);
            this.hideState = hidden;
            this.facing = facing;
            java.util.Map<Integer, List<Piece>> hash = this.inForcePool() ? ADC2Module.this.forcePoolHashMap : ADC2Module.this.stacks;
            List<Piece> stack = hash.get(position);
            if (stack == null) {
                stack = new ArrayList<Piece>();
                stack.add(this);
                hash.put(position, stack);
            } else {
                stack.add(0, this);
            }
        }

        public Pool getForcePool() {
            if (this.inForcePool()) {
                return (Pool)ADC2Module.this.forcePools.get(this.position);
            }
            return null;
        }

        public boolean isCard() {
            return this.types[0] == ValueType.CARD;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Piece)) {
                return false;
            }
            return this.getUniqueClassName().equals(((Piece)obj).getUniqueClassName()) && this.pieceClass == ((Piece)obj).pieceClass;
        }

        public int hashCode() {
            return this.getUniqueClassName().hashCode();
        }

        protected void setValue(int index, int value) {
            this.values[index] = value;
            this.types[index] = ValueType.NUMERIC;
        }

        protected void writeToArchive(SetupStack parent) throws IOException {
            GamePiece gp = this.getGamePiece();
            if (gp == null) {
                return;
            }
            assert (this.pieceSlot == null);
            this.pieceSlot = new PieceSlot(gp);
            ADC2Module.insertComponent(this.pieceSlot, parent);
        }

        protected void writeToArchive(DrawPile parent) throws IOException {
            GamePiece gp = this.getGamePiece();
            if (gp == null) {
                return;
            }
            assert (this.pieceSlot == null);
            this.pieceSlot = new CardSlot();
            this.pieceSlot.setPiece(gp);
            ADC2Module.insertComponent(this.pieceSlot, parent);
        }

        public Player getPlayer() {
            return this.pieceClass.getOwner();
        }

        public boolean inForcePool() {
            return (this.flags & 8) > 0;
        }

        protected GamePiece getGamePiece() throws IOException {
            if (this.gamePiece == null) {
                this.gamePiece = this.getBasicPiece();
                if (this.gamePiece == null) {
                    return null;
                }
                this.appendDecorator(this.getPieceNameMarker());
                this.appendDecorator(this.getDynamicProperty());
                this.appendDecorator(this.getPieceValueMask());
                this.appendDecorator(this.getMovementMarkable());
                this.appendDecorator(this.getDefendedEmbellishment());
                this.appendDecorator(this.getAttackedEmbellishment());
                this.appendDecorator(this.getFreeRotator());
                this.appendDecorator(this.getUsePrototype());
                this.appendDecorator(this.getPiecePropertySheet());
                this.appendDecorator(this.getReplaceWithPrevious());
                this.appendDecorator(this.getReplaceWithOther());
                this.appendDecorator(this.getClassPropertySheet());
                this.appendDecorator(this.getHidden());
            }
            return this.gamePiece;
        }

        private Decorator getReplaceWithPrevious() throws IOException {
            return this.pieceClass.getReplaceWithPreviousDecorator();
        }

        private Decorator getReplaceWithOther() throws IOException {
            return this.pieceClass.getReplaceWithOtherDecorator();
        }

        private Marker getPieceNameMarker() {
            if (this.pieceNameMarker == null) {
                if (this.name != null && this.name.length() > 0) {
                    usePieceNames = true;
                }
                this.pieceNameMarker = new Marker("mark;pcName", null);
                SequenceEncoder se = new SequenceEncoder(',');
                se.append(this.name == null ? "" : this.name);
                this.pieceNameMarker.mySetState(se.getValue());
            }
            return this.pieceNameMarker;
        }

        private void appendDecorator(Decorator p) {
            if (p != null) {
                p.setInner(this.gamePiece);
                this.gamePiece = p;
            }
        }

        protected Decorator getHidden() throws IOException {
            Player player;
            Decorator p = this.pieceClass.getHiddenDecorator();
            if (p != null && this.isHidden() && (player = this.pieceClass.getPlayer(this)) != Player.ALL_PLAYERS && player != Player.NO_PLAYERS) {
                p.mySetState(player.getName());
            }
            return p;
        }

        private boolean isHidden() {
            return this.pieceClass.checkHidden(this);
        }

        protected Obscurable getPieceValueMask() throws IOException {
            if (ADC2Module.this.usePieceValues()) {
                Obscurable p = this.pieceClass.getPieceValueMask();
                if (p != null && this.hideState == HideState.INFO_HIDDEN) {
                    p.mySetState(this.getPlayer().getName());
                }
                return p;
            }
            return null;
        }

        protected UsePrototype getUsePrototype() {
            return this.pieceClass.getUsePrototypeDecorator();
        }

        public double getFacingAngle() {
            if (this.facing >= FACING_ANGLES.length) {
                return 0.0;
            }
            return FACING_ANGLES[this.facing];
        }

        protected Embellishment getDefendedEmbellishment() throws IOException {
            Embellishment layer = this.pieceClass.getDefendedEmbellishmentDecorator();
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.hasDefended() ? 1 : -1).append("");
            layer.mySetState(se.getValue());
            return layer;
        }

        protected Embellishment getAttackedEmbellishment() throws IOException {
            Embellishment layer = this.pieceClass.getAttackedEmbellishmentDecorator();
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.hasAttacked() ? 1 : -1).append("");
            layer.mySetState(se.getValue());
            return layer;
        }

        protected FreeRotator getFreeRotator() {
            FreeRotator p = this.pieceClass.getFreeRotatorDecorator();
            if (p != null) {
                p.setAngle(this.getFacingAngle());
            }
            return p;
        }

        protected MovementMarkable getMovementMarkable() throws IOException {
            MovementMarkable p = this.pieceClass.getMovementMarkableDecorator();
            if (p != null) {
                p.setMoved(this.hasMoved());
            }
            return p;
        }

        protected PropertySheet getPiecePropertySheet() {
            if (this.piecePS == null) {
                this.piecePS = new PropertySheet();
                SequenceEncoder se = new SequenceEncoder('~');
                SequenceEncoder state = new SequenceEncoder('~');
                for (int i = 0; i < ADC2Module.this.pieceValues.length; ++i) {
                    if (ADC2Module.this.pieceValues[i] == null || ADC2Module.this.pieceValues[i].equals("")) continue;
                    se.append("0" + ADC2Module.this.pieceValues[i]);
                    Object o = this.getValue(i);
                    if (o instanceof String) {
                        state.append((String)o);
                        continue;
                    }
                    if (o instanceof Integer) {
                        state.append(o.toString());
                        continue;
                    }
                    if (o instanceof Boolean) {
                        state.append(o.equals(Boolean.TRUE) ? "yes" : "no");
                        continue;
                    }
                    state.append("");
                }
                String definition = se.getValue();
                Object st = this.piecePS.myGetState();
                if (st == null) {
                    st = state.getValue();
                } else if (state.getValue() != null) {
                    st = this.piecePS.myGetState() + "~" + state.getValue();
                }
                if (definition != null && definition.length() > 0) {
                    se = new SequenceEncoder(';');
                    se.append(definition);
                    se.append(PIECE_PROPERTIES);
                    se.append('P');
                    se.append(0);
                    se.append("").append("").append("");
                    this.piecePS.mySetType("propertysheet;" + se.getValue());
                    this.piecePS.mySetState((String)st);
                } else {
                    this.piecePS = null;
                }
            }
            return this.piecePS;
        }

        protected PropertySheet getClassPropertySheet() {
            if (this.classPS == null) {
                this.classPS = this.pieceClass.getPropertySheetDecorator();
            }
            return this.classPS;
        }

        protected DynamicProperty getDynamicProperty() {
            DynamicProperty dp = this.pieceClass.getDynamicPropertyDecorator();
            dp.setInner(this.gamePiece);
            dp.setValue(this.drawOnTopOfOthers() ? "1" : "0");
            return dp;
        }

        protected GamePiece getBasicPiece() throws IOException {
            String fileName = this.pieceClass.getImageName();
            if (fileName == null) {
                return null;
            }
            SequenceEncoder se = new SequenceEncoder("piece;", ';');
            se.append("").append("").append(fileName).append(this.getUniqueClassName());
            return new BasicPiece(se.getValue());
        }

        public boolean hasAttacked() {
            return (this.flags & 1) > 0;
        }

        public boolean hasDefended() {
            return !this.hasAttacked() && (this.flags & 2) > 0;
        }

        public boolean hasMoved() {
            return (this.flags & 4) > 0;
        }

        public boolean drawOnTopOfOthers() {
            return (this.flags & 0x10) > 0;
        }

        public String getUniqueClassName() {
            return this.pieceClass.getUniqueName();
        }

        public String getClassName() {
            return this.pieceClass.getName();
        }

        protected void setValue(int index, String value) {
            byte[] b = value.getBytes(StandardCharsets.US_ASCII);
            int result = 0;
            for (int i = 0; i < 4; ++i) {
                result = (result << 8) + (b[i] & 0xFF);
            }
            this.values[index] = result;
            this.types[index] = ValueType.TEXT;
        }

        protected void setValue(int index, boolean value) {
            this.values[index] = value ? 1 : 0;
            this.types[index] = ValueType.YESNO;
        }

        private int getValueAsInt(int index) {
            return this.values[index];
        }

        private String getValueAsString(int index) {
            byte[] b = new byte[4];
            int mask = 0x7F000000;
            int length = 0;
            for (int i = 0; i < b.length; ++i) {
                b[i] = (byte)((this.values[index] & mask) >> (3 - i) * 8);
                if (b[i] < 32 || b[i] > 126) break;
                ++length;
                mask >>= 8;
            }
            return new String(b, 0, length, StandardCharsets.US_ASCII);
        }

        private boolean getValueAsBoolean(int index) {
            return this.values[index] > 0;
        }

        public Object getValue(int index) {
            if (this.types[index] == null) {
                return null;
            }
            switch (this.types[index]) {
                case NUMERIC: {
                    return this.getValueAsInt(index);
                }
                case TEXT: {
                    return this.getValueAsString(index);
                }
                case YESNO: {
                    return this.getValueAsBoolean(index);
                }
            }
            return null;
        }

        protected void writeToArchive(ListWidget list) throws IOException {
            GamePiece gp = this.getGamePiece();
            if (gp == null) {
                return;
            }
            this.pieceSlot = new PieceSlot(gp);
            ADC2Module.insertComponent(this.pieceSlot, list);
        }

        protected PieceSlot getPieceSlot() {
            return this.pieceSlot;
        }
    }

    public class CardClass
    extends PieceClass {
        private final int setIndex;
        private final int symbolIndex;

        public CardClass(String name, int symbolIndex, int setIndex) {
            super(name, null, 200, 30001, 0);
            this.setIndex = setIndex;
            this.symbolIndex = symbolIndex;
        }

        @Override
        public String getHiddenName() {
            if (this.getOwner() == Player.NO_PLAYERS || this.getOwner() == Player.ALL_PLAYERS) {
                return "Unknown card";
            }
            return "Unknown " + this.getOwner().getName() + " card";
        }

        @Override
        public SymbolSet.SymbolData getHiddenSymbol() throws IOException {
            return ADC2Module.this.getCardDeck(this.setIndex).getGamePiece(0);
        }

        @Override
        protected SymbolSet.SymbolData getSymbol() throws IOException {
            if (this.symbol == null) {
                SymbolSet set = ADC2Module.this.getCardDeck(this.setIndex);
                this.symbol = set.getGamePiece(this.symbolIndex);
            }
            return this.symbol;
        }

        @Override
        protected void setValue(int index, boolean value) {
            assert (false);
        }

        @Override
        protected void setValue(int index, int value) {
            assert (false);
        }

        @Override
        protected void setValue(int index, String value) {
            assert (false);
        }

        @Override
        public FreeRotator getFreeRotatorDecorator() {
            return null;
        }

        @Override
        public Obscurable getPieceValueMask() throws IOException {
            return null;
        }

        @Override
        public boolean checkHidden(Piece piece) {
            if (piece.getForcePool() == null) {
                return piece.hideState == HideState.HIDDEN;
            }
            if (piece.getForcePool() instanceof HandPool) {
                Player player = this.getPlayer(piece);
                return player != Player.ALL_PLAYERS && player != Player.NO_PLAYERS;
            }
            return false;
        }

        @Override
        public PropertySheet getPropertySheetDecorator() {
            return null;
        }

        @Override
        public Obscurable getHiddenDecorator() throws IOException {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(NamedKeyStroke.of(KeyStroke.getKeyStroke(72, 128)));
            se.append(this.getHiddenSymbol().getFileName());
            se.append("Hide Piece");
            BufferedImage image = this.getSymbol().getImage();
            se.append("G" + ADC2Module.this.getFlagLayer(new Dimension(image.getWidth(), image.getHeight()), StateFlag.MARKER));
            se.append(this.getHiddenName());
            if (this.getOwner() == Player.NO_PLAYERS || this.getOwner() == Player.ALL_PLAYERS) {
                se.append("side:");
            } else {
                se.append("sides:" + this.getOwner().getName());
            }
            Obscurable p = new Obscurable();
            p.mySetType("obs;" + se.getValue());
            return p;
        }

        @Override
        public Player getOwner() {
            return Player.ALL_PLAYERS;
        }

        @Override
        public Player getPlayer(Piece p) {
            if (p.inForcePool() && p.getForcePool() instanceof HandPool) {
                return ((HandPool)p.getForcePool()).getOwner();
            }
            return this.getOwner();
        }
    }
}

