/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.GameModule;
import VASSAL.build.module.ExtensionsLoader;
import VASSAL.build.module.ExtensionsManager;
import VASSAL.build.module.ModuleExtension;
import VASSAL.build.module.ModulePlugin;
import VASSAL.command.Command;
import VASSAL.i18n.Resources;
import VASSAL.tools.DataArchive;
import VASSAL.tools.SequenceEncoder;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipException;

public class PluginsLoader
extends ExtensionsLoader {
    public static final String COMMAND_PREFIX = "PLUGIN\t";
    private final ExtensionsManager extMgr = new ExtensionsManager("plugins");

    @Override
    public void addTo(GameModule mod) {
        mod.addCommandEncoder(this);
        for (File ext : this.extMgr.getActiveExtensions()) {
            this.addExtension(ext);
        }
    }

    @Override
    protected ModuleExtension createExtension(String extname) throws ZipException, IOException {
        return new ModulePlugin(new DataArchive(extname));
    }

    @Override
    public Command decode(String command) {
        if (command.startsWith(COMMAND_PREFIX)) {
            SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(command.substring(COMMAND_PREFIX.length()), '\t');
            return new ModulePlugin.RegCmd(st.nextToken(), st.nextToken());
        }
        return super.decode(command);
    }

    @Override
    public String encode(Command c) {
        if (c instanceof ModulePlugin.RegCmd) {
            ModulePlugin.RegCmd cmd = (ModulePlugin.RegCmd)c;
            SequenceEncoder se = new SequenceEncoder('\t');
            se.append(cmd.getName()).append(cmd.getVersion());
            return COMMAND_PREFIX + se.getValue();
        }
        return super.encode(c);
    }

    public static String getPluginDirectory() {
        return new ExtensionsManager("plugins").getExtensionsDirectory(false).getPath();
    }

    @Override
    protected String getLoadedMessage(String name, String version) {
        return Resources.getString("PluginsLoader.plugin_loaded", name, version);
    }

    @Override
    protected String getErrorMessage(String name, String msg) {
        return Resources.getString("PluginsLoader.unable_to_load", name, msg);
    }

    public static interface PluginElement {
    }
}

