/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.Info;
import VASSAL.i18n.Resources;
import VASSAL.launch.ModuleManagerWindow;
import VASSAL.tools.DataArchive;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.image.tilecache.ImageTileDiskCache;
import VASSAL.tools.image.tilecache.TileUtils;
import VASSAL.tools.io.ArgEncoding;
import VASSAL.tools.io.FileArchive;
import VASSAL.tools.io.FileStore;
import VASSAL.tools.io.InputOutputStreamPump;
import VASSAL.tools.io.ProcessLauncher;
import VASSAL.tools.io.ProcessWrapper;
import VASSAL.tools.lang.Pair;
import VASSAL.tools.swing.EDT;
import VASSAL.tools.swing.ProgressDialog;
import VASSAL.tools.swing.Progressor;
import java.awt.Dimension;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TilingHandler {
    private static final Logger logger = LoggerFactory.getLogger(TilingHandler.class);
    protected final String aname;
    protected final File cdir;
    protected final Dimension tdim;
    protected final int maxheap_limit;
    @Deprecated(since="2021-12-01", forRemoval=true)
    protected final int pid = 42;

    public TilingHandler(String aname, File cdir, Dimension tdim, int mhlim) {
        this.aname = aname;
        this.cdir = cdir;
        this.tdim = tdim;
        this.maxheap_limit = mhlim;
    }

    @Deprecated(since="2021-12-01", forRemoval=true)
    public TilingHandler(String aname, File cdir, Dimension tdim, int mhlim, int pid) {
        this(aname, cdir, tdim, mhlim);
    }

    protected boolean isFresh(FileArchive archive, FileStore tcache, String ipath) throws IOException {
        String tpath = TileUtils.tileName(ipath, 0, 0, 1);
        long imtime = archive.getMTime(ipath);
        return imtime > 0L && imtime <= tcache.getMTime(tpath);
    }

    protected Dimension getImageSize(DataArchive archive, String ipath) throws IOException {
        try (InputStream in = archive.getInputStream(ipath);){
            Dimension dimension = ImageUtils.getImageSize(ipath, in);
            return dimension;
        }
    }

    protected Pair<Integer, Integer> findImages(DataArchive archive, FileStore tcache, List<String> multi, List<Pair<String, IOException>> failed) throws IOException {
        SortedSet<String> images = archive.getImageNameSet(true, true);
        int maxpix = 0;
        int tcount = 0;
        FileArchive fa = archive.getArchive();
        for (String ipath : images) {
            int t;
            Dimension idim;
            if (this.isFresh(fa, tcache, ipath)) continue;
            try {
                idim = this.getImageSize(archive, ipath);
            }
            catch (IOException e) {
                failed.add(Pair.of(ipath, e));
                continue;
            }
            int n = t = TileUtils.tileCountAtScale(idim, this.tdim, 1) > 1 ? TileUtils.tileCount(idim, this.tdim) : 0;
            if (t == 0) continue;
            tcount += t;
            multi.add(ipath);
            if (idim.width * idim.height <= maxpix) continue;
            maxpix = idim.width * idim.height;
        }
        return new Pair<Integer, Integer>(tcount, maxpix);
    }

    protected String[] makeSlicerCommandLine(int heap) {
        ArrayList<String> args = new ArrayList<String>(List.of(Info.getJavaBinPath().getAbsolutePath(), "-classpath", System.getProperty("java.class.path"), "-Xmx" + heap + "M", "-Duser.home=" + System.getProperty("user.home"), "VASSAL.tools.image.tilecache.ZipFileImageTiler"));
        String cdirpath = this.cdir.getAbsolutePath();
        if (ArgEncoding.requires(this.aname) || ArgEncoding.requires(cdirpath)) {
            args.add("--encoded-args");
            args.add(ArgEncoding.encode(this.aname));
            args.add(ArgEncoding.encode(cdirpath));
        } else {
            args.add(this.aname);
            args.add(cdirpath);
        }
        args.add(String.valueOf(this.tdim.width));
        args.add(String.valueOf(this.tdim.height));
        return args.toArray(new String[0]);
    }

    protected StateMachineHandler createStateMachineHandler(int tcount, Future<Integer> fut) {
        return new MyStateMachineHandler(tcount, fut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runSlicer(List<String> multi, int tcount, int maxheap) throws CancellationException, IOException {
        block25: {
            maxheap = Math.min(maxheap, this.maxheap_limit);
            String[] args = this.makeSlicerCommandLine(maxheap);
            InputOutputStreamPump errP = new InputOutputStreamPump(null, System.err);
            ProcessWrapper proc = new ProcessLauncher().launch(null, null, errP, args);
            StateMachineHandler h = this.createStateMachineHandler(tcount, proc.future);
            try (DataInputStream in = new DataInputStream(proc.stdout);){
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    byte b;
                    while ((b = in.readByte()) != 1) {
                        baos.write(b);
                    }
                }
                finally {
                    if (baos.size() > 0) {
                        logger.error(baos.toString(StandardCharsets.UTF_8));
                    }
                }
                new Thread(() -> {
                    try (PrintWriter stdin = new PrintWriter(proc.stdin, true, StandardCharsets.UTF_8);){
                        multi.forEach(stdin::println);
                    }
                }).start();
                h.handleStart();
                boolean done = false;
                block18: while (!done && !proc.future.isCancelled()) {
                    byte type = in.readByte();
                    switch (type) {
                        case 2: {
                            h.handleStartingImageState(in.readUTF());
                            continue block18;
                        }
                        case 3: {
                            h.handleTileWrittenState();
                            continue block18;
                        }
                        case 4: {
                            done = true;
                            h.handleTilingFinishedState();
                            continue block18;
                        }
                    }
                    throw new IllegalStateException("bad type: " + type);
                }
            }
            catch (IOException e) {
                logger.error("Error during tiling", (Throwable)e);
            }
            try {
                int retval = proc.future.get();
                if (retval == 0) {
                    h.handleSuccess();
                    break block25;
                }
                h.handleFailure();
                proc.future.cancel(true);
                logger.info("Tiling failed with return value == " + retval);
                if (maxheap < this.maxheap_limit) {
                    logger.info("Tiling possibly ran out of memory. Retrying tiling with 50% more.");
                    this.runSlicer(multi, tcount, (int)((double)maxheap * 1.5));
                    break block25;
                }
                throw new IOException("return value == " + retval);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    protected void makeHashDirs() throws IOException {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                File d = new File(String.format("%s/%1x/%1x%1x", this.cdir, i, i, j));
                FileUtils.forceMkdir((File)d);
            }
        }
    }

    protected void cleanup() throws IOException {
        FileUtils.forceDelete((File)this.cdir);
    }

    public void sliceTiles() throws CancellationException, IOException {
        Pair<Integer, Integer> s;
        ArrayList<String> multi = new ArrayList<String>();
        ArrayList<Pair<String, IOException>> failed = new ArrayList<Pair<String, IOException>>();
        try (DataArchive archive = new DataArchive(this.aname);){
            ImageTileDiskCache tcache = new ImageTileDiskCache(this.cdir.getAbsolutePath());
            s = this.findImages(archive, tcache, multi, failed);
        }
        if (multi.isEmpty()) {
            logger.info("No images to tile.");
            return;
        }
        this.makeHashDirs();
        int max_data_mbytes = 4 * (Integer)s.second >> 20;
        int maxheap = (int)(1.66 * (double)max_data_mbytes + 150.0);
        try {
            this.runSlicer(multi, (Integer)s.first, maxheap);
        }
        catch (IOException | CancellationException e) {
            this.cleanup();
            throw e;
        }
    }

    private static class MyStateMachineHandler
    implements StateMachineHandler {
        private final Future<Integer> fut;
        private final int tcount;
        private final ProgressDialog pd;
        private final Progressor progressor;

        public MyStateMachineHandler(int tcount, Future<Integer> fut) {
            this.tcount = tcount;
            this.fut = fut;
            this.pd = ProgressDialog.createOnEDT(ModuleManagerWindow.getInstance(), Resources.getString("TilingHandler.processing_image_tiles"), " ");
            this.progressor = new Progressor(0, tcount){

                @Override
                protected void run(Pair<Integer, Integer> prog) {
                    pd.setProgress(100 * (Integer)prog.second / this.max);
                }
            };
        }

        @Override
        public void handleStart() {
            EDT.execute(() -> this.pd.addActionListener(e -> {
                this.pd.setVisible(false);
                this.fut.cancel(true);
            }));
        }

        @Override
        public void handleStartingImageState(String ipath) {
            EDT.execute(() -> {
                this.pd.setLabel(Resources.getString("TilingHandler.tiling", ipath));
                if (!this.pd.isVisible()) {
                    this.pd.setVisible(true);
                }
            });
        }

        @Override
        public void handleTileWrittenState() {
            this.progressor.increment();
            if (this.progressor.get() >= this.tcount) {
                this.pd.setVisible(false);
            }
        }

        @Override
        public void handleTilingFinishedState() {
        }

        @Override
        public void handleSuccess() {
        }

        @Override
        public void handleFailure() {
            this.pd.setVisible(false);
        }
    }

    protected static interface StateMachineHandler {
        public void handleStart();

        public void handleStartingImageState(String var1);

        public void handleTileWrittenState();

        public void handleTilingFinishedState();

        public void handleSuccess();

        public void handleFailure();
    }
}

