/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.swing;

import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import org.apache.commons.lang3.SystemUtils;

public class SplitPane
extends JSplitPane {
    private static final long serialVersionUID = 1L;
    private int prevDividerLocation = 0;
    private int prevDividerSize = 0;

    public SplitPane(int orientation, Component first, Component second) {
        super(orientation, first, second);
        this.setDividerLocation(0.5);
        this.setContinuousLayout(true);
    }

    public void setLeftVisible(boolean vis) {
        this.setComponentVisible(this.leftComponent, vis);
    }

    public void setRightVisible(boolean vis) {
        this.setComponentVisible(this.rightComponent, vis);
    }

    public void setTopVisible(boolean vis) {
        this.setComponentVisible(this.leftComponent, vis);
    }

    public void setBottomVisible(boolean vis) {
        this.setComponentVisible(this.rightComponent, vis);
    }

    private void setComponentVisible(Component c, boolean vis) {
        if (c != null && c.isVisible() != vis) {
            this.toggleComponent(c);
        }
    }

    public boolean isLeftVisible() {
        return this.leftComponent != null && this.leftComponent.isVisible();
    }

    public boolean isRightVisible() {
        return this.rightComponent != null && this.rightComponent.isVisible();
    }

    public boolean isTopVisible() {
        return this.leftComponent != null && this.leftComponent.isVisible();
    }

    public boolean isBottomVisible() {
        return this.rightComponent != null && this.rightComponent.isVisible();
    }

    public void showLeft() {
        this.showComponent(this.leftComponent);
    }

    public void showRight() {
        this.showComponent(this.rightComponent);
    }

    public void showTop() {
        this.showComponent(this.leftComponent);
    }

    public void showBottom() {
        this.showComponent(this.rightComponent);
    }

    private void showComponent(Component c) {
        if (c != null && !c.isVisible()) {
            this.toggleComponent(c);
        }
    }

    public void hideLeft() {
        this.hideComponent(this.leftComponent);
    }

    public void hideRight() {
        this.hideComponent(this.rightComponent);
    }

    public void hideTop() {
        this.hideComponent(this.leftComponent);
    }

    public void hideBottom() {
        this.hideComponent(this.rightComponent);
    }

    private void hideComponent(Component c) {
        if (c != null && c.isVisible()) {
            this.toggleComponent(c);
        }
    }

    public void toggleLeft() {
        this.toggleComponent(this.leftComponent);
    }

    public void toggleRight() {
        this.toggleComponent(this.rightComponent);
    }

    public void toggleTop() {
        this.toggleComponent(this.leftComponent);
    }

    public void toggleBottom() {
        this.toggleComponent(this.rightComponent);
    }

    private void toggleComponent(Component c) {
        if (c != null) {
            c.setVisible(!c.isVisible());
            int tmp = this.getDividerSize();
            this.setDividerSize(this.prevDividerSize);
            this.prevDividerSize = tmp;
            tmp = this.getDividerLocation();
            this.setDividerLocation(this.prevDividerLocation);
            this.prevDividerLocation = tmp;
        }
    }

    public static void main(String[] args) throws Exception {
        if (!SystemUtils.IS_OS_WINDOWS) {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        JButton left = new JButton("Left");
        JButton right = new JButton("Right");
        SplitPane sp = new SplitPane(1, left, right);
        left.addActionListener(e -> {
            if (left.isVisible() && right.isVisible()) {
                sp.toggleLeft();
            } else {
                sp.toggleRight();
            }
        });
        right.addActionListener(e -> {
            if (left.isVisible() && right.isVisible()) {
                sp.toggleRight();
            } else {
                sp.toggleLeft();
            }
        });
        JFrame f = new JFrame();
        f.add((Component)sp, "Center");
        f.setSize(400, 300);
        f.setDefaultCloseOperation(3);
        f.setLocationRelativeTo(null);
        f.setVisible(true);
    }
}

