/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.module.gamepieceimage.ColorSwatch;
import VASSAL.build.module.gamepieceimage.ColorSwatchConfigurer;
import VASSAL.build.module.gamepieceimage.GamePieceImage;
import VASSAL.build.module.gamepieceimage.ItemInstance;
import VASSAL.build.module.gamepieceimage.SizeConfigurer;
import VASSAL.build.module.gamepieceimage.SymbolConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.i18n.Resources;
import VASSAL.tools.SequenceEncoder;

public class SymbolItemInstance
extends ItemInstance {
    public static final String SIZE = "size";
    public static final String SIZE_COLOR = "sizeColor";
    public static final String SYMBOL1 = "symbol1";
    public static final String SYMBOL2 = "symbol2";
    protected String size;
    protected String symbol1;
    protected String symbol2;
    private ColorSwatch sizeColor = ColorSwatch.getBlack();

    public SymbolItemInstance() {
    }

    public SymbolItemInstance(String nam, String typ, String loc, String sz, String s1, String s2) {
        super(nam, typ, loc);
        this.setSize(sz);
        this.setSymbol1(s1);
        this.setSymbol2(s2);
    }

    public SymbolItemInstance(String code, GamePieceImage defn) {
        super(defn);
        this.decode(code);
    }

    @Override
    public String encode() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.getType());
        se.append(this.getName());
        se.append(this.getLocation());
        se.append(this.getFgColor().encode());
        se.append(this.getBgColor().encode());
        se.append(this.getSize());
        se.append(this.getSymbol1());
        se.append(this.getSymbol2());
        se.append(this.getSizeColor().encode());
        return se.getValue();
    }

    public void decode(String code) {
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(code, ';');
        this.setType(sd.nextToken(""));
        this.setName(sd.nextToken(""));
        this.setLocation(sd.nextToken(""));
        this.setFgColor(new ColorSwatch(sd.nextToken("")));
        this.setBgColor(new ColorSwatch(sd.nextToken("")));
        this.setSize(sd.nextToken(""));
        this.setSymbol1(sd.nextToken(""));
        this.setSymbol2(sd.nextToken(""));
        this.setSizeColor(new ColorSwatch(sd.nextToken("")));
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getSize() {
        return this.size;
    }

    protected void setSizeColor(ColorSwatch sizeColor) {
        this.sizeColor = sizeColor;
    }

    protected ColorSwatch getSizeColor() {
        return this.sizeColor;
    }

    public void setSymbol1(String symbol1) {
        this.symbol1 = symbol1;
    }

    public String getSymbol1() {
        return this.symbol1;
    }

    public void setSymbol2(String symbol2) {
        this.symbol2 = symbol2;
    }

    public String getSymbol2() {
        return this.symbol2;
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.SymbolItemInstance.unit_size"), Resources.getString("Editor.SymbolItemInstance.first_symbol"), Resources.getString("Editor.SymbolItemInstance.second_symbol"), Resources.getString("Editor.SymbolItemInstance.symbol_color"), Resources.getString("Editor.background_color"), Resources.getString("Editor.SymbolItemInstance.size_color")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{SizeConfig.class, Symbol1Config.class, Symbol2Config.class, FgColorSwatchConfig.class, BgColorSwatchConfig.class, SizeColorSwatchConfig.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{SIZE, SYMBOL1, SYMBOL2, "fgColor", "bgColor", SIZE_COLOR};
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (SIZE.equals(key)) {
            this.size = (String)value;
        } else if (SYMBOL1.equals(key)) {
            this.symbol1 = (String)value;
        } else if (SYMBOL2.equals(key)) {
            this.symbol2 = (String)value;
        } else if ("fgColor".equals(key)) {
            if (value instanceof String) {
                value = new ColorSwatch((String)value);
            }
            this.fgColor = (ColorSwatch)value;
        } else if ("bgColor".equals(key)) {
            if (value instanceof String) {
                value = new ColorSwatch((String)value);
            }
            this.bgColor = (ColorSwatch)value;
        } else if (SIZE_COLOR.equals(key)) {
            if (value instanceof String) {
                value = new ColorSwatch((String)value);
            }
            this.sizeColor = (ColorSwatch)value;
        }
        if (this.myConfig != null) {
            this.myConfig.rebuildViz();
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (SIZE.equals(key)) {
            return this.size;
        }
        if (SYMBOL1.equals(key)) {
            return this.symbol1;
        }
        if (SYMBOL2.equals(key)) {
            return this.symbol2;
        }
        if ("fgColor".equals(key)) {
            return this.fgColor.encode();
        }
        if ("bgColor".equals(key)) {
            return this.bgColor.encode();
        }
        if (SIZE_COLOR.equals(key)) {
            return this.sizeColor.encode();
        }
        return null;
    }

    public static class SizeConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new SizeConfigurer(key, name);
        }
    }

    public static class Symbol1Config
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new SymbolConfigurer(key, name);
        }
    }

    public static class Symbol2Config
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new SymbolConfigurer(key, name);
        }
    }

    public static class FgColorSwatchConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new ColorSwatchConfigurer(key, name, ((SymbolItemInstance)c).getFgColor());
        }
    }

    public static class BgColorSwatchConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new ColorSwatchConfigurer(key, name, ((SymbolItemInstance)c).getBgColor());
        }
    }

    public static class SizeColorSwatchConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new ColorSwatchConfigurer(key, name, ((SymbolItemInstance)c).getFgColor());
        }
    }
}

