/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.net.URIBuilder;

public class HttpRequestWrapper {
    private final String baseURL;

    public HttpRequestWrapper(String baseURL) {
        this.baseURL = baseURL;
    }

    public List<String> doGet(Properties p) throws IOException {
        return this.doGet("", p);
    }

    private URI buildGet(String path, Properties props) throws IOException {
        try {
            URIBuilder b = new URIBuilder(this.baseURL + path);
            if (props != null) {
                Enumeration<Object> e = props.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String value = props.getProperty(key);
                    b.addParameter(key, value);
                }
            }
            return b.build();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    private String errorMessage(CloseableHttpResponse response) throws IOException {
        String msg = response.getCode() + " " + response.getReasonPhrase();
        String responseText = null;
        try {
            responseText = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (ParseException e) {
            throw new IOException(msg, e);
        }
        return msg + ": " + responseText;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<String> doGet(String path, Properties props) throws IOException {
        HttpGet httpGet = new HttpGet(this.buildGet(path, props));
        try (CloseableHttpClient client = HttpClients.createDefault();){
            List<String> list;
            block14: {
                CloseableHttpResponse response = client.execute((ClassicHttpRequest)httpGet);
                try {
                    list = this.getLinesOk(response, 200);
                    if (response == null) break block14;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return list;
        }
        catch (IOException e) {
            throw new IOException("Failed to " + httpGet.toString(), e);
        }
    }

    public List<String> doPost(Properties p) throws IOException {
        return this.doPost("", p);
    }

    private HttpPost buildPost(String path, Properties props) throws IOException {
        HttpPost httpPost = new HttpPost(this.baseURL + path);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = props.getProperty(key);
            params.add(new BasicNameValuePair(key, value));
        }
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        return httpPost;
    }

    public List<String> doPost(String path, Properties props) throws IOException {
        HttpPost httpPost = this.buildPost(path, props);
        try (CloseableHttpClient client = HttpClients.createDefault();){
            List<String> list;
            block12: {
                CloseableHttpResponse response = client.execute((ClassicHttpRequest)httpPost);
                try {
                    list = this.getLinesOk(response, 201);
                    if (response == null) break block12;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return list;
        }
    }

    private List<String> getLinesOk(CloseableHttpResponse response, int ok_code) throws IOException {
        if (response.getCode() == ok_code) {
            try {
                return IOUtils.readLines((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            }
            catch (UnsupportedOperationException e) {
                throw new IOException(e);
            }
        }
        throw new IOException(this.errorMessage(response));
    }
}

