/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.node;

import VASSAL.chat.HybridClient;
import VASSAL.chat.Room;
import VASSAL.chat.node.NodeClient;
import VASSAL.chat.node.NodeRoom;
import VASSAL.chat.ui.LockableRoomControls;
import VASSAL.i18n.Resources;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;

public class LockableNodeRoomControls
extends LockableRoomControls {
    public LockableNodeRoomControls(NodeClient client) {
        super(client);
    }

    @Override
    protected void addLockRoomAction(JPopupMenu popup, Room target) {
        NodeClient c = this.getNodeClient();
        if (c != null) {
            popup.add(new LockRoomAction((NodeRoom)target, c));
        }
    }

    private NodeClient getNodeClient() {
        NodeClient c = null;
        if (this.client instanceof NodeClient) {
            c = (NodeClient)this.client;
        } else if (this.client instanceof HybridClient && ((HybridClient)this.client).getDelegate() instanceof NodeClient) {
            c = (NodeClient)((HybridClient)this.client).getDelegate();
        }
        return c;
    }

    @Override
    protected void createRoom(String name) {
        Room existing = null;
        Room[] rooms = this.client.getAvailableRooms();
        for (int i = 0; existing == null && i < rooms.length; ++i) {
            if (!rooms[i].getName().equals(name)) continue;
            existing = rooms[i];
        }
        NodeClient nodeClient = this.getNodeClient();
        if (existing instanceof NodeRoom) {
            if (!((NodeRoom)existing).isLocked()) {
                this.client.setRoom(existing);
            }
        } else if (existing == null && nodeClient != null) {
            NodeRoom room = new NodeRoom(name);
            room.setOwner(nodeClient.getMyInfo().getId());
            this.client.setRoom(room);
            nodeClient.sendRoomInfo(room);
        } else {
            super.createRoom(name);
        }
    }

    class LockRoomAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final NodeClient client;
        private final NodeRoom target;

        public LockRoomAction(NodeRoom target, NodeClient client) {
            super(target.isLocked() ? Resources.getString("Chat.unlock_room") : Resources.getString("Chat.lock_room"));
            this.setEnabled(client.getMyInfo().getId().equals(target.getOwner()) && !target.getName().equals(client.getDefaultRoomName()));
            this.target = target;
            this.client = client;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.client.lockRoom(this.target);
        }
    }
}

