/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.node;

import VASSAL.chat.node.SocketWatcher;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class SocketHandler {
    private final Socket sock;
    private final SocketWatcher handler;
    private final BufferedReader reader;
    private final BufferedWriter writer;
    private final BlockingQueue<String> writeQueue = new LinkedBlockingQueue<String>();
    private boolean isOpen = true;
    private Thread readThread = null;
    private Thread writeThread = null;
    private static final String SIGN_OFF = "!BYE";

    public SocketHandler(Socket sock, SocketWatcher handler) throws IOException {
        this.sock = sock;
        this.handler = handler;
        this.reader = new BufferedReader(new InputStreamReader(sock.getInputStream(), StandardCharsets.UTF_8));
        this.writer = new BufferedWriter(new OutputStreamWriter(sock.getOutputStream(), StandardCharsets.UTF_8));
    }

    public void start() {
        if (this.readThread == null) {
            this.readThread = this.startReadThread();
        }
        if (this.writeThread == null) {
            this.writeThread = this.startWriteThread();
        }
    }

    private Thread startReadThread() {
        Runnable r = () -> {
            try {
                String line;
                while ((line = this.reader.readLine()) != null && !SIGN_OFF.equals(line)) {
                    if (line.length() <= 0) continue;
                    try {
                        this.handler.handleMessage(line);
                    }
                    catch (Exception e) {
                        System.err.println("Caught " + e.getClass().getName() + " handling " + line);
                        e.printStackTrace();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.closeSocket();
        };
        Thread t = new Thread(r, "read " + String.valueOf(this.sock.getInetAddress()));
        t.start();
        return t;
    }

    private Thread startWriteThread() {
        Runnable r = () -> {
            try {
                while (true) {
                    String line;
                    try {
                        line = this.writeQueue.poll(2L, TimeUnit.MINUTES);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    if (line != null) {
                        this.writeNext(line);
                        if (!SIGN_OFF.equals(line)) continue;
                        break;
                    }
                    this.writeLine("");
                    System.err.println("Sent keep-alive");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.closeSocket();
        };
        Thread t = new Thread(r, "write " + String.valueOf(this.sock.getInetAddress()));
        t.start();
        return t;
    }

    private void writeNext(String line) throws IOException {
        this.writer.write(line + "\n");
        this.writer.flush();
    }

    public void writeLine(String pMessage) {
        try {
            this.writeQueue.put(pMessage);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        this.writeLine(SIGN_OFF);
    }

    private void closeStreams() throws IOException {
        this.writer.close();
        this.reader.close();
    }

    private synchronized void closeSocket() {
        if (this.isOpen) {
            try {
                this.closeStreams();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.close();
            this.isOpen = false;
            this.handler.socketClosed(this);
        }
    }

    public InetAddress getInetAddress() {
        return this.sock.getInetAddress();
    }
}

