/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.ui;

import VASSAL.build.GameModule;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.Room;
import VASSAL.chat.node.NodeClient;
import VASSAL.chat.node.NodeRoom;
import VASSAL.chat.ui.RoomActionFactory;
import VASSAL.i18n.Resources;
import VASSAL.tools.swing.Dialogs;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;

public class JoinRoomAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private final Room r;
    private final ChatServerConnection client;

    public JoinRoomAction(Room r, ChatServerConnection client) {
        super(Resources.getString("Chat.join_room"));
        this.r = r;
        this.client = client;
        this.setEnabled(r != null && !r.equals(client.getRoom()));
    }

    public static void explainMainRoom() {
        GameModule.getGameModule().warn(Resources.getString("Chat.explain_main_room"));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        ArrayList<String> errors;
        boolean compatible;
        if (this.client instanceof NodeClient && !(compatible = ((NodeClient)this.client).checkCompatibility((NodeRoom)this.r, errors = new ArrayList<String>()))) {
            StringBuilder sb = new StringBuilder();
            sb.append(Resources.getString("Chat.join_issue", this.r.getName())).append("\n\n");
            for (String error : errors) {
                sb.append(" - ").append(error).append('\n');
            }
            sb.append('\n').append(Resources.getString("Chat.are_you_sure"));
            Dialogs.showMessageDialog(GameModule.getGameModule().getPlayerWindow(), Resources.getString("Chat.vassal_configuration_error"), Resources.getString("Chat.vassal_configuration_error"), sb.toString(), 1);
        }
        this.client.setRoom(this.r);
        if (this.r != null) {
            GameModule gm = GameModule.getGameModule();
            gm.warn(Resources.getString("Chat.joining_room", this.r.getName()));
            if (Resources.getString("Chat.main_room").equals(this.r.getName())) {
                JoinRoomAction.explainMainRoom();
            } else {
                gm.warn(Resources.getString("Chat.explain_joined_room"));
            }
        }
    }

    public static RoomActionFactory factory(ChatServerConnection chatClient) {
        return (p, tree) -> new JoinRoomAction(p, chatClient);
    }
}

