/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.BadDataReport;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.Map;
import VASSAL.build.module.map.DrawPile;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.counters.BoundsTracker;
import VASSAL.counters.Deck;
import VASSAL.counters.DeckVisitor;
import VASSAL.counters.DeckVisitorDispatcher;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.GlobalCommandTarget;
import VASSAL.counters.Mat;
import VASSAL.counters.MatCargo;
import VASSAL.counters.PieceFilter;
import VASSAL.counters.PieceIterator;
import VASSAL.counters.PropertyExporter;
import VASSAL.counters.Stack;
import VASSAL.i18n.Resources;
import VASSAL.script.expression.AuditTrail;
import VASSAL.script.expression.Auditable;
import VASSAL.script.expression.Expression;
import VASSAL.script.expression.FormattedStringExpression;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.FormattedString;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.RecursionLimitException;
import VASSAL.tools.RecursionLimiter;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.KeyStroke;

public class GlobalCommand
implements Auditable {
    protected KeyStroke keyStroke;
    protected boolean reportSingle;
    protected int selectFromDeck = -1;
    protected String selectFromDeckExpression = "-1";
    protected FormattedString reportFormat = new FormattedString();
    protected RecursionLimiter.Loopable owner;
    protected PropertySource source;
    protected GlobalCommandTarget target;
    private String fastProperty = "";
    private String fastValue = "";
    private boolean fastIsNumber = false;
    private double fastNumber = 0.0;
    private Pattern fastPattern;
    private static final Pattern fastCheckNumber = Pattern.compile("(\\+-)?\\d+(\\.\\d+)?");

    public GlobalCommand(RecursionLimiter.Loopable l) {
        this(l, null);
    }

    public GlobalCommand(RecursionLimiter.Loopable l, PropertySource p) {
        this.owner = l;
        this.source = p;
    }

    @Override
    public String getComponentTypeName() {
        return "Global Command";
    }

    @Override
    public String getComponentName() {
        return this.owner.getComponentTypeName();
    }

    public void setPropertySource(PropertySource ps) {
        this.source = ps;
    }

    public void setKeyStroke(KeyStroke keyStroke) {
        this.keyStroke = keyStroke;
    }

    public void setKeyStroke(NamedKeyStroke keyStroke) {
        this.keyStroke = keyStroke.getKeyStroke();
    }

    public void setReportFormat(String format) {
        this.reportFormat.setFormat(format);
    }

    public KeyStroke getKeyStroke() {
        return this.keyStroke;
    }

    public String getReportFormat() {
        return this.reportFormat.getFormat();
    }

    public boolean isReportSingle() {
        return this.reportSingle;
    }

    public void setReportSingle(boolean reportSingle) {
        this.reportSingle = reportSingle;
    }

    public void setTarget(GlobalCommandTarget target) {
        this.target = target;
    }

    public GlobalCommandTarget getTarget() {
        return this.target;
    }

    private boolean passesPropertyFastMatch(GamePiece gamePiece) {
        if (!this.target.fastMatchProperty || this.fastProperty.isEmpty()) {
            return true;
        }
        Object prop = gamePiece.getProperty(this.fastProperty);
        String value = prop == null ? null : prop.toString();
        switch (this.target.targetCompare) {
            case EQUALS: {
                return this.fastValue.equals(value);
            }
            case NOT_EQUALS: {
                return !this.fastValue.equals(value);
            }
        }
        if (prop == null || value == null) {
            return false;
        }
        switch (this.target.targetCompare) {
            case MATCH: {
                return this.fastPattern.matcher(value).matches();
            }
            case NOT_MATCH: {
                return !this.fastPattern.matcher(value).matches();
            }
        }
        if (!this.fastIsNumber || !this.isNumeric(value)) {
            switch (this.target.targetCompare) {
                case GREATER_EQUALS: {
                    return value.compareTo(this.fastValue) >= 0;
                }
                case GREATER: {
                    return value.compareTo(this.fastValue) > 0;
                }
                case LESS_EQUALS: {
                    return value.compareTo(this.fastValue) <= 0;
                }
                case LESS: {
                    return value.compareTo(this.fastValue) < 0;
                }
            }
        }
        double num = Double.parseDouble(value);
        switch (this.target.targetCompare) {
            case GREATER_EQUALS: {
                return num >= this.fastNumber;
            }
            case GREATER: {
                return num > this.fastNumber;
            }
            case LESS_EQUALS: {
                return num <= this.fastNumber;
            }
            case LESS: {
                return num < this.fastNumber;
            }
        }
        return false;
    }

    private boolean isNumeric(String s) {
        return fastCheckNumber.matcher(s).matches();
    }

    public Command apply(Map[] maps, PieceFilter filter, GlobalCommandTarget fastMatch) {
        return this.apply(maps, filter, fastMatch, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Command apply(Map[] maps, PieceFilter filter, GlobalCommandTarget fastMatch, AuditTrail audit) {
        Command command = new NullCommand();
        this.setTarget(fastMatch != null ? fastMatch : new GlobalCommandTarget());
        try {
            String howManyFromDeck;
            if (this.reportSingle) {
                Map.setChangeReportingEnabled(false);
            }
            RecursionLimiter.startExecution(this.owner);
            String reportText = this.reportFormat.getLocalizedText(this.source, (Auditable)this.owner, "Editor.report_format");
            if (reportText.length() > 0) {
                command = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), "*" + reportText);
                command.execute();
            }
            if (this.keyStroke == null || this.keyStroke.getKeyCode() == 0 && this.keyStroke.getModifiers() == 0) {
                NullCommand nullCommand = command;
                return nullCommand;
            }
            String fastMap = "";
            String fastBoard = "";
            String fastZone = "";
            String fastLocation = "";
            String fastDeck = "";
            String fastX = "";
            String fastY = "";
            GamePiece curPiece = this.target.getCurPiece();
            if (this.target.fastMatchLocation) {
                switch (this.target.targetType) {
                    case CURZONE: {
                        fastZone = curPiece != null ? (String)curPiece.getProperty("CurrentZone") : "";
                        break;
                    }
                    case CURLOC: {
                        fastLocation = curPiece != null ? (String)curPiece.getProperty("LocationName") : "";
                        break;
                    }
                    case ZONE: {
                        fastZone = this.target.targetZone.tryEvaluate(this.source, (Auditable)this.owner, "Editor.GlobalKeyCommand.zone_name");
                        fastZone = Expression.createExpression(fastZone).tryEvaluate(this.source, (Auditable)this.owner, "Editor.GlobalKeyCommand.zone_name");
                        break;
                    }
                    case DECK: {
                        fastDeck = this.target.targetDeck.tryEvaluate(this.source, (Auditable)this.owner, "Editor.GlobalKeyCommand.deck_name");
                        fastDeck = Expression.createExpression(fastDeck).tryEvaluate(this.source, (Auditable)this.owner, "Editor.GlobalKeyCommand.deck_name");
                        break;
                    }
                    case LOCATION: {
                        fastLocation = this.target.targetLocation.tryEvaluate(this.source, (Auditable)this.owner, "Editor.GlobalKeyCommand.location_name");
                        fastLocation = Expression.createExpression(fastLocation).tryEvaluate(this.source, (Auditable)this.owner, "Editor.GlobalKeyCommand.location_name");
                        break;
                    }
                    case XY: {
                        fastBoard = this.target.targetLocation.tryEvaluate(this.source, (Auditable)this.owner, "Editor.GlobalKeyCommand.board_name");
                        fastBoard = Expression.createExpression(fastBoard).tryEvaluate(this.source, (Auditable)this.owner, "Editor.GlobalKeyCommand.board_name");
                        fastX = this.target.targetX.tryEvaluate(this.source, (Auditable)this.owner, "Editor.GlobalKeyCommand.x_position");
                        fastX = Expression.createExpression(fastX).tryEvaluate(this.source, (Auditable)this.owner, "Editor.GlobalKeyCommand.x_position");
                        fastY = this.target.targetY.tryEvaluate(this.source, (Auditable)this.owner, "Editor.GlobalKeyCommand.y_position");
                        fastY = Expression.createExpression(fastY).tryEvaluate(this.source, (Auditable)this.owner, "Editor.GlobalKeyCommand.y_position");
                    }
                }
                if (!this.target.targetType.isCurrent()) {
                    fastMap = this.target.targetMap.tryEvaluate(this.source, (Auditable)this.owner, "Editor.GlobalKeyCommand.map_name");
                    fastMap = Expression.createExpression(fastMap).tryEvaluate(this.source, (Auditable)this.owner, "Editor.GlobalKeyCommand.map_name");
                }
            }
            if ("-1".equals(howManyFromDeck = this.getSelectFromDeckExpression())) {
                this.setSelectFromDeck(-1);
            } else if ("0".equals(howManyFromDeck)) {
                this.setSelectFromDeck(0);
            } else {
                int deckNum;
                FormattedStringExpression deckExpression = new FormattedStringExpression(howManyFromDeck);
                String deckVal = deckExpression.tryEvaluate(this.source, (Auditable)this.owner, "Editor.GlobalKeyCommand.fixed_number_of_pieces");
                deckVal = Expression.createExpression(deckVal).tryEvaluate(this.source, (Auditable)this.owner, "Editor.GlobalKeyCommand.fixed_number_of_pieces");
                try {
                    deckNum = Integer.parseInt(deckVal);
                }
                catch (NumberFormatException e) {
                    deckNum = 0;
                }
                this.setSelectFromDeck(Math.max(0, deckNum));
            }
            if (this.target.fastMatchProperty) {
                this.fastProperty = this.target.targetProperty.tryEvaluate(this.source, (Auditable)this.owner, "Editor.GlobalKeyCommand.property_name");
                this.fastProperty = Expression.createExpression(this.fastProperty).tryEvaluate(this.source, (Auditable)this.owner, "Editor.GlobalKeyCommand.property_name");
                this.fastValue = this.target.targetValue.tryEvaluate(this.source, (Auditable)this.owner, "Editor.GlobalKeyCommand.property_compare");
                this.fastValue = Expression.createExpression(this.fastValue).tryEvaluate(this.source, (Auditable)this.owner, "Editor.GlobalKeyCommand.property_compare");
                if (this.target.targetCompare == GlobalCommandTarget.CompareMode.EQUALS || this.target.targetCompare == GlobalCommandTarget.CompareMode.NOT_EQUALS) {
                    this.fastIsNumber = false;
                    this.fastNumber = 0.0;
                } else if (this.target.targetCompare == GlobalCommandTarget.CompareMode.MATCH || this.target.targetCompare == GlobalCommandTarget.CompareMode.NOT_MATCH) {
                    try {
                        this.fastPattern = Pattern.compile(this.fastValue);
                    }
                    catch (PatternSyntaxException ex) {
                        ErrorDialog.dataWarning(new BadDataReport("Fast Match - syntax error in regex: ", this.target.targetValue.getExpression()));
                        this.fastPattern = Pattern.compile("bAdMoDuLeDaTa");
                    }
                    this.fastIsNumber = false;
                    this.fastNumber = 0.0;
                } else {
                    this.fastIsNumber = this.isNumeric(this.fastValue);
                    this.fastNumber = this.fastIsNumber ? Double.parseDouble(this.fastValue) : 0.0;
                }
            }
            Visitor visitor = new Visitor(command, filter, this.keyStroke, audit);
            DeckVisitorDispatcher dispatcher = new DeckVisitorDispatcher(visitor);
            if (this.target.fastMatchLocation && this.target.targetType == GlobalCommandTarget.Target.CURSTACK) {
                if (curPiece != null) {
                    int useFromDeck;
                    Stack stack = curPiece.getParent();
                    List<GamePiece> pieces = null;
                    if (stack instanceof Deck) {
                        visitor.setSelectedCount(0);
                        int n = useFromDeck = ((Deck)stack).isAccessible() ? this.getSelectFromDeck() : 0;
                        if (useFromDeck != 0) {
                            pieces = ((Deck)stack).getOrderedPieces();
                        }
                    } else {
                        useFromDeck = -1;
                        List<GamePiece> list = pieces = stack != null ? stack.asList() : List.of(curPiece);
                    }
                    if (useFromDeck != 0) {
                        for (GamePiece gamePiece : pieces) {
                            if (!this.passesPropertyFastMatch(gamePiece)) continue;
                            dispatcher.accept(gamePiece);
                            if (useFromDeck <= 0 || visitor.getSelectedCount() < useFromDeck) continue;
                            break;
                        }
                    }
                }
            } else if (this.target.fastMatchLocation && this.target.targetType == GlobalCommandTarget.Target.DECK) {
                Deck dk;
                DrawPile d = DrawPile.findDrawPile(fastDeck);
                int useFromDeck = this.getSelectFromDeck();
                if (d != null && useFromDeck != 0 && (dk = d.getDeck()) != null && dk.isAccessible()) {
                    List<GamePiece> pieces = dk.getOrderedPieces();
                    visitor.setSelectedCount(0);
                    for (GamePiece gamePiece : pieces) {
                        if (!this.passesPropertyFastMatch(gamePiece)) continue;
                        dispatcher.accept(gamePiece);
                        if (useFromDeck <= 0 || visitor.getSelectedCount() < useFromDeck) continue;
                        break;
                    }
                }
            } else if (this.target.fastMatchLocation && this.target.targetType == GlobalCommandTarget.Target.CURMAT) {
                if (curPiece instanceof Decorator) {
                    MatCargo cargo;
                    GamePiece matPiece = Decorator.getDecorator(Decorator.getOutermost(curPiece), Mat.class);
                    if (matPiece == null && (cargo = (MatCargo)Decorator.getDecorator(Decorator.getOutermost(curPiece), MatCargo.class)) != null) {
                        matPiece = cargo.getMat();
                    }
                    if (matPiece != null) {
                        Mat mat = (Mat)Decorator.getDecorator(matPiece, Mat.class);
                        ArrayList<GamePiece> pieces = new ArrayList<GamePiece>();
                        for (GamePiece p : mat.getContents()) {
                            pieces.add(Decorator.getOutermost(p));
                        }
                        pieces.add(0, Decorator.getOutermost(matPiece));
                        for (GamePiece gamePiece : pieces) {
                            if (!this.passesPropertyFastMatch(gamePiece)) continue;
                            dispatcher.accept(gamePiece);
                        }
                    }
                }
            } else {
                for (Map map : maps) {
                    List<GamePiece> pieceList;
                    if (this.target.fastMatchLocation && (this.target.targetType == GlobalCommandTarget.Target.CURMAP ? curPiece != null && !map.equals(curPiece.getMap()) : !this.target.targetType.isCurrent() && !fastMap.isEmpty() && !fastMap.equals(map.getConfigureName()))) continue;
                    GamePiece[] everythingOnMap = map.getPieces();
                    if (!this.target.fastMatchLocation) {
                        if (!this.target.fastMatchProperty) {
                            for (GamePiece pieceOrStack : everythingOnMap) {
                                dispatcher.accept(pieceOrStack);
                            }
                            continue;
                        }
                        block28: for (GamePiece pieceOrStack : everythingOnMap) {
                            if (pieceOrStack instanceof Deck) {
                                int useFromDeck;
                                Deck deck = (Deck)pieceOrStack;
                                int n = useFromDeck = deck.isAccessible() ? this.getSelectFromDeck() : 0;
                                if (useFromDeck == 0) continue;
                                visitor.setSelectedCount(0);
                                pieceList = deck.getOrderedPieces();
                                for (GamePiece gamePiece : pieceList) {
                                    if (!this.passesPropertyFastMatch(gamePiece)) continue;
                                    dispatcher.accept(gamePiece);
                                    if (useFromDeck <= 0 || visitor.getSelectedCount() < useFromDeck) continue;
                                    continue block28;
                                }
                                continue;
                            }
                            pieceList = pieceOrStack instanceof Stack ? ((Stack)pieceOrStack).asList() : Collections.singletonList(pieceOrStack);
                            for (GamePiece gamePiece : pieceList) {
                                if (!this.passesPropertyFastMatch(gamePiece)) continue;
                                dispatcher.accept(gamePiece);
                            }
                        }
                        continue;
                    }
                    block31: for (GamePiece pieceOrStack : everythingOnMap) {
                        int useFromDeck;
                        if (pieceOrStack instanceof Stack) {
                            if (pieceOrStack instanceof Deck) {
                                if (((Deck)pieceOrStack).isAccessible()) {
                                    useFromDeck = this.getSelectFromDeck();
                                    visitor.setSelectedCount(0);
                                } else {
                                    useFromDeck = 0;
                                }
                            } else {
                                useFromDeck = -1;
                            }
                            pieceList = ((Stack)pieceOrStack).asList();
                            if (pieceOrStack instanceof Deck) {
                                pieceList = ((Deck)pieceOrStack).getOrderedPieces();
                            }
                        } else {
                            pieceList = Collections.singletonList(pieceOrStack);
                            useFromDeck = -1;
                        }
                        if (useFromDeck == 0) continue;
                        block32: for (GamePiece gamePiece : pieceList) {
                            Point pt;
                            if (!this.passesPropertyFastMatch(gamePiece)) continue;
                            switch (this.target.targetType) {
                                case CURZONE: 
                                case ZONE: {
                                    if (fastZone.equals(gamePiece.getProperty("CurrentZone"))) break;
                                    continue block32;
                                }
                                case CURLOC: 
                                case LOCATION: {
                                    if (fastLocation.equals(gamePiece.getProperty("LocationName"))) break;
                                    continue block32;
                                }
                            }
                            if (this.target.targetType == GlobalCommandTarget.Target.XY && (!fastBoard.isEmpty() && !fastBoard.equals(gamePiece.getProperty("CurrentBoard")) || !fastX.equals(Integer.toString((int)(pt = new Point(gamePiece.getPosition())).getX())) || !fastY.equals(Integer.toString((int)pt.getY())))) continue;
                            dispatcher.accept(gamePiece);
                            if (useFromDeck <= 0 || visitor.getSelectedCount() < useFromDeck) continue;
                            continue block31;
                        }
                    }
                }
            }
            visitor.getTracker().repaint();
            command = visitor.getCommand();
        }
        catch (RecursionLimitException e) {
            RecursionLimiter.infiniteLoop(e);
        }
        finally {
            RecursionLimiter.endExecution();
            if (this.reportSingle) {
                Map.setChangeReportingEnabled(true);
            }
        }
        return command;
    }

    public Command apply(Map map, PieceFilter filter) {
        return this.apply(new Map[]{map}, filter);
    }

    public Command apply(Map[] maps, PieceFilter filter) {
        return this.apply(maps, filter, null);
    }

    public Command apply(Map map, PieceFilter filter, GlobalCommandTarget fastMatch) {
        return this.apply(new Map[]{map}, filter, fastMatch);
    }

    public Command apply(Map map, PieceFilter filter, GlobalCommandTarget fastMatch, AuditTrail audit) {
        return this.apply(new Map[]{map}, filter, fastMatch, audit);
    }

    public int getSelectFromDeck() {
        return this.selectFromDeck;
    }

    public String getSelectFromDeckExpression() {
        return this.selectFromDeckExpression;
    }

    public void setSelectFromDeckExpression(String selectFromDeck) {
        this.selectFromDeckExpression = selectFromDeck;
    }

    public void setSelectFromDeck(int selectFromDeck) {
        this.selectFromDeck = selectFromDeck;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.keyStroke == null ? 0 : this.keyStroke.hashCode());
        result = 31 * result + (this.reportFormat == null ? 0 : this.reportFormat.hashCode());
        result = 31 * result + (this.reportSingle ? 1231 : 1237);
        result = 31 * result + this.selectFromDeckExpression.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GlobalCommand other = (GlobalCommand)obj;
        if (this.keyStroke == null ? other.keyStroke != null : !this.keyStroke.equals(other.keyStroke)) {
            return false;
        }
        if (this.reportFormat == null ? other.reportFormat != null : !this.reportFormat.equals(other.reportFormat)) {
            return false;
        }
        if (this.reportSingle != other.reportSingle) {
            return false;
        }
        if (!this.selectFromDeckExpression.equals(other.selectFromDeckExpression)) {
            return false;
        }
        if (this.target.fastMatchLocation != other.target.fastMatchLocation) {
            return false;
        }
        if (this.target.targetType != other.target.targetType) {
            return false;
        }
        if (!this.target.targetType.isCurrent() && !this.target.targetMap.equals(other.target.targetMap)) {
            return false;
        }
        if (this.target.targetType == GlobalCommandTarget.Target.ZONE && !this.target.targetZone.equals(other.target.targetZone)) {
            return false;
        }
        if (this.target.targetType == GlobalCommandTarget.Target.LOCATION && !this.target.targetLocation.equals(other.target.targetLocation)) {
            return false;
        }
        if (!(this.target.targetType != GlobalCommandTarget.Target.XY || this.target.targetBoard.equals(other.target.targetBoard) && this.target.targetX.equals(other.target.targetX) && this.target.targetY.equals(other.target.targetY))) {
            return false;
        }
        if (this.target.fastMatchProperty != other.target.fastMatchProperty) {
            return false;
        }
        if (this.target.fastMatchProperty) {
            if (!this.target.targetProperty.equals(other.target.targetProperty)) {
                return false;
            }
            if (!this.target.targetValue.equals(other.target.targetValue)) {
                return false;
            }
        }
        return true;
    }

    protected class Visitor
    implements DeckVisitor {
        private final Command command;
        private final BoundsTracker tracker;
        private final PieceFilter filter;
        private final KeyStroke stroke;
        private int selectedCount;
        private final AuditTrail auditSoFar;

        public Visitor(Command command, PieceFilter filter, KeyStroke stroke) {
            this(command, filter, stroke, null);
        }

        public Visitor(Command command, PieceFilter filter, KeyStroke stroke, AuditTrail audit) {
            this.command = command;
            this.tracker = new BoundsTracker();
            this.filter = filter;
            this.stroke = stroke;
            this.auditSoFar = audit;
        }

        public void setSelectedCount(int selectedCount) {
            this.selectedCount = selectedCount;
        }

        public int getSelectedCount() {
            return this.selectedCount;
        }

        @Override
        public Object visitDeck(Deck d) {
            if (!d.isAccessible()) {
                return null;
            }
            if (GlobalCommand.this.getSelectFromDeck() != 0) {
                d.setDragCount(d.getPieceCount());
                this.selectedCount = 0;
                PieceIterator it = d.drawCards();
                while (it.hasMoreElements() && (GlobalCommand.this.getSelectFromDeck() < 0 || GlobalCommand.this.getSelectFromDeck() > this.selectedCount)) {
                    this.apply(it.nextPiece(), true);
                }
            }
            return null;
        }

        @Override
        public Object visitStack(Stack s) {
            s.asList().forEach(this::apply);
            return null;
        }

        @Override
        public Object visitDefault(GamePiece p) {
            this.apply(p);
            return null;
        }

        private void apply(GamePiece p) {
            this.apply(p, false);
        }

        private void apply(GamePiece p, boolean visitingDeck) {
            AuditTrail audit = null;
            if (this.auditSoFar != null) {
                audit = new AuditTrail(this.auditSoFar);
                audit.addMessage(Resources.getString("Audit.gkc_applied_to", p.getComponentName()));
            }
            if (this.filter == null || this.filter.accept(p, (Auditable)GlobalCommand.this.owner, audit)) {
                if (visitingDeck) {
                    p.setProperty("obs;", p.getProperty("ObscuredPreDraw"));
                }
                this.tracker.addPiece(p);
                p.setProperty("snapshot", ((PropertyExporter)((Object)p)).getProperties());
                this.command.append(p.keyEvent(this.stroke));
                this.tracker.addPiece(p);
                ++this.selectedCount;
            } else if (visitingDeck) {
                p.setProperty("obs;", p.getProperty("ObscuredPreDraw"));
            }
        }

        public Command getCommand() {
            return this.command;
        }

        public BoundsTracker getTracker() {
            return this.tracker;
        }
    }
}

