/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.i18n;

import VASSAL.build.GameModule;
import VASSAL.i18n.Language;
import VASSAL.i18n.Resources;
import VASSAL.i18n.Translatable;
import VASSAL.i18n.TranslatableAttribute;
import VASSAL.i18n.Translation;
import VASSAL.i18n.VassalResourceBundle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Localization
extends Language {
    private static final Logger logger = LoggerFactory.getLogger(Localization.class);
    private static Localization instance;
    protected String moduleBundle = "Module";
    protected String languageBundle;
    protected String countryBundle;
    protected List<Translation> moduleTranslations = new ArrayList<Translation>();
    protected List<Translation> languageTranslations = new ArrayList<Translation>();
    protected List<Translation> countryTranslations = new ArrayList<Translation>();
    protected List<Translation> translations = new ArrayList<Translation>();
    protected VassalResourceBundle masterBundle;
    protected Set<TranslatableAttribute> translatableItems = new HashSet<TranslatableAttribute>();
    protected boolean translationInProgress = false;
    protected boolean translationComplete = false;

    private Localization() {
        this.languageBundle = this.moduleBundle + "_" + Resources.getLocale().getLanguage();
        this.countryBundle = this.languageBundle + "_" + Resources.getLocale().getCountry();
        this.moduleBundle = this.moduleBundle + ".properties";
        this.languageBundle = this.languageBundle + ".properties";
        this.countryBundle = this.countryBundle + ".properties";
    }

    public static Localization getInstance() {
        if (instance == null) {
            instance = new Localization();
        }
        return instance;
    }

    public String[] getTranslationList() {
        Collections.sort(this.translations);
        String[] s = new String[this.translations.size()];
        int idx = 0;
        for (Translation t : this.translations) {
            s[idx++] = t.getDescription();
        }
        return s;
    }

    public Translation getTranslation(String description) {
        for (Translation t : this.translations) {
            if (!t.getDescription().equals(description)) continue;
            return t;
        }
        return null;
    }

    public void saveTranslatableAttribute(Translatable component, String name, String value) {
        if (GameModule.getGameModule().isLocalizationEnabled()) {
            TranslatableAttribute ta = new TranslatableAttribute(component, name, value);
            this.translatableItems.add(ta);
        }
    }

    public void translate() throws IOException {
        if (GameModule.getGameModule().isLocalizationEnabled()) {
            for (Translation t : this.moduleTranslations) {
                this.addBundle(t.getBundle());
            }
            for (Translation t : this.languageTranslations) {
                this.addBundle(t.getBundle());
            }
            for (Translation t : this.countryTranslations) {
                this.addBundle(t.getBundle());
            }
            if (this.masterBundle != null) {
                this.translationInProgress = true;
                for (TranslatableAttribute attr : this.translatableItems) {
                    if (!attr.isTranslatable()) continue;
                    String key = attr.getKey();
                    try {
                        String translation = this.masterBundle.getString(key);
                        attr.applyTranslation(translation);
                    }
                    catch (MissingResourceException missingResourceException) {}
                }
                this.translationInProgress = false;
                this.translationComplete = true;
                logger.info("Translated");
            }
            this.translatableItems.clear();
            GameModule.getGameModule().initFrameTitle();
        } else {
            this.translationComplete = true;
        }
    }

    public String translate(String key, String defaultValue) {
        try {
            return this.masterBundle == null ? defaultValue : this.masterBundle.getString(key);
        }
        catch (MissingResourceException e) {
            return defaultValue;
        }
    }

    protected void addBundle(VassalResourceBundle child) {
        if (this.masterBundle != null) {
            child.setParent(this.masterBundle);
        }
        this.masterBundle = child;
    }

    public boolean isTranslationInProgress() {
        return this.translationInProgress;
    }

    public boolean isTranslationComplete() {
        return this.translationComplete;
    }

    public void addTranslation(Translation t) {
        if (GameModule.getGameModule().isLocalizationEnabled()) {
            Resources.addSupportedLocale(t.getLocale());
            if (this.moduleBundle.equals(t.getBundleFileName())) {
                this.moduleTranslations.add(t);
            } else if (this.languageBundle.equals(t.getBundleFileName())) {
                this.languageTranslations.add(t);
            } else if (this.countryBundle.equals(t.getBundleFileName())) {
                this.countryTranslations.add(t);
            }
        } else {
            this.translations.add(t);
        }
    }

    public void removeTranslation(Translation t) {
        this.translations.remove(t);
    }
}

