/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.Info;
import VASSAL.preferences.ReadOnlyPrefs;
import VASSAL.tools.ErrorDialog;
import java.awt.AWTError;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartUp {
    private static final Logger logger = LoggerFactory.getLogger(StartUp.class);

    public void initSystemProperties() {
        this.initHTTPProxyProperties();
        this.initSystemSpecificProperties();
        this.initUIProperties();
    }

    protected void initHTTPProxyProperties() {
        String httpProxyHost = "http.proxyHost";
        String proxyHost = "proxyHost";
        if (System.getProperty("http.proxyHost") == null && System.getProperty("proxyHost") != null) {
            System.setProperty("http.proxyHost", System.getProperty("proxyHost"));
        }
        String httpProxyPort = "http.proxyPort";
        String proxyPort = "proxyPort";
        if (System.getProperty("http.proxyPort") == null && System.getProperty("proxyPort") != null) {
            System.setProperty("http.proxyPort", System.getProperty("proxyPort"));
        }
    }

    public void setUIFont(FontUIResource f, FontUIResource fItalic, FontUIResource fBold, FontUIResource fBoth) {
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource)) continue;
            FontUIResource fonty = (FontUIResource)value;
            UIManager.put(key, fonty.getStyle() == 2 ? fItalic : (fonty.getStyle() == 1 ? fBold : (fonty.getStyle() == 3 ? fBoth : f)));
        }
    }

    protected void initUIProperties() {
        System.setProperty("swing.aatext", "true");
        System.setProperty("swing.boldMetal", "false");
        System.setProperty("awt.useSystemAAFontSettings", "on");
        try {
            Toolkit.getDefaultToolkit();
        }
        catch (AWTError e) {
            ErrorDialog.show(e, "Error.assistive_technology_not_found", new Object[0]);
        }
        try {
            SwingUtilities.invokeAndWait(() -> {
                if (SystemUtils.IS_OS_MAC) {
                    Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
                }
                if (!SystemUtils.IS_OS_WINDOWS) {
                    try {
                        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                        ErrorDialog.bug(e);
                    }
                    if ("com.sun.java.swing.plaf.gtk.GTKLookAndFeel".equals(UIManager.getLookAndFeel().getClass().getName())) {
                        UIManager.put("ColorChooserUI", "javax.swing.plaf.basic.BasicColorChooserUI");
                    }
                }
                UIManager.put("PopupMenu.consumeEventOnClose", Boolean.FALSE);
                String fontString = ReadOnlyPrefs.getGlobalPrefs().getStoredValue("overrideDefaultFontSize");
                try {
                    int fontSize = Integer.parseInt(fontString);
                    if (fontSize > 0) {
                        this.setUIFont(new FontUIResource("SansSerif", 0, Math.max(8, Math.min(fontSize, 32))), new FontUIResource("SansSerif", 2, Math.max(8, Math.min(fontSize, 32))), new FontUIResource("SansSerif", 1, Math.max(8, Math.min(fontSize, 32))), new FontUIResource("SansSerif", 3, Math.max(8, Math.min(fontSize, 32))));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            ErrorDialog.bug(e);
        }
    }

    protected void initSystemSpecificProperties() {
    }

    public void startErrorLog() {
        logger.info("Starting");
        logger.info("OS " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch"));
        logger.info("Java version " + System.getProperty("java.version"));
        logger.info("Java home " + System.getProperty("java.home"));
        logger.info("VASSAL version " + Info.getVersion());
    }
}

