/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.build.module.KeyNamer;
import VASSAL.tools.NamedKeyManager;
import VASSAL.tools.concurrent.ConcurrentSoftHashMap;
import VASSAL.tools.swing.SwingUtils;
import java.awt.event.KeyEvent;
import java.util.Map;
import java.util.Objects;
import javax.swing.KeyStroke;
import org.apache.commons.lang3.tuple.Pair;

public class NamedKeyStroke {
    private static final Map<Pair<KeyStroke, String>, NamedKeyStroke> CACHE = new ConcurrentSoftHashMap<Pair<KeyStroke, String>, NamedKeyStroke>();
    public static final NamedKeyStroke NULL_KEYSTROKE = new NamedKeyStroke();
    protected final KeyStroke stroke;
    protected final String name;

    public NamedKeyStroke(int code, int modifiers) {
        this(code, modifiers, null);
    }

    public NamedKeyStroke(int code, int modifiers, String s) {
        this(KeyStroke.getKeyStroke(code, modifiers), s);
    }

    public NamedKeyStroke(KeyStroke k) {
        this(k, null);
    }

    public NamedKeyStroke(String s) {
        this(null, s);
    }

    public NamedKeyStroke() {
        this(null, null);
    }

    public NamedKeyStroke(KeyStroke k, String s) {
        this.name = s != null ? s.intern() : null;
        this.stroke = NamedKeyManager.getInstance().getKeyStroke(this.name, k);
    }

    public boolean isNamed() {
        return this.name != null && !this.name.isEmpty();
    }

    public String getName() {
        return this.name;
    }

    public boolean isNull() {
        return this.stroke == null && this.name == null || this.stroke != null && this.stroke.getKeyCode() == 0 && this.stroke.getModifiers() == 0;
    }

    public KeyStroke getStroke() {
        return this.stroke;
    }

    public String getDesc() {
        if (this.isNamed()) {
            return this.name;
        }
        if (this.stroke != null) {
            return KeyNamer.getKeyString(this.stroke);
        }
        return "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof NamedKeyStroke) {
            return Objects.equals(this.stroke, ((NamedKeyStroke)o).stroke);
        }
        if (o instanceof KeyStroke) {
            return o.equals(this.stroke);
        }
        return false;
    }

    public KeyStroke getKeyStroke() {
        return this.stroke;
    }

    @Deprecated(since="2021-12-01", forRemoval=true)
    public static NamedKeyStroke getNamedKeyStroke(char c) {
        return NamedKeyStroke.of(c);
    }

    @Deprecated(since="2021-12-01", forRemoval=true)
    public static NamedKeyStroke getNamedKeyStroke(char c, int mod) {
        return NamedKeyStroke.of(c, mod);
    }

    @Deprecated(since="2021-12-01", forRemoval=true)
    public static NamedKeyStroke getNamedKeyStroke(int c, int mod) {
        return NamedKeyStroke.of(c, mod);
    }

    @Deprecated(since="2021-12-01", forRemoval=true)
    public static NamedKeyStroke getKeyStrokeForEvent(KeyEvent e) {
        return NamedKeyStroke.of(e);
    }

    public static NamedKeyStroke of(char c) {
        return NamedKeyStroke.of(c, 0);
    }

    public static NamedKeyStroke of(KeyEvent e) {
        return NamedKeyStroke.of(SwingUtils.getKeyStrokeForEvent(e));
    }

    public static NamedKeyStroke of(char c, int modifiers) {
        return NamedKeyStroke.of(KeyStroke.getKeyStroke((int)c, modifiers));
    }

    public static NamedKeyStroke of(int code, int modifiers) {
        return NamedKeyStroke.of(KeyStroke.getKeyStroke(code, modifiers));
    }

    public static NamedKeyStroke of(int code, int modifiers, String s) {
        return NamedKeyStroke.of(KeyStroke.getKeyStroke(code, modifiers), s);
    }

    public static NamedKeyStroke of(KeyStroke k) {
        return NamedKeyStroke.of(k, null);
    }

    public static NamedKeyStroke of(String s) {
        return NamedKeyStroke.of(NamedKeyManager.getInstance().getKeyStroke(s, null), s);
    }

    public static NamedKeyStroke of(KeyStroke k, String s) {
        return CACHE.computeIfAbsent((Pair<KeyStroke, String>)Pair.of((Object)k, (Object)s), p -> new NamedKeyStroke((KeyStroke)p.getLeft(), (String)p.getRight()));
    }
}

