/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image;

import VASSAL.Info;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.image.FallbackImageTypeConverter;
import VASSAL.tools.image.GeneralFilter;
import VASSAL.tools.image.ImageIOException;
import VASSAL.tools.image.ImageIOImageLoader;
import VASSAL.tools.image.ImageLoader;
import VASSAL.tools.image.ImageNotFoundException;
import VASSAL.tools.io.TemporaryFileFactory;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.WritableRaster;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import javax.swing.ImageIcon;

public class ImageUtils {
    private static final double DEGTORAD = -Math.PI / 180;
    private static final GeneralFilter.Filter upscale;
    private static final GeneralFilter.Filter downscale;
    private static final Map<RenderingHints.Key, Object> defaultHints;
    private static final TemporaryFileFactory tfac;
    private static final ImageLoader loader;
    protected static final BufferedImage compatOpaqueImage;
    protected static final BufferedImage compatTransImage;
    protected static final int compatOpaqueImageType;
    protected static final int compatTranslImageType;
    public static final BufferedImage NULL_IMAGE;
    public static final String GIF_SUFFIX = ".gif";
    public static final String PNG_SUFFIX = ".png";
    public static final String SVG_SUFFIX = ".svg";
    public static final String JPG_SUFFIX = ".jpg";
    public static final String JPEG_SUFFIX = ".jpeg";
    public static final String[] IMAGE_SUFFIXES;

    private ImageUtils() {
    }

    public static RenderingHints getDefaultHints() {
        return new RenderingHints(defaultHints);
    }

    public static Rectangle transform(Rectangle srect, double scale, double angle) {
        AffineTransform t = AffineTransform.getRotateInstance(-Math.PI / 180 * angle, srect.getCenterX(), srect.getCenterY());
        t.scale(scale, scale);
        return t.createTransformedShape(srect).getBounds();
    }

    public static BufferedImage transform(BufferedImage src, double scale, double angle) {
        return ImageUtils.transform(src, scale, angle, ImageUtils.getDefaultHints());
    }

    public static BufferedImage transform(BufferedImage src, double scale, double angle, RenderingHints hints) {
        if (src == null) {
            return null;
        }
        if (scale == 1.0 && angle == 0.0) {
            return src;
        }
        if ((double)src.getWidth() * scale == 0.0 || (double)src.getHeight() * scale == 0.0) {
            return NULL_IMAGE;
        }
        if (hints == null) {
            hints = ImageUtils.getDefaultHints();
        }
        if (scale == 1.0 && angle % 90.0 == 0.0) {
            hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            Rectangle ubox = ImageUtils.getBounds(src);
            Rectangle tbox = ImageUtils.transform(ubox, scale, angle);
            BufferedImage trans = ImageUtils.createCompatibleImage(tbox.width, tbox.height, src.getTransparency() != 1);
            AffineTransform t = new AffineTransform();
            t.translate(-tbox.x, -tbox.y);
            t.rotate(-Math.PI / 180 * angle, ubox.getCenterX(), ubox.getCenterY());
            t.scale(scale, scale);
            t.translate(ubox.x, ubox.y);
            Graphics2D g = trans.createGraphics();
            g.setRenderingHints(hints);
            g.drawImage(src, t, null);
            g.dispose();
            return trans;
        }
        if (angle != 0.0) {
            Rectangle ubox = ImageUtils.getBounds(src);
            Rectangle rbox = ImageUtils.transform(ubox, 1.0, angle);
            BufferedImage rot = ImageUtils.createCompatibleImage(rbox.width, rbox.height, src.getTransparency() != 1 || angle % 90.0 != 0.0);
            AffineTransform tx = new AffineTransform();
            tx.translate(-rbox.x, -rbox.y);
            tx.rotate(-Math.PI / 180 * angle, ubox.getCenterX(), ubox.getCenterY());
            tx.translate(ubox.x, ubox.y);
            Graphics2D g = rot.createGraphics();
            g.setRenderingHints(hints);
            g.drawImage(src, tx, null);
            g.dispose();
            src = rot;
        }
        if (scale != 1.0) {
            src = ImageUtils.coerceToIntType(src);
            Rectangle sbox = ImageUtils.transform(ImageUtils.getBounds(src), scale, 0.0);
            if (sbox.width == 0 || sbox.height == 0) {
                return NULL_IMAGE;
            }
            BufferedImage dst = GeneralFilter.zoom(sbox, src, scale > 1.0 ? upscale : downscale);
            return ImageUtils.toCompatibleImage(dst);
        }
        return src;
    }

    public static BufferedImage transform(BufferedImage src, int sw, int sh, RenderingHints hints) {
        if (src == null) {
            return null;
        }
        if (sw == 0 || sh == 0) {
            return NULL_IMAGE;
        }
        if (sw == src.getWidth() && sh == src.getHeight()) {
            return src;
        }
        if (hints == null) {
            hints = ImageUtils.getDefaultHints();
        }
        src = ImageUtils.coerceToIntType(src);
        Rectangle sbox = new Rectangle(0, 0, sw, sh);
        BufferedImage dst = GeneralFilter.zoom(sbox, src, sw > src.getWidth() ? upscale : downscale);
        return ImageUtils.toCompatibleImage(dst);
    }

    public static BufferedImage coerceToIntType(BufferedImage img) {
        switch (img.getType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return img;
            }
        }
        return ImageUtils.toType(img, img.getTransparency() == 1 ? 1 : (ImageUtils.getCompatibleTranslucentImageType() == 2 ? 2 : 3));
    }

    public static Rectangle getBounds(BufferedImage im) {
        return new Rectangle(-im.getWidth() / 2, -im.getHeight() / 2, im.getWidth(), im.getHeight());
    }

    public static Rectangle getBounds(Dimension d) {
        return new Rectangle(-d.width / 2, -d.height / 2, d.width, d.height);
    }

    public static Dimension getImageSize(String name, InputStream in) throws ImageIOException {
        return loader.size(name, in);
    }

    public static BufferedImage getImageResource(String name) throws ImageIOException {
        InputStream in = ImageUtils.class.getResourceAsStream(name);
        if (in == null) {
            throw new ImageNotFoundException(name);
        }
        return ImageUtils.getImage(name, in);
    }

    public static BufferedImage getImage(String name, InputStream in) throws ImageIOException {
        return loader.load(name, in, compatOpaqueImageType, compatTranslImageType, true);
    }

    public static BufferedImage toType(BufferedImage src, int type) {
        BufferedImage dst = new BufferedImage(src.getWidth(), src.getHeight(), type);
        Graphics2D g = dst.createGraphics();
        g.drawImage((Image)src, 0, 0, null);
        g.dispose();
        return dst;
    }

    public static Image forceLoad(Image img) {
        return new ImageIcon(img).getImage();
    }

    public static boolean isTransparent(Image img) {
        PixelGrabber pg = new PixelGrabber(img, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            ErrorDialog.bug(e);
        }
        return pg.getColorModel().hasAlpha();
    }

    public static boolean isTransparent(BufferedImage img) {
        return img.getTransparency() != 1;
    }

    public static BufferedImage toBufferedImage(Image src) {
        if (src == null) {
            return null;
        }
        if (src instanceof BufferedImage) {
            return ImageUtils.toCompatibleImage((BufferedImage)src);
        }
        src = ImageUtils.forceLoad(src);
        BufferedImage dst = ImageUtils.createCompatibleImage(src.getWidth(null), src.getHeight(null), ImageUtils.isTransparent(src));
        Graphics2D g = dst.createGraphics();
        g.drawImage(src, 0, 0, null);
        g.dispose();
        return dst;
    }

    private static boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    private static GraphicsConfiguration getGraphicsConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    public static int getCompatibleImageType() {
        return compatOpaqueImageType;
    }

    public static int getCompatibleTranslucentImageType() {
        return compatTranslImageType;
    }

    public static int getCompatibleImageType(boolean transparent) {
        return transparent ? compatTranslImageType : compatOpaqueImageType;
    }

    public static int getCompatibleImageType(BufferedImage img) {
        return ImageUtils.getCompatibleImageType(ImageUtils.isTransparent(img));
    }

    public static BufferedImage createCompatibleImage(int w, int h) {
        ColorModel cm = compatOpaqueImage.getColorModel();
        WritableRaster wr = cm.createCompatibleWritableRaster(w, h);
        return new BufferedImage(cm, wr, cm.isAlphaPremultiplied(), null);
    }

    public static BufferedImage createCompatibleImage(int w, int h, boolean transparent) {
        return transparent ? ImageUtils.createCompatibleTranslucentImage(w, h) : ImageUtils.createCompatibleImage(w, h);
    }

    public static BufferedImage createCompatibleTranslucentImage(int w, int h) {
        ColorModel cm = compatTransImage.getColorModel();
        WritableRaster wr = cm.createCompatibleWritableRaster(w, h);
        return new BufferedImage(cm, wr, cm.isAlphaPremultiplied(), null);
    }

    public static BufferedImage toCompatibleImage(BufferedImage src) {
        if (src.getColorModel().equals(compatOpaqueImage.getColorModel()) && src.getTransparency() == compatOpaqueImage.getTransparency() || src.getColorModel().equals(compatTransImage.getColorModel()) && src.getTransparency() == compatTransImage.getTransparency()) {
            return src;
        }
        BufferedImage dst = ImageUtils.createCompatibleImage(src.getWidth(), src.getHeight(), ImageUtils.isTransparent(src));
        Graphics2D g = dst.createGraphics();
        g.drawImage((Image)src, 0, 0, null);
        g.dispose();
        return dst;
    }

    public static boolean isCompatibleImage(BufferedImage img) {
        return img.getType() == ImageUtils.getCompatibleImageType(img.getTransparency() != 1);
    }

    public static boolean hasImageSuffix(String name) {
        String s = name.toLowerCase();
        for (String suffix : IMAGE_SUFFIXES) {
            if (!s.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public static String stripImageSuffix(String name) {
        String s = name.toLowerCase();
        for (String suffix : IMAGE_SUFFIXES) {
            if (!s.endsWith(suffix)) continue;
            return name.substring(0, name.length() - suffix.length());
        }
        return name;
    }

    static {
        BufferedImage timg;
        BufferedImage oimg;
        upscale = new GeneralFilter.MitchellFilter();
        downscale = new GeneralFilter.Lanczos3Filter();
        defaultHints = Map.of(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR, RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        tfac = () -> Files.createTempFile(Info.getTempDir().toPath(), "img_", "", new FileAttribute[0]).toFile();
        loader = new ImageIOImageLoader(new FallbackImageTypeConverter(tfac));
        if (ImageUtils.isHeadless()) {
            oimg = new BufferedImage(1, 1, 1);
            timg = new BufferedImage(1, 1, 2);
        } else {
            GraphicsConfiguration gc = ImageUtils.getGraphicsConfiguration();
            oimg = gc.createCompatibleImage(1, 1, 1);
            timg = gc.createCompatibleImage(1, 1, 3);
        }
        compatOpaqueImage = oimg;
        compatTransImage = timg;
        compatOpaqueImageType = compatOpaqueImage.getType();
        compatTranslImageType = compatTransImage.getType();
        NULL_IMAGE = ImageUtils.createCompatibleImage(1, 1);
        IMAGE_SUFFIXES = new String[]{GIF_SUFFIX, PNG_SUFFIX, SVG_SUFFIX, JPG_SUFFIX, JPEG_SUFFIX};
    }
}

